/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import sunw.hotjava.bean.DocumentSelection;
import sunw.hotjava.bean.HTMLBrowsable;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.ui.InfoLabel;
import sunw.hotjava.ui.InputField;

public class Locator
extends Panel
implements PropertyChangeListener {
    HJBProperties properties = HJBProperties.getHJBProperties("hjbrowser");
    private InfoLabel label;
    private InputField input;
    String docURL;
    HTMLBrowsable HJBrowser;
    protected PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public Locator(HTMLBrowsable hTMLBrowsable) {
        this.HJBrowser = hTMLBrowsable;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.input = new InputField(hTMLBrowsable);
        this.input.addFocusListener(new LocatorFocusListener());
        this.input.addMouseListener(new LocatorMouseListener());
        this.input.addKeyListener(new LocatorKeyListener());
        this.label = new InfoLabel(this.input.getFont());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagLayout.setConstraints(this.label, gridBagConstraints);
        this.add(this.label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 1);
        gridBagLayout.setConstraints(this.input, gridBagConstraints);
        this.add(this.input);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("documentURL")) {
            ((TextComponent)this.input).setText(propertyChangeEvent.getNewValue().toString());
            return;
        }
        if (propertyChangeEvent.getSource() != this && propertyChangeEvent.getPropertyName().equals("selection") && this.isSelectedTextExists()) {
            int n = this.input.getCaretPosition();
            this.input.select(n, n);
        }
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        Insets insets = this.getInsets();
        dimension.height = Math.max(dimension.height, this.input.getMinimumSize().height + insets.top + insets.bottom);
        return dimension;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Insets insets = this.getInsets();
        dimension.height = Math.max(dimension.height, this.input.getPreferredSize().height + insets.top + insets.bottom);
        return dimension;
    }

    public void paste(String string) {
        this.input.paste(string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    private boolean isSelectedTextExists() {
        return this.input.getSelectionStart() != this.input.getSelectionEnd();
    }

    protected void processFocusEvent() {
        DocumentSelection documentSelection = new DocumentSelection();
        documentSelection.text = !this.isSelectedTextExists() ? "" : this.input.getSelectedText();
        this.changeSupport.firePropertyChange("selection", null, documentSelection);
    }

    protected void processMouseAction(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 502) {
            DocumentSelection documentSelection = new DocumentSelection();
            documentSelection.text = !this.isSelectedTextExists() ? "" : this.input.getSelectedText();
            this.changeSupport.firePropertyChange("selection", null, documentSelection);
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        DocumentSelection documentSelection = new DocumentSelection();
        documentSelection.text = !this.isSelectedTextExists() ? "" : this.input.getSelectedText();
        this.changeSupport.firePropertyChange("selection", null, documentSelection);
    }

    private final class LocatorFocusListener
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            Locator.this.processFocusEvent();
        }

        public void focusLost(FocusEvent focusEvent) {
            Locator.this.processFocusEvent();
        }

        LocatorFocusListener() {
            Locator.this = Locator.this;
        }
    }

    private final class LocatorMouseListener
    extends MouseAdapter {
        public void mouseExited(MouseEvent mouseEvent) {
            Locator.this.processMouseAction(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Locator.this.processMouseAction(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Locator.this.processMouseAction(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Locator.this.processMouseAction(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Locator.this.processMouseAction(mouseEvent);
        }

        LocatorMouseListener() {
            Locator.this = Locator.this;
        }
    }

    private final class LocatorKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            Locator.this.processKeyEvent(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            Locator.this.processKeyEvent(keyEvent);
        }

        public void keyTyped(KeyEvent keyEvent) {
            Locator.this.processKeyEvent(keyEvent);
        }

        LocatorKeyListener() {
            Locator.this = Locator.this;
        }
    }
}

