/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.misc.StreamCopier;
import sunw.hotjava.ui.BPSIndicator;
import sunw.hotjava.ui.BytesTransferredInd;
import sunw.hotjava.ui.UIHJButton;

public class ProgressDialog
extends Frame
implements Observer,
ActionListener {
    private static final long kSleepInterval = 100L;
    private static final int k1K = 1024;
    private static final int k1M = 0x100000;
    private StreamCopier copier;
    private String bytesTransferredPrefix;
    private Label bytesTransferredLabel;
    private BytesTransferredInd bytesTransferredInd;
    private BPSIndicator bpsInd;
    private UIHJButton stopButton;
    private long totalBytes;
    private long bytesTransferred = -1L;
    private long transferStartTime;
    private long previousTime;
    private Thread myThread;
    private HJBProperties properties = HJBProperties.getHJBProperties("hjbrowser");

    public ProgressDialog(Frame frame, String string, URL uRL, String string2) {
        super(string);
        Color color = this.properties.getColor("hotjava.background", null);
        if (color != null) {
            ((Component)this).setBackground(color);
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        String string3 = this.properties.getProperty("progressDialog.url.label", "Source:");
        this.addComponent(gridBagLayout, gridBagConstraints, new Label(String.valueOf(string3) + " " + uRL));
        string3 = this.properties.getProperty("progressDialog.saveInto.label", "Destination:");
        this.addComponent(gridBagLayout, gridBagConstraints, new Label(String.valueOf(string3) + " " + string2));
        gridBagConstraints.ipady = 2;
        this.bytesTransferredPrefix = String.valueOf(this.properties.getProperty("progressDialog.transfer.label", "Bytes transferred:")) + " ";
        this.bytesTransferredInd = new BytesTransferredInd();
        this.addComponent(gridBagLayout, gridBagConstraints, this.bytesTransferredInd);
        this.bpsInd = new BPSIndicator();
        this.addComponent(gridBagLayout, gridBagConstraints, this.bpsInd);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.stopButton = new UIHJButton("progressDialog.stop", true, this.properties);
        this.stopButton.addActionListener(this);
        this.addComponent(gridBagLayout, gridBagConstraints, this.stopButton);
        this.pack();
        this.centerOnScreen(frame);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            URL uRL2 = ClassLoader.getSystemResource("lib/images/hotjava.icon.gif");
            Image image = toolkit.getImage(uRL2);
            this.setIconImage(image);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void addComponent(GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Component component) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void centerOnScreen(Frame frame) {
        Point point = frame.getLocationOnScreen();
        Dimension dimension = frame.getSize();
        Dimension dimension2 = this.getSize();
        point.x += (dimension.width - dimension2.width) / 2;
        point.y += (dimension.height - dimension2.height) / 2;
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        if (point.x < 0 || point.y < 0 || point.x + dimension2.width > dimension3.width || point.y + dimension2.height > dimension3.height) {
            point.x = (dimension3.width - dimension2.width) / 2;
            point.y = (dimension3.height - dimension2.height) / 2;
        }
        ((Component)this).setLocation(point.x, point.y);
    }

    public void start() {
        this.previousTime = this.transferStartTime = System.currentTimeMillis();
    }

    private void updateDisplay(long l) {
        if (this.bytesTransferred != l) {
            this.bytesTransferred = l;
            this.bytesTransferredInd.updateBytesTransferred(l);
        }
        this.updateTransferSpeed(l);
    }

    private void updateTransferSpeed(long l) {
        long l2 = System.currentTimeMillis();
        double d = 0.0;
        if (l2 > this.transferStartTime) {
            d = (double)l * 1000.0 / (double)(l2 - this.transferStartTime);
        }
        this.bpsInd.updateBPS((long)(d + 0.5));
        this.validate();
    }

    static String convertToReadableValue(long l) {
        String string = "";
        if (l >= 0x100000L) {
            l = l * 10L / 0x100000L;
            return String.valueOf(ProgressDialog.format1decimalPlace(l)) + "M";
        }
        if (l >= 1024L) {
            l = l * 10L / 1024L;
            return String.valueOf(ProgressDialog.format1decimalPlace(l)) + "K";
        }
        return String.valueOf(l) + string;
    }

    private static String format1decimalPlace(long l) {
        long l2 = l % 10L;
        return String.valueOf(l /= 10L) + "." + l2;
    }

    public synchronized void setTotalBytes(long l) {
        this.totalBytes = l;
        this.bytesTransferredInd.setTotalBytes(l);
        this.validate();
        this.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.stopButton) {
            this.copier.stop();
            this.dispose();
        }
    }

    public void update(Graphics graphics) {
        ((Container)this).paint(graphics);
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof StreamCopier) {
            if (this.copier == null) {
                this.copier = (StreamCopier)observable;
            }
            long l = System.currentTimeMillis();
            int n = (Integer)object;
            if (n < 0) {
                this.dispose();
            }
            if (l - this.previousTime >= 100L) {
                this.previousTime = l;
                this.updateDisplay(n);
            }
        }
    }
}

