/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.StringTokenizer;
import sun.awt.OrientableFlowLayout;
import sunw.hotjava.HJFrame;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.ui.TimedMessageContainer;
import sunw.hotjava.ui.UpdateableComponent;
import sunw.hotjava.ui.UserImageButton;

public class Toolbar
extends Panel
implements ActionListener {
    private ActionListener toolEventsListener;
    private HJFrame frm;
    protected Hashtable toolDictionary;
    private static HJBProperties properties = HJBProperties.getHJBProperties("hjbrowser");

    public static Toolbar getDefaultToolbar(HJFrame hJFrame) {
        return new Toolbar("2.0.default.toolbar", hJFrame);
    }

    public Toolbar(String string, HJFrame hJFrame) {
        this.frm = hJFrame;
        this.setName(string);
        this.toolDictionary = new Hashtable(7);
        this.toolEventsListener = hJFrame.getActionListener();
        this.init();
    }

    protected void init() {
        this.invalidate();
        HJBProperties hJBProperties = HJBProperties.getHJBProperties("hjbrowser");
        String string = hJBProperties.getProperty("hotjava." + this.getName() + ".buttonorder");
        this.setLayout((LayoutManager)new OrientableFlowLayout(0, 0, 1, 0, 0, 0, 0));
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        System.gc();
        System.runFinalization();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.addTool(string2);
        }
        System.gc();
        System.runFinalization();
        this.doLayout();
        this.validate();
    }

    public Component getTool(String string) {
        return (Component)this.toolDictionary.get(string);
    }

    public void orientHorizontally() {
        this.invalidate();
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof OrientableFlowLayout) {
            ((OrientableFlowLayout)layoutManager).orientHorizontally();
        }
        this.doLayout();
        this.validate();
    }

    public void orientVertically() {
        this.invalidate();
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof OrientableFlowLayout) {
            ((OrientableFlowLayout)layoutManager).orientVertically();
        }
        this.doLayout();
        this.validate();
    }

    protected Component makeTool(String string) {
        UserImageButton userImageButton = new UserImageButton(string);
        userImageButton.addActionListener(this.toolEventsListener);
        userImageButton.addActionListener(this);
        String string2 = properties.getProperty("button." + string + ".message");
        if (string2 != null) {
            TimedMessageContainer timedMessageContainer = new TimedMessageContainer(string2);
            timedMessageContainer.add(userImageButton);
            return timedMessageContainer;
        }
        return userImageButton;
    }

    public void addTool(String string) {
        Component component = this.makeTool(string);
        this.addTool(string, component);
    }

    public void addTool(String string, int n) {
        Component component = this.makeTool(string);
        this.addTool(string, component, n);
    }

    public void addTool(String string, Component component) {
        this.addTool(string, component, -1);
    }

    public synchronized void addTool(String string, Component component, int n) {
        this.invalidate();
        this.add(component, n);
        component.setVisible(true);
        this.validate();
        this.toolDictionary.put(string, component);
    }

    public synchronized Component removeTool(String string) {
        Component component = (Component)this.toolDictionary.get(string);
        if (component != null) {
            this.invalidate();
            this.remove(component);
            this.validate();
            this.toolDictionary.remove(string);
        }
        return component;
    }

    public void enableTool(String string, boolean bl) {
        Component component = (Component)this.toolDictionary.get(string);
        if (component != null) {
            component.setEnabled(bl);
        }
    }

    public void enableTool(String string) {
        this.enableTool(string, true);
    }

    public void disableTool(String string) {
        this.enableTool(string, false);
    }

    public synchronized void resetButtonAppearance() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof TimedMessageContainer) {
                TimedMessageContainer timedMessageContainer = (TimedMessageContainer)componentArray[n];
                Component[] componentArray2 = timedMessageContainer.getComponents();
                int n2 = 0;
                while (n2 < componentArray2.length) {
                    ((UpdateableComponent)((Object)componentArray2[n2])).updateAppearance();
                    ++n2;
                }
            } else if (componentArray[n] instanceof UpdateableComponent) {
                ((UpdateableComponent)((Object)componentArray[n])).updateAppearance();
            }
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.startsWith("entered")) {
            String string2 = string.substring("entered".length() + 1);
            String string3 = properties.getProperty("button." + string2 + ".message");
            this.frm.showStatus(string3);
            return;
        }
        if (string.equals("")) {
            this.frm.showStatus("");
        }
    }
}

