/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.event;

import com.swabunga.spell.event.WordTokenizer;
import java.text.BreakIterator;

public class StringWordTokenizer
implements WordTokenizer {
    private int currentWordPos = 0;
    private int currentWordEnd = 0;
    private int nextWordPos = -1;
    private StringBuffer text;
    private int wordCount = 0;
    private boolean moreTokens = true;
    private boolean first = true;
    private BreakIterator sentanceIterator = BreakIterator.getSentenceInstance();
    private boolean startsSentance = true;

    public StringWordTokenizer(String string) {
        this.sentanceIterator.setText(string);
        this.sentanceIterator.first();
        this.text = new StringBuffer(string);
        this.currentWordPos = StringWordTokenizer.getNextWordStart(this.text, 0);
        if (this.currentWordPos != -1) {
            this.currentWordEnd = StringWordTokenizer.getNextWordEnd(this.text, this.currentWordPos);
            this.nextWordPos = StringWordTokenizer.getNextWordStart(this.text, this.currentWordEnd);
        } else {
            this.moreTokens = false;
        }
    }

    private static int getNextWordStart(StringBuffer stringBuffer, int n) {
        int n2 = stringBuffer.length();
        for (int i = n; i < n2; ++i) {
            if (!Character.isLetterOrDigit(stringBuffer.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private static int getNextWordEnd(StringBuffer stringBuffer, int n) {
        int n2 = stringBuffer.length();
        for (int i = n; i < n2; ++i) {
            if (Character.isLetterOrDigit(stringBuffer.charAt(i))) continue;
            return i;
        }
        return n2;
    }

    @Override
    public boolean hasMoreWords() {
        return this.moreTokens;
    }

    @Override
    public int getCurrentWordPosition() {
        return this.currentWordPos;
    }

    @Override
    public int getCurrentWordEnd() {
        return this.currentWordEnd;
    }

    @Override
    public String nextWord() {
        if (!this.first) {
            this.currentWordPos = this.nextWordPos;
            this.currentWordEnd = StringWordTokenizer.getNextWordEnd(this.text, this.currentWordPos);
            this.nextWordPos = StringWordTokenizer.getNextWordStart(this.text, this.currentWordEnd + 1);
            int n = this.sentanceIterator.current();
            if (n == this.currentWordPos) {
                this.startsSentance = true;
            } else {
                this.startsSentance = false;
                if (this.currentWordEnd > n) {
                    this.sentanceIterator.next();
                }
            }
        }
        String string = this.text.substring(this.currentWordPos, this.currentWordEnd);
        ++this.wordCount;
        this.first = false;
        if (this.nextWordPos == -1) {
            this.moreTokens = false;
        }
        return string;
    }

    @Override
    public int getCurrentWordCount() {
        return this.wordCount;
    }

    @Override
    public void replaceWord(String string) {
        if (this.currentWordPos != -1) {
            this.text.replace(this.currentWordPos, this.currentWordEnd, string);
            this.first = true;
            this.currentWordPos = StringWordTokenizer.getNextWordStart(this.text, this.currentWordPos + string.length());
            if (this.currentWordPos != -1) {
                this.currentWordEnd = StringWordTokenizer.getNextWordEnd(this.text, this.currentWordPos);
                this.nextWordPos = StringWordTokenizer.getNextWordStart(this.text, this.currentWordEnd);
                this.sentanceIterator.setText(this.text.toString());
                this.sentanceIterator.following(this.currentWordPos);
            } else {
                this.moreTokens = false;
            }
        }
    }

    @Override
    public boolean isNewSentance() {
        return this.startsSentance;
    }

    @Override
    public String getContext() {
        return this.text.toString();
    }

    public String getFinalText() {
        return this.getContext();
    }

    public static void main(String[] stringArray) {
        String string;
        StringWordTokenizer stringWordTokenizer = new StringWordTokenizer("  This is a  test   problem");
        while (stringWordTokenizer.hasMoreWords()) {
            string = stringWordTokenizer.nextWord();
            System.out.println("Word is '" + string + "'");
            if (!"test".equals(string)) continue;
            stringWordTokenizer.replaceWord("mightly big");
        }
        System.out.println("End text is: '" + stringWordTokenizer.getFinalText() + "'");
        stringWordTokenizer = new StringWordTokenizer("    README   ");
        while (stringWordTokenizer.hasMoreWords()) {
            string = stringWordTokenizer.nextWord();
            System.out.println("Word is '" + string + "'");
        }
        System.out.println("End text is: '" + stringWordTokenizer.getFinalText() + "'");
        stringWordTokenizer = new StringWordTokenizer("This is a acronym (A.C.M.E). This is the second sentance.");
        while (stringWordTokenizer.hasMoreWords()) {
            string = stringWordTokenizer.nextWord();
            System.out.println("Word is '" + string + "'. Starts Sentance?=" + stringWordTokenizer.isNewSentance());
            if (!string.equals("acronym")) continue;
            stringWordTokenizer.replaceWord("test");
        }
    }
}

