/*
 * Decompiled with CFR 0.152.
 */
package dk.hfalk;

import dk.hfalk.HotEditFrame;
import dk.hfalk.db.DBHotEditManager;
import dk.hfalk.gui.DefaultAction;
import dk.hfalk.gui.SplashWindow;
import dk.hfalk.hotedit.OpenFileAction;
import dk.hfalk.hotedit.SaveFileAction;
import dk.hfalk.hotedit.SaveQuitFileAction;
import dk.hfalk.hotedit.edit.DeleteAreaAction;
import dk.hfalk.hotedit.edit.HotSpotEditPropertiesAction;
import dk.hfalk.hotedit.edit.ImageDescriptionAction;
import dk.hfalk.hotedit.edit.ImageInformationAction;
import dk.hfalk.hotedit.edit.ImageNameAction;
import dk.hfalk.hotedit.edit.MarkToolAction;
import dk.hfalk.hotedit.edit.ShowHideAreaAction;
import dk.hfalk.hotedit.gui.HotEditInternalAction;
import dk.hfalk.hotedit.html.clientside.SaveHTMLAction;
import dk.hfalk.hotedit.html.clientside.ShowHTMLAction;
import dk.hfalk.hotedit.settings.AppSettingsAction;
import dk.hfalk.hotedit.util.PlugInInterface;
import dk.hfalk.jfc.JProductInfoAction;
import dk.hfalk.jfc.JQuitAction;
import dk.hfalk.util.HotEditException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class HotEditAction
extends DefaultAction {
    private HotEditFrame frame = null;
    private SplashWindow splashWindow = null;
    private Hashtable _imageHashtable = null;
    private HelpSet helpSet;
    private HelpBroker helpBroker;
    private JMenu fileMenu;
    private JMenu windowMenu;
    private JMenuItem openFile;
    private JMenuItem saveFile;
    private JMenuItem quitFile;
    private JMenuItem markTool;
    private JMenuItem markPOLYTool;
    private JMenuItem markRECTTool;
    private JMenuItem markCIRCLETool;
    private JMenuItem endmarkTool;
    private JMenuItem deleteAreaTool;
    private JMenuItem hotSpotInfoEdit;
    private JMenuItem nameEdit;
    private JMenuItem descriptionEdit;
    private JMenuItem settingsEdit;
    private JMenuItem settingsHTML;
    private JMenuItem generateHTML;
    private JMenuItem showHTML;
    private JMenuItem showhideAreaTool;
    private JMenuItem printImage;
    private JMenuItem printInformation;
    private JMenuItem printHotSpot;
    private JMenuItem imageInfoTool;
    private JMenuItem logWindowItem;
    private JMenuItem prodHelp;
    private JButton openButton;
    private JButton saveButton;
    private JButton rectButton;
    private JButton circleButton;
    private JButton polyButton;
    public HotEditInternalAction hotEditInternalAction;
    public OpenFileAction openFileAction;
    public SaveFileAction saveFileAction;
    public SaveQuitFileAction saveQuitFileAction;
    public JQuitAction quitAction;
    public MarkToolAction polyAction;
    public MarkToolAction rectAction;
    public MarkToolAction circleAction;
    public DeleteAreaAction deleteAreaAction;
    public HotSpotEditPropertiesAction hotSpotEditPropertiesAction;
    public ImageNameAction imageNameAction;
    public ImageDescriptionAction imageDescriptionAction;
    public AppSettingsAction appSettingsAction;
    public ShowHTMLAction showHTMLAction;
    public SaveHTMLAction saveHTMLAction;
    public ShowHideAreaAction showHideAreaAction;
    public ImageInformationAction imageInformationAction;
    public JProductInfoAction productInfoAction;
    private HotEditInternalAction activeWindow = null;
    Hashtable windowList = null;
    static /* synthetic */ Class class$dk$hfalk$HotEditAction;

    public HotEditAction() {
        DBHotEditManager.instance().setMainController(this);
        this.show();
    }

    public HotEditAction(String string) {
        super(string);
        this.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.show();
    }

    public void show() {
        try {
            this.preInit();
            this.frame = new HotEditFrame();
            this.postInit();
            this.frame.setup(this);
            this.enableMenu();
            this.getKeyboardAction();
            this.refreshFileMenu();
            ((Component)this.frame).setVisible(true);
        }
        catch (HotEditException hotEditException) {
            hotEditException.printStackTrace();
        }
    }

    public void preInit() {
        this.getResources();
    }

    public void postInit() {
        this.getSettings();
        this.getHelp();
        this.buildMainWindow();
        this.splashWindow.close();
    }

    public void getResources() {
        this._imageHashtable = new Hashtable(20);
        this._imageHashtable.put("logo", new ImageIcon(this.getClass().getResource("images/hoteditlogo.jpg")));
        this.splashWindow = new SplashWindow(this.getImage("logo"));
        this.splashWindow.show(this.getResource("dk.hfalk.HotEditActionL", "SplashWindow_LoadingImages"));
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._imageHashtable.put("open", new ImageIcon(this.getClass().getResource("images/open.gif")));
        this._imageHashtable.put("save", new ImageIcon(this.getClass().getResource("images/save.gif")));
        this._imageHashtable.put("rectsmall", new ImageIcon(this.getClass().getResource("images/rectsmall.gif")));
        this._imageHashtable.put("polysmall", new ImageIcon(this.getClass().getResource("images/polysmall.gif")));
        this._imageHashtable.put("circlesmall", new ImageIcon(this.getClass().getResource("images/circlesmall.gif")));
        this._imageHashtable.put("gificon", new ImageIcon(this.getClass().getResource("images/gificon.gif")));
        this._imageHashtable.put("jpgicon", new ImageIcon(this.getClass().getResource("images/jpgicon.jpg")));
        this._imageHashtable.put("settings", new ImageIcon(this.getClass().getResource("images/settings.gif")));
        this._imageHashtable.put("trackinghelp", new ImageIcon(this.getClass().getResource("images/helptrack.gif")));
        this._imageHashtable.put("infohelp", new ImageIcon(this.getClass().getResource("images/helpinfo.gif")));
        this._imageHashtable.put("nographics", new ImageIcon(this.getClass().getResource("images/nographics.gif")));
        this._imageHashtable.put("smalllogo", new ImageIcon(this.getClass().getResource("images/logo.jpg")));
    }

    public ImageIcon getImage(String string) {
        return (ImageIcon)this._imageHashtable.get(string);
    }

    public void getHelp() {
        Object object;
        this.splashWindow.show(this.getResource("dk.hfalk.HotEditActionL", "SplashWindow_InstallingHelp"));
        try {
            object = (class$dk$hfalk$HotEditAction == null ? (class$dk$hfalk$HotEditAction = HotEditAction.class$("dk.hfalk.HotEditAction")) : class$dk$hfalk$HotEditAction).getClassLoader();
            URL uRL = HelpSet.findHelpSet((ClassLoader)object, (String)"help/HotEditHelp.hs");
            this.helpSet = new HelpSet((ClassLoader)object, uRL);
        }
        catch (Exception exception) {
            System.out.println("HelpSet  not found");
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            System.err.println("initialization error:");
            exceptionInInitializerError.getException().printStackTrace();
        }
        this.helpBroker = this.helpSet.createHelpBroker();
        object = this.frame.getRootPane();
        this.helpBroker.enableHelpKey((Component)object, "maintitle", null);
    }

    public void getSettings() {
        this.splashWindow.show(this.getResource("dk.hfalk.HotEditActionL", "SplashWindow_LoadingSettings"));
        Dimension dimension = DBHotEditManager.instance().getWindowPositionDimension("HotEditManager");
        Point point = DBHotEditManager.instance().getWindowPositionLocation("HotEditManager");
        if (dimension.width == 0 && dimension.height == 0) {
            ((Component)this.frame).setSize(600, 400);
            this.frame.center();
        } else {
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            if (dimension.width > dimension2.width || dimension.height > dimension2.height) {
                ((Component)this.frame).setSize(600, 400);
                this.frame.center();
            } else {
                ((Component)this.frame).setLocation(point);
                ((Component)this.frame).setSize(dimension);
            }
        }
        DBHotEditManager.instance().state = 0;
    }

    public void buildMainWindow() {
        this.splashWindow.show(this.getResource("dk.hfalk.HotEditActionL", "SplashWindow_BuildingMain"));
        this.frame.setTitle(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_Title") + " " + this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_Version"));
    }

    public JMenuBar getMenuBar() {
        JMenuItem jMenuItem;
        Object object;
        this.splashWindow.show(this.getResource("dk.hfalk.HotEditActionL", "SplashWindow_LoadingMenu"));
        JMenuBar jMenuBar = new JMenuBar();
        this.fileMenu = new JMenu(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuFile"));
        CSH.setHelpIDString((Component)this.fileMenu, (String)"menufile");
        this.openFile = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuFileOpen"));
        this.openFileAction = new OpenFileAction();
        this.openFileAction.setup(this);
        this.openFile.addActionListener(this.openFileAction);
        this.fileMenu.add(this.openFile);
        this.saveFile = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuFileSave"));
        this.saveFileAction = new SaveFileAction();
        this.saveFileAction.setup(this);
        this.saveFile.addActionListener(this.saveFileAction);
        this.fileMenu.add(this.saveFile);
        this.fileMenu.addSeparator();
        this.quitFile = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuFileQuit"));
        this.quitAction = new JQuitAction(this.frame);
        this.quitFile.addActionListener(this.quitAction);
        this.fileMenu.add(this.quitFile);
        jMenuBar.add(this.fileMenu);
        JMenu jMenu = new JMenu(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuEdit"));
        CSH.setHelpIDString((Component)jMenu, (String)"menuedit");
        JMenu jMenu2 = new JMenu(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuEditStartMark"));
        this.markPOLYTool = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuEditStartMarkPOLY"));
        this.polyAction = new MarkToolAction();
        this.polyAction.setup(this, "POLY");
        this.markPOLYTool.addActionListener(this.polyAction);
        jMenu2.add(this.markPOLYTool);
        this.markRECTTool = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuEditStartMarkRECT"));
        this.rectAction = new MarkToolAction();
        this.rectAction.setup(this, "RECT");
        this.markRECTTool.addActionListener(this.rectAction);
        jMenu2.add(this.markRECTTool);
        this.markCIRCLETool = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuEditStartMarkCIRCLE"));
        this.circleAction = new MarkToolAction();
        this.circleAction.setup(this, "CIRCLE");
        this.markCIRCLETool.addActionListener(this.circleAction);
        jMenu2.add(this.markCIRCLETool);
        jMenu.add(jMenu2);
        this.endmarkTool = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuEditEndMark"));
        this.endmarkTool.addActionListener(this.frame);
        jMenu.add(this.endmarkTool);
        this.deleteAreaTool = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuEditAreaDelete"));
        this.deleteAreaAction = new DeleteAreaAction();
        this.deleteAreaAction.setup(this);
        this.deleteAreaTool.addActionListener(this.deleteAreaAction);
        jMenu.add(this.deleteAreaTool);
        jMenu.addSeparator();
        this.hotSpotInfoEdit = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuEditHotSpotInfo"));
        this.hotSpotEditPropertiesAction = new HotSpotEditPropertiesAction();
        this.hotSpotEditPropertiesAction.setup(this, false);
        this.hotSpotInfoEdit.addActionListener(this.hotSpotEditPropertiesAction);
        jMenu.add(this.hotSpotInfoEdit);
        jMenu.addSeparator();
        this.nameEdit = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuEditImageName"));
        this.imageNameAction = new ImageNameAction();
        this.imageNameAction.setup(this);
        this.nameEdit.addActionListener(this.imageNameAction);
        jMenu.add(this.nameEdit);
        this.descriptionEdit = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuEditImageDescription"));
        this.imageDescriptionAction = new ImageDescriptionAction();
        this.imageDescriptionAction.setup(this);
        this.descriptionEdit.addActionListener(this.imageDescriptionAction);
        jMenu.add(this.descriptionEdit);
        jMenu.addSeparator();
        this.settingsEdit = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuEditSettings"));
        this.appSettingsAction = new AppSettingsAction();
        this.appSettingsAction.setup(this);
        this.settingsEdit.addActionListener(this.appSettingsAction);
        jMenu.add(this.settingsEdit);
        jMenuBar.add(jMenu);
        JMenu jMenu3 = new JMenu(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuTool"));
        CSH.setHelpIDString((Component)jMenu3, (String)"menutool");
        this.showhideAreaTool = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuToolAreaHide"));
        this.showHideAreaAction = new ShowHideAreaAction();
        this.showHideAreaAction.setup(this);
        this.showhideAreaTool.addActionListener(this.showHideAreaAction);
        jMenu3.add(this.showhideAreaTool);
        jMenu3.addSeparator();
        JMenu jMenu4 = new JMenu(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuToolPrint"));
        jMenu3.add(jMenu4);
        this.printImage = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuToolPrintImage"));
        jMenu4.add(this.printImage);
        this.printInformation = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuToolPrintInformation"));
        jMenu4.add(this.printInformation);
        this.printHotSpot = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuToolPrintHotSpot"));
        jMenu4.add(this.printHotSpot);
        jMenu3.addSeparator();
        this.imageInfoTool = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuToolImageInfo"));
        this.imageInformationAction = new ImageInformationAction();
        this.imageInformationAction.setup(this);
        this.imageInfoTool.addActionListener(this.imageInformationAction);
        jMenu3.add(this.imageInfoTool);
        jMenuBar.add(jMenu3);
        JMenu jMenu5 = new JMenu(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuPlugIn"));
        jMenuBar.add(jMenu5);
        Enumeration enumeration = DBHotEditManager.instance().getPlugInList().elements();
        while (enumeration.hasMoreElements()) {
            object = (PlugInInterface)enumeration.nextElement();
            jMenuItem = object.getMenu();
            jMenu5.add(jMenuItem);
        }
        this.windowMenu = new JMenu(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuWindow"));
        this.logWindowItem = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuWindowLog"));
        jMenuBar.add(this.windowMenu);
        object = new JMenu(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuHelp"));
        CSH.setHelpIDString((Component)object, (String)"menuhelp");
        jMenuItem = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuHelpGeneralHelp"));
        CSH.setHelpIDString((Component)jMenuItem, (String)"maintitle");
        jMenuItem.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(this.helpBroker));
        ((JMenu)object).add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuHelpKeysHelp"));
        CSH.setHelpIDString((Component)jMenuItem2, (String)"menuhelpkeys");
        jMenuItem2.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(this.helpBroker));
        ((JMenu)object).add(jMenuItem2);
        ((JMenu)object).addSeparator();
        this.prodHelp = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuHelpProductInfo"));
        this.productInfoAction = new JProductInfoAction(this.frame);
        this.productInfoAction.setup(this);
        this.productInfoAction.setTitle(DBHotEditManager.instance().common("Common_ProductInfoTitle"));
        this.productInfoAction.setText(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_HTMLTitle"), this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_SubTitle"));
        this.prodHelp.addActionListener(this.productInfoAction);
        ((JMenu)object).add(this.prodHelp);
        jMenuBar.add((JMenu)object);
        return jMenuBar;
    }

    public JToolBar getToolBar() {
        this.splashWindow.show(this.getResource("dk.hfalk.HotEditActionL", "SplashWindow_LoadingToolbar"));
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.openButton = new JButton(this.getImage("open"));
        this.openButton.setActionCommand(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuFileOpen"));
        this.openButton.addActionListener(this.openFileAction);
        this.openButton.setToolTipText(this.getResource("dk.hfalk.HotEditActionL", "ToolBarButton_OpenImage"));
        this.saveButton = new JButton(this.getImage("save"));
        this.saveButton.setActionCommand(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuFileSave"));
        this.saveButton.addActionListener(this.saveFileAction);
        this.saveButton.setToolTipText(this.getResource("dk.hfalk.HotEditActionL", "ToolBarButton_SaveImage"));
        this.polyButton = new JButton(this.getImage("polysmall"));
        this.polyButton.setActionCommand(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuEditStartMarkPOLY"));
        this.polyButton.addActionListener(this.polyAction);
        this.polyButton.setToolTipText(this.getResource("dk.hfalk.HotEditActionL", "ToolBarButton_MarkPoly"));
        this.rectButton = new JButton(this.getImage("rectsmall"));
        this.rectButton.setActionCommand(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuEditStartMarkRECT"));
        this.rectButton.addActionListener(this.rectAction);
        this.rectButton.setToolTipText(this.getResource("dk.hfalk.HotEditActionL", "ToolBarButton_MarkRect"));
        this.circleButton = new JButton(this.getImage("circlesmall"));
        this.circleButton.setActionCommand(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuEditStartMarkCIRCLE"));
        this.circleButton.addActionListener(this.circleAction);
        this.circleButton.setToolTipText(this.getResource("dk.hfalk.HotEditActionL", "ToolBarButton_MarkCircle"));
        JButton jButton = new JButton(this.getImage("settings"));
        jButton.addActionListener(this.appSettingsAction);
        jButton.setToolTipText(this.getResource("dk.hfalk.HotEditActionL", "ToolBarButton_MainSettings"));
        JButton jButton2 = new JButton(this.getImage("infohelp"));
        CSH.setHelpIDString((Component)jButton2, (String)"maintitle");
        jButton2.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(this.helpBroker));
        jButton2.setToolTipText(this.getResource("dk.hfalk.HotEditActionL", "ToolBarButton_MainHelp"));
        jToolBar.add(this.openButton);
        jToolBar.add(this.saveButton);
        jToolBar.addSeparator();
        jToolBar.add(this.polyButton);
        jToolBar.add(this.rectButton);
        jToolBar.add(this.circleButton);
        jToolBar.addSeparator();
        jToolBar.add(jButton);
        jToolBar.addSeparator();
        jToolBar.add(jButton2);
        return jToolBar;
    }

    public void getKeyboardAction() {
        this.splashWindow.show(this.getResource("dk.hfalk.HotEditActionL", "SplashWindow_InstallingKeyboard"));
        this.frame.getRootPane().registerKeyboardAction(this.saveFileAction, KeyStroke.getKeyStroke(113, 0, false), 2);
        this.frame.getRootPane().registerKeyboardAction(this.quitAction, KeyStroke.getKeyStroke(114, 0, false), 2);
        this.frame.getRootPane().registerKeyboardAction(this.quitAction, KeyStroke.getKeyStroke(81, 0, false), 2);
        this.saveQuitFileAction = new SaveQuitFileAction();
        this.saveQuitFileAction.setup(this);
        this.frame.getRootPane().registerKeyboardAction(this.saveQuitFileAction, KeyStroke.getKeyStroke(115, 0, false), 2);
        this.frame.getRootPane().registerKeyboardAction(this.deleteAreaAction, KeyStroke.getKeyStroke(127, 0, false), 2);
        this.frame.getRootPane().registerKeyboardAction(this.deleteAreaAction, KeyStroke.getKeyStroke(68, 0, false), 2);
        this.frame.getRootPane().registerKeyboardAction(this.productInfoAction, KeyStroke.getKeyStroke(121, 0, false), 2);
    }

    public HotEditFrame getFrame() {
        return this.frame;
    }

    public void setActiveWindow(HotEditInternalAction hotEditInternalAction) {
        this.activeWindow = hotEditInternalAction;
        this.refreshWindowMenu();
        this.enableMenu();
    }

    public HotEditInternalAction getActiveWindow() {
        return this.activeWindow;
    }

    public void addWindow(HotEditInternalAction hotEditInternalAction) {
        if (this.windowList == null) {
            this.windowList = new Hashtable();
        }
        this.windowList.put(hotEditInternalAction.getFilename(), hotEditInternalAction);
        this.refreshWindowMenu();
    }

    public void removeWindow(HotEditInternalAction hotEditInternalAction) {
        this.windowList.remove(hotEditInternalAction.getFilename());
        if (this.windowList.isEmpty()) {
            this.windowList = null;
        }
        this.refreshWindowMenu();
    }

    public HotEditInternalAction getWindow(String string) {
        if (this.windowList == null) {
            this.windowList = new Hashtable();
        }
        Enumeration enumeration = this.windowList.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equals(string)) continue;
            return (HotEditInternalAction)this.windowList.get(string2);
        }
        return null;
    }

    public void enableMenu() {
        Enumeration enumeration = DBHotEditManager.instance().getPlugInList().elements();
        while (enumeration.hasMoreElements()) {
            PlugInInterface plugInInterface = (PlugInInterface)enumeration.nextElement();
            plugInInterface.updateMenu();
        }
        if (this.windowList == null) {
            this.saveFile.setEnabled(false);
            this.saveButton.setEnabled(false);
            this.hotSpotInfoEdit.setEnabled(false);
            this.markPOLYTool.setEnabled(false);
            this.polyButton.setEnabled(false);
            this.markRECTTool.setEnabled(false);
            this.rectButton.setEnabled(false);
            this.markCIRCLETool.setEnabled(false);
            this.circleButton.setEnabled(false);
            this.endmarkTool.setEnabled(false);
            this.showhideAreaTool.setEnabled(false);
            this.nameEdit.setEnabled(false);
            this.descriptionEdit.setEnabled(false);
            this.deleteAreaTool.setEnabled(false);
            this.imageInfoTool.setEnabled(false);
            this.printImage.setEnabled(false);
            this.printInformation.setEnabled(false);
            this.printHotSpot.setEnabled(false);
            return;
        }
        this.saveFile.setEnabled(true);
        this.saveButton.setEnabled(true);
        this.markPOLYTool.setEnabled(true);
        this.polyButton.setEnabled(true);
        this.markRECTTool.setEnabled(true);
        this.rectButton.setEnabled(true);
        this.markCIRCLETool.setEnabled(true);
        this.circleButton.setEnabled(true);
        this.endmarkTool.setEnabled(false);
        this.nameEdit.setEnabled(true);
        this.descriptionEdit.setEnabled(true);
        this.imageInfoTool.setEnabled(true);
        this.printImage.setEnabled(true);
        this.printInformation.setEnabled(true);
        this.printHotSpot.setEnabled(true);
        if (this.activeWindow == null) {
            this.saveFile.setEnabled(false);
            this.saveButton.setEnabled(false);
            this.hotSpotInfoEdit.setEnabled(false);
            this.markPOLYTool.setEnabled(false);
            this.polyButton.setEnabled(false);
            this.markRECTTool.setEnabled(false);
            this.rectButton.setEnabled(false);
            this.markCIRCLETool.setEnabled(false);
            this.circleButton.setEnabled(false);
            this.endmarkTool.setEnabled(false);
            this.showhideAreaTool.setEnabled(false);
            this.nameEdit.setEnabled(false);
            this.descriptionEdit.setEnabled(false);
            this.deleteAreaTool.setEnabled(false);
            this.imageInfoTool.setEnabled(false);
            this.printImage.setEnabled(false);
            this.printInformation.setEnabled(false);
            this.printHotSpot.setEnabled(false);
            return;
        }
        if (this.activeWindow.getHotspotCount() > 0) {
            this.showhideAreaTool.setEnabled(true);
            this.deleteAreaTool.setEnabled(true);
            this.hotSpotInfoEdit.setEnabled(true);
        }
        if (this.activeWindow.getHotspotCount() == 0) {
            this.showhideAreaTool.setEnabled(false);
            this.deleteAreaTool.setEnabled(false);
            this.hotSpotInfoEdit.setEnabled(false);
            this.printHotSpot.setEnabled(false);
        }
        if (DBHotEditManager.instance().state == 16) {
            this.markPOLYTool.setEnabled(false);
            this.polyButton.setEnabled(false);
            this.markRECTTool.setEnabled(false);
            this.rectButton.setEnabled(false);
            this.markCIRCLETool.setEnabled(false);
            this.circleButton.setEnabled(false);
            this.endmarkTool.setEnabled(true);
            this.openFile.setEnabled(false);
            this.openButton.setEnabled(false);
        } else {
            this.markPOLYTool.setEnabled(true);
            this.polyButton.setEnabled(true);
            this.markRECTTool.setEnabled(true);
            this.rectButton.setEnabled(true);
            this.markCIRCLETool.setEnabled(true);
            this.circleButton.setEnabled(true);
            this.endmarkTool.setEnabled(false);
            this.openFile.setEnabled(true);
            this.openButton.setEnabled(true);
        }
    }

    public void refreshFileMenu() {
        int n = 4;
        int n2 = n + 5 + 1;
        if (DBHotEditManager.instance().sizeLastGroup() == 0) {
            return;
        }
        if (this.fileMenu.getItemCount() >= n) {
            this.fileMenu.removeAll();
            this.openFile = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuFileOpen"));
            this.openFile.addActionListener(this.openFileAction);
            this.fileMenu.add(this.openFile);
            this.saveFile = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuFileSave"));
            this.saveFile.addActionListener(this.saveFileAction);
            this.fileMenu.add(this.saveFile);
            this.fileMenu.addSeparator();
            int n3 = 0;
            while (n3 < DBHotEditManager.instance().sizeLastGroup()) {
                JMenuItem jMenuItem = new JMenuItem(String.valueOf(this.fileMenu.getItemCount() - n + 2) + " " + DBHotEditManager.instance().itemLastGroupAt(n3));
                jMenuItem.setActionCommand(String.valueOf(this.fileMenu.getItemCount() - n + 2));
                jMenuItem.addActionListener(this.frame);
                this.fileMenu.add(jMenuItem);
                ++n3;
            }
            this.fileMenu.addSeparator();
            this.quitFile = new JMenuItem(this.getResource("dk.hfalk.HotEditActionL", "JHotEdit_MenuFileQuit"));
            this.quitFile.addActionListener(this.quitAction);
            this.fileMenu.add(this.quitFile);
        }
        this.enableMenu();
    }

    public void refreshWindowMenu() {
        if (this.windowList == null) {
            this.windowMenu.removeAll();
            return;
        }
        this.windowMenu.removeAll();
        int n = 1;
        Enumeration enumeration = this.windowList.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            JMenuItem jMenuItem = new JMenuItem(String.valueOf(n) + " " + string);
            jMenuItem.addActionListener((HotEditInternalAction)this.windowList.get(string));
            ++n;
            this.windowMenu.add(jMenuItem);
        }
    }

    public HelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

