/*
 * Decompiled with CFR 0.152.
 */
package dk.hfalk.db;

import dk.hfalk.HotEditAction;
import dk.hfalk.db.DBHotSpotGroup;
import dk.hfalk.hotedit.util.PlugInInterface;
import dk.hfalk.util.Service;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class DBHotEditManager
implements Serializable {
    private String id = "HotEditManager";
    private String version = "1.0";
    private static DBHotEditManager _instance = null;
    private Vector windowList = new Vector();
    private Vector groupNameList = new Vector();
    private Vector groupFileList = new Vector();
    private Vector lastGroupList = new Vector();
    private ResourceBundle common;
    private boolean isCommonLoaded;
    private String _language = null;
    private String _country = null;
    public static final int STATE_NORMAL = 0;
    public static final int STATE_DRAW = 2;
    public static final int STATE_MOVE = 4;
    public static final int STATE_RESIZE = 8;
    public static final int STATE_STARTMARK = 16;
    public transient int state;
    private Hashtable resourceList = null;
    private Locale currentLocale = null;
    private Hashtable pluginList = null;
    HotEditAction controller;

    protected DBHotEditManager() {
        if (!new File("data").exists()) {
            new File("data").mkdir();
        }
        int n = 0;
        n = this.load();
        if (n != 0) {
            this.save();
        }
        Locale locale = new Locale(this.getLanguage(), this.getCountry());
        this.common = ResourceBundle.getBundle("dk.hfalk.CommonL", locale);
    }

    public void addGroup(String string, String string2) {
        this.groupNameList.addElement(string);
        this.groupFileList.addElement(string2);
    }

    public void addLastGroup(String string) {
        int n = this.lastGroupList.size();
        if (string.equals(this.itemLastGroup(string))) {
            if (this.itemLastGroupAt(0).equals(string)) {
                return;
            }
            int n2 = 1;
            while (n2 < this.sizeLastGroup()) {
                if (this.itemLastGroupAt(n2).equals(string)) {
                    this.lastGroupList.removeElementAt(n2);
                }
                ++n2;
            }
            this.lastGroupList.insertElementAt(string, 0);
            return;
        }
        if (n < 5) {
            this.lastGroupList.insertElementAt(string, 0);
        } else {
            this.lastGroupList.removeElementAt(4);
            this.lastGroupList.insertElementAt(string, 0);
        }
    }

    public String common(String string) {
        return this.common.getString(string);
    }

    public String getCountry() {
        if (this._country == null) {
            this._language = "en";
            this._country = "UK";
        }
        return this._country;
    }

    public String getLanguage() {
        if (this._language == null) {
            this._language = "en";
            this._country = "UK";
        }
        return this._language;
    }

    public Dimension getWindowPositionDimension(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.windowList.size()) {
            String string2 = (String)this.windowList.elementAt(n3);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            String string3 = stringTokenizer.nextToken();
            if (string3.equals(string)) {
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                String string7 = stringTokenizer.nextToken();
                n = Integer.parseInt(string6);
                n2 = Integer.parseInt(string7);
            }
            ++n3;
        }
        return new Dimension(n, n2);
    }

    public Point getWindowPositionLocation(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.windowList.size()) {
            String string2 = (String)this.windowList.elementAt(n3);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            String string3 = stringTokenizer.nextToken();
            if (string3.equals(string)) {
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                String string7 = stringTokenizer.nextToken();
                n = Integer.parseInt(string4);
                n2 = Integer.parseInt(string5);
            }
            ++n3;
        }
        return new Point(n, n2);
    }

    public static DBHotEditManager instance() {
        if (_instance == null) {
            _instance = new DBHotEditManager();
        }
        return _instance;
    }

    public DBHotSpotGroup itemGroup(String string) {
        int n = 0;
        while (n < this.groupNameList.size()) {
            String string2 = (String)this.groupNameList.elementAt(n);
            if (string2.equals(string)) {
                DBHotSpotGroup dBHotSpotGroup = new DBHotSpotGroup();
                dBHotSpotGroup.setFileName((String)this.groupFileList.elementAt(n));
                dBHotSpotGroup.load();
                return dBHotSpotGroup;
            }
            ++n;
        }
        return null;
    }

    public String itemGroupNameAt(int n) {
        String string = (String)this.groupNameList.elementAt(n);
        return string;
    }

    public String itemLastGroup(String string) {
        int n = 0;
        while (n < this.lastGroupList.size()) {
            String string2 = (String)this.lastGroupList.elementAt(n);
            if (string2.equals(string)) {
                return string2;
            }
            ++n;
        }
        return null;
    }

    public String itemLastGroupAt(int n) {
        String string = (String)this.lastGroupList.elementAt(n);
        return string;
    }

    public int load() {
        Object var5_1 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream("data" + Service.fileSeparator() + "HotEditManager.DBHotEditManager");
            GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
            this.id = (String)objectInputStream.readObject();
            this.version = (String)objectInputStream.readObject();
            this.windowList = (Vector)objectInputStream.readObject();
            this.groupNameList = (Vector)objectInputStream.readObject();
            this.groupFileList = (Vector)objectInputStream.readObject();
            this.lastGroupList = (Vector)objectInputStream.readObject();
            this._language = (String)objectInputStream.readObject();
            this._country = (String)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("IOException: Could not Deserialize!");
            return 41;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ClassNotFoundException: Could not Deserialize!");
            return 42;
        }
        return 0;
    }

    public void removeGroup(String string) {
        int n = 0;
        while (n < this.groupNameList.size()) {
            String string2 = (String)this.groupNameList.elementAt(n);
            if (string2.equals(string)) {
                this.groupNameList.removeElementAt(n);
            }
            ++n;
        }
    }

    public void removeLastGroup(String string) {
        int n = 0;
        while (n < this.lastGroupList.size()) {
            String string2 = (String)this.lastGroupList.elementAt(n);
            if (string2.equals(string)) {
                this.lastGroupList.removeElementAt(n);
            }
            ++n;
        }
    }

    public boolean save() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("data" + Service.fileSeparator() + "HotEditManager.DBHotEditManager");
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            objectOutputStream.writeObject(this.id);
            objectOutputStream.writeObject(this.version);
            objectOutputStream.writeObject(this.windowList);
            objectOutputStream.writeObject(this.groupNameList);
            objectOutputStream.writeObject(this.groupFileList);
            objectOutputStream.writeObject(this.lastGroupList);
            objectOutputStream.writeObject(this._language);
            objectOutputStream.writeObject(this._country);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("IOException: Could not Serialize!");
        }
        return true;
    }

    public DBHotEditManager setCountry(String string) {
        this._country = string;
        Locale locale = new Locale(this.getLanguage(), this.getCountry());
        this.common = ResourceBundle.getBundle("dk.hfalk.CommonL", locale);
        return this;
    }

    public DBHotEditManager setLanguage(String string) {
        this._language = string;
        return this;
    }

    public boolean setWindowPosition(String string, Point point, Dimension dimension) {
        String string2 = string + "," + String.valueOf(point.x) + "," + String.valueOf(point.y) + "," + String.valueOf(dimension.width) + "," + String.valueOf(dimension.height);
        int n = 0;
        while (n < this.windowList.size()) {
            String string3 = (String)this.windowList.elementAt(n);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            String string4 = stringTokenizer.nextToken();
            if (string4.equals(string)) {
                try {
                    this.windowList.setElementAt(string2, n);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                return true;
            }
            ++n;
        }
        this.windowList.addElement(string2);
        return true;
    }

    public int sizeGroup() {
        return this.groupNameList.size();
    }

    public int sizeLastGroup() {
        return this.lastGroupList.size();
    }

    public Locale getLocale() {
        return new Locale(this.getLanguage(), this.getCountry());
    }

    public String getResource(String string, String string2) {
        ResourceBundle resourceBundle = null;
        if (this.resourceList == null) {
            this.resourceList = new Hashtable();
        }
        if (this.currentLocale != DBHotEditManager.instance().getLocale()) {
            this.resourceList.clear();
            this.currentLocale = DBHotEditManager.instance().getLocale();
        }
        if (!this.resourceList.contains(string)) {
            try {
                resourceBundle = ResourceBundle.getBundle(string, this.currentLocale);
            }
            catch (MissingResourceException missingResourceException) {
                return null;
            }
            this.resourceList.put(string, resourceBundle);
        } else {
            resourceBundle = (ResourceBundle)this.resourceList.get(string);
        }
        return resourceBundle.getString(string2);
    }

    public Hashtable getPlugInList() {
        if (this.pluginList == null) {
            this.pluginList = new Hashtable();
            PlugInInterface plugInInterface = null;
            try {
                plugInInterface = (PlugInInterface)Class.forName("dk.hfalk.hotedit.html.clientside.ClientSideHTMLPlugIn").newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                return this.pluginList;
            }
            catch (Exception exception) {
                return this.pluginList;
            }
            this.pluginList.put("dk.hfalk.hotedit.html.clientside.ClientSideHTMLPlugIn", plugInInterface);
        }
        return this.pluginList;
    }

    public void setMainController(HotEditAction hotEditAction) {
        this.controller = hotEditAction;
    }

    public HotEditAction getMainController() {
        return this.controller;
    }
}

