/*
 * Decompiled with CFR 0.152.
 */
package dk.hfalk.db;

import dk.hfalk.db.DBHotSpotItem;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class DBHotSpotGroup
extends Observable
implements Observer,
Serializable {
    protected String id = "HotSpotGroup";
    protected String version = "1.0";
    protected String name;
    protected String description;
    protected Vector hotSpotItemList = new Vector();
    protected String fileName;
    protected String fileDescription;
    private long uidCount;

    public DBHotSpotGroup() {
        this.description = new String();
        this.name = new String();
        this.setChanged();
        this.notifyObservers("DBHotSpotGroup");
    }

    public void add(DBHotSpotItem dBHotSpotItem) {
        dBHotSpotItem.addObserver(this);
        this.hotSpotItemList.addElement(dBHotSpotItem);
        this.setChanged();
        this.notifyObservers(dBHotSpotItem);
    }

    public String description() {
        return this.description;
    }

    public boolean doNameExist(String string) {
        Enumeration enumeration = this.items().elements();
        while (enumeration.hasMoreElements()) {
            DBHotSpotItem dBHotSpotItem = (DBHotSpotItem)enumeration.nextElement();
            if (!dBHotSpotItem.name().toUpperCase().equals(string.toUpperCase())) continue;
            return false;
        }
        return true;
    }

    public String fileDescription() {
        return this.fileDescription;
    }

    public String fileName() {
        return this.fileName;
    }

    public DBHotSpotItem getSelected() {
        Enumeration enumeration = this.items().elements();
        while (enumeration.hasMoreElements()) {
            DBHotSpotItem dBHotSpotItem = (DBHotSpotItem)enumeration.nextElement();
            if (!dBHotSpotItem.isSelected()) continue;
            return dBHotSpotItem;
        }
        return null;
    }

    public DBHotSpotItem item(String string) {
        int n = 0;
        while (n < this.hotSpotItemList.size()) {
            DBHotSpotItem dBHotSpotItem = (DBHotSpotItem)this.hotSpotItemList.elementAt(n);
            if (dBHotSpotItem.name().equals(string)) {
                return (DBHotSpotItem)this.hotSpotItemList.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    public DBHotSpotItem itemAt(int n) {
        return (DBHotSpotItem)this.hotSpotItemList.elementAt(n);
    }

    public Vector items() {
        return this.hotSpotItemList;
    }

    public int load() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.fileName.substring(0, this.fileName.length() - 4) + ".DBHotSpotGroup");
            GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
            this.id = (String)objectInputStream.readObject();
            this.version = (String)objectInputStream.readObject();
            this.name = (String)objectInputStream.readObject();
            this.description = (String)objectInputStream.readObject();
            this.uidCount = objectInputStream.readLong();
            this.hotSpotItemList = (Vector)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("IOException: Could not Deserialize!");
            return 41;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ClassNotFoundException: Could not Deserialize!");
            return 42;
        }
        this.setChanged();
        this.notifyObservers("Load");
        return 0;
    }

    public String name() {
        return this.name;
    }

    public void remove(long l) {
        int n = 0;
        while (n < this.hotSpotItemList.size()) {
            DBHotSpotItem dBHotSpotItem = (DBHotSpotItem)this.hotSpotItemList.elementAt(n);
            if (dBHotSpotItem.getUID() == l) {
                ((DBHotSpotItem)this.hotSpotItemList.elementAt(n)).deleteObserver(this);
                this.hotSpotItemList.removeElementAt(n);
            }
            ++n;
        }
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void removeAllElements() {
        int n = 0;
        while (n < this.hotSpotItemList.size()) {
            ((DBHotSpotItem)this.hotSpotItemList.elementAt(n)).deleteObserver(this);
            this.hotSpotItemList.removeElementAt(n);
            ++n;
        }
        this.setChanged();
        this.notifyObservers();
    }

    public boolean save() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName.substring(0, this.fileName.length() - 4) + ".DBHotSpotGroup");
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            objectOutputStream.writeObject(this.id);
            objectOutputStream.writeObject(this.version);
            objectOutputStream.writeObject(this.name);
            objectOutputStream.writeObject(this.description);
            objectOutputStream.writeLong(this.uidCount);
            objectOutputStream.writeObject(this.hotSpotItemList);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("IOException: Could not Serialize!");
        }
        return true;
    }

    public DBHotSpotItem select(int n, int n2) {
        Enumeration enumeration = this.items().elements();
        while (enumeration.hasMoreElements()) {
            DBHotSpotItem dBHotSpotItem = (DBHotSpotItem)enumeration.nextElement();
            if (!dBHotSpotItem.isOnBorder(n, n2)) continue;
            return dBHotSpotItem;
        }
        return null;
    }

    public void setDescription(String string) {
        if (this.description == null) {
            this.description = new String();
        }
        if (!this.description.equals(string)) {
            this.description = string;
        }
        this.setChanged();
        this.notifyObservers(this.description);
    }

    public void setFileDescription(String string) {
        if (this.fileDescription == null) {
            this.fileDescription = new String();
        }
        if (!this.fileDescription.equals(string)) {
            this.fileDescription = string;
        }
        this.setChanged();
        this.notifyObservers(this.fileDescription);
    }

    public void setFileName(String string) {
        if (this.fileName == null) {
            this.fileName = new String();
        }
        if (!this.fileName.equals(string)) {
            this.fileName = string;
        }
        this.setChanged();
        this.notifyObservers(this.fileName);
    }

    public void setName(String string) {
        if (this.name == null) {
            this.name = new String();
        }
        if (!this.name.equals(string)) {
            this.name = string;
        }
        this.setChanged();
        this.notifyObservers(this.name);
    }

    public int size() {
        return this.hotSpotItemList.size();
    }

    public void update(Observable observable, Object object) {
        this.setChanged();
        this.notifyObservers("Item");
    }

    public synchronized long getUID() {
        ++this.uidCount;
        return this.uidCount;
    }
}

