/*
 * Decompiled with CFR 0.152.
 */
package dk.hfalk.hotedit.html.clientside.db;

import dk.hfalk.util.Service;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class DBClientSideHTMLManager
implements Serializable {
    private String id = "ClientSideHTMLManager";
    private String version = "1.0";
    private static DBClientSideHTMLManager _instance = null;
    private boolean mapTag = false;
    private boolean altAttribute = false;

    protected DBClientSideHTMLManager() {
        if (!new File("data").exists()) {
            new File("data").mkdir();
        }
        int n = 0;
        n = this.load();
        if (n != 0) {
            this.save();
        }
    }

    public static DBClientSideHTMLManager instance() {
        if (_instance == null) {
            _instance = new DBClientSideHTMLManager();
        }
        return _instance;
    }

    public int load() {
        try {
            FileInputStream fileInputStream = new FileInputStream("data" + Service.fileSeparator() + "ClientSideHTMLManager.DBClientSideHTMLManager");
            GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
            this.id = (String)objectInputStream.readObject();
            this.version = (String)objectInputStream.readObject();
            this.mapTag = objectInputStream.readBoolean();
            this.altAttribute = objectInputStream.readBoolean();
            objectInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("IOException: Could not Deserialize!");
            return 41;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ClassNotFoundException: Could not Deserialize!");
            return 42;
        }
        return 0;
    }

    public boolean save() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("data" + Service.fileSeparator() + "ClientSideHTMLManager.DBClientSideHTMLManager");
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            objectOutputStream.writeObject(this.id);
            objectOutputStream.writeObject(this.version);
            objectOutputStream.writeBoolean(this.mapTag);
            objectOutputStream.writeBoolean(this.altAttribute);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("IOException: Could not Serialize!");
        }
        return true;
    }

    public boolean getMapTag() {
        return this.mapTag;
    }

    public void setMapTag(boolean bl) {
        this.mapTag = bl;
    }

    public boolean getAltAttribute() {
        return this.altAttribute;
    }

    public void setAltAttribute(boolean bl) {
        this.altAttribute = bl;
    }
}

