/*
 * Decompiled with CFR 0.152.
 */
package dk.hfalk.hotedit.html.clientside.util;

import dk.hfalk.db.DBHotSpotGroup;
import dk.hfalk.db.DBHotSpotItem;
import dk.hfalk.hotedit.html.clientside.db.DBClientSideHTMLManager;
import dk.hfalk.hotedit.html.clientside.util.Compositor;
import dk.hfalk.hotedit.util.HotEditPlugIn;
import dk.hfalk.util.Service;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class HTMLCompositor
implements Compositor {
    private ByteArrayOutputStream outputStream;

    public void compose(ByteArrayOutputStream byteArrayOutputStream, DBHotSpotGroup dBHotSpotGroup) {
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        if (dBHotSpotGroup.size() == 0) {
            printWriter.println("");
            printWriter.close();
        }
        String string = dBHotSpotGroup.fileName().substring(dBHotSpotGroup.fileName().lastIndexOf(Service.fileSeparator()) + 1, dBHotSpotGroup.fileName().length());
        String string2 = string.substring(0, string.length() - 4);
        if (!DBClientSideHTMLManager.instance().getMapTag()) {
            printWriter.print("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">\n");
            printWriter.print("<HTML>\n");
            printWriter.print("<BODY>\n");
            printWriter.print("<HEAD>\n");
            printWriter.print("  <TITLE>" + string2 + "</TITLE>\n\n");
            printWriter.print("  <META NAME=\"Generator\"\n");
            printWriter.print("        CONTENT=\"HotEdit v" + HotEditPlugIn.getHotEditVersion() + "\">\n");
            printWriter.print("</HEAD>\n\n");
        }
        this.generateMap(printWriter, dBHotSpotGroup);
        if (!DBClientSideHTMLManager.instance().getMapTag()) {
            printWriter.print("<CENTER>\n");
            if (string.substring(string.length() - 3, string.length()).equals("gif")) {
                printWriter.print("<IMG SRC=\"" + string2 + ".gif" + "\" USEMAP=\"#" + string2 + "\">\n");
            } else {
                printWriter.print("<IMG SRC=\"" + string2 + ".jpg" + "\" USEMAP=\"#" + string2 + "\">\n");
            }
            printWriter.print("</CENTER>\n");
            printWriter.print("\n</BODY>\n");
            printWriter.print("</HTML>\n");
        }
        printWriter.close();
    }

    public void generateMap(PrintWriter printWriter, DBHotSpotGroup dBHotSpotGroup) {
        String string = dBHotSpotGroup.fileName().substring(dBHotSpotGroup.fileName().lastIndexOf(Service.fileSeparator()) + 1, dBHotSpotGroup.fileName().length());
        String string2 = string.substring(0, string.length() - 4);
        printWriter.print("<MAP>\n");
        printWriter.print("<MAP NAME=\"" + string2 + "\">\n");
        int n = 0;
        while (n < dBHotSpotGroup.size()) {
            int n2;
            DBHotSpotItem dBHotSpotItem = dBHotSpotGroup.itemAt(n);
            if (dBHotSpotItem.type().equals("POLY")) {
                printWriter.print("<AREA SHAPE=POLY COORDS=\"");
                printWriter.print(dBHotSpotItem.value()[0]);
                printWriter.print("," + dBHotSpotItem.value()[1]);
                n2 = 2;
                while (n2 < dBHotSpotItem.value().length) {
                    printWriter.print("," + dBHotSpotItem.value()[n2]);
                    printWriter.print("," + dBHotSpotItem.value()[n2 + 1]);
                    n2 += 2;
                }
                printWriter.print("\" HREF=\"" + dBHotSpotItem.getAttribute("Html HREF") + "\"");
                if (DBClientSideHTMLManager.instance().getAltAttribute()) {
                    printWriter.print(" ALT=\"" + dBHotSpotItem.name() + "\">\n");
                } else {
                    printWriter.print(">\n");
                }
            }
            if (dBHotSpotItem.type().equals("RECT")) {
                printWriter.print("<AREA SHAPE=RECT COORDS=\"");
                if (dBHotSpotItem.value()[2] > dBHotSpotItem.value()[0] && dBHotSpotItem.value()[3] > dBHotSpotItem.value()[1]) {
                    printWriter.print(dBHotSpotItem.value()[0]);
                    printWriter.print("," + dBHotSpotItem.value()[1]);
                    printWriter.print("," + dBHotSpotItem.value()[2]);
                    printWriter.print("," + dBHotSpotItem.value()[3]);
                }
                if (dBHotSpotItem.value()[2] < dBHotSpotItem.value()[0] && dBHotSpotItem.value()[3] < dBHotSpotItem.value()[1]) {
                    printWriter.print(dBHotSpotItem.value()[2]);
                    printWriter.print("," + dBHotSpotItem.value()[3]);
                    printWriter.print("," + dBHotSpotItem.value()[0]);
                    printWriter.print("," + dBHotSpotItem.value()[1]);
                }
                if (dBHotSpotItem.value()[2] <= dBHotSpotItem.value()[0] && dBHotSpotItem.value()[3] >= dBHotSpotItem.value()[1]) {
                    printWriter.print(dBHotSpotItem.value()[2]);
                    printWriter.print("," + dBHotSpotItem.value()[1]);
                    printWriter.print("," + dBHotSpotItem.value()[0]);
                    printWriter.print("," + dBHotSpotItem.value()[3]);
                }
                if (dBHotSpotItem.value()[2] >= dBHotSpotItem.value()[0] && dBHotSpotItem.value()[3] <= dBHotSpotItem.value()[1]) {
                    printWriter.print(dBHotSpotItem.value()[0]);
                    printWriter.print("," + dBHotSpotItem.value()[3]);
                    printWriter.print("," + dBHotSpotItem.value()[2]);
                    printWriter.print("," + dBHotSpotItem.value()[1]);
                }
                printWriter.print("\" HREF=\"" + dBHotSpotItem.getAttribute("Html HREF") + "\"");
                if (DBClientSideHTMLManager.instance().getAltAttribute()) {
                    printWriter.print(" ALT=\"" + dBHotSpotItem.name() + "\">\n");
                } else {
                    printWriter.print(">\n");
                }
            }
            if (dBHotSpotItem.type().equals("CIRCLE")) {
                printWriter.print("<AREA SHAPE=CIRCLE COORDS=\"");
                printWriter.print(dBHotSpotItem.value()[0]);
                printWriter.print("," + dBHotSpotItem.value()[1]);
                n2 = (int)Math.round(Math.sqrt(Math.pow(dBHotSpotItem.value()[2] - dBHotSpotItem.value()[0], 2.0) + Math.pow(dBHotSpotItem.value()[3] - dBHotSpotItem.value()[1], 2.0)));
                printWriter.print("," + String.valueOf(n2));
                printWriter.print("\" HREF=\"" + dBHotSpotItem.getAttribute("Html HREF") + "\"");
                if (DBClientSideHTMLManager.instance().getAltAttribute()) {
                    printWriter.print(" ALT=\"" + dBHotSpotItem.name() + "\">\n");
                } else {
                    printWriter.print(">\n");
                }
            }
            ++n;
        }
        printWriter.print("<AREA SHAPE=default NOHREF>\n");
        printWriter.print("</MAP>\n\n");
    }
}

