/*
 * Decompiled with CFR 0.152.
 */
package org.vafada.jimagemapper;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import org.vafada.jimagemapper.DrawingLayer;
import org.vafada.jimagemapper.MapGenerator;
import org.vafada.jimagemapper.SwingWorker;
import org.vafada.jimagemapper.ZoomUtils;

public class JImageMapper
extends JFrame {
    public static final int RECTANGLE = 1;
    public static final int CIRCLE = 2;
    public static final int POLYGON = 3;
    public static final int SELECTION = 4;
    private JLabel imageContainer;
    private JLayeredPane layerPane;
    private DrawingLayer drawingLayer;
    private String imageName;
    private JLabel currentShape;
    private BufferedImage image;
    private double zoomLevel = 1.0;
    private static final double zoomIncrement = 0.8;

    public JImageMapper() {
        super("JImageMapper");
        this.initComponents();
        this.setVisible(true);
    }

    public JImageMapper(String string) {
        this();
        this.imageName = string;
        this.loadImage(this.imageName);
        this.drawingLayer.deleteShapes();
    }

    private void initComponents() {
        JToolBar jToolBar = new JToolBar(null, 0);
        jToolBar.setFloatable(false);
        ImageIcon imageIcon = new ImageIcon(JImageMapper.class.getResource("/img/Open24.gif"), "Open");
        JButton jButton = new JButton();
        jButton.setToolTipText("Open Image");
        jButton.setText(null);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setIcon(imageIcon);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(2);
                jFileChooser.setFileFilter(new MyFilter());
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.showOpenDialog(JImageMapper.this);
                File file = jFileChooser.getSelectedFile();
                if (file != null) {
                    JImageMapper.this.imageName = file.getName();
                    JImageMapper.this.loadImage(file.getPath());
                    JImageMapper.this.drawingLayer.deleteShapes();
                }
            }
        });
        jToolBar.add(jButton);
        ImageIcon imageIcon2 = new ImageIcon(JImageMapper.class.getResource("/img/Export24.gif"), "Export");
        JButton jButton2 = new JButton();
        jButton2.setToolTipText("Generate HTML");
        jButton2.setText(null);
        jButton2.setMargin(new Insets(0, 0, 0, 0));
        jButton2.setIcon(imageIcon2);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                List list = JImageMapper.this.drawingLayer.getShapes();
                MapGenerator.generateImageMap(JImageMapper.this.imageName, list);
            }
        });
        jToolBar.add(jButton2);
        jToolBar.add(new JToolBar.Separator());
        ImageIcon imageIcon3 = new ImageIcon(JImageMapper.class.getResource("/img/Select24.gif"), "Select");
        JToggleButton jToggleButton = new JToggleButton();
        jToggleButton.setToolTipText("Selection");
        jToggleButton.setText(null);
        jToggleButton.setMargin(new Insets(0, 0, 0, 0));
        jToggleButton.setIcon(imageIcon3);
        jToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JImageMapper.this.drawingLayer.setCurrentShape(4);
                JImageMapper.this.updateShape("Selection");
            }
        });
        jToolBar.add(jToggleButton);
        ImageIcon imageIcon4 = new ImageIcon(JImageMapper.class.getResource("/img/Rect24.gif"), "Rect");
        JToggleButton jToggleButton2 = new JToggleButton();
        jToggleButton2.setToolTipText("Rectangle");
        jToggleButton2.setText(null);
        jToggleButton2.setMargin(new Insets(0, 0, 0, 0));
        jToggleButton2.setIcon(imageIcon4);
        jToggleButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JImageMapper.this.drawingLayer.setCurrentShape(1);
                JImageMapper.this.updateShape("Rectangle");
            }
        });
        jToggleButton2.setSelected(true);
        jToolBar.add(jToggleButton2);
        ImageIcon imageIcon5 = new ImageIcon(JImageMapper.class.getResource("/img/Circle24.gif"), "Circle");
        JToggleButton jToggleButton3 = new JToggleButton();
        jToggleButton3.setToolTipText("Circle");
        jToggleButton3.setText(null);
        jToggleButton3.setMargin(new Insets(0, 0, 0, 0));
        jToggleButton3.setIcon(imageIcon5);
        jToggleButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JImageMapper.this.drawingLayer.setCurrentShape(2);
                JImageMapper.this.updateShape("Circle");
            }
        });
        jToolBar.add(jToggleButton3);
        ImageIcon imageIcon6 = new ImageIcon(JImageMapper.class.getResource("/img/Poly24.gif"), "Polygon");
        JToggleButton jToggleButton4 = new JToggleButton();
        jToggleButton4.setToolTipText("Polygon");
        jToggleButton4.setText(null);
        jToggleButton4.setMargin(new Insets(0, 0, 0, 0));
        jToggleButton4.setIcon(imageIcon6);
        jToggleButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JImageMapper.this.drawingLayer.setCurrentShape(3);
                JImageMapper.this.updateShape("Polygon");
            }
        });
        jToolBar.add(jToggleButton4);
        jToolBar.add(new JToolBar.Separator());
        ImageIcon imageIcon7 = new ImageIcon(JImageMapper.class.getResource("/img/Delete24.gif"), "Delete");
        JButton jButton3 = new JButton();
        jButton3.setToolTipText("Delete All");
        jButton3.setText(null);
        jButton3.setMargin(new Insets(0, 0, 0, 0));
        jButton3.setIcon(imageIcon7);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JImageMapper.this.drawingLayer.deleteShapes();
            }
        });
        jToolBar.add(jButton3);
        jToolBar.add(new JToolBar.Separator());
        ImageIcon imageIcon8 = new ImageIcon(JImageMapper.class.getResource("/img/ZoomIn24.gif"), "Zoom In");
        JButton jButton4 = new JButton();
        jButton4.setToolTipText("Zoom In");
        jButton4.setText(null);
        jButton4.setMargin(new Insets(0, 0, 0, 0));
        jButton4.setIcon(imageIcon8);
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JImageMapper.this.image != null) {
                    JImageMapper.this.zoomIn();
                }
            }
        });
        jToolBar.add(jButton4);
        ImageIcon imageIcon9 = new ImageIcon(JImageMapper.class.getResource("/img/ZoomOut24.gif"), "Zoom Out");
        JButton jButton5 = new JButton();
        jButton5.setToolTipText("Zoom Out");
        jButton5.setText(null);
        jButton5.setMargin(new Insets(0, 0, 0, 0));
        jButton5.setIcon(imageIcon9);
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JImageMapper.this.image != null) {
                    JImageMapper.this.zoomOut();
                }
            }
        });
        jToolBar.add(jButton5);
        ImageIcon imageIcon10 = new ImageIcon(JImageMapper.class.getResource("/img/Zoom24.gif"), "Zoom Reset");
        JButton jButton6 = new JButton();
        jButton6.setToolTipText("Reset Zoom");
        jButton6.setText(null);
        jButton6.setMargin(new Insets(0, 0, 0, 0));
        jButton6.setIcon(imageIcon10);
        jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JImageMapper.this.image != null) {
                    JImageMapper.this.zoomReset();
                }
            }
        });
        jToolBar.add(jButton6);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jToggleButton);
        buttonGroup.add(jToggleButton2);
        buttonGroup.add(jToggleButton3);
        buttonGroup.add(jToggleButton4);
        this.getContentPane().add((Component)jToolBar, "North");
        this.imageContainer = new JLabel("");
        this.imageContainer.setHorizontalAlignment(2);
        this.imageContainer.setVerticalAlignment(1);
        this.drawingLayer = new DrawingLayer(this);
        this.layerPane = new JLayeredPane();
        this.layerPane.add((Component)this.imageContainer, new Integer(1));
        this.layerPane.add((Component)this.drawingLayer, new Integer(2));
        JScrollPane jScrollPane = new JScrollPane(this.layerPane);
        this.getContentPane().add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel();
        Border border = BorderFactory.createLineBorder(Color.black);
        jPanel.setBorder(border);
        this.currentShape = new JLabel("Rectangle");
        jPanel.add(this.currentShape);
        this.getContentPane().add((Component)jPanel, "South");
        this.setSize(400, 400);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2);
        this.setDefaultCloseOperation(3);
    }

    private void updatePhotograph() {
        this.updatePhotograph(this.image);
    }

    private void updatePhotograph(BufferedImage bufferedImage) {
        Dimension dimension = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
        this.imageContainer.setText(null);
        this.imageContainer.setBounds(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        this.imageContainer.setIcon(new ImageIcon(bufferedImage));
        this.drawingLayer.setSize(dimension);
        this.layerPane.setPreferredSize(dimension);
        this.pack();
    }

    private void loadImage(final String string) {
        SwingWorker swingWorker = new SwingWorker(){

            @Override
            public Object construct() {
                File file = new File(string);
                if (file.exists() && file.isFile()) {
                    ImageIcon imageIcon = new ImageIcon(string);
                    JImageMapper.this.image = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 1);
                    Graphics2D graphics2D = JImageMapper.this.image.createGraphics();
                    graphics2D.drawImage(imageIcon.getImage(), null, null);
                }
                return JImageMapper.this.image;
            }

            @Override
            public void finished() {
                if (JImageMapper.this.image != null) {
                    JImageMapper.this.updatePhotograph();
                }
            }
        };
        swingWorker.start();
    }

    private void updateShape(String string) {
        this.currentShape.setText(string);
    }

    private void zoomOut() {
        this.zoomLevel *= 0.8;
        if (this.zoomLevel < 1.01 && this.zoomLevel > 0.99) {
            this.zoomLevel = 1.0;
        }
        this.setCursor(new Cursor(3));
        BufferedImage bufferedImage = ZoomUtils.zoom(this.image, this.zoomLevel);
        this.updatePhotograph(bufferedImage);
        this.setCursor(new Cursor(0));
    }

    private void zoomIn() {
        this.zoomLevel /= 0.8;
        if (this.zoomLevel < 1.01 && this.zoomLevel > 0.99) {
            this.zoomLevel = 1.0;
        }
        this.setCursor(new Cursor(3));
        BufferedImage bufferedImage = ZoomUtils.zoom(this.image, this.zoomLevel);
        this.updatePhotograph(bufferedImage);
        this.setCursor(new Cursor(0));
    }

    private void zoomReset() {
        this.zoomLevel = 1.0;
        this.setCursor(new Cursor(3));
        this.updatePhotograph(this.image);
        this.setCursor(new Cursor(0));
    }

    public double getZoomLevel() {
        return this.zoomLevel;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            new JImageMapper(stringArray[0]);
        } else {
            new JImageMapper();
        }
    }

    class MyFilter
    extends FileFilter {
        MyFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return string.endsWith(".png") || string.endsWith(".gif") || string.endsWith(".jpg");
        }

        @Override
        public String getDescription() {
            return "Graphics files";
        }
    }
}

