/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class SmartFrame
extends Frame
implements WindowListener {
    public static Properties properties = null;
    static String propertiesFileName = "properties";
    static int frameCount;
    String name;
    boolean iconified = false;

    SmartFrame(String string) {
        this.name = string;
        if (properties == null) {
            try {
                properties = new Properties();
                properties.load(new FileInputStream(propertiesFileName));
            }
            catch (IOException iOException) {}
        }
        ++frameCount;
        this.addWindowListener(this);
    }

    SmartFrame(String string, String string2) {
        super(string2);
        this.name = string;
        if (properties == null) {
            try {
                properties = new Properties();
                properties.load(new FileInputStream(propertiesFileName));
            }
            catch (IOException iOException) {}
        }
        ++frameCount;
        this.addWindowListener(this);
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.iconified = false;
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        this.iconified = true;
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.saveFrameInfo();
        ((Component)this).setVisible(false);
        if (--frameCount == 0) {
            try {
                properties.save(new FileOutputStream(propertiesFileName), "SmartFrame class - written by Alexandre Sieira Vilar (sieira@usa.net)");
            }
            catch (IOException iOException) {}
            System.exit(0);
        }
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.iconified = true;
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        this.iconified = false;
    }

    public void loadFrameInfo() {
        boolean bl = false;
        String string = properties.getProperty(String.valueOf(this.name) + ".width");
        String string2 = properties.getProperty(String.valueOf(this.name) + ".height");
        try {
            if (string != null && string2 != null) {
                ((Component)this).setSize(Integer.valueOf(string), Integer.valueOf(string2));
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        string = properties.getProperty(String.valueOf(this.name) + ".x");
        string2 = properties.getProperty(String.valueOf(this.name) + ".y");
        try {
            if (string == null || string2 == null) {
                throw new NumberFormatException();
            }
            ((Component)this).setLocation(Integer.valueOf(string), Integer.valueOf(string2));
        }
        catch (NumberFormatException numberFormatException) {
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.getToolkit().getScreenSize();
            ((Component)this).setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
            bl = true;
        }
        if (bl) {
            this.saveFrameInfo();
        }
    }

    public void saveFrameInfo() {
        Dimension dimension = this.getSize();
        Point point = this.getLocation();
        if (this.iconified) {
            return;
        }
        ((Hashtable)properties).put(String.valueOf(this.name) + ".width", Integer.toString(dimension.width));
        ((Hashtable)properties).put(String.valueOf(this.name) + ".height", Integer.toString(dimension.height));
        ((Hashtable)properties).put(String.valueOf(this.name) + ".x", Integer.toString(point.x));
        ((Hashtable)properties).put(String.valueOf(this.name) + ".y", Integer.toString(point.y));
    }

    public static void setPropertiesFileName(String string) {
        propertiesFileName = string;
    }

    public static String getPropertiesFileName() {
        return propertiesFileName;
    }

    public static int getFrameCount() {
        return frameCount;
    }

    public void close() {
        this.windowClosing(null);
        this.windowClosed(null);
    }

    public static void main(String[] stringArray) {
        SmartFrame.setPropertiesFileName("sfexample.properties");
        SmartFrame smartFrame = new SmartFrame("sf", "SmartFrame Example");
        SmartFrame smartFrame2 = new SmartFrame("sf2", "Example2");
        smartFrame.add("Center", new TextArea("This is an example of the SmartFrame class,\na window that keeps track of its size and position,\nand saves that information to disk."));
        smartFrame.pack();
        smartFrame.loadFrameInfo();
        smartFrame.show();
        smartFrame2.add("Center", new TextArea("This is an example of the SmartFrame class,\na window that keeps track of its size and position,\nand saves that information to disk."));
        smartFrame2.pack();
        smartFrame2.loadFrameInfo();
        smartFrame2.show();
    }
}

