/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.app;

import com.totalvalidator.TotalValidator;
import com.totalvalidator.app.InfoPanel;
import com.totalvalidator.utils.FileUtils;
import com.totalvalidator.utils.GeneralUtils;
import com.totalvalidator.utils.Zipper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class About
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static String[] levels = new String[]{"Off", "On"};
    private JComboBox logLevel;
    private TotalValidator tv;
    private JButton sendLog;

    public About(TotalValidator tv, InfoPanel infoPanel, Color backgroundColour) {
        super((Frame)tv, true);
        this.setResizable(false);
        this.tv = tv;
        this.initComponents(infoPanel, backgroundColour);
        Dimension aboutSize = this.getSize();
        Point p = tv.getLocationOnScreen();
        if (aboutSize.height > tv.getHeight()) {
            aboutSize.height = tv.getHeight();
        }
        if (aboutSize.width > tv.getWidth()) {
            aboutSize.width = tv.getWidth();
        }
        this.setLocation(p.x + (tv.getWidth() - aboutSize.width) / 2, p.y + (tv.getHeight() - aboutSize.height) / 2);
        this.setVisible(true);
    }

    private void initComponents(InfoPanel infoPanel, Color backgroundColour) {
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().setBackground(backgroundColour);
        this.setTitle("Total Validator Tool");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                About.this.setVisible(false);
                About.this.dispose();
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        this.getContentPane().add((Component)infoPanel, gridBagConstraints);
        JPanel loggingPanel = new JPanel();
        loggingPanel.setOpaque(false);
        JLabel levelLabel = new JLabel();
        levelLabel.setText("Debugging:");
        loggingPanel.add(levelLabel);
        this.logLevel = new JComboBox<String>(levels);
        if (GeneralUtils.isMacOSX()) {
            this.logLevel.setOpaque(false);
        }
        this.logLevel.setToolTipText("Only change this option if asked to by TV Support");
        this.logLevel.setSelectedItem(GeneralUtils.LOGGER.getLevel() == Level.SEVERE ? "Off" : "On");
        this.logLevel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                About.this.sendLog.setEnabled(About.this.logLevel.getSelectedIndex() > 0);
            }
        });
        loggingPanel.add(this.logLevel);
        this.sendLog = new JButton();
        if (GeneralUtils.isMacOSX()) {
            this.sendLog.setOpaque(false);
        }
        this.sendLog.setText("Send Logs");
        Font stdFont = this.getFont();
        Font smallFont = new Font(stdFont.getFontName(), stdFont.getStyle(), stdFont.getSize() - 2);
        this.sendLog.setFont(smallFont);
        this.sendLog.setMnemonic(66);
        this.sendLog.setToolTipText("Send log files to Total Validator Support");
        this.sendLog.setEnabled(this.logLevel.getSelectedIndex() > 0);
        this.sendLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    File logFile = new File(System.getProperty("java.io.tmpdir") + "/totalvalidator.log");
                    if (!logFile.exists()) {
                        logFile = new File(System.getProperty("user.home") + "/totalvalidator.log");
                    }
                    String log = logFile.getAbsolutePath();
                    if (logFile.exists()) {
                        String zipFile = new Zipper().zipUp(log, ".zip", null, FileUtils.getDataFolder(), null);
                        GeneralUtils.launchBrowser("mailto:support@totalvalidator.com?subject=Debug%20Logs");
                        JOptionPane.showMessageDialog(About.this.tv, "Zip file of logs saved to " + zipFile, "Logs Saved", 1);
                    } else {
                        JOptionPane.showMessageDialog(About.this.tv, "No log file at " + log, "No log file found", 0);
                    }
                }
                catch (Exception e) {
                    GeneralUtils.LOGGER.log(Level.SEVERE, "Sendlog failure", e);
                }
            }
        });
        loggingPanel.add(this.sendLog);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        this.getContentPane().add((Component)loggingPanel, gridBagConstraints);
        JPanel jPanel1 = new JPanel();
        jPanel1.setOpaque(false);
        JButton okay = new JButton();
        if (GeneralUtils.isMacOSX()) {
            okay.setOpaque(false);
        }
        okay.setText("OK");
        okay.setMnemonic(88);
        okay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                About.this.tv.setLoggingLevel((String)About.this.logLevel.getSelectedItem());
                About.this.setVisible(false);
                About.this.dispose();
            }
        });
        jPanel1.add(okay);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.getContentPane().add((Component)jPanel1, gridBagConstraints);
        this.pack();
    }
}

