/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.app;

import com.totalvalidator.TotalValidator;
import com.totalvalidator.app.Agent;
import com.totalvalidator.app.AgentComparator;
import com.totalvalidator.app.EditUserAgents;
import com.totalvalidator.app.Tab;
import com.totalvalidator.exceptions.CommandLineException;
import com.totalvalidator.exceptions.ValidationException;
import com.totalvalidator.options.Option;
import com.totalvalidator.parser.CommandLineParser;
import com.totalvalidator.sgml.SupportedDTDs;
import com.totalvalidator.utils.FileUtils;
import com.totalvalidator.utils.GeneralUtils;
import com.totalvalidator.utils.GetFile;
import com.totalvalidator.validations.AccessibilityValidation;
import com.totalvalidator.validations.SpellingValidation;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.ComboBoxEditor;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicTab
extends JPanel
implements Tab {
    private static final long serialVersionUID = 1L;
    private static final String START_PAGE = "StartPage";
    private static final String START_PAGE_ITEM = "StartPageItem";
    private static final String START_FOLDER = "StartFolder";
    private static final String HTML = "HTML";
    private static final String WAI = "WAI";
    private static final String SPELL = "Spell";
    private static final String LINKS = "Links";
    private static final String WARNINGS = "Warnings";
    private static final String SHOW_SUCCESS = "ShowSuccess";
    private static final String[] WAI_OPTIONS = new String[]{"", "US Section 508", "WCAG v1 A", "WCAG v1 AA", "WCAG v1 AAA", "WCAG v2 A", "WCAG v2 AA", "WCAG v2 AAA"};
    protected static final int MAX_PAGES = 11;
    private static final String SEP = "|";
    private static final String USER_AGENT_EXAMPLES = "help/useragent.props";
    private static final String DEFAULT_AGENT = "Identity";
    public static final String LAST_RESULTS = "LastResults";
    private static final String DISPLAY_BROWSER = "DisplayBrowser";
    private String startingFolder;
    private String currentAgent = "Total Validator";
    private JComboBox startingPage;
    private JComboBox dtds;
    private JComboBox wai;
    private JComboBox spellCheck;
    private JCheckBox brokenLinks;
    private JCheckBox warnings;
    private JCheckBox showSuccess;
    private Option option;
    private JTextField displayBrowser;
    private JComboBox userAgent;
    protected Set<Agent> agents;
    protected String lastResults;
    private JTabbedPane tabbedPane;
    private boolean suppressEvents;

    public BasicTab(final JTabbedPane tabbedPane, Properties props, Properties commonProps, final Image icon, Option opt, CommandLineParser ffclp) {
        this.option = opt;
        this.tabbedPane = tabbedPane;
        this.setLayout(new GridBagLayout());
        this.setBackground(TotalValidator.TOTAL_LIGHT_BLUE);
        this.setOpaque(true);
        PageVerifier pageVerifier = new PageVerifier();
        Font stdFont = this.getFont();
        Font smallFont = new Font(stdFont.getFontName(), stdFont.getStyle(), stdFont.getSize() - 2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.setOpaque(false);
        jPanel3.setBorder(new TitledBorder("What to check"));
        JLabel jLabel1 = new JLabel();
        jLabel1.setText("Starting web page:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        jPanel3.add((Component)jLabel1, gridBagConstraints);
        this.startingPage = new JComboBox();
        if (GeneralUtils.isMacOSX()) {
            this.startingPage.setOpaque(false);
        }
        this.startingPage.setEditable(true);
        this.startingPage.setMaximumRowCount(11);
        this.startingPage.setToolTipText("Enter a web page starting with 'http' or click the Browse button");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        jPanel3.add((Component)this.startingPage, gridBagConstraints);
        JButton browseStart = new JButton();
        if (GeneralUtils.isMacOSX()) {
            browseStart.setOpaque(false);
        }
        browseStart.setText("Browse");
        browseStart.setFont(smallFont);
        browseStart.setMnemonic(66);
        browseStart.setToolTipText("Select a local web page");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        browseStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String page = (String)BasicTab.this.startingPage.getSelectedItem();
                if (page != null && !page.trim().equals("") && !page.startsWith("http")) {
                    BasicTab.this.startingFolder = new File(page).getParentFile().getAbsolutePath();
                }
                GetFile gf = null;
                try {
                    gf = new GetFile(icon, BasicTab.this.startingFolder, false);
                }
                catch (ValidationException e) {
                    GeneralUtils.LOGGER.log(Level.SEVERE, "GetFile Failed", e);
                }
                gf.browse("Select a web page", new String[0]);
                File theFile = gf.getFile();
                if (theFile != null) {
                    BasicTab.this.startingFolder = theFile.getParentFile().getAbsolutePath();
                    for (int i = 0; i < BasicTab.this.startingPage.getItemCount(); ++i) {
                        if (!((String)BasicTab.this.startingPage.getItemAt(i)).equals(theFile.getAbsolutePath())) continue;
                        BasicTab.this.startingPage.setSelectedIndex(i);
                        return;
                    }
                    ComboBoxEditor editor = BasicTab.this.startingPage.getEditor();
                    editor.setItem(theFile.getAbsolutePath());
                }
            }
        });
        jPanel3.add((Component)browseStart, gridBagConstraints);
        JPanel pagesPanel = this.option.addPagesPanel(props, tabbedPane, ffclp, this);
        if (pagesPanel != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints.weightx = 1.0;
            jPanel3.add((Component)pagesPanel, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        jPanel4.setOpaque(false);
        jPanel4.setBorder(new TitledBorder("Validations"));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("HTML validation:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        jPanel4.add((Component)jLabel2, gridBagConstraints);
        this.dtds = new JComboBox<Object>(SupportedDTDs.dtdNames.toArray());
        if (GeneralUtils.isMacOSX()) {
            this.dtds.setOpaque(false);
        }
        this.dtds.setToolTipText("Auto uses the <!DOCTYPE>, Best-fit ignores it");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        jPanel4.add((Component)this.dtds, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Accessibility validation:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        jPanel4.add((Component)jLabel3, gridBagConstraints);
        this.wai = new JComboBox<String>(WAI_OPTIONS);
        if (GeneralUtils.isMacOSX()) {
            this.wai.setOpaque(false);
        }
        this.wai.setToolTipText("Select an accessibility standard to validate against");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        jPanel4.add((Component)this.wai, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Spell check:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        jPanel4.add((Component)jLabel4, gridBagConstraints);
        this.spellCheck = new JComboBox<String>(this.option.getSpellOptions());
        if (GeneralUtils.isMacOSX()) {
            this.spellCheck.setOpaque(false);
        }
        this.spellCheck.setToolTipText("Perform a spell check");
        this.spellCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (BasicTab.this.suppressEvents) {
                    return;
                }
                JComboBox cb = (JComboBox)e.getSource();
                String language = SpellingValidation.getLanguage((String)cb.getSelectedItem());
                BasicTab.this.option.setSpellCheckEnabled(language != null);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        jPanel4.add((Component)this.spellCheck, gridBagConstraints);
        JPanel linksPanel = new JPanel();
        linksPanel.setLayout(new GridBagLayout());
        linksPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.brokenLinks = new JCheckBox("Check for broken links");
        this.brokenLinks.setToolTipText("Check for broken links");
        this.brokenLinks.setOpaque(false);
        this.brokenLinks.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (BasicTab.this.suppressEvents) {
                    return;
                }
                BasicTab.this.option.setLinksEnabled(e.getStateChange() == 1);
            }
        });
        linksPanel.add((Component)this.brokenLinks, gridBagConstraints);
        this.warnings = new JCheckBox("Show warnings");
        this.warnings.setOpaque(false);
        this.warnings.setToolTipText("Display warning messages as well as errors");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        linksPanel.add((Component)this.warnings, gridBagConstraints);
        this.showSuccess = new JCheckBox("Show on success");
        this.showSuccess.setOpaque(false);
        this.showSuccess.setToolTipText("Display pages with no reported problems");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        linksPanel.add((Component)this.showSuccess, gridBagConstraints);
        JPanel miscPanel = new JPanel();
        miscPanel.setLayout(new GridBagLayout());
        miscPanel.setOpaque(false);
        miscPanel.setBorder(new TitledBorder("Miscellaneous"));
        JLabel browserLabel = new JLabel();
        browserLabel.setText("Browser for results:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        miscPanel.add((Component)browserLabel, gridBagConstraints);
        this.displayBrowser = new JTextField();
        this.displayBrowser.setEditable(true);
        this.displayBrowser.setToolTipText("Path to the browser to display the results. Leave blank for default.");
        this.displayBrowser.setInputVerifier(pageVerifier);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        if (GeneralUtils.isMacOSX()) {
            gridBagConstraints.gridwidth = 0;
        } else {
            gridBagConstraints.weightx = 0.5;
        }
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        miscPanel.add((Component)this.displayBrowser, gridBagConstraints);
        if (!GeneralUtils.isMacOSX()) {
            JButton browseBrowser = new JButton();
            if (GeneralUtils.isMacOSX()) {
                browseBrowser.setOpaque(false);
            }
            browseBrowser.setText("Browse");
            browseBrowser.setFont(smallFont);
            browseBrowser.setMnemonic(79);
            browseBrowser.setToolTipText("Select a browser to display results in");
            browseBrowser.setVerifyInputWhenFocusTarget(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(0, 0, 5, 5);
            browseBrowser.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String browserFolder = BasicTab.this.displayBrowser.getText();
                    if (browserFolder == null || browserFolder.trim().equals("") || !new File(browserFolder.trim()).exists()) {
                        browserFolder = new File(FileUtils.getInstallationFolder()).getAbsolutePath();
                    }
                    GetFile gf = null;
                    try {
                        gf = new GetFile(icon, browserFolder, false);
                    }
                    catch (ValidationException e) {
                        GeneralUtils.LOGGER.log(Level.SEVERE, "GetFile Failed", e);
                    }
                    gf.browse("Select a browser", new String[0]);
                    File theFile = gf.getFile();
                    if (theFile != null) {
                        browserFolder = theFile.getAbsolutePath();
                        BasicTab.this.displayBrowser.setText(browserFolder);
                        GeneralUtils.setDisplayBrowser(browserFolder);
                    }
                }
            });
            miscPanel.add((Component)browseBrowser, gridBagConstraints);
        }
        JLabel userAgentLabel = new JLabel();
        userAgentLabel.setText("Browser identification:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        miscPanel.add((Component)userAgentLabel, gridBagConstraints);
        this.getUserAgents();
        this.userAgent = new JComboBox<Object>(this.agents.toArray());
        if (GeneralUtils.isMacOSX()) {
            this.userAgent.setOpaque(false);
        }
        this.userAgent.setToolTipText("What browser the tool appears as to web sites");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        miscPanel.add((Component)this.userAgent, gridBagConstraints);
        JButton editAgents = new JButton();
        if (GeneralUtils.isMacOSX()) {
            editAgents.setOpaque(false);
        }
        editAgents.setText("Edit List");
        editAgents.setFont(smallFont);
        editAgents.setMnemonic(69);
        editAgents.setToolTipText("Amend the list of Browsers");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        editAgents.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Object obj = BasicTab.this.userAgent.getSelectedItem();
                if (obj != null) {
                    BasicTab.this.currentAgent = ((Agent)obj).getIdentity();
                }
                EditUserAgents.showEditor(tabbedPane.getParent(), BasicTab.this.agents);
                if (!EditUserAgents.isCancelled()) {
                    BasicTab.this.agents = EditUserAgents.getAgents();
                    if (BasicTab.this.agents.size() == 0) {
                        Agent agent = new Agent("Total Validator", "TotalValidator/6.0");
                        BasicTab.this.agents.add(agent);
                    }
                    BasicTab.this.userAgent.removeAllItems();
                    int i = 0;
                    for (Agent agent : BasicTab.this.agents) {
                        BasicTab.this.userAgent.insertItemAt(agent, i++);
                    }
                    BasicTab.this.setCurrentAgent();
                    BasicTab.this.saveUserAgents();
                }
            }
        });
        miscPanel.add((Component)editAgents, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.weightx = 1.0;
        jPanel4.add((Component)linksPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)miscPanel, gridBagConstraints);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(false);
        JButton results = new JButton();
        if (GeneralUtils.isMacOSX()) {
            results.setOpaque(false);
        }
        results.setText("Last Results");
        results.setMnemonic(76);
        results.setToolTipText("Display results of last validation");
        results.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (BasicTab.this.lastResults != null && new File(BasicTab.this.lastResults).exists()) {
                    try {
                        GeneralUtils.launchBrowser(new File(BasicTab.this.lastResults).toURI().toURL().toString());
                    }
                    catch (Exception e) {
                        GeneralUtils.LOGGER.log(Level.SEVERE, "Failed to display results", e);
                        JOptionPane.showMessageDialog(BasicTab.this, "Could not display results.", "Last Results", 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(BasicTab.this, "Could not locate results.", "Last Results", 0);
                }
            }
        });
        buttonPanel.add(results);
        if (this.option.getType() != 'B') {
            JButton reset = new JButton();
            if (GeneralUtils.isMacOSX()) {
                reset.setOpaque(false);
            }
            reset.setText("Reset Tab");
            reset.setMnemonic(82);
            reset.setToolTipText("Reset settings on this tab to defaults");
            reset.setVerifyInputWhenFocusTarget(false);
            reset.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    int result = JOptionPane.showConfirmDialog(BasicTab.this, "This will reset all your settings on this tab to the defaults. Are you sure?", "Reset to defaults", 0);
                    if (result == 0) {
                        BasicTab.this.resetTab();
                    }
                }
            });
            buttonPanel.add(reset);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)buttonPanel, gridBagConstraints);
        JPanel filler = new JPanel();
        filler.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)filler, gridBagConstraints);
        this.updateTab(props, commonProps, ffclp);
        tabbedPane.addTab("Basic", null, this, "Basic Options");
    }

    private void setCurrentAgent() {
        boolean foundOne = false;
        for (Agent agent : this.agents) {
            if (!agent.getIdentity().equals(this.currentAgent)) continue;
            this.userAgent.setSelectedItem(agent);
            foundOne = true;
            break;
        }
        if (!foundOne) {
            this.userAgent.setSelectedIndex(0);
        }
    }

    private void getUserAgents() {
        this.agents = BasicTab.readAgentsList(false);
        this.saveUserAgents();
    }

    static Set<Agent> readAgentsList(boolean getDefault) {
        String exampleFile = FileUtils.getInstallationFolder() + USER_AGENT_EXAMPLES;
        String fileName = getDefault ? exampleFile : "identities.props";
        Properties props = new Properties();
        TreeSet<Object> agentsList = new TreeSet<Object>(new AgentComparator());
        boolean oldFile = false;
        InputStream is = null;
        try {
            is = FileUtils.getLocalInputStream(FileUtils.getDataFolder() + fileName);
        }
        catch (Exception e1) {
            try {
                is = FileUtils.getLocalInputStream(FileUtils.getInstallationFolder() + "identities.props");
                oldFile = true;
            }
            catch (Exception e2) {
                try {
                    is = FileUtils.getLocalInputStream(exampleFile);
                }
                catch (Exception e3) {
                    GeneralUtils.LOGGER.log(Level.FINE, "Failed to read Example User Agent Properties", e3);
                }
            }
        }
        if (is != null) {
            try {
                props.load(is);
                is.close();
                Enumeration<?> e = props.propertyNames();
                while (e.hasMoreElements()) {
                    String ua = (String)e.nextElement();
                    Agent agent = new Agent(ua, props.getProperty(ua));
                    agentsList.add(agent);
                }
                if (oldFile && (GeneralUtils.isMacOSX() || GeneralUtils.isWinNT())) {
                    FileUtils.deleteFile(new File(FileUtils.getInstallationFolder() + "identities.props"), false);
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        if (agentsList.size() == 0) {
            Agent agent = new Agent("Total Validator", "TotalValidator/6.0");
            agentsList.add(agent);
        }
        return agentsList;
    }

    public void saveCommonProperties(Properties commonProps) {
        if (this.lastResults != null) {
            commonProps.setProperty(LAST_RESULTS, this.lastResults);
        }
    }

    @Override
    public void saveProperties(Properties props) {
        StringBuilder pages = new StringBuilder();
        int count = this.startingPage.getItemCount() - 1;
        for (int i = 0; i < this.startingPage.getItemCount() - 1; ++i) {
            pages.append(this.startingPage.getItemAt(i)).append(SEP);
        }
        pages.append(this.startingPage.getItemAt(count));
        props.setProperty(START_PAGE, pages.toString());
        int selectedItem = this.startingPage.getSelectedIndex();
        if (selectedItem < 0) {
            selectedItem = 0;
        }
        props.setProperty(START_PAGE_ITEM, selectedItem + "");
        props.setProperty(START_FOLDER, this.startingFolder);
        props.setProperty(HTML, this.dtds.getSelectedIndex() + "");
        props.setProperty(WAI, this.wai.getSelectedIndex() + "");
        props.setProperty(SPELL, this.spellCheck.getSelectedIndex() + "");
        props.setProperty(LINKS, this.brokenLinks.isSelected() + "");
        props.setProperty(WARNINGS, this.warnings.isSelected() + "");
        props.setProperty(SHOW_SUCCESS, this.showSuccess.isSelected() + "");
        props.setProperty(DISPLAY_BROWSER, this.displayBrowser.getText().trim());
        Object obj = this.userAgent.getSelectedItem();
        if (obj != null) {
            props.setProperty(DEFAULT_AGENT, ((Agent)obj).getIdentity());
        }
    }

    private void saveUserAgents() {
        Properties agentProps = new Properties();
        for (Agent agent : this.agents) {
            agentProps.setProperty(agent.getIdentity(), agent.getDetails());
        }
        try {
            agentProps.store(FileUtils.getLocalOutputStream(FileUtils.getDataFolder() + "identities.props"), "Total Validator Properties - Do not edit this file.");
        }
        catch (Exception e) {
            GeneralUtils.LOGGER.log(Level.SEVERE, "Failed whist saving Properties", e);
        }
    }

    @Override
    public void resetTab() {
        this.startingPage.setSelectedIndex(0);
        this.dtds.setSelectedIndex(1);
        this.wai.setSelectedIndex(6);
        this.spellCheck.setSelectedIndex(0);
        this.brokenLinks.setSelected(true);
        this.warnings.setSelected(true);
        this.showSuccess.setSelected(false);
        this.displayBrowser.setText("");
        this.currentAgent = "Total Validator";
        this.setCurrentAgent();
        this.option.resetPages();
    }

    @Override
    public void getFields(List<String> options) throws CommandLineException {
        Agent agent;
        String browser;
        String language;
        String waiName;
        String theUrl = this.getUrl();
        if (theUrl.length() == 0) {
            this.tabbedPane.setSelectedComponent(this);
            throw new CommandLineException("Starting web page is missing");
        }
        String message = this.checkUrl(theUrl);
        if (message != null) {
            this.tabbedPane.setSelectedComponent(this);
            throw new CommandLineException(message);
        }
        options.add(theUrl.startsWith("http") ? "-url" : "-file");
        options.add(theUrl);
        String dtdName = (String)this.dtds.getSelectedItem();
        if (dtdName != null && dtdName.trim().length() > 0) {
            options.add("-dtd");
            options.add(dtdName);
        }
        if ((waiName = AccessibilityValidation.getWAI((String)this.wai.getSelectedItem())) != null) {
            options.add("-accessibility");
            options.add(waiName);
        }
        if ((language = SpellingValidation.getLanguage((String)this.spellCheck.getSelectedItem())) != null && language != "Own dictionary") {
            options.add("-spellcheck");
            options.add(language);
        }
        if (this.brokenLinks.isSelected()) {
            options.add("-brokenlinks");
        }
        if (this.warnings.isSelected()) {
            options.add("-showwarnings");
        }
        if (this.showSuccess.isSelected()) {
            options.add("-showsuccess");
        }
        if ((browser = this.displayBrowser.getText().trim()).length() > 0) {
            options.add("-displaybrowser");
            options.add(browser);
        }
        if ((agent = (Agent)this.userAgent.getSelectedItem()) != null && agent.getIdentity().length() > 0) {
            options.add("-identity");
            options.add(agent.getIdentity());
        }
    }

    public String getUrl() {
        return ((String)this.startingPage.getEditor().getItem()).trim();
    }

    private Vector<String> getItems(String pages) {
        Vector<String> items = new Vector<String>();
        items.add("");
        StringTokenizer st = new StringTokenizer(pages, SEP);
        while (st.hasMoreTokens()) {
            items.add(st.nextToken());
        }
        return items;
    }

    public static int getIndex(Properties props, String property, int defaultVal) {
        int index = defaultVal;
        String val = props.getProperty(property, defaultVal + "");
        try {
            index = Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return index;
    }

    private String checkUrl(String text) {
        if (text.length() > 0 && !text.startsWith("http")) {
            try {
                FileUtils.getFile(text);
            }
            catch (ValidationException e) {
                return "Starting web page: " + e.getMessage();
            }
        }
        return null;
    }

    public void addPageToList(String resultsPage) {
        this.lastResults = resultsPage;
        String newItem = this.getUrl();
        this.startingPage.insertItemAt(newItem, 1);
        for (int i = 2; i < this.startingPage.getItemCount(); ++i) {
            if (!((String)this.startingPage.getItemAt(i)).equals(newItem)) continue;
            this.startingPage.removeItemAt(i);
            break;
        }
        if (this.startingPage.getItemCount() > 11) {
            this.startingPage.removeItemAt(11);
        }
        this.startingPage.setSelectedIndex(1);
    }

    public void resetListToDefault() {
        this.startingPage.removeAllItems();
        this.startingPage.addItem("");
    }

    public boolean isLinks() {
        return this.brokenLinks.isSelected();
    }

    public boolean isSpellCheck() {
        String language = SpellingValidation.getLanguage((String)this.spellCheck.getSelectedItem());
        return language != null;
    }

    public void updateTab(Properties props, Properties commonProps, CommandLineParser ffclp) {
        this.suppressEvents = true;
        this.startingPage.removeAllItems();
        String pages = props.getProperty(START_PAGE, "http://www.totalvalidator.com");
        for (String page : this.getItems(pages)) {
            this.startingPage.addItem(page);
        }
        int page = 0;
        try {
            page = Integer.parseInt(props.getProperty(START_PAGE_ITEM, "0"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.startingPage.setSelectedIndex(page);
        this.startingFolder = props.getProperty(START_FOLDER, "");
        String links = props.getProperty(LINKS, "true");
        String showWarnings = props.getProperty(WARNINGS, "true");
        String successVal = props.getProperty(SHOW_SUCCESS, "false");
        String browser = props.getProperty(DISPLAY_BROWSER, "");
        if (ffclp != null) {
            if (ffclp.getTheUrl() != null) {
                this.startingPage.getEditor().setItem(ffclp.getTheUrl());
            }
            if (ffclp.getDtdName() == null) {
                this.dtds.setSelectedIndex(0);
            } else {
                this.dtds.setSelectedItem(SupportedDTDs.getDisplayName(ffclp.getDtdName()));
            }
            if (ffclp.getAccessibilityLevel() == null) {
                this.wai.setSelectedIndex(0);
            } else {
                this.wai.setSelectedItem(AccessibilityValidation.getDisplayName(ffclp.getAccessibilityLevel()));
            }
            if (!ffclp.isSpellCheck()) {
                this.spellCheck.setSelectedIndex(0);
            } else if (ffclp.getLanguage() != null) {
                this.spellCheck.setSelectedItem(SpellingValidation.getDisplayName(ffclp.getLanguage()));
            } else {
                this.spellCheck.setSelectedItem("Own dictionary");
            }
            this.brokenLinks.setSelected(ffclp.isBrokenLinks());
            this.warnings.setSelected(ffclp.isShowWarnings());
            this.showSuccess.setSelected(ffclp.isShowSuccess());
            browser = GeneralUtils.getDisplayBrowser();
        } else {
            this.dtds.setSelectedIndex(BasicTab.getIndex(props, HTML, 1));
            this.wai.setSelectedIndex(BasicTab.getIndex(props, WAI, 6));
            this.spellCheck.setSelectedIndex(BasicTab.getIndex(props, SPELL, 0));
            this.brokenLinks.setSelected(links.equals("true"));
            this.warnings.setSelected(showWarnings.equals("true"));
            this.showSuccess.setSelected(successVal.equals("true"));
            GeneralUtils.setDisplayBrowser(browser);
        }
        this.option.setSpellCheckEnabled(this.isSpellCheck());
        this.displayBrowser.setText(browser);
        this.currentAgent = props.getProperty(DEFAULT_AGENT, "Total Validator");
        this.setCurrentAgent();
        this.lastResults = commonProps.getProperty(LAST_RESULTS);
        this.suppressEvents = false;
    }

    class PageVerifier
    extends InputVerifier {
        PageVerifier() {
        }

        public boolean shouldYieldFocus(JComponent source) {
            if (BasicTab.this.option.isDisableVerifier()) {
                return true;
            }
            this.verify(source);
            return true;
        }

        public boolean verify(JComponent source) {
            GeneralUtils.setDisplayBrowser(((JTextField)source).getText().trim());
            return true;
        }
    }
}

