/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.app;

import com.totalvalidator.app.AuthenticationDialog;
import com.totalvalidator.app.ToolBuildVersion;
import com.totalvalidator.utils.FileUtils;
import com.totalvalidator.utils.GeneralUtils;
import com.totalvalidator.utils.ProxyDetails;
import java.awt.Frame;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;

public class CheckSite {
    private CheckSite() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkVersion(String userAgent, ProxyDetails proxyDetails, Frame frame, boolean prompt, String updateSite) throws IOException {
        if (proxyDetails != null) {
            GeneralUtils.getAuthenticator().addProxyAuthentication(proxyDetails);
        }
        String version = null;
        URL url = new URL(updateSite);
        URLConnection connection = url.openConnection();
        if (connection instanceof HttpURLConnection) {
            GeneralUtils.logProxies(url);
            boolean notAuthenticated = true;
            while (notAuthenticated) {
                Object var12_11;
                notAuthenticated = false;
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                httpConnection.setRequestProperty("user-agent", userAgent);
                httpConnection.setConnectTimeout(30000);
                httpConnection.setReadTimeout(30000);
                httpConnection.connect();
                int response = -1;
                try {
                    response = httpConnection.getResponseCode();
                    var12_11 = null;
                }
                catch (Throwable throwable) {
                    var12_11 = null;
                    version = FileUtils.getContent(httpConnection);
                    throw throwable;
                }
                version = FileUtils.getContent(httpConnection);
                if (response == 407 && prompt) {
                    if (AuthenticationDialog.getAuthDetails(frame, httpConnection, true, updateSite, Integer.MAX_VALUE) != -1) {
                        connection = url.openConnection();
                        notAuthenticated = true;
                        continue;
                    }
                    version = null;
                    continue;
                }
                if (response == 200) continue;
                version = null;
            }
        }
        return version == null || CheckSite.checkForChanges(version) ? version : "";
    }

    private static boolean checkForChanges(String latestVersion) {
        int[] thisTool = CheckSite.getVersionParts(ToolBuildVersion.getBuildVersion());
        if (latestVersion.endsWith("\n")) {
            latestVersion = latestVersion.substring(0, latestVersion.length() - 1);
        }
        int[] latest = CheckSite.getVersionParts(latestVersion);
        return CheckSite.newerVersion(thisTool, latest);
    }

    private static int[] getVersionParts(String versionStr) {
        StringTokenizer st = new StringTokenizer(versionStr, ".");
        int[] version = new int[3];
        for (int i = 0; i < version.length; ++i) {
            try {
                version[i] = st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 0;
                continue;
            }
            catch (NumberFormatException e) {
                version[i] = 0;
            }
        }
        return version;
    }

    private static boolean newerVersion(int[] current, int[] latest) {
        for (int i = 0; i < latest.length; ++i) {
            if (latest[i] > current[i]) {
                return true;
            }
            if (latest[i] >= current[i]) continue;
            return false;
        }
        return false;
    }
}

