/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.sgml;

import com.totalvalidator.sgml.Piece;
import com.totalvalidator.utils.GeneralUtils;
import com.totalvalidator.validations.problem.ValidationProblem;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSPiece
extends Piece {
    private static final char AT = '@';
    private static final char BLOCK_START = '{';
    private static final char BLOCK_END = '}';
    private static final char SEMI = ';';
    private static final char QUOTE = '\'';
    private static final char DBL_QUOTE = '\"';
    private static final char SPACE = ' ';
    private static final String COMMA = ",";
    private String atKeyword;
    private List<String> selectors;
    private List<String> properties;

    public CSSPiece(Piece piece) {
        super(piece);
    }

    public CSSPiece(boolean parse, String thePieceString, int lineNumber, List<String> ignoreMessages, boolean showWarnings) {
        super(thePieceString, lineNumber, ignoreMessages, showWarnings);
        if (parse) {
            if (thePieceString.charAt(0) == '@') {
                StringTokenizer st = new StringTokenizer(thePieceString);
                this.atKeyword = st.nextToken();
                String atRule = st.nextToken();
                if (atRule.charAt(atRule.length() - 1) != ';') {
                    this.setProblem(ValidationProblem.MISSING_SEMI);
                }
            } else {
                int index = thePieceString.indexOf(123);
                if (index == -1) {
                    this.setProblem(ValidationProblem.MISSING_BLOCK);
                } else if (index == 0) {
                    this.setProblem(ValidationProblem.MISSING_SELECTOR);
                } else {
                    int endIndex = thePieceString.lastIndexOf(125);
                    if (endIndex == -1 || endIndex < index) {
                        this.setProblem(ValidationProblem.MISSING_BLOCK_END);
                    } else if (endIndex != thePieceString.length() - 1) {
                        this.setProblem(ValidationProblem.BLOCK_NOT_LAST);
                    } else {
                        String selectorGroup = thePieceString.substring(0, index).trim();
                        if (selectorGroup.length() > 0) {
                            this.parseSelector(selectorGroup);
                        }
                        String declaration = thePieceString.substring(index + 1, thePieceString.length() - 1);
                        this.parseDeclaration(declaration);
                    }
                }
            }
        }
    }

    private void parseSelector(String selectorGroup) {
        this.selectors = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(selectorGroup, COMMA);
        while (st.hasMoreTokens()) {
            String sel = st.nextToken().trim();
            if (sel.length() == 0) {
                this.setProblem(ValidationProblem.EMPTY_SELECTOR);
                continue;
            }
            this.selectors.add(sel);
        }
    }

    private void parseDeclaration(String declaration) {
        this.properties = new ArrayList<String>();
        String deQuotedDec = declaration;
        int firstQuote = declaration.indexOf(39);
        int firstDblQuote = declaration.indexOf(34);
        if (firstQuote != -1) {
            if (firstDblQuote == -1) {
                deQuotedDec = this.deQuote(deQuotedDec, '\'');
            } else if (firstQuote < firstDblQuote) {
                deQuotedDec = this.deQuote(deQuotedDec, '\'');
                deQuotedDec = this.deQuote(deQuotedDec, '\"');
            } else {
                deQuotedDec = this.deQuote(deQuotedDec, '\"');
                deQuotedDec = this.deQuote(deQuotedDec, '\'');
            }
        } else if (firstDblQuote != -1) {
            deQuotedDec = this.deQuote(deQuotedDec, '\"');
        }
        if (!deQuotedDec.endsWith(";")) {
            deQuotedDec = deQuotedDec + ';';
        }
        int index = deQuotedDec.indexOf(59);
        GeneralUtils.LOGGER.finest("CSS Properties");
        while (index != -1) {
            String property = declaration.substring(0, index).trim();
            this.properties.add(property);
            GeneralUtils.LOGGER.finest('\t' + property);
            if (index == deQuotedDec.length() - 1) break;
            index = deQuotedDec.indexOf(59, index + 1);
        }
    }

    private String deQuote(String declaration, char quoteChar) {
        int secondQuote;
        int firstQuote = declaration.indexOf(quoteChar);
        while (firstQuote != -1 && firstQuote < declaration.length() - 1 && (secondQuote = declaration.indexOf(quoteChar, firstQuote + 1)) != -1) {
            declaration = declaration.substring(0, firstQuote) + this.getSpaces(secondQuote - firstQuote) + declaration.substring(secondQuote);
            firstQuote = declaration.indexOf(quoteChar);
        }
        return declaration;
    }

    private String getSpaces(int count) {
        StringBuilder spaces = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            spaces.append(' ');
        }
        return spaces.toString();
    }

    public String getAtKeyword() {
        return this.atKeyword;
    }

    public List<String> getSelectors() {
        return this.selectors;
    }

    public List<String> getProperties() {
        return this.properties;
    }
}

