/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.sgml;

import com.totalvalidator.sgml.Element;
import com.totalvalidator.sgml.EntityEncoder;
import com.totalvalidator.sgml.Piece;
import com.totalvalidator.sgml.RealAttribute;
import com.totalvalidator.sgml.TagValidator;
import com.totalvalidator.utils.GeneralUtils;
import com.totalvalidator.validations.problem.ValidationProblem;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tag
extends Piece {
    public static final String NO_NAME = "NO_NAME";
    public static final String NO_VAL = "NO_VAL";
    private static final String XML = "xml:";
    private static final String SVG = "svg:";
    private static final String HTML = "html:";
    private static final String XHTML = "xhtml:";
    private static final String XML_LANG = "xml:lang";
    private static final String XML_SPACE = "xml:space";
    private static final String XML_BASE = "xml:base";
    private Map<String, RealAttribute> attributes;
    private Map<String, String> origAttrNames;
    private Piece matchingTag;
    private boolean endTag;
    private TagValidator tagValidator;
    private boolean valuesInQuotes = true;
    private boolean singleton;
    private String element;
    private String strippedElement;
    private String origElement;

    public Tag(String text, int lineNumber, EntityEncoder ee, List<String> ignoreMessages, boolean showWarnings) {
        super(text, lineNumber, ignoreMessages, showWarnings);
        text = this.getText();
        if (text.length() > 0) {
            this.parseTag(ee);
        }
    }

    public Tag(Piece piece) {
        super(piece);
        Tag t = (Tag)piece;
        this.attributes = t.attributes;
        this.origAttrNames = t.origAttrNames;
        this.endTag = t.endTag;
        this.singleton = t.singleton;
        this.valuesInQuotes = t.valuesInQuotes;
        this.element = t.element;
        this.origElement = t.origElement;
        this.strippedElement = t.strippedElement;
    }

    private void parseTag(EntityEncoder ee) {
        String parsedTag = this.getText();
        int charNum = 0;
        if (parsedTag.charAt(0) == '/') {
            this.endTag = true;
            ++charNum;
            parsedTag = parsedTag.substring(1);
        }
        if (parsedTag.endsWith("/")) {
            this.singleton = true;
            parsedTag = parsedTag.substring(0, parsedTag.length() - 1);
            if (!this.getThePieceString().endsWith("/")) {
                this.setProblem(ValidationProblem.BADLY_DEFINED_SINGLETON);
            }
        }
        this.setElement(null);
        StringTokenizer st = new StringTokenizer(parsedTag);
        if (st.hasMoreTokens()) {
            this.origElement = st.nextToken();
            int elementLength = this.origElement.length();
            this.element = this.origElement.toLowerCase(Locale.ENGLISH);
            this.strippedElement = this.stripNameSpace(this.element);
            if (!this.element.startsWith("!-") && !this.element.startsWith("![") && this.element.charAt(0) != '@' && st.hasMoreTokens()) {
                int position;
                charNum += elementLength;
                parsedTag = parsedTag.substring(elementLength, parsedTag.length());
                StringBuilder sb = new StringBuilder();
                char[] chars = parsedTag.toCharArray();
                boolean inName = false;
                boolean inValue = false;
                boolean singleQuotedValue = false;
                boolean doubleQuotedValue = false;
                boolean startValue = false;
                String attributeName = "";
                String origAttrName = "";
                int nameStart = -1;
                int sbStart = 1;
                int noNameCount = 0;
                for (int i = 0; i < chars.length; ++i) {
                    if (!inValue) {
                        if (chars[i] == ' ') {
                            if (!inName) continue;
                            if (this.attributes == null) {
                                this.attributes = new HashMap<String, RealAttribute>();
                                this.origAttrNames = new HashMap<String, String>();
                            }
                            origAttrName = sb.toString();
                            attributeName = this.stripNameSpace(origAttrName).toLowerCase(Locale.ENGLISH);
                            if (parsedTag.substring(i).trim().length() == 0) continue;
                            sb.setLength(0);
                            inName = false;
                            continue;
                        }
                        if (chars[i] == '\'' || chars[i] == '\"') {
                            if (!inName) {
                                if (!"".equals(attributeName)) {
                                    this.attributes.put(attributeName, new RealAttribute(attributeName, NO_VAL, nameStart, -1, -1));
                                    this.origAttrNames.put(attributeName, origAttrName);
                                    attributeName = "";
                                    origAttrName = "";
                                }
                                nameStart = -1;
                                inValue = true;
                                if (chars[i] == '\'') {
                                    singleQuotedValue = true;
                                    continue;
                                }
                                doubleQuotedValue = true;
                                continue;
                            }
                            this.setProblem(ValidationProblem.MISMATCHED_QUOTES, charNum + i, charNum + i + 1);
                            sb.append(chars[i]);
                            continue;
                        }
                        if (!inName) {
                            if (chars[i] == '=') {
                                inValue = true;
                                startValue = true;
                                continue;
                            }
                            if (!"".equals(attributeName)) {
                                if (this.attributes.containsKey(attributeName)) {
                                    this.setProblemAttribute(new ValidationProblem("The '" + attributeName + "' attribute is duplicated:", ValidationProblem.DUPLICATE_ATTR), attributeName);
                                } else {
                                    this.attributes.put(attributeName, new RealAttribute(attributeName, NO_VAL, nameStart, -1, -1));
                                    this.origAttrNames.put(attributeName, origAttrName);
                                }
                                attributeName = "";
                                origAttrName = "";
                            }
                            nameStart = i + charNum;
                            inName = true;
                            sb.append(chars[i]);
                            continue;
                        }
                        if (chars[i] == '=') {
                            origAttrName = sb.toString();
                            attributeName = this.stripNameSpace(origAttrName).toLowerCase(Locale.ENGLISH);
                            sb.setLength(0);
                            inValue = true;
                            startValue = true;
                            inName = false;
                            continue;
                        }
                        sb.append(chars[i]);
                        continue;
                    }
                    if (startValue) {
                        if (chars[i] == ' ') continue;
                        if (chars[i] == '\'') {
                            singleQuotedValue = true;
                            startValue = false;
                            continue;
                        }
                        if (chars[i] == '\"') {
                            doubleQuotedValue = true;
                            startValue = false;
                            continue;
                        }
                        this.valuesInQuotes = false;
                        if (sb.length() == 0) {
                            sbStart = i + charNum;
                        }
                        sb.append(chars[i]);
                        startValue = false;
                        continue;
                    }
                    if (singleQuotedValue) {
                        if (chars[i] == '\'') {
                            noNameCount = this.saveAttribute(attributeName, sb, ee, origAttrName, nameStart, sbStart, noNameCount);
                            inValue = false;
                            attributeName = "";
                            nameStart = -1;
                            origAttrName = "";
                            singleQuotedValue = false;
                            continue;
                        }
                        if (sb.length() == 0) {
                            sbStart = i + charNum;
                        }
                        sb.append(chars[i]);
                        continue;
                    }
                    if (doubleQuotedValue) {
                        if (chars[i] == '\"') {
                            noNameCount = this.saveAttribute(attributeName, sb, ee, origAttrName, nameStart, sbStart, noNameCount);
                            inValue = false;
                            attributeName = "";
                            nameStart = -1;
                            origAttrName = "";
                            doubleQuotedValue = false;
                            continue;
                        }
                        if (sb.length() == 0) {
                            sbStart = i + charNum;
                        }
                        sb.append(chars[i]);
                        continue;
                    }
                    if (chars[i] == '\'' || chars[i] == '\"') {
                        this.setProblem(ValidationProblem.MISMATCHED_QUOTES, charNum + i, charNum + i + 1);
                        inValue = false;
                        noNameCount = this.saveAttribute(attributeName, sb, ee, origAttrName, nameStart, sbStart, noNameCount);
                        attributeName = "";
                        nameStart = -1;
                        origAttrName = "";
                        continue;
                    }
                    if (chars[i] == ' ') {
                        if (sb.length() == 0) {
                            if (attributeName != null && attributeName.length() > 0) {
                                this.setProblem(new ValidationProblem("The '" + attributeName + "' attribute's value is missing:", ValidationProblem.MISSING_ATTR_VALUE), nameStart, nameStart + attributeName.length());
                            } else {
                                this.setProblem(new ValidationProblem("The attribute's value is missing:", ValidationProblem.MISSING_ATTR_VALUE));
                            }
                        } else {
                            position = this.checkUnquotedValue(sb);
                            if (position != -1) {
                                this.setProblem(new ValidationProblem("Invalid characters found in" + (attributeName != null && attributeName.length() > 0 ? " the '" + attributeName + "'" : "") + " attribute's value starting at index: " + position, ValidationProblem.INVALID_ATTR_CHARS), sbStart, sbStart + sb.length());
                            }
                        }
                        inValue = false;
                        noNameCount = this.saveAttribute(attributeName, sb, ee, origAttrName, nameStart, sbStart, noNameCount);
                        attributeName = "";
                        nameStart = -1;
                        origAttrName = "";
                        continue;
                    }
                    if (sb.length() == 0) {
                        sbStart = i + charNum;
                    }
                    sb.append(chars[i]);
                }
                if (singleQuotedValue || doubleQuotedValue) {
                    this.setProblem(ValidationProblem.MISMATCHED_QUOTES);
                }
                if (inName && sb.length() > 0 && !sb.toString().equals("/")) {
                    if (this.attributes == null) {
                        this.attributes = new HashMap<String, RealAttribute>();
                        this.origAttrNames = new HashMap<String, String>();
                    }
                    if (this.attributes.containsKey(attributeName = this.stripNameSpace(origAttrName = sb.toString()).toLowerCase(Locale.ENGLISH))) {
                        this.setProblemAttribute(new ValidationProblem("The '" + attributeName + "' attribute is duplicated:", ValidationProblem.DUPLICATE_ATTR), attributeName);
                    } else {
                        this.attributes.put(attributeName, new RealAttribute(attributeName, NO_VAL, nameStart, -1, -1));
                        this.origAttrNames.put(attributeName, origAttrName);
                    }
                }
                if (inValue) {
                    if (sb.length() == 0) {
                        if (attributeName != null && attributeName.length() > 0) {
                            this.setProblem(new ValidationProblem("The '" + attributeName + "' attribute's value is missing:", ValidationProblem.MISSING_ATTR_VALUE), nameStart, nameStart + attributeName.length());
                        } else {
                            this.setProblem(new ValidationProblem("The attribute's value is missing:", ValidationProblem.MISSING_ATTR_VALUE));
                        }
                    } else if (!singleQuotedValue && !doubleQuotedValue && (position = this.checkUnquotedValue(sb)) != -1) {
                        this.setProblem(new ValidationProblem("Invalid characters found in" + (attributeName.length() > 0 ? " the '" + attributeName + "'" : "") + " attribute's value starting at index: " + position, ValidationProblem.INVALID_ATTR_CHARS), sbStart, sbStart + sb.length());
                    }
                    noNameCount = this.saveAttribute(attributeName, sb, ee, origAttrName, nameStart, sbStart, noNameCount);
                }
            }
        }
    }

    @Override
    String stripNameSpace(String candidate) {
        if (candidate == null) {
            return null;
        }
        if (XML_LANG.equals(candidate) || XML_SPACE.equals(candidate) || XML_BASE.equals(candidate)) {
            return candidate;
        }
        if (candidate.startsWith(XML)) {
            candidate = candidate.substring(4);
        } else if (candidate.startsWith(HTML)) {
            candidate = candidate.substring(5);
        } else if (candidate.startsWith(XHTML)) {
            candidate = candidate.substring(6);
        } else if (candidate.startsWith(SVG)) {
            candidate = candidate.substring(4);
        }
        return candidate;
    }

    private int checkUnquotedValue(StringBuilder sb) {
        int position = -1;
        for (int i = 1; i < sb.length(); ++i) {
            char ch = sb.charAt(i);
            if (GeneralUtils.isLatinLetter(ch) || GeneralUtils.isLatinDigit(ch) || ch == '-' || ch == '_' || ch == ':' || ch == '.') continue;
            position = i + 1;
            break;
        }
        return position;
    }

    private int saveAttribute(String attributeName, StringBuilder sb, EntityEncoder ee, String origAttrName, int nameStart, int valStart, int noNameCount) {
        int index;
        if (this.attributes == null) {
            this.attributes = new HashMap<String, RealAttribute>();
            this.origAttrNames = new HashMap<String, String>();
        }
        if (attributeName.length() == 0) {
            attributeName = NO_NAME + noNameCount;
            ++noNameCount;
        } else if (this.attributes.containsKey(attributeName)) {
            this.setProblemAttribute(new ValidationProblem("The '" + attributeName + "' attribute is duplicated:", ValidationProblem.DUPLICATE_ATTR), attributeName);
            return noNameCount;
        }
        String attrValue = sb.toString();
        sb.setLength(0);
        int valEnd = valStart + attrValue.length();
        if (valEnd > valStart && (index = attrValue.indexOf(38)) != -1) {
            if ((index = Tag.notEntity(attrValue, index)) != -1) {
                this.setProblem(new ValidationProblem("Found '&amp;' within '" + (!attributeName.startsWith(NO_NAME) ? attributeName : attrValue) + "'. You should use '&amp;amp;' instead:", ValidationProblem.NOT_ENTITY_ATTR), valStart + index, valStart + index + 1);
            } else {
                String[] result = ee.decode(attrValue, false, true);
                attrValue = result[0];
                if (result[1].equals("true")) {
                    this.setProblem(ValidationProblem.BAD_HEX_REPRESENTATION);
                }
                String text = AMP_PATTERN.matcher(attrValue).replaceAll("");
                int index2 = 0;
                while ((index = text.indexOf(38, index2)) != -1 && (index2 = text.indexOf(59, index)) != -1) {
                    if (index2 - index > 10) {
                        this.setProblem(new ValidationProblem("Found '&amp;' within '" + (!attributeName.startsWith(NO_NAME) ? attributeName : attrValue) + "'. You should use '&amp;amp;' instead:", ValidationProblem.NOT_ENTITY_ATTR), valStart + index, valStart + index + 1);
                        continue;
                    }
                    this.setProblem(new ValidationProblem("Found invalid character reference '&amp;" + text.substring(index + 1, index2 + 1) + "' within '" + (!attributeName.startsWith(NO_NAME) ? attributeName : attrValue) + "':", ValidationProblem.BAD_ENTITY));
                }
            }
        }
        this.attributes.put(attributeName, new RealAttribute(attributeName, attrValue, nameStart, valStart, valEnd));
        this.origAttrNames.put(attributeName, origAttrName);
        return noNameCount;
    }

    @Override
    public boolean isEndTag() {
        return this.endTag;
    }

    @Override
    public void setMatchingTag(Piece oldTag) {
        this.matchingTag = oldTag;
    }

    @Override
    public boolean hasMatchingTag() {
        return this.matchingTag != null;
    }

    @Override
    public String getOrigElement(boolean isXml) {
        return isXml ? this.stripNameSpace(this.origElement) : this.origElement;
    }

    @Override
    public String getElement(boolean isXml) {
        return isXml ? this.stripNameSpace(this.element) : this.element;
    }

    @Override
    public String getStrippedElement() {
        return this.strippedElement;
    }

    @Override
    public void setElement(String string) {
        this.element = string;
        this.strippedElement = string;
        this.origElement = string;
    }

    @Override
    public void setProblemElement(ValidationProblem problem) {
        if (this.element != null) {
            if (this.isEndTag()) {
                this.setProblem(problem, 1, 1 + this.element.length());
            } else {
                this.setProblem(problem, 0, this.element.length());
            }
        }
    }

    @Override
    public void setProblemAttribute(ValidationProblem problem, String attributeName) {
        int startChar = this.attributes.get(attributeName).getNameStart();
        String origAttrName = this.origAttrNames.get(attributeName);
        this.setProblem(problem, startChar, startChar + origAttrName.length());
    }

    @Override
    public void setProblemValue(ValidationProblem problem, String attributeName) {
        RealAttribute attr = this.attributes.get(attributeName);
        this.setProblem(problem, attr.getValueStart(), attr.getValueEnd());
    }

    @Override
    public Piece getMatchingTag() {
        return this.matchingTag;
    }

    @Override
    public Map<String, RealAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isSingleton() {
        return this.singleton;
    }

    @Override
    public void setEndTag(boolean endTag) {
        this.endTag = endTag;
    }

    @Override
    public boolean isValuesInQuotes() {
        return this.valuesInQuotes;
    }

    @Override
    public String getAttr(String attrName) {
        String val;
        if (this.attributes != null && this.attributes.containsKey(attrName) && !(val = this.attributes.get(attrName).getValue()).equals(NO_VAL)) {
            return val.trim();
        }
        return null;
    }

    @Override
    public String getOrigAttrName(String attrName, boolean isXml) {
        if (this.origAttrNames == null || !this.origAttrNames.containsKey(attrName)) {
            return null;
        }
        String origAttrName = this.origAttrNames.get(attrName).trim();
        return isXml ? this.stripNameSpace(origAttrName) : origAttrName;
    }

    @Override
    public void makeValidator(Element e) {
        if (!"#pcdata".equals(e.getName())) {
            this.tagValidator = new TagValidator(e);
        }
    }

    @Override
    public TagValidator getValidator() {
        return this.tagValidator;
    }

    @Override
    public void removeValidator() {
        this.tagValidator = null;
    }
}

