/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.utils;

import com.totalvalidator.app.AuthenticationDialog;
import com.totalvalidator.exceptions.ValidationException;
import com.totalvalidator.parser.CommandLineParser;
import com.totalvalidator.sgml.EntityEncoder;
import com.totalvalidator.utils.GeneralUtils;
import com.totalvalidator.utils.MyReader;
import com.totalvalidator.validations.http.Form;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletContext;
import javax.swing.JFileChooser;

public class FileUtils {
    public static final String ACCEPT = "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
    public static final String REFERER = "http://www.totalvalidator.com/index.html";
    public static final String TEXT_HTML = "text/html";
    public static final String XML_XHTML = "application/xhtml+xml";
    public static final String TEXT_XML = "text/xml";
    public static final String APP_XML = "application/xml";
    public static final char NL = '\n';
    public static final String SEP = ":";
    public static final int TIMEOUT = 30000;
    public static final String UTF8 = "UTF-8";
    private static final String ERROR_RETRIEVING_PAGE = "Error retrieving page: ";
    private static final String FILE = "File: '";
    private static final String COLON = " : ";
    private static final String REDIRECT_ERROR = " redirects more than 5 times. Please enter the final URL instead";
    private static final MimetypesFileTypeMap mimeMap = new MimetypesFileTypeMap();
    private static final Pattern SPACE_PATTERN = Pattern.compile(" ");
    private static File absoluteInstallFolder;
    private static String installationFolder;
    private static String dataFolder;
    private static String documentsFolder;
    private static String resultsFolder;
    private static String passwordsFolder;
    private static String webRoot;
    private static String logFolder;
    private static String blackListFile;
    private ServletContext context;

    public FileUtils(ServletContext servletContext) {
        this.context = servletContext;
    }

    private static void migrateOldFolders(File dataFolder, String docsFolder) {
        String oldHomeFolder = System.getProperty("user.home");
        File oldRoaming = new File(oldHomeFolder + "\\AppData\\Roaming\\TotalValidatorTool\\");
        if (oldRoaming.exists()) {
            try {
                FileUtils.renameTo(oldRoaming, dataFolder);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (System.getProperty("os.name").indexOf("Vista") == -1 && System.getProperty("os.name").indexOf("7") == -1 && (oldRoaming = new File(oldHomeFolder + "\\Application Data\\TotalValidatorTool\\")).exists()) {
            try {
                FileUtils.renameTo(oldRoaming, dataFolder);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        String oldDocsFolder = oldHomeFolder;
        oldDocsFolder = System.getProperty("os.name").indexOf("Vista") != -1 ? oldDocsFolder + "\\Documents\\TotalValidatorTool\\" : oldDocsFolder + "\\My Documents\\TotalValidatorTool\\";
        File oldDocs = new File(oldDocsFolder);
        File newDocs = new File(docsFolder);
        if (oldDocs.exists() && !newDocs.exists()) {
            try {
                FileUtils.renameTo(oldDocs, newDocs);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public FileUtils() {
    }

    public static MyReader getReader(URL[] urls, boolean getStream, CommandLineParser cl, String referer, boolean checkType, Form form) throws ValidationException {
        MyReader myReader = new MyReader();
        HttpURLConnection httpConnection = null;
        try {
            URLConnection connection = urls[0].openConnection();
            GeneralUtils.LOGGER.fine("Getting url: " + urls[0]);
            if (connection instanceof HttpURLConnection) {
                urls[1] = urls[0];
                boolean ok = false;
                int redirectCount = 1;
                while (!ok && redirectCount < 7) {
                    httpConnection = (HttpURLConnection)connection;
                    httpConnection.setInstanceFollowRedirects(false);
                    httpConnection.setConnectTimeout(30000);
                    httpConnection.setReadTimeout(30000);
                    httpConnection.setRequestProperty("User-Agent", cl == null ? "TotalValidator/6.0" : cl.getUserAgent());
                    httpConnection.setRequestProperty("Accept", ACCEPT);
                    httpConnection.setRequestProperty("Referer", referer == null ? REFERER : referer);
                    if (form != null) {
                        httpConnection.setRequestProperty("content-type", "application/x-www-form-urlencoded");
                        if (form.isPost()) {
                            httpConnection.setDoInput(true);
                            httpConnection.setDoOutput(true);
                            httpConnection.setRequestMethod("POST");
                            httpConnection.setRequestProperty("content-length", "" + form.getLength());
                            OutputStream os = httpConnection.getOutputStream();
                            os.write(form.getBytes());
                            os.close();
                        } else {
                            httpConnection.setRequestMethod("GET");
                        }
                    } else {
                        httpConnection.setRequestMethod("GET");
                    }
                    httpConnection.connect();
                    int response = httpConnection.getResponseCode();
                    if (response == 200) {
                        FileUtils.getThePage(httpConnection, myReader, checkType, urls, cl, getStream);
                        ok = true;
                        continue;
                    }
                    if (response == 301 || response == 302 || response == 303 || response == 307) {
                        String redirectLocation = httpConnection.getHeaderField("Location");
                        if (redirectLocation != null) {
                            if (!redirectLocation.toLowerCase(Locale.ENGLISH).startsWith("http")) {
                                redirectLocation = FileUtils.resolveRelativeUrl(redirectLocation, urls[0].toString(), null);
                            }
                            if (redirectLocation != null) {
                                urls[0] = new URL(redirectLocation);
                                connection = urls[0].openConnection();
                                GeneralUtils.LOGGER.fine("Based on " + redirectLocation);
                                GeneralUtils.LOGGER.fine("Redirecting to: " + urls[0]);
                                ++redirectCount;
                                continue;
                            }
                        }
                        FileUtils.getReaderError(httpConnection, myReader, checkType, urls, cl, getStream, response);
                        ok = true;
                        continue;
                    }
                    if (response == 407 && cl != null && cl.isInteractiveAuth()) {
                        GeneralUtils.LOGGER.info("Proxy Authentication Request");
                        if (AuthenticationDialog.getAuthDetails(null, httpConnection, true, urls[0].toString(), Integer.MAX_VALUE) != -1) {
                            connection = urls[0].openConnection();
                            continue;
                        }
                        FileUtils.getReaderError(httpConnection, myReader, checkType, urls, cl, getStream, response);
                        ok = true;
                        continue;
                    }
                    if (response == 401 && cl != null && cl.isInteractiveAuth()) {
                        GeneralUtils.LOGGER.info("HTTP Authentication Request");
                        if (AuthenticationDialog.getAuthDetails(null, httpConnection, false, urls[0].toString(), Integer.MAX_VALUE) != -1) {
                            connection = urls[0].openConnection();
                            continue;
                        }
                        FileUtils.getReaderError(httpConnection, myReader, checkType, urls, cl, getStream, response);
                        ok = true;
                        continue;
                    }
                    if (response == 401 && cl == null) {
                        ok = true;
                        continue;
                    }
                    FileUtils.getReaderError(httpConnection, myReader, checkType, urls, cl, getStream, response);
                    ok = true;
                }
                if (!ok) {
                    throw new ValidationException(urls[0] + REDIRECT_ERROR);
                }
            } else if (getStream) {
                myReader.setInputStream(connection.getInputStream());
                myReader.setContentType(FileUtils.getContentType(new File(urls[0].getPath())));
            }
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            FileUtils.readStream(httpConnection);
            String message = e.getMessage();
            if (message == null) {
                message = "";
            }
            throw new ValidationException("Could not connect to page: " + message);
        }
        return myReader;
    }

    private static void getReaderError(HttpURLConnection httpConnection, MyReader myReader, boolean checkType, URL[] urls, CommandLineParser cl, boolean getStream, int response) throws Exception {
        if (cl == null || !cl.isValidateErrors()) {
            String message = httpConnection.getResponseMessage();
            if (message == null) {
                message = "";
            }
            throw new ValidationException(ERROR_RETRIEVING_PAGE + urls[0] + COLON + response + " " + message);
        }
        FileUtils.getThePage(httpConnection, myReader, checkType, urls, cl, getStream);
    }

    private static void getThePage(HttpURLConnection httpConnection, MyReader myReader, boolean checkType, URL[] urls, CommandLineParser cl, boolean getStream) throws Exception {
        myReader.setContentTypeHeader(httpConnection.getContentType());
        try {
            myReader.setInputStream(httpConnection.getInputStream());
        }
        catch (Exception e) {
            myReader.setInputStream(httpConnection.getErrorStream());
        }
        if (checkType) {
            if (!FileUtils.validContentType(myReader.getContentType())) {
                throw new ValidationException(urls[0] + " is not an (x)html page. The page must be of type 'text/html' or 'application/xhtml+xml' ");
            }
            String charset = FileUtils.getCharset(myReader.getContentType(), "CHARSET");
            if (charset != null) {
                try {
                    if (!Charset.isSupported(charset)) {
                        throw new ValidationException("The character set '" + charset + "' as specified in the http header is unsupported");
                    }
                }
                catch (IllegalCharsetNameException e) {
                    throw new ValidationException("The character set '" + charset + "' as specified in the http header is invalid");
                }
                myReader.setCharset(charset);
                GeneralUtils.LOGGER.info("Character set used: " + charset);
                if (cl != null) {
                    cl.setHttpCharset(charset);
                }
            } else if (cl != null) {
                myReader.setHttpStream(true);
            }
            myReader.setScriptLanguageHeader(httpConnection.getHeaderField("content-script-type") != null);
            myReader.setStyleLanguageHeader(httpConnection.getHeaderField("content-style-type") != null);
        }
        if (!getStream) {
            InputStream is = myReader.getInputStream();
            while (is.read() != -1) {
            }
            myReader.getInputStream().close();
        }
    }

    public static String resolveRelativeUrl(String link, String baseUrl, EntityEncoder ee) {
        if (link.toLowerCase(Locale.ENGLISH).startsWith("javascript")) {
            return null;
        }
        if (link.length() == 0) {
            return baseUrl;
        }
        if (link.charAt(0) == '?') {
            int index = baseUrl.indexOf(63);
            if (index != -1) {
                baseUrl = baseUrl.substring(0, index);
            }
            baseUrl = baseUrl + link;
        } else if (link.charAt(0) == ';') {
            int index = baseUrl.indexOf(59);
            if (index != -1) {
                baseUrl = baseUrl.substring(0, index);
            } else {
                index = baseUrl.indexOf(63);
                if (index != -1) {
                    baseUrl = baseUrl.substring(0, index);
                }
            }
            baseUrl = baseUrl + link;
        } else {
            if ((baseUrl.toLowerCase(Locale.ENGLISH).startsWith("file:") || link.toLowerCase(Locale.ENGLISH).startsWith("file:")) && link.indexOf(32) != -1) {
                link = SPACE_PATTERN.matcher(link).replaceAll("%20");
            }
            try {
                URI baseUri = new URI(baseUrl);
                if ("".equals(baseUri.getPath()) && link.charAt(0) != '/') {
                    baseUri = new URI(baseUrl + '/');
                }
                baseUrl = baseUri.resolve(link).toString();
            }
            catch (Throwable t) {
                if (ee != null) {
                    String[] result = ee.decode(baseUrl, false, false);
                    baseUrl = result[0];
                    result = ee.decode(link, false, false);
                    link = result[0];
                }
                try {
                    URI baseUri = new URI(baseUrl);
                    if ("".equals(baseUri.getPath()) && link.charAt(0) != '/') {
                        baseUri = new URI(baseUrl + '/');
                    }
                    baseUrl = baseUri.resolve(link).toString();
                }
                catch (Throwable t2) {
                    GeneralUtils.LOGGER.log(Level.FINE, "Couldn't resolve " + link + " against " + baseUrl, t2);
                    return null;
                }
            }
        }
        try {
            if (baseUrl.charAt(baseUrl.length() - 1) == '/' && "/".equals(new URL(baseUrl).getPath())) {
                baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return baseUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getContent(HttpURLConnection httpConnection) {
        StringBuilder sb;
        block20: {
            IOException e222;
            BufferedReader br;
            BufferedInputStream bis;
            block18: {
                bis = null;
                br = null;
                sb = new StringBuilder();
                br = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), UTF8));
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                Object var6_6 = null;
                if (bis == null) break block18;
                try {
                    bis.close();
                }
                catch (IOException e222) {
                    // empty catch block
                }
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e222) {}
            }
            break block20;
            {
                catch (IOException e3) {
                    IOException e222;
                    FileUtils.readStream(httpConnection);
                    Object var6_7 = null;
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException e222) {
                            // empty catch block
                        }
                    }
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException e222;
                Object var6_8 = null;
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return sb.toString();
    }

    public static boolean validContentType(String type) {
        if (type == null) {
            return false;
        }
        return (type = type.trim().toLowerCase(Locale.ENGLISH)).startsWith(TEXT_HTML) || type.startsWith(XML_XHTML);
    }

    public static String getCharset(String type, String attribute) {
        if (type == null) {
            return null;
        }
        type = type.trim().toUpperCase();
        int index = type.indexOf(attribute);
        String charset = null;
        int len = attribute.length();
        if (index != -1 && type.length() > index + len) {
            charset = type.substring(index + len).trim();
            if (charset.length() == 0) {
                return null;
            }
            if (charset.charAt(0) != '=') {
                return null;
            }
            if ((charset = charset.substring(1).trim()).length() == 0) {
                return null;
            }
            index = charset.indexOf(";");
            if (index != -1 && (charset = charset.substring(0, index).trim()).length() == 0) {
                return null;
            }
            if ((charset.charAt(0) == '\"' || charset.charAt(0) == '\'') && (charset = charset.substring(1).trim()).length() == 0) {
                return null;
            }
            index = charset.indexOf("\"");
            if (index != -1 && (charset = charset.substring(0, index).trim()).length() == 0) {
                return null;
            }
            index = charset.indexOf("'");
            if (index != -1 && (charset = charset.substring(0, index).trim()).length() == 0) {
                return null;
            }
        }
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void readStream(HttpURLConnection httpConnection) {
        if (httpConnection == null) {
            return;
        }
        InputStream is = null;
        is = httpConnection.getInputStream();
        while (is.read() != -1) {
        }
        Object var5_2 = null;
        if (is == null) return;
        try {
            is.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (Exception e) {
                is = httpConnection.getErrorStream();
                if (is != null) {
                    try {
                        while (is.read() != -1) {
                        }
                    }
                    catch (Exception exception) {
                    }
                }
                Object var5_3 = null;
                if (is == null) return;
                try {
                    is.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public InputStream getInputStream(String fileName) throws ValidationException {
        InputStream is = null;
        if (this.context != null) {
            is = this.context.getResourceAsStream("WEB-INF/" + fileName);
            if (is == null) {
                is = FileUtils.getLocalInputStream(this.context.getRealPath("WEB-INF/" + fileName));
            }
        } else {
            is = FileUtils.getLocalInputStream(fileName);
        }
        return is;
    }

    public static InputStream getLocalInputStream(String fileName) throws ValidationException {
        File sourceFile = FileUtils.getFile(fileName);
        FileInputStream is = null;
        try {
            is = new FileInputStream(sourceFile);
        }
        catch (FileNotFoundException e) {
            throw new ValidationException(FILE + fileName + "' not found");
        }
        return is;
    }

    public static File getFile(String fileName) throws ValidationException {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new ValidationException(FILE + file.getAbsolutePath() + "' doesn't exist");
        }
        if (!file.canRead()) {
            throw new ValidationException(FILE + file.getAbsolutePath() + "' can't be read");
        }
        if (!file.isFile()) {
            throw new ValidationException(FILE + file.getAbsolutePath() + "' is not a file");
        }
        return file;
    }

    public static File getFolder(String folderName) throws IOException {
        File folder = new File(folderName);
        if (!folder.exists()) {
            throw new IOException("Folder '" + folder.getAbsolutePath() + "' doesn't exist");
        }
        if (!folder.canRead()) {
            throw new IOException("Folder '" + folder.getAbsolutePath() + "' can't be read");
        }
        if (folder.isFile()) {
            throw new IOException(FILE + folder.getAbsolutePath() + "' is not a folder");
        }
        return folder;
    }

    public static OutputStream getLocalOutputStream(String filename) throws ValidationException {
        FileOutputStream fos = null;
        File localFile = new File(filename);
        String parent = localFile.getParent();
        if (parent != null) {
            File dir = new File(parent);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!dir.exists()) {
                throw new ValidationException(FILE + localFile + "' doesn't have write permission (3)");
            }
        }
        if (localFile.exists() && !localFile.canWrite()) {
            throw new ValidationException(FILE + localFile + "' doesn't have write permission (1)");
        }
        try {
            fos = new FileOutputStream(localFile);
        }
        catch (FileNotFoundException e) {
            throw new ValidationException(FILE + localFile + "' doesn't have write permission (2)");
        }
        return fos;
    }

    public static void deleteFile(File theFile, boolean recurse) throws IOException {
        if (theFile.exists()) {
            if (!theFile.canWrite()) {
                throw new IOException(FILE + theFile.getAbsolutePath() + "' doesn't have delete permission");
            }
            if (theFile.isDirectory() && recurse) {
                FileUtils.removeDirs(theFile);
            } else {
                theFile.delete();
            }
        }
    }

    private static void removeDirs(File dir) throws IOException {
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            File currFile = new File(dir.getPath() + File.separator + files[i]);
            if (currFile.isDirectory()) {
                FileUtils.removeDirs(currFile);
                continue;
            }
            FileUtils.deleteFile(currFile, false);
        }
        FileUtils.deleteFile(dir, false);
    }

    public static Reader getLocalReader(String fileName) throws ValidationException {
        File sourceFile = FileUtils.getFile(fileName);
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(sourceFile), UTF8);
        }
        catch (IOException e) {
            throw new ValidationException(e);
        }
        return reader;
    }

    public static void renameTo(File source, File dest) throws IOException {
        if (source.getCanonicalPath().equals(dest.getCanonicalPath())) {
            return;
        }
        if (!source.canRead()) {
            throw new IOException(FILE + source.getAbsolutePath() + "' doesn't have read permission");
        }
        if (dest.exists() && !dest.canWrite()) {
            throw new IOException(FILE + dest.getAbsolutePath() + "' doesn't have write permission");
        }
        if (source.isDirectory()) {
            File[] files;
            dest.mkdirs();
            if (!dest.exists()) {
                throw new IOException(FILE + dest.getAbsolutePath() + "' doesn't have write permission (2)");
            }
            for (File file : files = source.listFiles()) {
                File destFile = new File(dest, file.getName());
                File sourceFile = new File(source, file.getName());
                if (sourceFile.isDirectory()) {
                    FileUtils.renameTo(sourceFile, destFile);
                    continue;
                }
                sourceFile.renameTo(destFile);
            }
            FileUtils.deleteFile(source, true);
        } else {
            source.renameTo(dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyLocalFile(String source, String dest) throws IOException {
        if (source.equals(dest)) {
            return;
        }
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(source));
            bos = new BufferedOutputStream(new FileOutputStream(dest));
            int i = -1;
            while ((i = bis.read()) != -1) {
                ((BufferedOutputStream)bos).write(i);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (bis != null) {
                    bis.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        catch (IOException e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(String sourceFile, String destFolder) throws IOException, ValidationException {
        File dest = new File(destFolder);
        File source = new File(sourceFile);
        dest = new File(dest, source.getName());
        if (source.getCanonicalPath().equals(dest.getCanonicalPath())) {
            return;
        }
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            bis = new BufferedInputStream(this.getInputStream(sourceFile));
            bos = new BufferedOutputStream(new FileOutputStream(dest));
            int i = -1;
            while ((i = bis.read()) != -1) {
                ((BufferedOutputStream)bos).write(i);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                if (bis != null) {
                    bis.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        catch (IOException e) {}
    }

    private static void setInstallationFolder(String folder) {
        installationFolder = folder + File.separatorChar;
        if (!GeneralUtils.isMacOSX() && !GeneralUtils.isWinNT() && documentsFolder.length() == 0) {
            FileUtils.setDocumentsFolder(installationFolder);
        }
    }

    public static String getInstallationFolder() {
        return installationFolder;
    }

    private static void setAbsoluteInstallFolder(File folder) {
        absoluteInstallFolder = folder;
    }

    public static File getAbsoluteInstallFolder() {
        return absoluteInstallFolder;
    }

    public static String getDataFolder() {
        return dataFolder;
    }

    private static File setDataFolder(String dataFolder) {
        FileUtils.dataFolder = dataFolder;
        File folder = new File(dataFolder);
        folder.mkdirs();
        return folder;
    }

    public static String getDocumentsFolder() {
        File folder = new File(documentsFolder);
        folder.mkdirs();
        return documentsFolder;
    }

    private static void setDocumentsFolder(String documentsFolder) {
        FileUtils.documentsFolder = documentsFolder;
    }

    public static String getResultsFolder() {
        if ("".equals(resultsFolder)) {
            resultsFolder = documentsFolder;
        }
        File folder = new File(resultsFolder);
        folder.mkdirs();
        return resultsFolder;
    }

    public static void setResultsFolder(String resultsFolder) {
        FileUtils.resultsFolder = resultsFolder;
    }

    public static String getContentType(File f) {
        return mimeMap.getContentType(f);
    }

    public static String getPasswordsFolder() {
        return passwordsFolder;
    }

    public static void setPasswordsFolder(String passwordsFolder) {
        FileUtils.passwordsFolder = passwordsFolder;
    }

    public static String getWebRoot() {
        return webRoot;
    }

    public static void setWebRoot(String webRoot) {
        FileUtils.webRoot = webRoot;
    }

    public static String getLogFolder() {
        return logFolder;
    }

    public static void setLogFolder(String logFolder) {
        FileUtils.logFolder = logFolder;
    }

    public static String getBlackListFile() {
        return blackListFile;
    }

    public static void setBlackListFile(String blackListFile) {
        FileUtils.blackListFile = blackListFile;
    }

    public static boolean checkInstallationFolder(String[] args) {
        boolean extension = false;
        for (int i = 0; i < args.length; ++i) {
            String path;
            File currentFolder;
            if (!args[i].equals("-path") || i + 1 >= args.length) continue;
            if ((currentFolder = new File(path = args[++i])).exists() && currentFolder.isDirectory() && currentFolder.canRead()) {
                FileUtils.setInstallationFolder(path);
                FileUtils.setAbsoluteInstallFolder(currentFolder);
            }
            extension = true;
        }
        if (FileUtils.getAbsoluteInstallFolder() == null) {
            FileUtils.setAbsoluteInstallFolder(new File("."));
        }
        return extension;
    }

    static {
        installationFolder = "";
        dataFolder = "";
        documentsFolder = "";
        resultsFolder = "";
        passwordsFolder = "/home/halford/workspace/ValidatorLive/passwords/";
        webRoot = "/var/www/validator/";
        logFolder = "/home/halford/workspace/ValidatorLive/usage/";
        blackListFile = "/home/halford/workspace/ValidatorLive/blacklist.txt";
        String homeFolder = System.getProperty("user.home");
        if (GeneralUtils.isMacOSX()) {
            FileUtils.setDataFolder(homeFolder + "/Library/Application Support/TotalValidatorTool/");
            FileUtils.setDocumentsFolder(homeFolder + "/Documents/TotalValidatorTool/");
        } else if (GeneralUtils.isWinNT()) {
            String appData = null;
            try {
                appData = System.getenv("APPDATA");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (appData == null) {
                String user = new JFileChooser().getFileSystemView().getHomeDirectory().getParent();
                appData = System.getProperty("os.name").indexOf("Vista") != -1 || System.getProperty("os.name").indexOf("7") != -1 ? user + "\\AppData\\Roaming" : user + "\\Application Data";
            }
            File roaming = FileUtils.setDataFolder(appData + "\\TotalValidatorTool\\");
            String docsFolder = new JFileChooser().getFileSystemView().getDefaultDirectory().getAbsolutePath() + "\\TotalValidatorTool\\";
            FileUtils.setDocumentsFolder(docsFolder);
            FileUtils.migrateOldFolders(roaming, docsFolder);
        } else {
            FileUtils.setDataFolder(homeFolder + "/.totalvalidatortool/");
            File docsFolder = new File(homeFolder + "/Documents");
            if (docsFolder.exists() && docsFolder.isDirectory() && docsFolder.canWrite()) {
                FileUtils.setDocumentsFolder(homeFolder + "/Documents/totalvalidatortool/");
            }
        }
        mimeMap.addMimeTypes("application/xhtml+xml xhtml XHTML xht XHT\ntext/xml xml XML\napplication/gzip gz\napplication/x-msdownload exe EXE");
    }
}

