/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.utils;

import com.totalvalidator.utils.GeneralUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Locale;

public class MyReader {
    private Reader reader;
    private boolean scriptLanguageHeader;
    private boolean styleLanguageHeader;
    private String contentType;
    private String charset;
    private InputStream inputStream;
    private boolean httpStream;
    private byte[] bytes;
    private ByteArrayInputStream bais;
    private boolean isXml;
    private String contentTypeHeader;

    public Reader getReader() {
        if (this.inputStream == null) {
            return null;
        }
        try {
            if (this.reader == null) {
                if (this.charset == null) {
                    this.charset = this.httpStream ? "UTF-8" : Charset.defaultCharset().name();
                    GeneralUtils.LOGGER.info("Default character set used: " + this.charset);
                }
                this.reader = new InputStreamReader(this.inputStream, this.charset);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return this.reader;
    }

    public void convertToBuffer() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int i = -1;
            while ((i = this.inputStream.read()) != -1) {
                baos.write(i);
            }
            this.inputStream.close();
            baos.close();
            this.bytes = baos.toByteArray();
            this.bais = new ByteArrayInputStream(this.bytes);
            this.inputStream = this.bais;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void resetBuffer() {
        if (this.bais != null) {
            this.bais.reset();
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public boolean haveCharset() {
        return this.charset != null;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        String type;
        this.contentType = contentType;
        if (contentType != null && ((type = contentType.trim().toLowerCase(Locale.ENGLISH)).startsWith("application/xhtml+xml") || type.startsWith("text/xml") || type.startsWith("application/xml"))) {
            this.isXml = true;
        }
    }

    public String getContentTypeHeader() {
        return this.contentTypeHeader;
    }

    public void setContentTypeHeader(String contentType) {
        this.contentTypeHeader = contentType;
        this.setContentType(contentType);
    }

    public boolean isScriptLanguageHeader() {
        return this.scriptLanguageHeader;
    }

    public boolean isStyleLanguageHeader() {
        return this.styleLanguageHeader;
    }

    public void setScriptLanguageHeader(boolean scriptLanguageHeader) {
        this.scriptLanguageHeader = scriptLanguageHeader;
    }

    public void setStyleLanguageHeader(boolean styleLanguageHeader) {
        this.styleLanguageHeader = styleLanguageHeader;
    }

    public boolean isHttpStream() {
        return this.httpStream;
    }

    public void setHttpStream(boolean httpStream) {
        this.httpStream = httpStream;
    }

    public boolean isXml() {
        return this.isXml;
    }
}

