/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator;

import com.totalvalidator.Validator;
import com.totalvalidator.app.About;
import com.totalvalidator.app.AuthenticationDialog;
import com.totalvalidator.app.BasicTab;
import com.totalvalidator.app.CheckSite;
import com.totalvalidator.app.InfoPanel;
import com.totalvalidator.app.SplashScreen;
import com.totalvalidator.app.ToolBuildVersion;
import com.totalvalidator.app.WaitFrame;
import com.totalvalidator.exceptions.CommandLineException;
import com.totalvalidator.options.Option;
import com.totalvalidator.options.OptionFactory;
import com.totalvalidator.parser.CommandLineParser;
import com.totalvalidator.utils.BuildVersion;
import com.totalvalidator.utils.FileUtils;
import com.totalvalidator.utils.GeneralUtils;
import com.totalvalidator.utils.MyProxySelector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;

public class TotalValidator
extends JFrame
implements Runnable,
ActionListener {
    public static final String UPDATES = "Updates";
    public static final Color TOTAL_LIGHT_BLUE = new Color(223, 223, 255);
    public static final String[] MESSAGES = new String[]{"This will reset all your settings on this tab to the defaults. Are you sure?"};
    private static final long serialVersionUID = 1L;
    public static final String COMMON_PROPERTIES = "common.props";
    private static final String OLD_PROPERTIES = "validator.props";
    private static final String PROPS_SUFFIX = ".tv.props";
    public static final String PROPS_HEADER = "Total Validator Properties - Do not edit this file.";
    private static final String HELP_FILE = "help/help.html";
    private static final Color TOTAL_BACKGROUND = Color.WHITE;
    static final Color TOTAL_FOREGROUND = Color.BLACK;
    static final String PAGE_COUNT = "Pages validated/queued:";
    static final String[] VALIDATE_MESSAGES = new String[]{"Validating .... Please Wait", "Use Cancel to abort"};
    private static final String[] UPDATE_MESSAGES = new String[]{"Checking for updates .... Please Wait"};
    private static final String[] CANCEL_MESSAGES = new String[]{"Cancelling .... Please Wait", "This may take up to 30 secs to complete"};
    private static final String FRAME_WIDTH = "FrameWidth";
    private static final String FRAME_HEIGHT = "FrameHeight";
    private static final String FRAME_X = "FrameX";
    private static final String FRAME_Y = "FrameY";
    private static final String UPDATES_TITLE = "Updates Check";
    private static final String USE_PROXY = "UseWindowsProxy";
    private static final String SPLASH_SCREEN = "SplashScreen";
    private static final String VERSION = "Version";
    private static final String TV_ICON = "com/totalvalidator/images/tv64.gif";
    private static final String COPYRIGHT = "Copyright (c) 2011 Total Validator";
    public static final String CANCEL = "Cancel";
    private static final String TOOL_TITLE = "Total Validator Tool";
    private static final String SHORT_REPORT = "ShortReport";
    private static final String HIDE_RESULTS = "HideResults";
    private static final String LOG_LEVEL = "LogLevel";
    private static boolean ranFromExtension;
    private JCheckBoxMenuItem autoUpdates;
    private JCheckBoxMenuItem useSystemProxy;
    private JCheckBoxMenuItem shortReport;
    private JCheckBoxMenuItem splashScreen;
    private JCheckBoxMenuItem hideResults;
    private Image icon;
    private InfoPanel infoPanel;
    private Option option;
    private BasicTab basicTab;
    private JButton validate;
    private Validator v;
    private boolean checkForUpdates = false;
    private boolean showUpdateErrors = true;
    private SplashScreen cancelling;
    private WaitFrame pleaseWait;
    private int maxPages;
    private Properties commonProps;
    private Properties props;
    private int idealHeight;
    private String userAgent;
    private CommandLineParser ffclp;
    private JTabbedPane tabbedPane;
    private JMenu fileMenu;
    private boolean firstTimeUse;
    private JMenuItem updatesCheck;

    public static void main(String[] args) {
        ranFromExtension = GeneralUtils.basicSettings(args);
        TotalValidator tv = new TotalValidator();
        tv.launch(args);
    }

    private void launch(String[] args) {
        Thread t;
        try {
            this.option = OptionFactory.newOption();
            this.userAgent = "Total Validator Tool " + this.option.getType() + ToolBuildVersion.getBuildVersion();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage() != null ? e.getMessage() : "Error - No Message", "Validation Error", 0);
            GeneralUtils.LOGGER.log(Level.SEVERE, "Failed whilst retrieving Option", e);
            System.exit(1);
        }
        this.loadCommon();
        if (ranFromExtension) {
            this.loadCommandLine(args);
        }
        this.icon = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(TV_ICON));
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(this.icon, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.setIconImage(this.icon);
        String[] version = new String[]{"Tool: v" + ToolBuildVersion.getBuildVersion() + " - " + ToolBuildVersion.getBuildDate(), "Engine: v" + BuildVersion.getBuildVersion() + " - " + BuildVersion.getBuildDate(), COPYRIGHT, "All rights reserved."};
        this.infoPanel = new InfoPanel(this.icon, TOTAL_FOREGROUND, TOTAL_LIGHT_BLUE, version, null, null, 0, this);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.commonProps.getProperty(SPLASH_SCREEN, "true").equals("true")) {
            SplashScreen ss = new SplashScreen(this, this.addBorder(this.infoPanel), true, this.getStoredDimensions());
            t = new Thread(ss);
            t.start();
        }
        this.initComponents();
        this.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent e) {
                int width = (int)TotalValidator.this.getSize().getWidth();
                int height = (int)TotalValidator.this.getSize().getHeight();
                if (width < TotalValidator.this.option.getWidth()) {
                    width = TotalValidator.this.option.getWidth();
                }
                if (height < TotalValidator.this.idealHeight) {
                    height = TotalValidator.this.idealHeight;
                }
                TotalValidator.this.setSize(width, height);
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentHidden(ComponentEvent e) {
            }
        });
        this.setPosition(false);
        this.setVisible(true);
        String check = this.commonProps.getProperty(UPDATES, "false");
        if ("true".equals(check)) {
            this.checkForUpdates = true;
            this.showUpdateErrors = false;
            t = new Thread(this);
            t.start();
        }
    }

    private void setPosition(boolean reset) {
        int[] storedDims;
        int width = this.option.getWidth();
        int height = this.idealHeight;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - width) / 2;
        int y = (screenSize.height - height) / 2;
        String version = this.commonProps.getProperty(VERSION, "");
        if (!version.equals(ToolBuildVersion.getBuildVersion())) {
            reset = true;
        }
        if (!reset && (storedDims = this.getStoredDimensions()) != null) {
            width = storedDims[0];
            height = storedDims[1];
            x = storedDims[2];
            y = storedDims[3];
        }
        this.setSize(width, height);
        this.setLocation(x, y);
        this.validate();
    }

    private int[] getStoredDimensions() {
        int[] storedDims = new int[4];
        String str = this.commonProps.getProperty(FRAME_WIDTH, "");
        try {
            storedDims[0] = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
        str = this.commonProps.getProperty(FRAME_HEIGHT, "");
        try {
            storedDims[1] = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
        str = this.commonProps.getProperty(FRAME_X, "");
        try {
            storedDims[2] = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
        str = this.commonProps.getProperty(FRAME_Y, "");
        try {
            storedDims[3] = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return storedDims;
    }

    private JPanel addBorder(JPanel panel) {
        JPanel borderedPanel = new JPanel();
        borderedPanel.setBorder(new LineBorder(TOTAL_FOREGROUND));
        borderedPanel.setBackground(TOTAL_LIGHT_BLUE);
        borderedPanel.add(panel);
        return borderedPanel;
    }

    private void loadCommon() {
        boolean noCommonProps = false;
        this.commonProps = new Properties();
        try {
            InputStream is = FileUtils.getLocalInputStream(FileUtils.getDataFolder() + COMMON_PROPERTIES);
            this.commonProps.load(is);
            is.close();
        }
        catch (Exception e) {
            GeneralUtils.LOGGER.log(Level.INFO, "Failed to read Properties", e);
            noCommonProps = true;
        }
        String logLevel = this.commonProps.getProperty(LOG_LEVEL);
        if (logLevel != null) {
            this.setLoggingLevel(logLevel);
        }
        this.option.loadCommon(this, this.commonProps);
        this.openSettings(this.option.getSettingsName(), false, noCommonProps);
        if (noCommonProps) {
            this.commonProps.setProperty(VERSION, this.props.getProperty(VERSION, ""));
            this.props.remove(VERSION);
            this.commonProps.setProperty(FRAME_WIDTH, this.props.getProperty(FRAME_WIDTH, ""));
            this.props.remove(FRAME_WIDTH);
            this.commonProps.setProperty(FRAME_HEIGHT, this.props.getProperty(FRAME_HEIGHT, ""));
            this.props.remove(FRAME_HEIGHT);
            this.commonProps.setProperty(FRAME_X, this.props.getProperty(FRAME_X, ""));
            this.props.remove(FRAME_X);
            this.commonProps.setProperty(FRAME_Y, this.props.getProperty(FRAME_Y, ""));
            this.props.remove(FRAME_Y);
            this.commonProps.setProperty(UPDATES, this.props.getProperty(UPDATES, "false"));
            this.props.remove(UPDATES);
            this.commonProps.setProperty(SHORT_REPORT, this.props.getProperty(SHORT_REPORT, "false"));
            this.props.remove(SHORT_REPORT);
            this.commonProps.setProperty(SPLASH_SCREEN, this.props.getProperty(SPLASH_SCREEN, "true"));
            this.props.remove(SPLASH_SCREEN);
            this.commonProps.setProperty(USE_PROXY, this.props.getProperty(USE_PROXY, "true"));
            this.props.remove(USE_PROXY);
            this.commonProps.setProperty(HIDE_RESULTS, this.props.getProperty(HIDE_RESULTS, "false"));
            this.props.remove(HIDE_RESULTS);
            this.commonProps.setProperty("LastResults", this.props.getProperty("LastResults", ""));
            this.props.remove("LastResults");
        }
    }

    public void openSettings(String currentProps, boolean updateUI, boolean noCommonProps) {
        block8: {
            this.option.openSettings(currentProps);
            this.props = new Properties();
            try {
                InputStream is = FileUtils.getLocalInputStream(this.getPropsFile(currentProps));
                this.props.load(is);
                is.close();
            }
            catch (Exception e) {
                if (noCommonProps) {
                    try {
                        InputStream is = FileUtils.getLocalInputStream(FileUtils.getDataFolder() + OLD_PROPERTIES);
                        this.props.load(is);
                        is.close();
                    }
                    catch (Exception e1) {
                        try {
                            InputStream is = FileUtils.getLocalInputStream(FileUtils.getInstallationFolder() + OLD_PROPERTIES);
                            this.props.load(is);
                            is.close();
                        }
                        catch (Exception e2) {
                            GeneralUtils.LOGGER.log(Level.INFO, "Failed to read Properties", e2);
                        }
                    }
                    this.firstTimeUse = true;
                }
                this.firstTimeUse = this.option.missingSettings(this.props, currentProps, this.firstTimeUse);
                if (!updateUI) break block8;
                JOptionPane.showMessageDialog(this, "One or more settings files are missing", "Missing settings", 0);
            }
        }
        if (updateUI) {
            this.tabbedPane.setSelectedComponent(this.basicTab);
            this.basicTab.updateTab(this.props, this.commonProps, null);
            this.option.updateTabs(this.props);
        }
    }

    private void loadCommandLine(String[] args) {
        this.ffclp = new CommandLineParser(new FileUtils());
        try {
            this.ffclp.processArgs(args);
        }
        catch (CommandLineException e) {
            GeneralUtils.LOGGER.severe(e.getMessage());
        }
    }

    public void resetAllToDefaults(boolean resetPosition) {
        this.tabbedPane.setSelectedComponent(this.basicTab);
        this.basicTab.resetTab();
        this.option.resetToDefaults();
        if (resetPosition) {
            this.setPosition(true);
        }
    }

    private void initComponents() {
        JMenuBar jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.fileMenu.setMnemonic(70);
        this.fileMenu.setText("File");
        this.option.addFileMenuItems1(this.fileMenu);
        JMenuItem saveItem = new JMenuItem();
        saveItem.setVerifyInputWhenFocusTarget(true);
        saveItem.setMnemonic(83);
        saveItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        saveItem.setText("Save");
        saveItem.setToolTipText("Save settings");
        saveItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TotalValidator.this.saveSettings(true, false);
            }
        });
        this.fileMenu.add(saveItem);
        this.option.addFileMenuItems2();
        JSeparator fsep2 = new JSeparator();
        this.fileMenu.add(fsep2);
        JMenuItem validateItem = new JMenuItem();
        validateItem.setVerifyInputWhenFocusTarget(true);
        validateItem.setMnemonic(86);
        if (GeneralUtils.isMacOSX()) {
            validateItem.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }
        validateItem.setText("Validate");
        validateItem.setToolTipText("Run the Validator");
        validateItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Thread t = new Thread(TotalValidator.this);
                t.start();
            }
        });
        this.fileMenu.add(validateItem);
        JSeparator fsep3 = new JSeparator();
        this.fileMenu.add(fsep3);
        JMenuItem resetList = new JMenuItem();
        resetList.setMnemonic(76);
        resetList.setText("Reset List");
        resetList.setToolTipText("Reset the starting page list");
        resetList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TotalValidator.this.basicTab.resetListToDefault();
            }
        });
        this.fileMenu.add(resetList);
        JMenuItem resetItem = new JMenuItem();
        resetItem.setMnemonic(82);
        resetItem.setText("Reset All");
        resetItem.setToolTipText("Reset all settings on all tabs to the defaults");
        resetItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int result = JOptionPane.showConfirmDialog(TotalValidator.this, "This will reset all your settings to the defaults. Are you sure?", "Reset to defaults", 0);
                if (result == 0) {
                    TotalValidator.this.resetAllToDefaults(true);
                }
            }
        });
        this.fileMenu.add(resetItem);
        this.option.addFileMenuItems3();
        JSeparator fsep5 = new JSeparator();
        this.fileMenu.add(fsep5);
        JMenuItem exitItem = new JMenuItem();
        if (GeneralUtils.isMacOSX()) {
            exitItem.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }
        exitItem.setMnemonic(88);
        exitItem.setText(GeneralUtils.isMacOSX() ? "Close Window" : "Exit");
        exitItem.setToolTipText("Exit and close the Tool");
        exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TotalValidator.this.saveSettings(false, false);
                System.exit(0);
            }
        });
        this.fileMenu.add(exitItem);
        jMenuBar1.add(this.fileMenu);
        JMenu optionsMenu = new JMenu();
        optionsMenu.setMnemonic(79);
        optionsMenu.setText("Options");
        this.updatesCheck = new JMenuItem();
        this.updatesCheck.setMnemonic(85);
        this.updatesCheck.setText("Check for Updates");
        this.updatesCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TotalValidator.this.checkForUpdates = true;
                TotalValidator.this.showUpdateErrors = true;
                Thread t = new Thread(TotalValidator.this);
                t.start();
            }
        });
        optionsMenu.add(this.updatesCheck);
        JSeparator osep1 = new JSeparator();
        optionsMenu.add(osep1);
        this.autoUpdates = new JCheckBoxMenuItem();
        this.autoUpdates.setMnemonic(65);
        this.autoUpdates.setText("Auto-update Check");
        String check = this.commonProps.getProperty(UPDATES, "false");
        this.autoUpdates.setState(check.equals("true"));
        optionsMenu.add(this.autoUpdates);
        this.useSystemProxy = new JCheckBoxMenuItem();
        this.useSystemProxy.setMnemonic(83);
        this.useSystemProxy.setText("Use System Proxy");
        String useProxyStr = this.commonProps.getProperty(USE_PROXY, "true");
        this.useSystemProxy.setState(useProxyStr.equals("true"));
        if (this.ffclp != null) {
            this.useSystemProxy.setState(this.ffclp.useSystemProxy());
        }
        this.useSystemProxy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JOptionPane.showMessageDialog(TotalValidator.this, "Restart the Tool for this change to take effect", "System Proxy Settings", 2);
            }
        });
        optionsMenu.add(this.useSystemProxy);
        this.splashScreen = new JCheckBoxMenuItem();
        this.splashScreen.setMnemonic(80);
        this.splashScreen.setText("Splashscreen");
        String showSplash = this.commonProps.getProperty(SPLASH_SCREEN, "true");
        this.splashScreen.setState(showSplash.equals("true"));
        optionsMenu.add(this.splashScreen);
        jMenuBar1.add(optionsMenu);
        this.hideResults = new JCheckBoxMenuItem();
        this.hideResults.setMnemonic(72);
        this.hideResults.setText("Hide Results");
        String showBrowser = this.commonProps.getProperty(HIDE_RESULTS, "false");
        this.hideResults.setState(showBrowser.equals("true"));
        if (this.ffclp != null) {
            this.hideResults.setState(this.ffclp.isHideResults());
        }
        optionsMenu.add(this.hideResults);
        jMenuBar1.add(optionsMenu);
        this.shortReport = new JCheckBoxMenuItem();
        this.shortReport.setMnemonic(79);
        this.shortReport.setText("Short Report");
        String report = this.commonProps.getProperty(SHORT_REPORT, "false");
        this.shortReport.setState(report.equals("true"));
        if (this.ffclp != null) {
            this.shortReport.setState(this.ffclp.isShortReport());
        }
        optionsMenu.add(this.shortReport);
        jMenuBar1.add(optionsMenu);
        JMenu helpMenu = new JMenu();
        helpMenu.setVerifyInputWhenFocusTarget(false);
        helpMenu.setMnemonic(72);
        helpMenu.setText("Help");
        JMenuItem helpItem = new JMenuItem();
        if (GeneralUtils.isMacOSX()) {
            helpItem.setText("TotalValidator Help");
        } else {
            helpItem.setMnemonic(72);
            helpItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
            helpItem.setText("Help");
        }
        helpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    GeneralUtils.launchBrowser(new File(FileUtils.getInstallationFolder() + TotalValidator.HELP_FILE).toURI().toURL().toString());
                }
                catch (Exception e) {
                    GeneralUtils.LOGGER.log(Level.SEVERE, "Failed to display Help", e);
                    JOptionPane.showMessageDialog(TotalValidator.this, "Could not display help.", "Help", 0);
                }
            }
        });
        helpMenu.add(helpItem);
        JSeparator hsep1 = new JSeparator();
        helpMenu.add(hsep1);
        JMenuItem aboutItem = new JMenuItem();
        aboutItem.setMnemonic(65);
        aboutItem.setText("About");
        aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                new About(TotalValidator.this, TotalValidator.this.infoPanel, TOTAL_LIGHT_BLUE);
            }
        });
        helpMenu.add(aboutItem);
        jMenuBar1.add(helpMenu);
        this.setJMenuBar(jMenuBar1);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().setBackground(TOTAL_BACKGROUND);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TotalValidator.this.saveSettings(false, false);
                System.exit(0);
            }
        });
        this.setTitle(TOOL_TITLE);
        this.setDefaultCloseOperation(0);
        this.tabbedPane = new JTabbedPane();
        this.basicTab = new BasicTab(this.tabbedPane, this.props, this.commonProps, this.icon, this.option, this.ffclp);
        this.option.extraTabs(this.tabbedPane, this.props, this.icon, this.option, this.ffclp, this.basicTab);
        this.tabbedPane.setBackground(TOTAL_LIGHT_BLUE);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tabbedPane, gridBagConstraints);
        JPanel buttonPanel2 = new JPanel();
        buttonPanel2.setOpaque(false);
        this.validate = new JButton();
        if (GeneralUtils.isMacOSX()) {
            this.validate.setOpaque(false);
        }
        this.validate.setText("Validate");
        this.validate.setMnemonic(86);
        this.validate.setVerifyInputWhenFocusTarget(false);
        this.validate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Thread t = new Thread(TotalValidator.this);
                t.start();
            }
        });
        buttonPanel2.add(this.validate);
        JButton save = new JButton();
        if (GeneralUtils.isMacOSX()) {
            save.setOpaque(false);
        }
        save.setText("Save");
        save.setMnemonic(83);
        save.setToolTipText("Save settings");
        save.setVerifyInputWhenFocusTarget(false);
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TotalValidator.this.saveSettings(true, false);
            }
        });
        buttonPanel2.add(save);
        JButton resetAll = new JButton();
        if (GeneralUtils.isMacOSX()) {
            resetAll.setOpaque(false);
        }
        resetAll.setText("Reset All");
        resetAll.setMnemonic(65);
        resetAll.setToolTipText("Reset all settings to defaults");
        resetAll.setVerifyInputWhenFocusTarget(false);
        resetAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int result = JOptionPane.showConfirmDialog(TotalValidator.this, "This will reset all your settings to the defaults. Are you sure?", "Reset to defaults", 0);
                if (result == 0) {
                    TotalValidator.this.resetAllToDefaults(true);
                }
            }
        });
        buttonPanel2.add(resetAll);
        JButton exit = new JButton();
        if (GeneralUtils.isMacOSX()) {
            exit.setOpaque(false);
        }
        exit.setText("Exit");
        exit.setMnemonic(88);
        exit.setVerifyInputWhenFocusTarget(false);
        exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TotalValidator.this.saveSettings(false, false);
                System.exit(0);
            }
        });
        buttonPanel2.add(exit);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)buttonPanel2, gridBagConstraints);
        this.pack();
        this.idealHeight = this.getHeight();
    }

    private void checkForUpdates() throws Exception {
        boolean prompt = this.showUpdateErrors && this.option.isInteractive();
        String updates = null;
        try {
            updates = CheckSite.checkVersion(this.userAgent, this.option.getProxyDetails(), this, prompt, this.option.getUpdateSite());
        }
        catch (IOException e) {
            if (this.cancelling != null) {
                return;
            }
            if (this.showUpdateErrors) {
                JOptionPane.showMessageDialog(this, "Could not connect to update site. Please check your Internet connection.", UPDATES_TITLE, 0);
            }
            return;
        }
        if (this.cancelling != null) {
            return;
        }
        if (updates == null) {
            if (this.showUpdateErrors) {
                JOptionPane.showMessageDialog(this, "Update site not available. Try again later.", UPDATES_TITLE, 0);
            }
        } else if (updates.length() > 0) {
            if (JOptionPane.showConfirmDialog(this, "A later version is available. Do you wish to download it?", UPDATES_TITLE, 0) == 0) {
                GeneralUtils.launchBrowser(this.option.getDownloadPage());
            }
        } else if (this.showUpdateErrors) {
            JOptionPane.showMessageDialog(this, "No updates available", UPDATES_TITLE, 1);
        }
    }

    public void run() {
        System.setProperty("java.net.useSystemProxies", this.useSystemProxy.getState() ? "true" : "false");
        try {
            if (this.checkForUpdates) {
                this.checkForUpdates = false;
                if (this.showUpdateErrors) {
                    this.disableGUI();
                    InfoPanel waitPanel = new InfoPanel(null, TOTAL_FOREGROUND, TOTAL_LIGHT_BLUE, UPDATE_MESSAGES, null, CANCEL, 67, this);
                    this.pleaseWait = new WaitFrame(this, waitPanel, UPDATES);
                    this.pleaseWait.setVisible(true);
                } else {
                    this.updatesCheck.setEnabled(false);
                }
                ((MyProxySelector)ProxySelector.getDefault()).setProxyDetails(this.option.getProxyDetails());
                this.checkForUpdates();
                this.updatesCheck.setEnabled(true);
            } else {
                this.option.disableVerifiers();
                InfoPanel waitPanel = new InfoPanel(null, TOTAL_FOREGROUND, TOTAL_LIGHT_BLUE, null, VALIDATE_MESSAGES, CANCEL, 67, this);
                this.pleaseWait = new WaitFrame(this, waitPanel, "Validating");
                ((MyProxySelector)ProxySelector.getDefault()).setProxyDetails(this.option.getProxyDetails());
                AuthenticationDialog.resetCount();
                this.doValidation(this.pleaseWait);
            }
        }
        catch (CommandLineException e) {
            this.cancelFrames();
            JOptionPane.showMessageDialog(this, e.getMessage() != null ? e.getMessage() : "Error - No Message", "Invalid Entry", 2);
        }
        catch (Exception e) {
            this.cancelFrames();
            JOptionPane.showMessageDialog(this, e.getMessage() != null ? e.getMessage() : "Error - No Message", "Validation Error", 0);
            GeneralUtils.LOGGER.log(Level.SEVERE, "Failed", e);
        }
        this.cancelFrames();
        this.option.enableVerifiers();
        this.enableGUI();
    }

    private void cancelFrames() {
        if (this.pleaseWait != null) {
            this.pleaseWait.dispose();
            this.pleaseWait = null;
        }
        if (this.cancelling != null) {
            this.cancelling.dispose();
            this.cancelling = null;
        }
    }

    private void doValidation(WaitFrame pleaseWait) throws Exception {
        ArrayList<String> options = new ArrayList<String>();
        options.add("-interact");
        if (this.shortReport.getState()) {
            options.add("-shortreport");
        }
        this.basicTab.getFields(options);
        this.option.getFields(options, this.tabbedPane);
        this.disableGUI();
        pleaseWait.setVisible(true);
        String[] args = new String[options.size()];
        args = options.toArray(args);
        CommandLineParser cl = new CommandLineParser(new FileUtils());
        cl.setTool(true);
        cl.processArgs(args);
        this.maxPages = cl.getMaxPages();
        long startTime = System.currentTimeMillis();
        this.v = new Validator();
        this.v.setOption(this.option);
        this.v.setServlet(false);
        this.v.setCommandLineParser(cl);
        this.v.setFileUtils(new FileUtils());
        this.v.addActionListener(this);
        String resultsFile = this.v.validate();
        this.v = null;
        long duration = System.currentTimeMillis() - startTime;
        GeneralUtils.LOGGER.info("Validation took: " + this.formatTime(duration));
        File results = new File(resultsFile);
        if (!this.hideResults.getState()) {
            GeneralUtils.launchBrowser(results.toURI().toURL().toString());
        }
        this.basicTab.addPageToList(results.getAbsolutePath());
    }

    private String formatTime(long duration) {
        long seconds = duration / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        return this.pad(hours) + ":" + this.pad(minutes %= 60L) + ":" + this.pad(seconds %= 60L);
    }

    private String pad(long number) {
        return (number < 10L ? "0" : "") + number;
    }

    private void enableGUI() {
        this.setEnabled(true);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void disableGUI() {
        this.setEnabled(false);
        this.setCursor(new Cursor(3));
    }

    public void saveSettings(boolean save, boolean saveAs) {
        this.basicTab.saveCommonProperties(this.commonProps);
        StringBuilder rupsList = this.option.saveCommonProperties(this.commonProps);
        this.commonProps.setProperty(VERSION, ToolBuildVersion.getBuildVersion());
        this.commonProps.setProperty(FRAME_WIDTH, this.getWidth() + "");
        this.commonProps.setProperty(FRAME_HEIGHT, this.getHeight() + "");
        this.commonProps.setProperty(FRAME_X, this.getLocation().x + "");
        this.commonProps.setProperty(FRAME_Y, this.getLocation().y + "");
        this.commonProps.setProperty(UPDATES, this.autoUpdates.getState() + "");
        this.commonProps.setProperty(SHORT_REPORT, this.shortReport.getState() + "");
        this.commonProps.setProperty(SPLASH_SCREEN, this.splashScreen.getState() + "");
        this.commonProps.setProperty(USE_PROXY, this.useSystemProxy.getState() + "");
        this.commonProps.setProperty(HIDE_RESULTS, this.hideResults.getState() + "");
        try {
            this.commonProps.store(FileUtils.getLocalOutputStream(FileUtils.getDataFolder() + COMMON_PROPERTIES), PROPS_HEADER);
        }
        catch (Exception e) {
            GeneralUtils.LOGGER.log(Level.SEVERE, "Failed whist saving Properties", e);
        }
        try {
            save = this.option.saveAs(this.commonProps, saveAs, rupsList, save);
        }
        catch (Exception e1) {
            return;
        }
        Properties savedProps = new Properties();
        this.basicTab.saveProperties(savedProps);
        this.option.saveProperties(savedProps);
        if (!save && !this.firstTimeUse) {
            boolean changes = false;
            for (String string : this.props.keySet()) {
                String oldValue = this.props.getProperty(string);
                String newValue = savedProps.getProperty(string);
                if (!(oldValue == null && newValue != null || oldValue != null && newValue == null) && newValue.equals(oldValue)) continue;
                changes = true;
                break;
            }
            if (!changes) {
                return;
            }
            int result = JOptionPane.showConfirmDialog(this, "Do you wish to save your changes first?", "Save changes", 0);
            if (result != 0) {
                return;
            }
        }
        try {
            savedProps.store(FileUtils.getLocalOutputStream(this.getPropsFile(this.option.getSettingsName())), PROPS_HEADER);
        }
        catch (Exception e) {
            GeneralUtils.LOGGER.log(Level.SEVERE, "Failed whist saving Properties", e);
        }
        this.firstTimeUse = false;
        this.props = savedProps;
    }

    public String getPropsFile(String propsPrefix) {
        return FileUtils.getDataFolder() + propsPrefix + PROPS_SUFFIX;
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() instanceof Validator) {
            int pageCount = event.getID();
            int mPages = this.maxPages - pageCount;
            String[] liveMessages = new String[]{PAGE_COUNT, pageCount + " / " + (this.maxPages > 1 && this.v.pagesLeft > mPages ? mPages : this.v.pagesLeft)};
            GeneralUtils.LOGGER.info(liveMessages[0] + " " + liveMessages[1]);
            if (this.pleaseWait != null) {
                this.pleaseWait.getInfoPanel().setLiveMessages(liveMessages);
            }
        } else {
            if (this.pleaseWait != null) {
                this.pleaseWait.dispose();
                this.pleaseWait = null;
            }
            InfoPanel cancelPanel = new InfoPanel(null, TOTAL_FOREGROUND, TOTAL_LIGHT_BLUE, CANCEL_MESSAGES, null, null, 0, this);
            this.cancelling = new SplashScreen(this, this.addBorder(cancelPanel), false, null);
            this.cancelling.setVisible(true);
            if (this.v != null) {
                this.v.cancel();
            }
        }
    }

    public void setLoggingLevel(String levelStr) {
        Level level = levelStr.equals("Off") ? Level.SEVERE : Level.ALL;
        GeneralUtils.LOGGER.setLevel(level);
        System.setProperty("SingleThread", level == Level.ALL ? "true" : "false");
        GeneralUtils.logSystemProperties();
        this.commonProps.setProperty(LOG_LEVEL, levelStr);
    }
}

