/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.parser;

import com.totalvalidator.exceptions.ValidationException;
import com.totalvalidator.sgml.Attribute;
import com.totalvalidator.sgml.Element;
import com.totalvalidator.sgml.EntityEncoder;
import com.totalvalidator.sgml.Tag;
import com.totalvalidator.utils.DirSelector;
import com.totalvalidator.utils.GeneralUtils;
import com.totalvalidator.validations.problem.ValidationProblem;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DTDParser
implements Serializable {
    private static final char TAG_END = '>';
    private static final char TAG_START = '<';
    private EntityEncoder encoder = new EntityEncoder();
    private boolean xml = true;
    private Map<String, String> entities = new HashMap<String, String>();
    private Map<String, Element> elements = new HashMap<String, Element>();
    private String directory = "";
    private String docType;
    static final long serialVersionUID = -1L;
    private String dtdName;
    private boolean bestFit = false;
    private static Map<String, DTDParser> DTDCache = new HashMap<String, DTDParser>();

    public static void main(String[] args) {
        GeneralUtils.setupLogging();
        try {
            DTDParser.parseDTDs();
            JOptionPane.showMessageDialog(new Frame(), "DTD Parsing Finished", "Validator", 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(new Frame(), e.getMessage() != null ? e.getMessage() : "Error - No Message", "Parsing Error", 0);
            System.exit(1);
        }
        System.exit(0);
    }

    private static void parseDTDs() throws Exception {
        File folder;
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        DirSelector ds = new DirSelector(null, "Select a folder to parse", "/media/truecrypt1/workspace/Validator/source/templates/dtds");
        String dir = ds.getDirectory();
        if (dir != null && (folder = new File(ds.getDirectory())).isDirectory()) {
            DTDParser.parseFolder(folder);
        }
    }

    private static void parseFolder(File folder) throws Exception {
        File[] files = folder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                DTDParser.parseFolder(files[i]);
                continue;
            }
            if (!files[i].getName().endsWith(".dtd")) continue;
            DTDParser parser = new DTDParser();
            parser.getType(files[i]);
            parser.parseFile(new FileInputStream(files[i]));
            if (parser == null) continue;
            DTDParser.serialise(parser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void serialise(DTDParser parser) throws Exception {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(parser.directory + "/" + parser.dtdName + ".object"));
            oos.writeObject(parser);
            oos.flush();
            Object var3_2 = null;
            if (oos == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (oos == null) throw throwable;
            oos.close();
            throw throwable;
        }
        oos.close();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DTDParser deserialise(InputStream dtd, String dtdName) throws ValidationException {
        ObjectInputStream ois;
        DTDParser parser = null;
        if (dtdName.indexOf("doctype.dtd") != -1) {
            return new DTDParser();
        }
        if (dtdName.indexOf("bestfit.dtd") != -1) {
            parser = new DTDParser();
            parser.setBestFit(true);
            return parser;
        } else {
            ois = null;
            ois = new ObjectInputStream(dtd);
            parser = (DTDParser)ois.readObject();
            Object var6_4 = null;
            if (ois == null) return parser;
            try {
                ois.close();
                return parser;
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return parser;
        {
            catch (Exception e) {
                e.printStackTrace();
                throw new ValidationException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (ois == null) throw throwable;
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void parseFile(InputStream source) throws Exception {
        src = null;
        src = source instanceof BufferedInputStream != false ? new PushbackInputStream((BufferedInputStream)source, 4) : new PushbackInputStream(new BufferedInputStream(source), 4);
        i = -1;
        currentLine = 1;
        withinTag = false;
        inComment = false;
        inSpecial = false;
        inDTDComment = false;
        newTag = new StringBuilder();
        data = new StringBuilder();
        buffer = new char[4];
lbl12:
        // 4 sources

        try {
            while ((i = src.read()) != -1) {
                block24: {
                    block25: {
                        block26: {
                            block18: {
                                block19: {
                                    block21: {
                                        block22: {
                                            block23: {
                                                block20: {
                                                    c = (char)i;
                                                    if (inComment || inSpecial || inDTDComment) {
                                                        buffer[3] = buffer[2];
                                                        buffer[2] = buffer[1];
                                                        buffer[1] = buffer[0];
                                                        buffer[0] = c;
                                                    }
                                                    if (c == '\n') {
                                                        ++currentLine;
                                                    }
                                                    if (inDTDComment) {
                                                        if (buffer[2] != '-' || buffer[1] != '-') continue;
                                                        inDTDComment = false;
                                                    }
                                                    if (c == '>') {
                                                        if (inComment) {
                                                            if (buffer[3] == '-' || buffer[2] != '-' || buffer[1] != '-') continue;
                                                            inComment = false;
                                                            continue;
                                                        }
                                                        if (inSpecial && buffer[2] == ']' && buffer[1] == ']') {
                                                            inSpecial = false;
                                                            data = new StringBuilder();
                                                            continue;
                                                        }
                                                        if (!withinTag) {
                                                            throw new ValidationException((data.length() == 0 ? ValidationProblem.EXTRA_END_ERROR.getShortMessage() : ValidationProblem.MISSING_START_ERROR.getShortMessage()) + " at line " + currentLine);
                                                        }
                                                        withinTag = false;
                                                        this.parseNewTag(newTag.toString(), inSpecial != false ? data.toString() : null);
                                                        newTag = new StringBuilder();
                                                        if (inSpecial) continue;
                                                        data = new StringBuilder();
                                                        continue;
                                                    }
                                                    if (inComment || inDTDComment) continue;
                                                    if (c != '<') break block18;
                                                    if (withinTag) {
                                                        throw new ValidationException((newTag.length() == 0 ? ValidationProblem.EXTRA_START_ERROR.getShortMessage() : ValidationProblem.MISSING_END_ERROR.getShortMessage()) + " at line " + currentLine);
                                                    }
                                                    if (!inSpecial && data.length() > 0) {
                                                        data = new StringBuilder();
                                                    }
                                                    if ((first = (char)src.read()) == '\uffffffff' || first != '!') break block19;
                                                    second = (char)src.read();
                                                    if (second == '\uffffffff' || second != '[') break block20;
                                                    inSpecial = true;
                                                    for (j = 0; j < 4; ++j) {
                                                        buffer[j] = 65535;
                                                    }
                                                    ** GOTO lbl12
                                                }
                                                if (second == '\uffffffff' || second != '-') break block21;
                                                third = (char)src.read();
                                                if (third == '\uffffffff' || third != '-') break block22;
                                                fourth = (char)src.read();
                                                if (fourth == '\uffffffff' || fourth == '-') break block23;
                                                inComment = true;
                                                for (j = 0; j < 4; ++j) {
                                                    buffer[j] = 65535;
                                                }
                                                ** GOTO lbl12
                                            }
                                            src.unread(fourth);
                                            src.unread(third);
                                            src.unread(second);
                                            src.unread(first);
                                            withinTag = true;
                                            continue;
                                        }
                                        src.unread(third);
                                        src.unread(second);
                                        src.unread(first);
                                        withinTag = true;
                                        continue;
                                    }
                                    src.unread(second);
                                    src.unread(first);
                                    withinTag = true;
                                    continue;
                                }
                                src.unread(first);
                                withinTag = true;
                                continue;
                            }
                            if (!withinTag) break block24;
                            if (c != '-') break block25;
                            first = (char)src.read();
                            if (first == '\uffffffff' || first != '-') break block26;
                            inDTDComment = true;
                            for (j = 0; j < 4; ++j) {
                                buffer[j] = 65535;
                            }
                            ** GOTO lbl12
                        }
                        src.unread(first);
                        newTag.append(c);
                        continue;
                    }
                    newTag.append(c);
                    continue;
                }
                data.append(c);
            }
            if (withinTag) {
                throw new ValidationException((newTag.length() == 0 ? ValidationProblem.EXTRA_START_ERROR.getShortMessage() : ValidationProblem.MISSING_END_ERROR.getShortMessage()) + " at line " + currentLine);
            }
            var19_19 = null;
            ** if (src == null) goto lbl-1000
        }
        catch (Throwable var18_21) {
            var19_20 = null;
            if (src != null) {
                src.close();
            }
            source.close();
            throw var18_21;
        }
lbl-1000:
        // 1 sources

        {
            src.close();
        }
lbl-1000:
        // 2 sources

        {
        }
        source.close();
        element = new Element("!doctype", this.xml != false ? "EMPTY" : "- O EMPTY");
        this.elements.put("!doctype", element);
        element = new Element("#pcdata", this.xml != false ? "EMPTY" : "- O EMPTY");
        this.elements.put("#pcdata", element);
    }

    private void parseNewTag(String text, String data) throws Exception {
        int index;
        text = Tag.trimWhitespace(text);
        if (data != null) {
            index = data.indexOf(37);
            int index2 = data.indexOf(59);
            if (index2 == -1) {
                index2 = data.indexOf(32, index);
            }
            if (index != -1 && index2 != -1) {
                String conditional = data.substring(index, index2 + 1);
                if (!"include".equals(conditional = this.replaceEntities(conditional).toLowerCase(Locale.ENGLISH).trim())) {
                    return;
                }
            }
        }
        if (text.startsWith("!ENTITY ")) {
            index = text.indexOf("PUBLIC");
            if (index != -1) {
                this.loadCharEntities(text);
            } else {
                this.addEntity(text);
            }
        } else if (text.toUpperCase(Locale.ENGLISH).startsWith("!ELEMENT ")) {
            text = this.replaceEntities(text).toLowerCase(Locale.ENGLISH);
            GeneralUtils.LOGGER.fine(text);
            StringTokenizer st = new StringTokenizer(text, " ");
            st.nextToken();
            String name = st.nextToken();
            if (name.charAt(0) == '(') {
                int index2 = text.indexOf(40);
                int index22 = text.indexOf(41) + 1;
                name = text.substring(index2, index22);
                String value = text.substring(index22).trim();
                st = new StringTokenizer(name, "(|)");
                while (st.hasMoreTokens()) {
                    name = st.nextToken().trim();
                    if (this.elements.containsKey(name)) continue;
                    Element element = new Element(name, value);
                    this.elements.put(name, element);
                    if (!this.xml) continue;
                    this.xml = element.isXml();
                }
            } else if (!this.elements.containsKey(name)) {
                int index3 = text.indexOf(" " + name + " ") + name.length() + 1;
                String value = text.substring(index3).trim();
                Element element = new Element(name, value);
                this.elements.put(name, element);
                if (this.xml) {
                    this.xml = element.isXml();
                }
            }
        } else if (text.toUpperCase(Locale.ENGLISH).startsWith("!ATTLIST ")) {
            text = this.replaceEntities(text).toLowerCase(Locale.ENGLISH);
            StringTokenizer st = new StringTokenizer(text, " ");
            st.nextToken();
            String name = st.nextToken();
            if (name.charAt(0) == '(') {
                int index4 = text.indexOf(40);
                int index2 = text.indexOf(41) + 1;
                name = text.substring(index4, index2);
                String value = text.substring(index2).trim();
                Attribute attr = new Attribute(value);
                st = new StringTokenizer(name, "(|)");
                while (st.hasMoreTokens()) {
                    name = st.nextToken().trim();
                    Element e = this.elements.get(name);
                    if (e.getAttr() != null) continue;
                    e.setAttr(attr);
                }
            } else {
                int index5 = text.indexOf(" " + name + " ") + name.length() + 1;
                String value = text.substring(index5).trim();
                Attribute attr = new Attribute(value);
                Element e = this.elements.get(name);
                if (e == null) {
                    GeneralUtils.LOGGER.severe(name);
                }
                if (e.getAttr() == null) {
                    e.setAttr(attr);
                }
            }
        } else {
            GeneralUtils.LOGGER.severe(text);
        }
    }

    private void addEntity(String text) throws ValidationException {
        StringTokenizer st = new StringTokenizer(text, " ");
        st.nextToken();
        String type = st.nextToken();
        if ("%".equals(type)) {
            String name = st.nextToken();
            if (this.entities.containsKey(name)) {
                return;
            }
            int index = text.indexOf(34) + 1;
            int index2 = text.lastIndexOf(34);
            String value = text.substring(index, index2);
            value = this.replaceEntities(value);
            this.entities.put(name, value);
            GeneralUtils.LOGGER.fine("Entity: " + name + "=" + value);
        } else {
            String name = type;
            String value = st.nextToken();
            if ("CDATA".equals(value)) {
                value = st.nextToken();
            }
            value = value.substring(1, value.length() - 1);
            this.encoder.addCharEntityRef(name, value);
        }
    }

    private String replaceEntities(String value) throws ValidationException {
        int index = -1;
        int index2 = -1;
        while ((index = value.indexOf(37)) != -1) {
            String entity = "";
            int skip = 0;
            index2 = value.indexOf(124, index);
            int index3 = value.indexOf(32, index);
            if (index3 != -1 && (index2 == -1 || index2 > index3)) {
                index2 = index3;
            }
            if ((index3 = value.indexOf(41, index)) != -1 && (index2 == -1 || index2 > index3)) {
                index2 = index3;
            }
            if ((index3 = value.indexOf(62, index)) != -1 && (index2 == -1 || index2 > index3)) {
                index2 = index3;
            }
            if ((index3 = value.indexOf(59, index)) != -1 && (index2 == -1 || index2 > index3) && (index2 = index3) != -1) {
                skip = 1;
            }
            if (index2 != -1) {
                entity = value.substring(index + 1, index2);
                index2 += skip;
            } else {
                entity = value.substring(index + 1);
            }
            if (!this.entities.containsKey(entity)) {
                throw new ValidationException("Missing entity reference: " + entity + " in " + value);
            }
            if ((entity = this.entities.get(entity)).trim().length() != 0) {
                value = value.substring(0, index) + entity + (index2 != -1 ? value.substring(index2) : "");
                continue;
            }
            value = value.substring(0, index).trim() + (index2 != -1 ? value.substring(index2) : "");
        }
        return value;
    }

    public EntityEncoder getEncoder() {
        return this.encoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadCharEntities(String text) throws Exception {
        StringTokenizer st = new StringTokenizer(text, "\"");
        st.nextToken();
        st.nextToken();
        st.nextToken();
        String fileName = st.nextToken();
        if (text.indexOf("DTD") != -1) {
            File dtdFile = new File(this.directory + fileName);
            this.parseFile(new FileInputStream(dtdFile));
            return;
        }
        File entityFile = new File(this.directory + fileName);
        BufferedReader br = new BufferedReader(new FileReader(entityFile));
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                if (!(line = line.trim()).startsWith("<!ENTITY ")) continue;
                st = new StringTokenizer(line, " \"");
                st.nextToken();
                String name = st.nextToken().trim();
                if ("%".equals(name)) continue;
                String value = st.nextToken().trim();
                if ("CDATA".equals(value)) {
                    value = st.nextToken().trim();
                }
                this.encoder.addCharEntityRef(name, value);
            }
            Object var10_10 = null;
            if (br == null) return;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (br == null) throw throwable;
            br.close();
            throw throwable;
        }
        br.close();
    }

    public Map<String, Element> getElements() {
        return this.elements;
    }

    public boolean isXml() {
        return this.xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getType(File dtdFile) throws Exception {
        this.directory = dtdFile.getParentFile().getAbsolutePath() + "/";
        this.dtdName = dtdFile.getName();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(this.directory + "Catalog.cat"));
            String line = "";
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("PUBLIC")) continue;
                StringTokenizer st = new StringTokenizer(line, "\"");
                st.nextToken();
                this.docType = st.nextToken().trim();
                String tmp = st.nextToken().trim();
                if (tmp.length() == 0) {
                    tmp = st.nextToken();
                }
                if (!this.dtdName.equals(tmp)) continue;
                break;
            }
            Object var7_6 = null;
            if (br == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (br == null) throw throwable;
            br.close();
            throw throwable;
        }
        br.close();
    }

    public String getOrigDocType() {
        return this.docType;
    }

    public boolean isBestFit() {
        return this.bestFit;
    }

    private void setBestFit(boolean bestFit) {
        this.bestFit = bestFit;
    }

    public static synchronized DTDParser getParser(InputStream dtd, String dtdName) throws ValidationException {
        DTDParser parser = DTDCache.get(dtdName);
        if (parser == null) {
            parser = DTDParser.deserialise(dtd, dtdName);
            DTDCache.put(dtdName, parser);
        }
        return parser;
    }
}

