/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.reports;

import com.totalvalidator.exceptions.ValidationException;
import com.totalvalidator.snapshot.Snapshot;
import com.totalvalidator.utils.BuildVersion;
import com.totalvalidator.utils.FileUtils;
import com.totalvalidator.utils.GeneralUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainReportPage {
    public static final String HEADER1 = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en-GB\" lang=\"en-GB\">\n<head>\n\t<meta http-equiv=\"content-type\" content=\"application/xhtml+xml; charset=UTF-8\" />\n\t<link rel=\"shortcut icon\" href=\"http://www.totalvalidator.com/favicon.ico\" type=\"image/x-icon\" />\n\t<title>Total Validator Results</title>\n\t<meta name=\"author\" content=\"Total Validator\" />\n\t<link rel=\"stylesheet\" href=\"";
    public static final String HEADER21 = "images/mainstyle.css\" />\n</head>\n<body>\n<div class=\"main\">\n<div class=\"pagehead\">\n<h1><img src=\"";
    public static final String HEADER22 = "images/tvheader2.gif\" alt=\"Total Validator\"/><br/>HTML / XHTML / WCAG / Section 508 / Links / Spelling</h1></div><div class=\"topnavbar\"><map id=\"navbar\" title=\"Navigation Bar\"><p><a href=\"http://www.totalvalidator.com/index.html\">Home</a> | <a href=\"http://www.totalvalidator.com/tools/index.html\">Tools</a> | <a href=\"http://www.totalvalidator.com/downloads/index.html\">Downloads</a> | <a href=\"http://www.totalvalidator.com/purchases/index.html\">Purchases</a> | <a href=\"http://www.totalvalidator.com/support/index.html\">Support</a> | <a href=\"http://www.totalvalidator.com/home/sitemap.html\">Site Map</a></p></map></div>";
    public static final String HEADER32 = "images/tvheader2.gif\" alt=\"Total Validator\"/><br/>HTML / XHTML / WCAG / Section 508 / Links / Spelling</h1></div><div class=\"topnavbar\"><map id=\"navbar\" title=\"Navigation Bar\"><p><a href=\"";
    public static final String HEADER4 = "help/help.html\">Help</a> | <a href=\"http://www.totalvalidator.com/index.html\">Website</a> | <a href=\"http://www.totalvalidator.com/validator/FeedbackForm\">Feedback</a></p></map></div>";
    public static final String HEADER5 = "http://www.totalvalidator.com/support/extension.html\">Help</a> | <a href=\"http://www.totalvalidator.com/index.html\">Website</a> | <a href=\"http://www.totalvalidator.com/validator/FeedbackForm\">Feedback</a></p></map></div>";
    public static final String FOOTER = "<div class=\"footer\">\n<p class=\"footer\">Copyright 2011 Total Validator.\nAll rights reserved.</p>\n</div>\n</div>\n</body>\n</html>";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss z, MMMM dd, yyyy", Locale.UK);
    private static final String UP_LINK = "<p><a href=\"#\"><img src=\"images/up.gif\" alt=\"\"/> top</a></p>\n";
    private static final String CANCELLED = "<p><span class=\"strong\">The validation was cancelled at this point</span></p>\n";
    private static final String END_ROW = "</td></tr>";
    private static final String CLICK_ON_LINKS = "<p>Click on any image(s)/link(s) below to view the results.<br/>For pages that validate you can <a href='http://www.totalvalidator.com/support/logos.html'>display a logo.</a></p>\n";
    private static final String NO_PROBLEMS = "<p><span class=\"success\"><img src=\"images/ln_validated.gif\" alt=\"Success: No problems found\"/></span></p><p>For websites that validate you can <a href='http://www.totalvalidator.com/support/logos.html'>display an appropriate logo.</a></p>";
    private long startTime;
    private String problemSummary;
    private String folder;
    private String outputFile;
    private StringBuilder pages = new StringBuilder();
    private String page;
    private String subPage;
    private String summaryPage;
    private boolean servlet;

    public MainReportPage(String page, String folder, String outputFile, boolean servlet) {
        this.outputFile = outputFile;
        this.servlet = servlet;
        this.summaryPage = "../";
        int index = outputFile.lastIndexOf(92);
        this.summaryPage = index == -1 ? ((index = outputFile.lastIndexOf(47)) == -1 ? this.summaryPage + outputFile : this.summaryPage + outputFile.substring(index + 1)) : this.summaryPage + outputFile.substring(index + 1);
        this.folder = folder;
        this.page = page;
        this.startTime = System.currentTimeMillis();
    }

    public List<String> close(int linksTested, int pageCount, int totalErrors, int totalWarnings, List<String> options, String[] snapshots, boolean cancelled, boolean extension) throws ValidationException {
        StringBuilder output = new StringBuilder();
        output.append(HEADER1);
        if (this.servlet) {
            output.append(HEADER21);
            output.append(HEADER22);
        } else {
            output.append(HEADER21);
            output.append(HEADER32);
            if (extension) {
                output.append(HEADER5);
            } else {
                try {
                    output.append(FileUtils.getAbsoluteInstallFolder().toURI().toURL());
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
                output.append(HEADER4);
            }
        }
        output.append("\n<h2>Summary</h2>\n");
        output.append(this.getSummary(linksTested, pageCount, totalErrors + "", totalWarnings, totalWarnings + "", options, null));
        output.append(UP_LINK);
        output.append("\n<h2>Validation results</h2>\n");
        output.append(this.pages.length() == 0 ? NO_PROBLEMS : CLICK_ON_LINKS + this.pages.toString()).append("\n");
        if (cancelled) {
            output.append(CANCELLED);
        }
        output.append(UP_LINK);
        List<String> failedList = Snapshot.printSnapshots(snapshots, output, this.folder, UP_LINK);
        output.append(FOOTER);
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), "UTF-8")));
        }
        catch (IOException e) {
            throw new ValidationException(e);
        }
        pw.print(output.toString());
        pw.flush();
        pw.close();
        pw = null;
        return failedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSummary(int linksTested, int pageCount, String totalErrorsMessage, int totalWarnings, String totalWarningsMessage, List<String> options, String docType) {
        StringBuilder summary = new StringBuilder();
        summary.append("<table summary=\"Summary of tests\">");
        String pageLink = "Uploaded Page".equals(this.page) ? this.page : "<a title=\"The starting page\" href=\"" + this.page + "\">" + this.page + "</a>";
        summary.append("\n<tr><td class=\"nowrapl\">Starting page:</td><td colspan=\"3\">").append(pageLink).append(END_ROW);
        summary.append("\n<tr><td class=\"nowrapl\">Started at:</td><td colspan=\"3\">");
        MainReportPage mainReportPage = this;
        synchronized (mainReportPage) {
            summary.append(sdf.format(new Date(this.startTime)));
        }
        summary.append(END_ROW);
        String timeTaken = this.getDuration();
        summary.append("\n<tr><td class=\"nowrapl\">Time taken:</td><td class=\"rhs\">").append(timeTaken).append(END_ROW);
        summary.append("\n<tr><td class=\"nowrapl\">Validator Version:</td><td class=\"rhs\">v").append(BuildVersion.getBuildVersion()).append(END_ROW);
        if (pageCount > 0) {
            summary.append("\n<tr><td class=\"nowrapl\">Total pages checked:</td><td class=\"rhs\">").append(pageCount).append(END_ROW);
        }
        if (linksTested > 0) {
            summary.append("\n<tr><td class=\"nowrapl\">Total links checked:</td><td class=\"rhs\">").append(linksTested).append(END_ROW);
        }
        summary.append("\n<tr><td class=\"nowrapl\">Total errors found:</td><td class=\"rhs\">").append(totalErrorsMessage).append(END_ROW);
        if (totalWarnings > 0) {
            summary.append("\n<tr><td class=\"nowrapl\">Total warnings found:</td><td class=\"rhs\">").append(totalWarningsMessage).append(END_ROW);
        }
        if (docType != null) {
            summary.append("\n<tr><td class=\"nowrapl\">(X)HTML used for this page:</td><td class=\"rhs\">").append(docType).append(END_ROW);
        }
        summary.append("\n</table>");
        summary.append("\n<p><span class=\"strong\">Options:</span></p><ul>");
        for (String option : options) {
            summary.append("<li>").append(option).append("</li>\n");
        }
        summary.append("</ul>\n");
        return summary.toString();
    }

    public String getDuration() {
        long duration = (System.currentTimeMillis() - this.startTime) / 1000L;
        String timeTaken = duration + " seconds";
        if (duration >= 120L) {
            timeTaken = duration / 60L + " minutes";
        }
        return timeTaken;
    }

    public void setPageDetails(String subPage, String problemSummary) {
        this.problemSummary = problemSummary;
        this.subPage = subPage;
    }

    public void reportPage(String outputPage) {
        this.pages.append("<p><span class=\"strong\">").append(this.subPage).append("<br/>\n");
        if (outputPage != null) {
            this.pages.append("<a href='").append(this.folder).append("/").append(outputPage).append("'>").append(this.problemSummary).append("</a></span></p>\n");
        } else {
            this.pages.append(this.problemSummary).append("</span></p>\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getReport() {
        String report = null;
        BufferedReader br = null;
        File results = new File(this.outputFile);
        br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(results), "UTF-8"));
        char[] chars = new char[(int)results.length()];
        br.read(chars);
        report = new String(chars);
        Object var6_6 = null;
        if (br == null) return report;
        try {
            br.close();
            br = null;
            return report;
        }
        catch (IOException e1) {}
        return report;
        {
            catch (Exception e) {
                GeneralUtils.LOGGER.log(Level.SEVERE, "Couldn't get main report", e);
                Object var6_7 = null;
                if (br == null) return report;
                try {
                    br.close();
                    br = null;
                    return report;
                }
                catch (IOException e1) {}
                return report;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (br == null) throw throwable;
            try {
                br.close();
                br = null;
                throw throwable;
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public String getSummaryPage() {
        return this.summaryPage;
    }

    static {
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

