/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.validations.http;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Form {
    private static final String EQUALS = "=";
    private boolean post;
    private byte[] bytes;
    private String queryParams;

    public Form(Map<String, List<String>> nvPairs, boolean post) {
        this.post = post;
        boolean firstOne = true;
        StringBuilder sb = new StringBuilder();
        for (String name : nvPairs.keySet()) {
            if (firstOne) {
                firstOne = false;
            } else {
                sb.append('&');
            }
            List<String> values = nvPairs.get(name);
            for (String value : values) {
                sb.append(this.encodeURIComponent(name)).append(EQUALS).append(this.encodeURIComponent(value));
            }
        }
        this.queryParams = sb.toString();
        if (post) {
            this.bytes = this.queryParams.getBytes();
        }
    }

    private String encodeURIComponent(String theString) {
        try {
            return URLEncoder.encode(theString, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return theString;
        }
    }

    public boolean isPost() {
        return this.post;
    }

    public int getLength() {
        return this.bytes.length;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getQueryParams() {
        return this.queryParams;
    }
}

