/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.data.content;

import java.awt.Dimension;
import java.io.File;
import org.xissweb.file.FileHelper;
import org.xissweb.image.ImageData;

public class ImageDescInfo {
    private String extension;
    private int width;
    private int height;

    public ImageDescInfo() {
    }

    public Object clone() {
        return new ImageDescInfo(this.extension, this.width, this.height);
    }

    public ImageDescInfo(File imageFile, Dimension dim) {
        this.updateFromImageFile(imageFile, dim);
    }

    public ImageDescInfo(ImageData imageData) {
        this.updateFromImageFile(imageData);
    }

    private ImageDescInfo(String extension, int width, int height) {
        this.extension = extension;
        this.width = width;
        this.height = height;
    }

    public void updateFromImageFile(ImageData imageData) {
        this.setExtension(imageData.getExtension());
        this.setWidth(imageData.getWidth());
        this.setHeight(imageData.getHeight());
    }

    public void updateFromImageFile(File imageFile, Dimension dim) {
        this.setExtension(FileHelper.fileNameExtention(imageFile));
        this.setWidth(dim.width);
        this.setHeight(dim.height);
    }

    public boolean equals(Object arg0) {
        boolean result = false;
        if (arg0 != null && arg0 instanceof ImageDescInfo) {
            ImageDescInfo desc = (ImageDescInfo)arg0;
            result = this.getExtension().equals(desc.getExtension()) && this.getWidth() == desc.getWidth() && this.getHeight() == desc.getHeight();
        }
        return result;
    }

    public ImageDescInfo cloneDesc() {
        return new ImageDescInfo(this.extension, this.width, this.height);
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extention) {
        this.extension = extention;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

