/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.data.content;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.xissweb.data.content.ContentInfoIdentifiable;
import org.xissweb.data.content.ImageInfo;

public class SectionInfo
implements ContentInfoIdentifiable {
    private static final String ANONYMOUS_SECTION = "anonymous.section";
    private String title = "";
    private ArrayList images = new ArrayList();

    public Object clone() {
        SectionInfo section = new SectionInfo();
        section.title = this.title;
        Iterator i = this.images.iterator();
        while (i.hasNext()) {
            section.images.add(((ImageInfo)i.next()).clone());
        }
        return section;
    }

    public Object getIdentifier() {
        if (this.title.length() > 0) {
            return this.title;
        }
        if (!this.images.isEmpty()) {
            return ((ContentInfoIdentifiable)this.images.get(0)).getIdentifier();
        }
        return ANONYMOUS_SECTION;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List getImages() {
        return this.images;
    }

    public void setImages(List list) {
        this.images.clear();
        this.images.addAll(list);
    }

    public void addImage(ImageInfo image) {
        this.images.add(image);
    }

    public ImageInfo getImageInfoByName(String name) {
        ImageInfo image = null;
        Iterator i = this.images.iterator();
        while (i.hasNext() && image == null) {
            ImageInfo img = (ImageInfo)i.next();
            if (!img.getFileName().equals(name)) continue;
            image = img;
        }
        return image;
    }

    public int maxNumber() {
        int max = 0;
        if (this.images != null && this.images.size() > 0) {
            max = ((ImageInfo)this.images.get(this.images.size() - 1)).getNumber();
        }
        return max;
    }

    public boolean removeUnexistingImages() {
        boolean removed = false;
        for (int i = this.images.size() - 1; i >= 0; --i) {
            ImageInfo image = (ImageInfo)this.images.get(i);
            if (image.isImageExists()) continue;
            this.images.remove(i);
            removed = true;
        }
        return removed;
    }

    public int countImages(int msgNum) {
        int count = msgNum;
        Iterator i = this.images.iterator();
        while (i.hasNext()) {
            ((ImageInfo)i.next()).setNumber(count++);
        }
        return count;
    }

    public String toString() {
        return this.title.length() == 0 ? ResourceBundle.getBundle(this.getClass().getName()).getString(ANONYMOUS_SECTION) : this.title;
    }
}

