/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.data.layout;

import org.xissweb.data.imetadata.ImageMetadataHelper;
import org.xissweb.data.imetadata.ImageMetadataSchema;
import org.xissweb.data.layout.Arrangeable;
import org.xissweb.data.layout.LocalIndexInfo;
import org.xissweb.data.layout.LocationOnMapInfo;

public class ImageAreaInfo
implements Arrangeable,
ImageMetadataSchema {
    public static final String COMMENT_BOTTOM = "bottom";
    public static final String COMMENT_TOP = "top";
    public static final String META_DATA_NONE = "none";
    public static final String META_DATA_BOTTOM = "bottom";
    public static final String META_DATA_TOP = "top";
    public static final int gpsKeyCount = 3;
    public static final String DEFAULT_NUMBER_FORMAT = "@#/%+";
    public static final int DEFAULT_SIZE = 500;
    private int width;
    private int height;
    private String commentPosition;
    private String numberFormat;
    private LocalIndexInfo localIndexInfo;
    private LocationOnMapInfo locationOnMap = null;
    private Object[] metadatas = new Object[ImageMetadataHelper.imageTypeCount()];
    private String metaDataPosition;

    public ImageAreaInfo() {
        for (int i = 0; i < this.metadatas.length; ++i) {
            this.metadatas[i] = new boolean[ImageMetadataHelper.imageMetaDataKeyCount(i) - 3];
        }
    }

    public Object clone() {
        ImageAreaInfo iArea = new ImageAreaInfo();
        iArea.setWidth(this.getWidth());
        iArea.setHeight(this.getHeight());
        iArea.setCommentPosition(this.getCommentPosition());
        iArea.setNumberFormat(this.getNumberFormat());
        for (int i = 0; i < this.metadatas.length; ++i) {
            boolean[] md = new boolean[this.getMetadata(i).length];
            for (int j = 0; j < md.length; ++j) {
                md[j] = this.getMetadata(i)[j];
            }
            iArea.setMetadata(md, i);
        }
        iArea.setMetaDataPosition(this.getMetaDataPosition());
        if (this.hasLocalIndex()) {
            iArea.setLocalIndexInfo((LocalIndexInfo)this.localIndexInfo.clone());
        }
        if (this.locationOnMap != null) {
            iArea.locationOnMap = (LocationOnMapInfo)this.locationOnMap.clone();
        }
        return iArea;
    }

    public boolean hasWidth() {
        return true;
    }

    public String toString() {
        return this.width + "x" + this.height + ", " + this.commentPosition + ", format \"" + this.numberFormat + '\"';
    }

    public boolean hasImageLocationOnMap() {
        return this.locationOnMap != null;
    }

    public LocationOnMapInfo getLocationOnMap() {
        return this.locationOnMap;
    }

    public void setLocationOnMap(LocationOnMapInfo locationOnMap) {
        this.locationOnMap = locationOnMap;
    }

    public boolean hasMetaData(int imageType) {
        return this.metadatas[imageType] != null;
    }

    public boolean[] getMetadata(int imageType) {
        return (boolean[])this.metadatas[imageType];
    }

    public void setMetadata(boolean[] metadata, int imageType) {
        this.metadatas[imageType] = metadata;
    }

    public String getMetaDataPosition() {
        if (this.metaDataPosition == null) {
            this.metaDataPosition = "bottom";
        }
        return this.metaDataPosition;
    }

    public void setMetaDataPosition(String metaDataPosition) {
        this.metaDataPosition = metaDataPosition;
    }

    public String getCommentPosition() {
        return this.commentPosition;
    }

    public void setCommentPosition(String commentPosition) {
        this.commentPosition = commentPosition;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(String numberFormat) {
        this.numberFormat = numberFormat;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean hasLocalIndex() {
        return this.localIndexInfo != null;
    }

    public LocalIndexInfo getLocalIndexInfo() {
        return this.localIndexInfo;
    }

    public void setLocalIndexInfo(LocalIndexInfo localIndexInfo) {
        this.localIndexInfo = localIndexInfo;
    }
}

