/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.data.layout;

import java.awt.Dimension;

public class ThumbnailsInfoInfo {
    public static final String UNIT_PIXEL = "px";
    public static final String UNIT_PERCENT = "%";
    public static final String SHAPE_RECTANGLE = "rectangle";
    public static final String SHAPE_SQUARE = "square";
    public static final String QUALITY_LOW = "low";
    public static final String QUALITY_HIGH = "high";
    private int size;
    private String unit;
    private String shape;
    private String quality;

    public String toString() {
        return this.size + this.unit + " " + this.shape + " " + this.quality;
    }

    public String getQuality() {
        return this.quality;
    }

    public void setQuality(String quality) {
        this.quality = quality;
    }

    public String getShape() {
        return this.shape;
    }

    public void setShape(String shape) {
        this.shape = shape;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public final Dimension thumbnailSize(int w, int h) {
        int originW = w;
        int originH = h;
        int size = this.getSize();
        int maxDim = Math.max(originW, originH);
        float factor = 1.0f;
        if (this.getShape().equals(SHAPE_SQUARE)) {
            originW = maxDim;
            originH = maxDim;
        }
        factor = this.getUnit().equals(UNIT_PIXEL) ? (float)size * 1.0f / (float)maxDim : (float)size / 100.0f;
        int width = (int)((float)originW * factor);
        int height = (int)((float)originH * factor);
        return new Dimension(width, height);
    }
}

