/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.build;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.xissweb.data.content.ImageInfo;
import org.xissweb.data.content.SlideShowContentInfo;
import org.xissweb.data.content.xml.ContentDeserializer;
import org.xissweb.file.FileHelper;
import org.xissweb.gui.Main;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.build.SwingBuilder;
import org.xissweb.gui.prefs.ConfigurableEditable;
import org.xissweb.gui.prefs.PreferencesEditionManager;
import org.xissweb.gui.prefs.data.PreferenceInfo;
import org.xissweb.gui.util.ActiveLabel;
import org.xissweb.gui.util.ImageFileCounter;
import org.xissweb.gui.worker.ProcessLauncher;
import org.xissweb.gui.worker.SwingWorker;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.prefs.ui.ComponentConfigurator;
import org.xissweb.produce.DirectoryActionEvent;
import org.xissweb.produce.SlideShowDirectory;
import org.xissweb.produce.build.BuildEventListener;
import org.xissweb.produce.build.Builder;
import org.xissweb.project.SlideShowProject;

public class BuildLauncher
extends JDialog
implements ProcessLauncher,
ConfigurableEditable,
BuildEventListener {
    private static final long serialVersionUID = 735482164069865935L;
    private static final String PREFS_ID = "org.xissweb.gui.build.BuildLauncher";
    private static final String PAUSE_ICON = "/images/common/pause.png";
    private static final String RESTART_ICON = "/images/common/restart.png";
    private static final String STOP_ICON = "/images/common/stop.png";
    private static final String CLOSE_WHEN_DONE = "close.when.done";
    private SlideShowProject project;
    private Set selectedDirs = null;
    private File baseDir;
    private File destDir;
    private File repository;
    ContentDeserializer contentDeserializer = new ContentDeserializer();
    private SwingBuilder swingBuilder;
    private Builder builder;
    private TextDisplayer textDisplayer = new TextDisplayer(class$org$xissweb$gui$build$BuildLauncher == null ? (class$org$xissweb$gui$build$BuildLauncher = BuildLauncher.class$("org.xissweb.gui.build.BuildLauncher")) : class$org$xissweb$gui$build$BuildLauncher);
    private int dirCountProgress;
    private int buidCountProgress;
    private int nbVisitedDirs;
    private int nbCreatedThumbnails;
    private int nbUpdatedContentFiles;
    private int nbCreatedIndexPages;
    private int nbCreatedImagePages;
    private int nbCopiedSkins;
    private JPanel jContentPane = null;
    private JPanel headerPanel = null;
    private JPanel footerPanel = null;
    private JPanel mainPanel = null;
    private JProgressBar buildProgress = null;
    private JTextArea infoTextArea = null;
    private JScrollPane jScrollPane = null;
    private JButton closeButton = null;
    private JProgressBar directoryProgress = null;
    private JLabel buildTextLabel = null;
    private JLabel srcDirLabel = null;
    private JCheckBox closeWhenDoneCheckBox = null;
    private ActiveLabel stopButton = null;
    private ActiveLabel pauseRestartButton = null;
    private JPanel controlPanel = null;
    static /* synthetic */ Class class$org$xissweb$gui$build$BuildLauncher;

    public BuildLauncher(Frame parent) {
        super(parent, "", true);
        this.initialize();
        this.builder = new Builder();
        this.builder.addListener(this);
        this.builder.addListener(Main.get().getXissWeb().getFileManager());
        this.buildProgress.setIndeterminate(false);
        this.closeButton.setEnabled(true);
        this.applyPreferences();
    }

    private void applyPreferences() {
        ComponentConfigurator.configure((Component)this);
        PreferenceInfo pInfo = PreferencesEditionManager.get().getPreferenceInfo(CLOSE_WHEN_DONE, PREFS_ID);
        boolean close = pInfo.getDefaultValue().equals("true");
        this.closeWhenDoneCheckBox.setSelected(Main.preferences.getBoolean(CLOSE_WHEN_DONE, PREFS_ID, close));
        PreferencesEditionManager.get().registerConfigurable(this);
    }

    public void prefrerenceEdited(PreferenceInfo prefInfo, Object value) {
        if (prefInfo.getKey().equals(CLOSE_WHEN_DONE)) {
            this.closeWhenDoneCheckBox.setSelected((Boolean)value);
            this.storeClosePreference();
        }
    }

    public String getDefaultValue(PreferenceInfo prefInfo) {
        return null;
    }

    void storeClosePreference() {
        Main.preferences.putBoolean(CLOSE_WHEN_DONE, PREFS_ID, this.closeWhenDoneCheckBox.isSelected());
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setTitle(ResourceBundle.getBundle(this.getClass().getName()).getString("title"));
        this.setBounds(new Rectangle(0, 0, 470, 380));
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getHeaderPanel(), "North");
            this.jContentPane.add((Component)this.getFooterPanel(), "South");
            this.jContentPane.add((Component)this.getMainPanel(), "Center");
        }
        return this.jContentPane;
    }

    public void visitingInDirectory(DirectoryActionEvent event) {
        if (event.isSelected()) {
            ++this.nbVisitedDirs;
            ++this.dirCountProgress;
            this.directoryProgress.setValue(this.dirCountProgress);
            this.buidCountProgress = 0;
            this.buildProgress.setValue(0);
            File dir = event.getDirectory();
            File slideshowFile = new File(dir, this.project.getProperties().getSlideshowContentFileName());
            if (slideshowFile.exists()) {
                SlideShowContentInfo contentInfo = this.contentDeserializer.deserialize(slideshowFile);
                File imgDir = SlideShowDirectory.imageDirectory(dir, this.project.getProperties());
                int nbImages = 0;
                Iterator i = contentInfo.imageIterator();
                while (i.hasNext()) {
                    ImageInfo iInfo = (ImageInfo)i.next();
                    File imgDestDir = FileHelper.fileInTargetDir(this.baseDir, imgDir, this.destDir);
                    File iFile = new File(imgDestDir, iInfo.mainFileName());
                    ++nbImages;
                    if (this.repository == null) {
                        File oFile = new File(imgDir, iInfo.mainFileName());
                        if (!FileHelper.isOutOfSync(oFile, iFile)) continue;
                        ++nbImages;
                        continue;
                    }
                    File imgRepository = FileHelper.fileInTargetDir(this.baseDir, imgDir, this.repository);
                    File oFile = new File(imgRepository, iInfo.originalFileName());
                    if (!FileHelper.isOutOfSync(oFile, iFile)) continue;
                    nbImages += 2;
                }
                this.buildProgress.setMaximum(nbImages);
            }
            StringBuffer buff = new StringBuffer();
            String path = FileHelper.relativePath(this.project.getLocation(), dir);
            int index = path.lastIndexOf(File.separatorChar);
            for (int i = 0; i < index; ++i) {
                buff.append(' ');
            }
            buff.append(dir.getName()).append(' ');
            this.addInfo(buff.toString());
        }
    }

    public void inDirectoryVisited(DirectoryActionEvent event) {
        if (event.isSelected()) {
            ++this.dirCountProgress;
            this.directoryProgress.setValue(this.dirCountProgress);
            this.addInfo("\n");
        }
    }

    public void writingSlideshowContent(DirectoryActionEvent event) {
        ++this.nbUpdatedContentFiles;
    }

    public void generateIndexPage(DirectoryActionEvent event) {
        ++this.nbCreatedIndexPages;
        this.addInfo("i");
    }

    public void generateImagePage(DirectoryActionEvent event) {
        ++this.nbCreatedImagePages;
        ++this.buidCountProgress;
        this.buildProgress.setValue(this.buidCountProgress);
        this.addInfo(".");
    }

    public void copySkin(DirectoryActionEvent event) {
        ++this.nbCopiedSkins;
        this.addInfo("s(" + event.getDirectory().getName() + ")");
    }

    public void creatingThumbnail(DirectoryActionEvent event) {
        ++this.nbCreatedThumbnails;
        ++this.buidCountProgress;
        this.buildProgress.setValue(this.buidCountProgress);
        this.addInfo("+");
    }

    public void copyingImage(DirectoryActionEvent event) {
        this.addInfo("=");
    }

    public void resizingImage(DirectoryActionEvent event) {
        ++this.buidCountProgress;
        this.buildProgress.setValue(this.buidCountProgress);
        this.addInfo("o");
    }

    public void copyingContentDir(DirectoryActionEvent event) {
    }

    public void slideshowContentWroten(DirectoryActionEvent event) {
    }

    public void imageResized(DirectoryActionEvent event) {
    }

    public void outDirectoryVisited(DirectoryActionEvent event) {
    }

    public void visitingOutDirectory(DirectoryActionEvent event) {
    }

    private JPanel getHeaderPanel() {
        if (this.headerPanel == null) {
            this.srcDirLabel = new JLabel();
            this.srcDirLabel.setText("-");
            this.srcDirLabel.setFont(new Font("Arial", 1, 12));
            this.buildTextLabel = new JLabel();
            this.buildTextLabel.setText("-");
            this.buildTextLabel.setFont(new Font("Arial", 0, 12));
            this.textDisplayer.register(this.buildTextLabel, "build.text");
            this.headerPanel = new JPanel();
            this.headerPanel.add((Component)this.buildTextLabel, null);
            this.headerPanel.add((Component)this.srcDirLabel, null);
        }
        return this.headerPanel;
    }

    private JPanel getFooterPanel() {
        if (this.footerPanel == null) {
            GridBagConstraints closeCts = new GridBagConstraints();
            closeCts.insets = new Insets(5, 5, 5, 5);
            closeCts.gridx = 3;
            closeCts.gridy = 0;
            closeCts.weightx = 10.0;
            closeCts.anchor = 13;
            GridBagConstraints closeWenDoneCts = new GridBagConstraints();
            closeWenDoneCts.insets = new Insets(5, 5, 5, 5);
            closeWenDoneCts.anchor = 17;
            closeWenDoneCts.gridx = 0;
            closeWenDoneCts.gridy = 0;
            closeWenDoneCts.weightx = 10.0;
            closeWenDoneCts.insets = new Insets(5, 5, 5, 5);
            this.footerPanel = new JPanel();
            this.footerPanel.setLayout(new GridBagLayout());
            this.footerPanel.add((Component)this.getCloseWhenDoneCheckBox(), closeWenDoneCts);
            this.footerPanel.add((Component)this.getCloseButton(), closeCts);
        }
        return this.footerPanel;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 1;
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.weightx = 10.0;
            gridBagConstraints11.gridy = 3;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(5, 60, 5, 60);
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridwidth = 3;
            gridBagConstraints2.gridx = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(5, 60, 5, 60);
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridwidth = 3;
            gridBagConstraints1.gridx = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.insets = new Insets(5, 20, 5, 20);
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.setBorder(BorderFactory.createEtchedBorder(0));
            this.mainPanel.add((Component)this.getJScrollPane(), gridBagConstraints);
            this.mainPanel.add((Component)this.getJProgressBar2(), gridBagConstraints1);
            this.mainPanel.add((Component)this.getJProgressBar(), gridBagConstraints2);
            this.mainPanel.add((Component)this.getControlPanel(), gridBagConstraints11);
        }
        return this.mainPanel;
    }

    public void performStart() {
        ImageFileCounter counter = new ImageFileCounter();
        counter.count(this.project, this.project.getSrcDirectory(), this.selectedDirs);
        this.baseDir = this.project.getSrcDirectory();
        this.destDir = this.project.getBuildDirectory();
        if (!this.project.getProperties().isImportImage()) {
            this.repository = this.project.getRepositoryDirectory();
        }
        this.builder.setProject(this.project);
        this.builder.setSelection(this.selectedDirs);
        this.swingBuilder = new SwingBuilder();
        this.swingBuilder.setBuilder(this.builder);
        this.swingBuilder.setLauncher(this);
        this.closeButton.setEnabled(false);
        this.directoryProgress.setValue(0);
        this.nbVisitedDirs = 0;
        this.nbCreatedThumbnails = 0;
        this.nbUpdatedContentFiles = 0;
        this.nbCreatedIndexPages = 0;
        this.nbCreatedImagePages = 0;
        this.nbCopiedSkins = 0;
        this.dirCountProgress = 0;
        this.directoryProgress.setMaximum(counter.getDirectoryCount() * 2 + 1);
        this.buildProgress.setValue(0);
        this.swingBuilder.start();
        this.setInfo("");
    }

    private JProgressBar getJProgressBar() {
        if (this.buildProgress == null) {
            this.buildProgress = new JProgressBar();
            this.buildProgress.setPreferredSize(new Dimension(280, 14));
            this.buildProgress.setStringPainted(false);
            this.buildProgress.setIndeterminate(false);
        }
        return this.buildProgress;
    }

    public void openPrecessor(SlideShowProject project, Set selectedDirs) {
        this.project = project;
        this.selectedDirs = selectedDirs;
        StringBuffer buff = new StringBuffer();
        if (selectedDirs == null) {
            buff.append(project.getProperties().getSrcRootDir());
        } else {
            File srcDir = project.getSrcDirectory();
            Object[] dirs = selectedDirs.toArray(new File[selectedDirs.size()]);
            Arrays.sort(dirs);
            for (int i = 0; i < dirs.length; ++i) {
                Object f = dirs[i];
                buff.append(FileHelper.relativePath(srcDir, (File)f));
                if (i + 1 >= dirs.length) continue;
                buff.append(", ");
            }
        }
        this.setTitle(ResourceBundle.getBundle(this.getClass().getName()).getString("title") + " " + project.getLocation().getName());
        this.srcDirLabel.setText(buff.toString());
        this.buildProgress.setIndeterminate(false);
        this.textDisplayer.resetAllText();
        this.setPauseDisplay(true);
        this.getPauseRestartButton().setEnabled(true);
        this.getStopButton().setEnabled(true);
        this.performStart();
        this.setVisible(true);
    }

    public void performPauseRestart() {
        this.swingBuilder.interrupt(false);
        this.setPauseDisplay(!this.swingBuilder.isInPause());
    }

    private void setPauseDisplay(boolean val) {
        if (val) {
            this.getPauseRestartButton().setIcon(XissWebUI.getIcon(PAUSE_ICON));
            this.textDisplayer.registerToolTip(this.getPauseRestartButton(), "pause.button");
        } else {
            this.getPauseRestartButton().setIcon(XissWebUI.getIcon(RESTART_ICON));
            this.textDisplayer.registerToolTip(this.getPauseRestartButton(), "restart.button");
        }
    }

    public void performStop() {
        this.swingBuilder.interrupt(true);
    }

    public void processFinished(SwingWorker worker, long time, boolean complete) {
        ++this.dirCountProgress;
        this.directoryProgress.setValue(this.dirCountProgress);
        this.setPauseDisplay(true);
        this.pauseRestartButton.setEnabled(false);
        this.stopButton.setEnabled(false);
        this.closeButton.setEnabled(true);
        this.builder.stop();
        this.printStatistics(time);
        if (this.closeWhenDoneCheckBox.isSelected()) {
            this.setVisible(false);
        }
    }

    private void printStatistics(long time) {
        SimpleDateFormat df = new SimpleDateFormat("mm:ss.SSS");
        StringBuffer buff = new StringBuffer();
        buff.append("\n").append(ResourceBundle.getBundle(this.getClass().getName()).getString("message.build.done") + " " + df.format(new Date(time)) + '\n');
        buff.append("   ").append(this.nbVisitedDirs).append(" ").append(ResourceBundle.getBundle(this.getClass().getName()).getString("message.visited.directories") + '\n');
        buff.append("   ").append(this.nbCopiedSkins).append(" ").append(ResourceBundle.getBundle(this.getClass().getName()).getString("message.copied.skins") + '\n');
        buff.append("   ").append(this.nbCreatedThumbnails).append(" ").append(ResourceBundle.getBundle(this.getClass().getName()).getString("message.created.thumbnails") + '\n');
        buff.append("   ").append(this.nbUpdatedContentFiles).append(" ").append(ResourceBundle.getBundle(this.getClass().getName()).getString("message.updated.content.files") + '\n');
        buff.append("   ").append(this.nbCreatedIndexPages).append(" ").append(ResourceBundle.getBundle(this.getClass().getName()).getString("message.created.index.pages") + '\n');
        buff.append("   ").append(this.nbCreatedImagePages).append(" ").append(ResourceBundle.getBundle(this.getClass().getName()).getString("message.created.image.pages"));
        this.addInfo(buff.toString());
    }

    public void setInfo(String text) {
        this.infoTextArea.setText(text);
        this.scrollInfoToBottom();
    }

    public void addInfo(String text) {
        this.infoTextArea.append(text);
        this.scrollInfoToBottom();
    }

    private void scrollInfoToBottom() {
        Point pt = this.jScrollPane.getViewport().getViewPosition();
        pt.setLocation(pt.getX(), (double)Math.max(0, this.infoTextArea.getHeight() - this.jScrollPane.getViewport().getHeight()));
        this.jScrollPane.getViewport().setViewPosition(pt);
    }

    private JTextArea getJTextArea() {
        if (this.infoTextArea == null) {
            this.infoTextArea = new JTextArea();
            this.infoTextArea.setFont(new Font("Courier New", 0, 12));
            this.infoTextArea.setTabSize(3);
            this.infoTextArea.setBackground(XissWebUI.paleColor);
            this.infoTextArea.setEditable(false);
            this.infoTextArea.setName("result display");
        }
        return this.infoTextArea;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTextArea());
        }
        return this.jScrollPane;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.textDisplayer.register(this.closeButton, "close.button");
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BuildLauncher.this.setVisible(false);
                }
            });
        }
        return this.closeButton;
    }

    private JProgressBar getJProgressBar2() {
        if (this.directoryProgress == null) {
            this.directoryProgress = new JProgressBar();
            this.directoryProgress.setPreferredSize(new Dimension(280, 14));
        }
        return this.directoryProgress;
    }

    private JCheckBox getCloseWhenDoneCheckBox() {
        if (this.closeWhenDoneCheckBox == null) {
            this.closeWhenDoneCheckBox = new JCheckBox();
            this.closeWhenDoneCheckBox.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    BuildLauncher.this.storeClosePreference();
                }
            });
            this.textDisplayer.register(this.closeWhenDoneCheckBox, CLOSE_WHEN_DONE);
        }
        return this.closeWhenDoneCheckBox;
    }

    private ActiveLabel getStopButton() {
        if (this.stopButton == null) {
            this.stopButton = new ActiveLabel();
            this.textDisplayer.registerToolTip(this.stopButton, "stop.button");
            this.stopButton.setIcon(XissWebUI.getIcon(STOP_ICON));
            this.stopButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BuildLauncher.this.performStop();
                }
            });
        }
        return this.stopButton;
    }

    private JLabel getPauseRestartButton() {
        if (this.pauseRestartButton == null) {
            ActiveLabel label = new ActiveLabel();
            label.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BuildLauncher.this.performPauseRestart();
                }
            });
            this.pauseRestartButton = label;
        }
        return this.pauseRestartButton;
    }

    private JPanel getControlPanel() {
        if (this.controlPanel == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints4.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 10;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 0.0;
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
            this.controlPanel = new JPanel();
            this.controlPanel.setLayout(new GridBagLayout());
            this.controlPanel.add((Component)this.getPauseRestartButton(), gridBagConstraints3);
            this.controlPanel.add((Component)this.getStopButton(), gridBagConstraints4);
        }
        return this.controlPanel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

