/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.content;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.xerces.parsers.DOMParser;
import org.xissweb.data.content.HtmlContentEnabled;
import org.xissweb.data.content.ImageInfo;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.content.ContentEditor;
import org.xissweb.gui.content.ContentEditorHelper;
import org.xissweb.gui.content.ContentElementEditorObserver;
import org.xissweb.gui.editor.DocumentException;
import org.xissweb.gui.editor.Editor;
import org.xissweb.gui.editor.EditorsContainer;
import org.xissweb.gui.editor.ValidProcessHandler;
import org.xissweb.gui.editor.html.HtmlEditorHelper;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.xml.XMLHelper;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ContentTextEditor
extends JPanel
implements Editor,
ErrorHandler {
    private static final long serialVersionUID = 4407334446529914429L;
    private static final String ERROR_ICON = "/images/common/error.png";
    private HtmlContentEnabled htmlEnebled = null;
    private JScrollPane textScrollPane = null;
    private JTextPane textPane = null;
    private CaretListener textPaneCaretListener = new CaretListener(){

        public void caretUpdate(CaretEvent e) {
            ContentTextEditor.this.modified();
        }
    };
    private KeyAdapter textPaneKeyAdapter = new KeyAdapter(){

        public void keyTyped(KeyEvent e) {
            if (e.getModifiers() == 2) {
                if (e.getKeyChar() == 's' || e.getKeyChar() == 'S') {
                    ((ContentEditor)ContentTextEditor.this.editorObserver).save();
                }
            } else {
                ContentTextEditor.this.modified();
            }
        }
    };
    private TextDisplayer textDisplayer = TextDisplayManager.createTextDisplayFor(this.getClass());
    HtmlEditorHelper htmlEditorHelper = new HtmlEditorHelper(this, this.getTextPane());
    ContentElementEditorObserver editorObserver;
    private DefaultMutableTreeNode node;
    private String data;
    private boolean modified = false;
    private JLabel elementLabel = null;
    private JRadioButton htmlRadioButton = null;
    private boolean onError;
    private JLabel errorLabel = null;

    public ContentTextEditor() {
        this.initialize();
    }

    public ContentElementEditorObserver getEditorObserver() {
        return this.editorObserver;
    }

    public boolean htmlModeSelected() {
        return this.htmlRadioButton.isSelected();
    }

    public void setEditorObserver(ContentElementEditorObserver editorObserver) {
        this.editorObserver = editorObserver;
    }

    public void setEditionEnabled(boolean enabled) {
        this.textPane.setEnabled(enabled);
    }

    public boolean isDocumentValid() {
        return !this.onError;
    }

    private void initEdition() {
        this.htmlEnebled = null;
        if (this.node != null && this.node.getUserObject() instanceof HtmlContentEnabled) {
            this.htmlEnebled = (HtmlContentEnabled)this.node.getUserObject();
        }
        this.elementLabel.setIcon(this.elementToIcon(this.node));
        this.elementLabel.setText(this.elementToString(this.node));
        this.htmlRadioButton.setVisible(this.htmlEnebled != null);
        this.htmlRadioButton.setSelected(this.htmlEnebled != null && this.htmlEnebled.isHtmlContent());
        this.textPane.removeCaretListener(this.textPaneCaretListener);
        this.textPane.removeKeyListener(this.textPaneKeyAdapter);
        this.textPane.setEditable(false);
        this.textPane.setText("");
        if (this.node != null) {
            try {
                String str = ContentEditorHelper.getNodeTextValue(this.node, this.editorObserver.getTextEncoding(), true);
                ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes());
                this.textPane.read(new InputStreamReader(in), (Object)this.editorObserver.getTextEncoding());
                in.close();
                this.data = this.textPane.getText();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.textPane.setEditable(this.node != null);
        this.textPane.addCaretListener(this.textPaneCaretListener);
        this.textPane.addKeyListener(this.textPaneKeyAdapter);
        this.modified = false;
    }

    private ImageIcon elementToIcon(DefaultMutableTreeNode node) {
        if (node == null) {
            return null;
        }
        if (ContentEditorHelper.isTitleElement(node) || ContentEditorHelper.isDescriptionElement(node)) {
            return ContentEditorHelper.getContentElementIcon((DefaultMutableTreeNode)node.getParent());
        }
        return ContentEditorHelper.getContentElementIcon(node);
    }

    private String elementToString(DefaultMutableTreeNode node) {
        if (node == null) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        if (ContentEditorHelper.isImageInfoElement(node)) {
            ImageInfo iInfo = (ImageInfo)node.getUserObject();
            buff.append(ContentEditor.imageInfoToString(iInfo));
        } else if (ContentEditorHelper.isTitleElement(node)) {
            buff.append(this.textDisplayer.getString("element.title"));
        } else if (ContentEditorHelper.isDescriptionElement(node)) {
            buff.append(this.textDisplayer.getString("element.description"));
        } else if (ContentEditorHelper.isLinkElement(node)) {
            buff.append(this.textDisplayer.getString("element.link"));
        } else if (ContentEditorHelper.isSectionElement(node)) {
            buff.append(this.textDisplayer.getString("element.section"));
        }
        return buff.toString();
    }

    public boolean isReadOnly() {
        return false;
    }

    public void cancel() {
        this.initEdition();
    }

    public void edit() {
        this.initEdition();
    }

    public void edit(Object arg) {
        this.initEdition();
    }

    public String getDocumentName() {
        return null;
    }

    public Object getEditedDocument() {
        return this.node;
    }

    public Component getEditorGuiComponent() {
        return this;
    }

    public Icon getIcon() {
        return null;
    }

    public JMenuItem[] getMenuItems() {
        return null;
    }

    public boolean hasDocumentModified() {
        return this.modified;
    }

    public void reload() {
        this.initEdition();
    }

    private boolean validateContent(String html) {
        this.onError = false;
        try {
            DOMParser parser = new DOMParser();
            parser.setErrorHandler((ErrorHandler)this);
            StringReader reader = new StringReader(html);
            InputSource in = new InputSource(reader);
            parser.parse(in);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.onError;
    }

    void modified() {
        if (this.node != null) {
            if (this.htmlModeSelected()) {
                this.modified(this.validateContent(XMLHelper.addXMLHeader(this.textPane.getText(), "html", this.editorObserver.getTextEncoding())));
            } else {
                this.modified(false);
            }
        }
    }

    public void modified(boolean error) {
        this.onError = error;
        this.errorLabel.setVisible(this.onError);
        if (!error) {
            this.modified = ContentEditorHelper.updateEditedText(this.node, this.data, this.textPane.getText(), this.htmlModeSelected(), this.editorObserver.getTextEncoding());
            if (this.modified) {
                this.save();
            }
        }
    }

    public int save() {
        this.editorObserver.elementEditionEnd(this, this.node, this.modified);
        this.data = ContentEditorHelper.getNodeTextValue(this.node, this.editorObserver.getTextEncoding(), true);
        this.modified = false;
        return 0;
    }

    public void setEditedDocument(Object document) throws DocumentException {
        this.node = (DefaultMutableTreeNode)document;
    }

    public void setEditorsContainer(EditorsContainer editorsContainer) {
    }

    public void setValidProcessHandler(ValidProcessHandler handler) {
    }

    public ValidProcessHandler getValidProcessHandler() {
        return null;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = 2;
        gridBagConstraints13.anchor = 13;
        gridBagConstraints13.gridy = 0;
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.gridwidth = 2;
        gridBagConstraints12.anchor = 13;
        gridBagConstraints12.gridy = 1;
        this.errorLabel = new JLabel();
        this.errorLabel.setText("");
        this.errorLabel.setIcon(XissWebUI.getIcon(ERROR_ICON));
        this.errorLabel.setVisible(false);
        this.errorLabel.setFont(XissWebUI.boldItalicFont);
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 1;
        gridBagConstraints11.anchor = 13;
        gridBagConstraints11.gridy = 0;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.insets = new Insets(2, 2, 0, 2);
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.gridy = 0;
        this.elementLabel = new JLabel();
        this.elementLabel.setFont(XissWebUI.labelPlainFont);
        this.elementLabel.setText("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.elementLabel, gridBagConstraints1);
        this.add((Component)this.getHtmlRadioButton(), gridBagConstraints11);
        this.add((Component)this.errorLabel, gridBagConstraints12);
        this.add((Component)this.getTextScrollPane(), gridBagConstraints);
    }

    public JScrollPane getTextScrollPane() {
        if (this.textScrollPane == null) {
            this.textScrollPane = new JScrollPane();
            this.textScrollPane.setViewportView(this.getTextPane());
        }
        return this.textScrollPane;
    }

    private JTextPane getTextPane() {
        if (this.textPane == null) {
            this.textPane = new JTextPane();
            this.textPane.setEnabled(true);
            this.textPane.setEditable(true);
            int w = this.textPane.getPreferredSize().width;
            int h = this.textPane.getPreferredSize().height;
            Dimension dim = new Dimension(w, h * 2);
            this.textPane.setMinimumSize(dim);
            this.textPane.setPreferredSize(dim);
            this.textPane.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    ContentTextEditor.this.performMouseClicked(e);
                }
            });
        }
        return this.textPane;
    }

    void performMouseClicked(MouseEvent e) {
        if (this.getHtmlRadioButton().isSelected() && e.getButton() == 3) {
            this.htmlEditorHelper.showPopupMenu(e);
        }
    }

    private JRadioButton getHtmlRadioButton() {
        if (this.htmlRadioButton == null) {
            this.htmlRadioButton = new JRadioButton();
            this.htmlRadioButton.setText("HTML");
            this.htmlRadioButton.setVisible(false);
            this.htmlRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentTextEditor.this.performHtmlRadioButton();
                }
            });
        }
        return this.htmlRadioButton;
    }

    void performHtmlRadioButton() {
        this.modified();
    }

    private String buildErrorMessage(SAXParseException e) {
        String txt = e.getLocalizedMessage();
        this.errorLabel.setText(txt);
        return txt;
    }

    public void error(SAXParseException e) throws SAXException {
        this.buildErrorMessage(e);
        this.onError = true;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.buildErrorMessage(e);
        this.onError = true;
    }

    public void warning(SAXParseException e) throws SAXException {
        this.buildErrorMessage(e);
        this.onError = true;
    }
}

