/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.content;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.xissweb.gui.content.ContentEditorHelper;
import org.xissweb.gui.content.ContentElementEditorObserver;

public class ContentTreeCellEditor
extends DefaultTreeCellEditor {
    private static final int textEditorWidth = 450;
    private static final int textEditorHeight = 24;
    private ContentElementEditorObserver editorObserver;
    private DefaultMutableTreeNode currentNode;
    private JPanel editorComponent;
    private JLabel imageComponent;
    private JTextField textComponent;
    private String data;

    public ContentTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer, ContentElementEditorObserver editorObserver) {
        super(tree, renderer);
        this.editorObserver = editorObserver;
        this.imageComponent = new JLabel("");
        this.textComponent = new JTextField();
        this.textComponent.setPreferredSize(new Dimension(450, 24));
        this.textComponent.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 27) {
                    ContentTreeCellEditor.this.stopCellEditing();
                }
            }
        });
        FlowLayout layout = new FlowLayout();
        layout.setHgap(0);
        layout.setVgap(0);
        layout.setAlignment(0);
        this.editorComponent = new JPanel(layout);
        this.editorComponent.setPreferredSize(new Dimension(520, 70));
        this.editorComponent.add(this.imageComponent);
        this.editorComponent.add(this.textComponent);
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row) {
        this.currentNode = (DefaultMutableTreeNode)value;
        Icon icon = null;
        Component c = tree.getCellRenderer().getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, true);
        if (c instanceof JLabel) {
            icon = ((JLabel)c).getIcon();
        } else {
            JPanel panel = (JPanel)c;
            icon = ((JLabel)panel.getComponent(0)).getIcon();
        }
        if (icon != null) {
            this.textComponent.setPreferredSize(new Dimension(450, icon.getIconHeight()));
            this.editorComponent.setPreferredSize(new Dimension(450 + icon.getIconWidth(), icon.getIconHeight()));
        } else {
            this.textComponent.setPreferredSize(new Dimension(450, 24));
            this.editorComponent.setPreferredSize(new Dimension(450, 24));
        }
        this.imageComponent.setIcon(icon);
        this.imageComponent.setText("");
        String str = ContentEditorHelper.getNodeTextValue(this.currentNode, this.editorObserver.getTextEncoding(), false);
        if (ContentEditorHelper.isHtmlContent(this.currentNode)) {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes());
                this.textComponent.read(new InputStreamReader((InputStream)in, this.editorObserver.getTextEncoding()), null);
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.textComponent.setText(str);
        }
        this.data = this.textComponent.getText();
        return this.editorComponent;
    }

    public Object getCellEditorValue() {
        String txt = this.textComponent.getText();
        this.editorObserver.elementEditionEnd(this, this.currentNode, ContentEditorHelper.updateEditedText(this.currentNode, this.data, txt, ContentEditorHelper.isHtmlContent(this.currentNode), this.editorObserver.getTextEncoding()));
        return this.currentNode.getUserObject();
    }
}

