/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.content;

import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import org.xissweb.data.content.ImageInfo;
import org.xissweb.data.content.SectionInfo;
import org.xissweb.data.content.SlideShowContentInfo;
import org.xissweb.data.content.SlideShowRefInfo;
import org.xissweb.gui.util.tree.TreeModel;

public class ContentTreeModel
extends TreeModel {
    private static final long serialVersionUID = 1901412009430828790L;
    private static final String NO_CONTENT = "NO CONTENT";
    public static final String INFO_ELEMENT = "INFO";
    private SlideShowContentInfo contentInfo;

    public ContentTreeModel() {
        super(new DefaultMutableTreeNode(NO_CONTENT));
        this.contentInfo = null;
    }

    public ContentTreeModel(SlideShowContentInfo contentInfo) {
        super(new DefaultMutableTreeNode(contentInfo));
        this.contentInfo = contentInfo;
        this.init();
    }

    protected void init() {
        DefaultMutableTreeNode theRoot = (DefaultMutableTreeNode)this.getRoot();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(INFO_ELEMENT);
        theRoot.add(node);
        DefaultMutableTreeNode n = new DefaultMutableTreeNode(this.contentInfo.getTitle());
        node.add(n);
        n = new DefaultMutableTreeNode(this.contentInfo.getDescription());
        node.add(n);
        SlideShowRefInfo link = this.contentInfo.getPrevious();
        if (link != null) {
            n = new DefaultMutableTreeNode(link);
            theRoot.add(n);
        }
        if ((link = this.contentInfo.getNext()) != null) {
            n = new DefaultMutableTreeNode(link);
            theRoot.add(n);
        }
        Iterator i = this.contentInfo.getSections().iterator();
        while (i.hasNext()) {
            SectionInfo section = (SectionInfo)i.next();
            DefaultMutableTreeNode sNode = new DefaultMutableTreeNode(section);
            theRoot.add(sNode);
            Iterator j = section.getImages().iterator();
            while (j.hasNext()) {
                ImageInfo info = (ImageInfo)j.next();
                sNode.add(new DefaultMutableTreeNode(info));
            }
        }
    }
}

