/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.content;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.xissweb.data.content.ContentInfoIdentifiable;
import org.xissweb.data.content.ImageInfo;
import org.xissweb.data.content.SectionInfo;
import org.xissweb.data.content.SlideShowContentInfo;
import org.xissweb.gui.content.ContentEditor;
import org.xissweb.gui.content.ContentEditorHelper;
import org.xissweb.gui.util.tree.TreeHelper;
import org.xissweb.gui.util.tree.TreeNodeTransferable;

public class ListContentElementTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 7471292477005882456L;
    DataFlavor nodesFlavor = TreeNodeTransferable.dataFlavor;
    ContentEditor editor;
    JTree source = null;
    ArrayList originNodes = null;
    int addIndex = -1;
    int addCount = 0;

    public ListContentElementTransferHandler(ContentEditor editor) {
        this.editor = editor;
    }

    public boolean importData(JComponent c, Transferable t) {
        JTree target = null;
        ArrayList from = null;
        if (!this.canImport(c, t.getTransferDataFlavors())) {
            return false;
        }
        try {
            target = (JTree)c;
            if (!this.hasNodeFlavor(t.getTransferDataFlavors())) {
                return false;
            }
            from = (ArrayList)t.getTransferData(this.nodesFlavor);
        }
        catch (UnsupportedFlavorException ufe) {
            System.out.println("importData: unsupported data flavor");
            return false;
        }
        catch (IOException e) {
            System.out.println("importData: I/O error during transfert");
            return false;
        }
        DefaultMutableTreeNode to = TreeHelper.getSelectedNode(target);
        boolean result = false;
        result = this.source.equals(target) && this.isDroppingToItself(to, from) ? false : (ContentEditorHelper.isImageInfoElements(from) ? this.doImportImages(target, from, to) : (ContentEditorHelper.isSectionElements(from) ? this.doImportSections(target, from, to) : false));
        if (!result) {
            this.originNodes = null;
        }
        return result;
    }

    private boolean isDroppingToItself(DefaultMutableTreeNode to, ArrayList from) {
        boolean result = false;
        Iterator i = from.iterator();
        while (i.hasNext() && !result) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)i.next();
            if (!((ContentInfoIdentifiable)node.getUserObject()).getIdentifier().equals(((ContentInfoIdentifiable)to.getUserObject()).getIdentifier())) continue;
            result = true;
        }
        return result;
    }

    private boolean doImportImages(JTree tree, ArrayList from, DefaultMutableTreeNode to) {
        boolean importDone = false;
        if (ContentEditorHelper.isSectionElement(to)) {
            this.insertImages(to, from, 0);
            ((DefaultTreeModel)tree.getModel()).nodeStructureChanged(to);
            importDone = true;
        } else if (ContentEditorHelper.isImageInfoElement(to)) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)to.getParent();
            this.insertImages(parent, from, parent.getIndex(to) + 1);
            ((DefaultTreeModel)tree.getModel()).nodeStructureChanged(parent);
            importDone = true;
        }
        return importDone;
    }

    private boolean doImportSections(JTree tree, ArrayList from, DefaultMutableTreeNode to) {
        boolean importDone = false;
        if (ContentEditorHelper.isRootElement(to)) {
            this.insertSections(to, from, 0);
            importDone = true;
        } else if (ContentEditorHelper.isSectionElement(to)) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)to.getParent();
            SlideShowContentInfo slideShowInfo = (SlideShowContentInfo)parent.getUserObject();
            this.insertSections(parent, from, parent.getIndex(to) + 1 - ContentEditorHelper.sectionsOffset(slideShowInfo));
            importDone = true;
        }
        return importDone;
    }

    private void insertImages(DefaultMutableTreeNode secNode, ArrayList imgNodes, int index) {
        SectionInfo section = (SectionInfo)secNode.getUserObject();
        int i = index;
        Iterator it = imgNodes.iterator();
        while (it.hasNext()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)it.next();
            secNode.insert(node, i);
            section.getImages().add(i, node.getUserObject());
            ++i;
        }
    }

    private void insertSections(DefaultMutableTreeNode rootNode, ArrayList secNodes, int index) {
        SlideShowContentInfo contentInfo = (SlideShowContentInfo)rootNode.getUserObject();
        int offset = ContentEditorHelper.sectionsOffset(contentInfo);
        int i = index;
        Iterator it = secNodes.iterator();
        while (it.hasNext()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)it.next();
            rootNode.insert(node, i + offset);
            contentInfo.getSections().add(i, node.getUserObject());
            ++i;
        }
    }

    protected void exportDone(JComponent c, Transferable data, int action) {
        if (action == 2 && this.originNodes != null) {
            JTree tree = (JTree)c;
            if (ContentEditorHelper.isImageInfoElements(this.originNodes)) {
                Iterator i = this.originNodes.iterator();
                while (i.hasNext()) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)i.next();
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                    SectionInfo section = (SectionInfo)parent.getUserObject();
                    section.getImages().remove(node.getUserObject());
                    parent.remove(node);
                    ((DefaultTreeModel)tree.getModel()).nodeStructureChanged(parent);
                }
                this.editor.getContentInfo().resetImageNumber();
                this.originNodes = null;
                this.editor.modified(false);
            } else if (ContentEditorHelper.isSectionElements(this.originNodes)) {
                Iterator i = this.originNodes.iterator();
                while (i.hasNext()) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)i.next();
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                    SlideShowContentInfo contentInfo = (SlideShowContentInfo)parent.getUserObject();
                    contentInfo.getSections().remove(node.getUserObject());
                    parent.remove(node);
                    ((DefaultTreeModel)tree.getModel()).nodeStructureChanged(parent);
                }
                this.editor.getContentInfo().resetImageNumber();
                this.originNodes = null;
                this.editor.modified(false);
            }
            TreeHelper.expandAll(tree);
        }
    }

    private boolean hasNodeFlavor(DataFlavor[] flavors) {
        if (this.nodesFlavor == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(this.nodesFlavor)) continue;
            return true;
        }
        return false;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return this.hasNodeFlavor(flavors);
    }

    protected Transferable createTransferable(JComponent c) {
        TreeNodeTransferable transf = null;
        this.source = (JTree)c;
        this.originNodes = TreeHelper.getSelectedNodes(this.source);
        if (this.originNodes != null) {
            ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>(this.originNodes.size());
            Iterator i = this.originNodes.iterator();
            while (i.hasNext()) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode();
                DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)i.next();
                if (ContentEditorHelper.isImageInfoElement(oNode)) {
                    node.setUserObject(((ImageInfo)oNode.getUserObject()).clone());
                    nodes.add(node);
                    continue;
                }
                if (!ContentEditorHelper.isSectionElement(oNode)) continue;
                SectionInfo section = (SectionInfo)((SectionInfo)oNode.getUserObject()).clone();
                node.setUserObject(section);
                Iterator j = section.getImages().iterator();
                while (j.hasNext()) {
                    DefaultMutableTreeNode n = new DefaultMutableTreeNode();
                    n.setUserObject(j.next());
                    node.add(n);
                }
                nodes.add(node);
            }
            if (!nodes.isEmpty()) {
                transf = new TreeNodeTransferable(nodes);
            }
        }
        return transf;
    }

    public int getSourceActions(JComponent c) {
        return 2;
    }
}

