/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.content;

import java.awt.Component;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.content.MetaDataTableModel;
import org.xissweb.i18n.TextDisplayer;

public class MetaDataTableCellEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = -7135876487410531128L;
    private static final Pattern latDMSPattern = Pattern.compile("[NS] [0-8]?[0-9] [0-5]?[0-9] [0-5]?[0-9].[0-9]*");
    private static final Pattern latDMSLimitPattern = Pattern.compile("[NS] 90 0?0 0?0.0*");
    private static final Pattern lonDMSPattern = Pattern.compile("[EW] (1?[0-9]?[0-9]) [0-5]?[0-9] [0-5]?[0-9].[0-9]*");
    private static final Pattern lonDMSLimitPattern = Pattern.compile("[NS] 180 0?0 0?0.0*");
    private TextDisplayer displayer = new TextDisplayer(this.getClass());
    private JTable table;
    private int row;

    public MetaDataTableCellEditor() {
        super(new JTextField());
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.row = row;
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    private boolean isLatitude(int row) {
        MetaDataTableModel model = (MetaDataTableModel)this.table.getModel();
        return model.keys[row] == "latitude";
    }

    private boolean isLongitude(int row) {
        MetaDataTableModel model = (MetaDataTableModel)this.table.getModel();
        return model.keys[row] == "longitude";
    }

    public boolean stopCellEditing() {
        JTextField textField = (JTextField)this.getComponent();
        String text = textField.getText();
        if (this.isLatitude(this.row)) {
            String str = this.normalizeLatitude(text);
            if (str != null) {
                textField.setText(str);
            } else {
                XissWebUI.showErrorMessage(this.displayer.getString("latitude.error"), this.displayer.getString("latitude.error.title"));
            }
        } else if (this.isLongitude(this.row)) {
            String str = this.normalizeLongitude(text);
            if (str != null) {
                textField.setText(str);
            } else {
                XissWebUI.showErrorMessage(this.displayer.getString("longitude.error"), this.displayer.getString("longitude.error.title"));
            }
        }
        super.stopCellEditing();
        return true;
    }

    private String normalizeLatitude(String text) {
        if ("-".equals(text) || text.length() == 0) {
            return "-";
        }
        try {
            double l = Double.parseDouble(text);
            if (l < -90.0 || l > 90.0) {
                return null;
            }
            return this.toDMS(l, "N", "S");
        }
        catch (NumberFormatException e) {
            String value = text.trim();
            Matcher m = latDMSPattern.matcher(value);
            Matcher m2 = latDMSLimitPattern.matcher(value);
            if (m.matches() || m2.matches()) {
                return value;
            }
            return null;
        }
    }

    private String normalizeLongitude(String text) {
        if ("-".equals(text) || text.length() == 0) {
            return "-";
        }
        try {
            double l = Double.parseDouble(text);
            if (l < -180.0 || l > 180.0) {
                return null;
            }
            return this.toDMS(l, "E", "W");
        }
        catch (NumberFormatException e) {
            int d;
            String value = text.trim();
            Matcher m2 = lonDMSLimitPattern.matcher(value);
            if (m2.matches()) {
                return value;
            }
            Matcher m = lonDMSPattern.matcher(value);
            if (m.matches() && (d = Integer.parseInt(m.group(1))) < 180) {
                return value;
            }
            return null;
        }
    }

    private String toDMS(double value, String pos, String neg) {
        double l = value;
        StringBuffer result = new StringBuffer();
        if (l < 0.0) {
            result.append(neg);
            l = StrictMath.abs(l);
        } else {
            result.append(pos);
        }
        result.append(' ');
        int dms = (int)StrictMath.floor(l);
        result.append(dms).append(' ');
        l = (l - (double)dms) * 60.0;
        dms = (int)StrictMath.floor(l);
        result.append(dms).append(' ');
        l = (l - (double)dms) * 60.0;
        result.append(l);
        return result.toString();
    }
}

