/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.content;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.xissweb.data.content.ImageInfo;
import org.xissweb.data.content.ImageMetaData;
import org.xissweb.data.imetadata.ImageMetadataHelper;
import org.xissweb.gui.content.ContentEditor;
import org.xissweb.i18n.TextDisplayer;

public class MetaDataTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 107686446274456163L;
    private static final int NO_IMAGE_TYPE = -1;
    private static final String[] NO_KEYS = new String[0];
    private static final String NO_TYPE_CHAR = "[?]";
    public static final String multipleValue = "";
    private static final TextDisplayer textDisplayer = new TextDisplayer(class$org$xissweb$gui$content$MetaDataTableModel == null ? (class$org$xissweb$gui$content$MetaDataTableModel = MetaDataTableModel.class$("org.xissweb.gui.content.MetaDataTableModel")) : class$org$xissweb$gui$content$MetaDataTableModel);
    private ContentEditor editor;
    private List images;
    int imageType;
    String[] keys;
    private int propertyCount;
    private Object[] values;
    private boolean[] edition;
    static /* synthetic */ Class class$org$xissweb$gui$content$MetaDataTableModel;

    public MetaDataTableModel(ContentEditor editor, List images) {
        this.editor = editor;
        this.images = images;
        this.analyseImagesType();
        this.values = new Object[this.propertyCount];
        this.edition = new boolean[this.propertyCount];
        this.resetEdition();
    }

    private void analyseImagesType() {
        this.imageType = -1;
        this.keys = NO_KEYS;
        this.propertyCount = 0;
        if (this.images != null) {
            Iterator i = this.images.iterator();
            ImageInfo info = (ImageInfo)i.next();
            this.imageType = info.getMetaData().getImageType();
            this.keys = ImageMetadataHelper.getImageMetaDataKeys(this.imageType);
            this.propertyCount = ImageMetadataHelper.imageMetaDataKeyCount(this.imageType);
            while (i.hasNext()) {
                info = (ImageInfo)i.next();
                if (this.imageType == info.getMetaData().getImageType()) continue;
                this.imageType = -1;
                this.keys = NO_KEYS;
                this.propertyCount = 0;
                break;
            }
        }
    }

    void resetEdition() {
        for (int i = 0; i < this.edition.length; ++i) {
            this.edition[i] = false;
        }
    }

    public String getColumnName(int column) {
        if (column == 0) {
            StringBuffer buff = new StringBuffer();
            if (this.images != null) {
                if (this.propertyCount == 0) {
                    buff.append(NO_TYPE_CHAR);
                } else {
                    ImageInfo info = (ImageInfo)this.images.get(0);
                    buff.append('[').append(ContentEditor.IMAGE_TYPE_KEYS[info.getMetaData().getImageType()]).append(']');
                }
            }
            buff.append(' ').append(textDisplayer.getString("property.column.name"));
            return buff.toString();
        }
        return textDisplayer.getString("value.column.name");
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.propertyCount;
    }

    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return ImageMetaData.internationalizeKey(this.imageType, row);
        }
        if (row < this.values.length) {
            if (this.values[row] == null) {
                this.values[row] = this.getMetaDataValue(row);
            }
            return this.values[row];
        }
        return null;
    }

    public boolean isEditedAt(int index) {
        return this.edition[index];
    }

    private Object getMetaDataValue(int index) {
        HashSet<Object> set = new HashSet<Object>();
        Iterator i = this.images.iterator();
        while (i.hasNext()) {
            set.add(this.getMetadataValue((ImageInfo)i.next(), index));
        }
        return set.isEmpty() ? null : (set.size() > 1 ? multipleValue : set.iterator().next());
    }

    private Object getMetadataValue(ImageInfo iInfo, int index) {
        return iInfo.getMetaData() == null ? "-" : iInfo.getMetaData().getDisplayValue(this.keys[index]);
    }

    public boolean isCellEditable(int row, int col) {
        return col == 1;
    }

    public void setValueAt(Object value, int row, int column) {
        if (!value.equals(this.values[row])) {
            Object v = value;
            if (v.equals(multipleValue)) {
                v = "-";
            }
            Iterator i = this.images.iterator();
            while (i.hasNext()) {
                ImageInfo iInfo = (ImageInfo)i.next();
                if (iInfo.getMetaData() == null) {
                    iInfo.setMetaData(new ImageMetaData());
                }
                iInfo.getMetaData().put(this.keys[row], v.toString());
            }
            this.values[row] = v;
            this.edition[row] = true;
            this.editor.modified(false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

