/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.content.links;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.xissweb.data.layout.SlideShowLayoutInfo;
import org.xissweb.gui.Main;
import org.xissweb.gui.content.links.LinkedSlideshowTreeCellRenderer;
import org.xissweb.gui.content.links.LinkedSlideshowTreeModel;
import org.xissweb.gui.content.links.LinksTreeUI;
import org.xissweb.gui.util.tree.TreeHelper;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.prefs.ui.ComponentConfigurator;
import org.xissweb.project.ProjectChangeObserver;
import org.xissweb.project.links.LinkedSlideshow;

public class LinkedSlideshowDialog
extends JDialog
implements ProjectChangeObserver {
    private static final long serialVersionUID = 1L;
    public static final int INCONSISTENTCY = 0;
    public static final int SELECTION = 1;
    DefaultMutableTreeNode nodeUnderAction;
    private JPanel mainContentPane = null;
    private JScrollPane scrollPane = null;
    private JTree tree = null;
    private JPanel controlPanel = null;
    private JButton closeButton = null;
    private TextDisplayer textDisplayer = null;
    private JPopupMenu linksPopupMenu = null;
    private JPopupMenu layoutPopupMenu = null;
    private JPopupMenu slideshowPopupMenu = null;
    private JMenuItem manageLinksMenuItem = null;
    private JMenuItem editLayoutMenuItem = null;
    private JMenuItem editSlidehowMenuItem = null;

    public LinkedSlideshowDialog(Frame owner, int mode) {
        super(owner);
        this.setModal(false);
        this.textDisplayer = TextDisplayManager.createTextDisplayFor(this.getClass());
        this.initialize();
        String prefsCategory = this.getClass().getName();
        switch (mode) {
            case 0: {
                this.textDisplayer.registerTitle(this, "title.inconsistent");
                break;
            }
            case 1: {
                this.textDisplayer.registerTitle(this, "title.selection");
                prefsCategory = prefsCategory + ".selection";
            }
        }
        ComponentConfigurator.configure((Component)this, (String)prefsCategory);
    }

    public void open(LinkedSlideshow linkedSlideshow) {
        this.tree.setModel(new LinkedSlideshowTreeModel(linkedSlideshow));
        TreeHelper.expandAll(this.tree);
        this.setVisible(true);
    }

    public void open(List linkedSlideshows) {
        this.tree.setModel(new LinkedSlideshowTreeModel(linkedSlideshows));
        TreeHelper.expandAll(this.tree);
        this.setVisible(true);
    }

    public void linkedSlideShowsChanged(List linkedSlideshows) {
        this.dataChanged(linkedSlideshows);
    }

    public void dataChanged(LinkedSlideshow linkedSlideshow) {
        this.tree.setModel(new LinkedSlideshowTreeModel(linkedSlideshow));
        TreeHelper.expandAll(this.tree);
    }

    public void dataChanged(List linkedSlideshows) {
        this.tree.setModel(new LinkedSlideshowTreeModel(linkedSlideshows));
        TreeHelper.expandAll(this.tree);
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setContentPane(this.getMainContentPane());
    }

    private JPanel getMainContentPane() {
        if (this.mainContentPane == null) {
            this.mainContentPane = new JPanel();
            this.mainContentPane.setLayout(new BorderLayout());
            this.mainContentPane.add((Component)this.getScrollPane(), "Center");
            this.mainContentPane.add((Component)this.getControlPanel(), "South");
        }
        return this.mainContentPane;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getTree());
        }
        return this.scrollPane;
    }

    private JTree getTree() {
        if (this.tree == null) {
            this.tree = new JTree();
            this.tree.setModel(new LinkedSlideshowTreeModel());
            this.tree.setCellRenderer(new LinkedSlideshowTreeCellRenderer());
            this.tree.setRootVisible(false);
            LinksTreeUI.UI(this.tree);
            this.tree.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    LinkedSlideshowDialog.this.onMouseClicked(e);
                }
            });
        }
        return this.tree;
    }

    void onMouseClicked(MouseEvent e) {
        this.nodeUnderAction = TreeHelper.getNode(this.tree, e);
        if (this.nodeUnderAction != null && e.getButton() == 3) {
            JPopupMenu popup = null;
            if (this.nodeUnderAction.getUserObject() instanceof LinkedSlideshow) {
                popup = this.getLinksPopupMenu();
            } else if (this.nodeUnderAction.getUserObject() instanceof SlideShowLayoutInfo) {
                popup = this.getLayoutPopupMenu();
            } else if (this.nodeUnderAction.getUserObject() instanceof File) {
                popup = this.getSlideshowPopupMenu();
            }
            popup.show(this.tree, e.getX(), e.getY());
        }
    }

    private JPanel getControlPanel() {
        if (this.controlPanel == null) {
            this.controlPanel = new JPanel();
            this.controlPanel.setLayout(new FlowLayout());
            this.controlPanel.add((Component)this.getCloseButton(), null);
        }
        return this.controlPanel;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.textDisplayer.register(this.closeButton, "close.button");
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LinkedSlideshowDialog.this.setVisible(false);
                }
            });
        }
        return this.closeButton;
    }

    private JPopupMenu getLinksPopupMenu() {
        if (this.linksPopupMenu == null) {
            this.linksPopupMenu = new JPopupMenu();
            this.linksPopupMenu.add(this.getManageLinksMenuItem());
        }
        return this.linksPopupMenu;
    }

    private JPopupMenu getLayoutPopupMenu() {
        if (this.layoutPopupMenu == null) {
            this.layoutPopupMenu = new JPopupMenu();
            this.layoutPopupMenu.add(this.getEditLayoutMenuItem());
        }
        return this.layoutPopupMenu;
    }

    private JPopupMenu getSlideshowPopupMenu() {
        if (this.slideshowPopupMenu == null) {
            this.slideshowPopupMenu = new JPopupMenu();
            this.slideshowPopupMenu.add(this.getEditSlideshowMenuItem());
        }
        return this.slideshowPopupMenu;
    }

    private JMenuItem getManageLinksMenuItem() {
        if (this.manageLinksMenuItem == null) {
            this.manageLinksMenuItem = new JMenuItem();
            this.manageLinksMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LinkedSlideshowDialog.this.performManageLinks((LinkedSlideshow)LinkedSlideshowDialog.this.nodeUnderAction.getUserObject());
                }
            });
            this.textDisplayer.register(this.manageLinksMenuItem, "manage.links.menu.item");
        }
        return this.manageLinksMenuItem;
    }

    void performManageLinks(LinkedSlideshow linkedSlideshow) {
        Main.get().getXissWeb().getLinksManagerDialog().open(linkedSlideshow);
    }

    private JMenuItem getEditLayoutMenuItem() {
        if (this.editLayoutMenuItem == null) {
            this.editLayoutMenuItem = new JMenuItem();
            this.editLayoutMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LinkedSlideshowDialog.this.performEditLayout(((SlideShowLayoutInfo)LinkedSlideshowDialog.this.nodeUnderAction.getUserObject()).getFile());
                }
            });
            this.textDisplayer.register(this.editLayoutMenuItem, "edit.layout.menu.item");
        }
        return this.editLayoutMenuItem;
    }

    void performEditLayout(File file) {
        Main.get().getEditorManager().openEditor(file.getName(), (Object)file);
    }

    private JMenuItem getEditSlideshowMenuItem() {
        if (this.editSlidehowMenuItem == null) {
            this.editSlidehowMenuItem = new JMenuItem();
            this.editSlidehowMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LinkedSlideshowDialog.this.performEditSlideshow((File)LinkedSlideshowDialog.this.nodeUnderAction.getUserObject());
                }
            });
            this.textDisplayer.register(this.editSlidehowMenuItem, "edit.slideshow.menu.item");
        }
        return this.editSlidehowMenuItem;
    }

    void performEditSlideshow(File dir) {
        File f = new File(dir, "slideshow.xml");
        Main.get().getEditorManager().openEditor(f.getName(), (Object)f);
    }
}

