/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.editor.font;

import java.awt.Font;
import java.awt.GraphicsEnvironment;

public class CssFontHelper {
    static final Font[] ALL_FONTS = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();

    private CssFontHelper() {
    }

    public static String fontName(String fName) {
        int index = fName.indexOf("-");
        if (index > 0) {
            return fName.substring(0, index) + fName.substring(index + 1);
        }
        return fName.equals("monospace") ? "monospaced" : fName;
    }

    public static boolean fontExist(String fName) {
        String name = CssFontHelper.fontName(fName);
        for (int i = 0; i < ALL_FONTS.length; ++i) {
            if (!ALL_FONTS[i].getName().equalsIgnoreCase(name) && !ALL_FONTS[i].getFamily().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static Font getFont(String[] names) {
        Font font = null;
        for (int i = 0; i < names.length - 1; ++i) {
            String name = names[i].replace('\"', ' ').trim();
            if (!CssFontHelper.fontExist(name)) continue;
            font = Font.decode(name);
        }
        return font == null ? Font.decode(CssFontHelper.fontName(names[names.length - 1])) : font;
    }
}

