/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.file;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.xissweb.data.layout.SlideShowLayoutInfo;
import org.xissweb.data.layout.xml.LayoutSerializer;
import org.xissweb.file.FileHelper;
import org.xissweb.gui.Main;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.editor.Editor;
import org.xissweb.gui.editor.EditorManager;
import org.xissweb.gui.editor.text.TextEditor;
import org.xissweb.gui.file.FileDirectoryNameChecker;
import org.xissweb.gui.file.FileManagerObserver;
import org.xissweb.gui.file.FileSelection;
import org.xissweb.gui.file.FileSelectionObserver;
import org.xissweb.gui.file.FileTransferHandler;
import org.xissweb.gui.file.FileTreeCellRenderer;
import org.xissweb.gui.file.FileTreeModel;
import org.xissweb.gui.prefs.data.PreferenceInfo;
import org.xissweb.gui.util.OsNameHelper;
import org.xissweb.gui.util.ShowHelper;
import org.xissweb.gui.util.input.InputDialog;
import org.xissweb.gui.util.tree.TreeHelper;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.image.ImageFileHelper;
import org.xissweb.prefs.ui.ComponentConfigurator;
import org.xissweb.produce.DirectoryActionEvent;
import org.xissweb.produce.SlideShowDirectory;
import org.xissweb.produce.build.BuildEventListener;
import org.xissweb.produce.sow.SowEventListener;
import org.xissweb.project.SlideShowProject;
import org.xissweb.project.SlideShowProperties;

public class FileManager
extends JPanel
implements SowEventListener,
BuildEventListener,
FileSelectionObserver {
    private static final long serialVersionUID = 4171612658905421676L;
    private static final String HTML_START = "<html>";
    private static final String HTML_END = "</html>";
    private static final String RED_TEXT_START = "<span style=\"color: red\">";
    private static final String RED_TEXT_END = "</span>";
    private static final String BR_TAG = "<br>";
    private static final String LI_END = "</li>";
    private static final String LI_START = "<li>";
    private static final String UL_END = "</ul>";
    private static final String UL_START = "<ul>";
    private static final String PERFS_FOLDER_NAME_INPUT_DIALOG = "folder.name.input.dialog";
    private static final String SELECTION_KEY = "file.selection";
    private static final String SELECTION_SEPARATOR = ",";
    private static final String PREFS_SHOW_FILES = "show.files";
    private static final String PREFS_SHOW_IMAGES_IN_SLIDE_SHOWS = "show.images.in.slide.show";
    private static final String FOLDER_ICON = "/images/file/directory.png";
    private static final String SKIN_DOC_ICON = "/images/file/skinDoc.png";
    private static final String SKIN_DOC_ERROR_ICON = "/images/file/skinDoc-error.png";
    private static final String SKINS_DIR_ICON = "/images/file/directory-skins.png";
    private static final String DIRECTORY_ICON = "/images/file/directory.png";
    private static final String PPROJECT_ROOT_ICON = "/images/file/project-directory.png";
    private static final String SRC_DIRECTORY_ICON = "/images/file/directory-src.png";
    private static final String EXCLUDED_DIRECTORY_ICON = "/images/file/directory-excluded.png";
    private static final String IMAGE_DIRECTORY_ICON = "/images/file/directory-images.png";
    private static final String IMAGE_REPOSITORY_ICON = "/images/file/repository.png";
    private static final String ORIGIN_DIRECTORY_ICON = "/images/file/origin.png";
    private static final String SRC_ERROR_ICON = "/images/file/directory-src-error.png";
    private static final String IMAGE_REPOSITORY_ERROR_ICON = "/images/file/repository-error.png";
    private static final String ORIGIN_ERROR_ICON = "/images/file/origin-error.png";
    private static final String SRC_SOW_ICON = "/images/file/directory-src-sow.png";
    private static final String IMAGE_REPOSITORY_SOW_ICON = "/images/file/repository-sow.png";
    private static final String ORIGIN_SOW_ICON = "/images/file/origin-sow.png";
    private static final String PROPERTIES_SLIDE_SOW_ICON = "/images/file/properties.png";
    private static final String LAYOUT_SLIDE_SOW_ICON = "/images/file/layout.png";
    private static final String LAYOUT_SLIDE_SOW_ERROR_ICON = "/images/file/layout-error.png";
    private static final String CONTENT_SLIDE_SOW_ICON = "/images/file/content.png";
    private static final String CONTENT_SLIDE_SOW_ERROR_ICON = "/images/file/content-error.png";
    private static final String IMAGE_FILE_ICON = "/images/file/image-file.png";
    private static final String FILE_HTML_ICON = "/images/file/file-html.png";
    private static final String FILE_HTML_ERROR_ICON = "/images/file/file-html-error.png";
    private static final String FILE_CSS_ICON = "/images/file/file-css.png";
    private static final String FILE_XML_ICON = "/images/file/file-xml.png";
    private static final String FILE_XML_ERROR_ICON = "/images/file/file-xml-error.png";
    private static final String FILE_JS_ICON = "/images/file/file-js.png";
    private static final String FILE_PHP_ICON = "/images/file/file-php.png";
    private static final String FILE_TEXT_ICON = "/images/file/fileText.png";
    private static final String FILE_ICON = "/images/file/file.png";
    TextDisplayer textDisplayer;
    private FileManagerObserver observer;
    private JTree fileTree = null;
    DefaultMutableTreeNode nodeUnderMenu = null;
    private FileSelection fileSelection;
    private FileTreeModel treeModel;
    private boolean showFilesTreeFilter;
    private boolean showImageInSlideShowsTreeFilter;
    private FileDirectoryNameChecker skinNameChecker = new FileDirectoryNameChecker();
    private JPopupMenu filePopupMenu = null;
    private JMenuItem saveMenuFileItem = null;
    private JMenuItem cancelMenuFileItem = null;
    private JMenuItem closeMenuFileItem = null;
    private JMenuItem openMenuFileItem = null;
    private JPopupMenu dirPopupMenu = null;
    private JMenu addLayoutMenu = null;
    private File layoutToPast = null;
    private JMenuItem newLayoutMenuItem = null;
    private JMenu openWithMenu = null;
    private JMenuItem graphicEditorMenuItem = null;
    private JMenuItem textEditorMenuItem = null;
    private JMenuItem addSkinMenuItem = null;
    private JMenuItem deleteFileMenuItem = null;
    private JMenuItem slideshowBiuldMenu;
    private JMenuItem slideshowShowMenu;
    private JSeparator slideshowSeparator;
    private JSeparator dirMenuSeparator = null;
    private JMenuItem sowDirMenuItem = null;
    private JMenuItem buildDirMenuItem = null;
    private JMenuItem showDirMenuItem = null;
    private JMenuItem refreshMenuItem = null;
    private JCheckBoxMenuItem hideShowImageFiles = null;
    private JCheckBoxMenuItem hideShowAllFiles = null;
    private JScrollPane fileScrollPane;
    private JLabel selectLabel;
    private JPanel fileSelectionPanel;
    private JButton unselectAllButton;
    private JSeparator fileSeparator;
    private JMenuItem renameFileMenuItem;
    private JMenuItem newFolderMenuItem;
    private JMenuItem deleteFolderMenuItem;
    private JMenuItem renameFolderMenuItem;
    private JSeparator dirMenuFolderSeparator;
    private InputDialog folderNameInputDialog;
    private JMenuItem newFileMenuItem;
    static /* synthetic */ Class class$org$xissweb$gui$file$FileManager;

    static boolean isDirectImageDirSlideShow(File directory) {
        SlideShowProperties props = Main.get().getCurrentProject().getProperties();
        return props.getImageDirFilter().equals("only") && directory.getName().equals(props.getImageDirName());
    }

    public FileManager() {
        this.textDisplayer = TextDisplayManager.createTextDisplayFor(class$org$xissweb$gui$file$FileManager == null ? (class$org$xissweb$gui$file$FileManager = FileManager.class$("org.xissweb.gui.file.FileManager")) : class$org$xissweb$gui$file$FileManager);
        this.initialize();
        this.showFilesTreeFilter = Main.preferences.getBoolean(PREFS_SHOW_FILES, this.getClass(), false);
        this.showImageInSlideShowsTreeFilter = Main.preferences.getBoolean(PREFS_SHOW_IMAGES_IN_SLIDE_SHOWS, this.getClass(), false);
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getFileScrollPane(), "Center");
        this.add((Component)this.getFileSelectionPanel(), "South");
    }

    private JScrollPane getFileScrollPane() {
        if (this.fileScrollPane == null) {
            this.fileScrollPane = new JScrollPane();
            this.fileScrollPane.setViewportView(this.getFileTree());
        }
        return this.fileScrollPane;
    }

    private JTree getFileTree() {
        if (this.fileTree == null) {
            this.fileTree = new JTree((TreeNode)null);
            this.fileTree.setRootVisible(false);
            this.fileTree.setModel(null);
            this.fileSelection = new FileSelection(this.fileTree);
            this.fileTree.setSelectionModel(this.fileSelection);
            this.fileSelection.addObserver(this);
            if (OsNameHelper.isMac()) {
                this.fileTree.setRowHeight(XissWebUI.getIcon(PPROJECT_ROOT_ICON).getIconHeight());
            }
            this.fileTree.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    FileManager.this.onMouseClicked(e);
                }
            });
            this.fileTree.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    FileManager.this.onKeyPressedAction(e);
                }
            });
            this.fileTree.setTransferHandler(new FileTransferHandler(this));
            this.fileTree.setDragEnabled(true);
            this.fileTree.setEnabled(true);
        }
        return this.fileTree;
    }

    public FileTreeModel getFileTreeModel() {
        return (FileTreeModel)this.fileTree.getModel();
    }

    private JPanel getFileSelectionPanel() {
        if (this.fileSelectionPanel == null) {
            this.selectLabel = new JLabel();
            this.selectLabel.setText("");
            this.selectLabel.setHorizontalAlignment(0);
            this.selectLabel.setHorizontalTextPosition(0);
            this.selectLabel.setFont(new Font("Dialog", 0, 11));
            this.fileSelectionPanel = new JPanel();
            this.fileSelectionPanel.setLayout(new BorderLayout());
            this.fileSelectionPanel.add((Component)this.getUnselectAllButton(), "South");
            this.fileSelectionPanel.add(this.selectLabel);
            this.fileSelectionPanel.setVisible(false);
        }
        return this.fileSelectionPanel;
    }

    private JButton getUnselectAllButton() {
        if (this.unselectAllButton == null) {
            this.unselectAllButton = new JButton();
            this.textDisplayer.register(this.unselectAllButton, "file.unselect.all");
            this.textDisplayer.registerToolTip(this.unselectAllButton, "file.unselect.all.tooltip");
            this.unselectAllButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileManager.this.unselectAll();
                }
            });
        }
        return this.unselectAllButton;
    }

    public void setShowFiles(boolean showFiles) {
        this.showFilesTreeFilter = showFiles;
        this.getHideShowAllFiles().setSelected(showFiles);
    }

    public void setShowImageInSlideShows(boolean showImageInSlideShows) {
        this.showImageInSlideShowsTreeFilter = showImageInSlideShows;
        this.getHideShowImageFile().setSelected(showImageInSlideShows);
    }

    public boolean isShowFilesTreeFilter() {
        return this.showFilesTreeFilter;
    }

    public boolean isShowImageInSlideShowsTreeFilter() {
        return this.showImageInSlideShowsTreeFilter;
    }

    public String getDefaultValue(PreferenceInfo prefInfo) {
        return null;
    }

    public FileManagerObserver getObserver() {
        return this.observer;
    }

    public void setObserver(FileManagerObserver observer) {
        this.observer = observer;
    }

    void onMouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.onDoubleClick(e);
        } else if (e.getClickCount() == 1 && e.getButton() == 3) {
            this.onRightClick(e);
        } else if (e.getClickCount() == 1 && e.getButton() == 1) {
            this.onSimpleClick(e);
        }
    }

    public void applySelection(String selection) {
        String strSelection = Main.preferences.get(SELECTION_KEY, this.getClass(), null);
        if (strSelection != null) {
            Main.get().getXissWeb().getProjectPrefs().storeFileSelection(strSelection);
            Main.preferences.remove(SELECTION_KEY, this.getClass());
        }
        HashSet<DefaultMutableTreeNode> nodes = new HashSet<DefaultMutableTreeNode>();
        StringTokenizer token = new StringTokenizer(selection, SELECTION_SEPARATOR);
        while (token.hasMoreElements()) {
            String dirName = token.nextToken();
            File dir = new File(dirName);
            DefaultMutableTreeNode n = this.treeModel.getNodeFromUserObject(dir);
            if (n == null) continue;
            nodes.add(n);
        }
        this.fileSelection.setCheckedNodes(nodes);
    }

    private void storeFileSelectionPreference() {
        if (Main.get().hasCurrentProject()) {
            Set directories = this.fileSelection.getAllDircetorySelection();
            StringBuffer strBuff = new StringBuffer();
            Iterator i = directories.iterator();
            while (i.hasNext()) {
                File f = (File)i.next();
                strBuff.append(f.getAbsolutePath());
                if (!i.hasNext()) continue;
                strBuff.append(SELECTION_SEPARATOR);
            }
            Main.get().getXissWeb().getProjectPrefs().storeFileSelection(strBuff.toString());
        }
    }

    public void unselectAll() {
        this.fileSelection.uncheckAll();
    }

    void onKeyPressedAction(KeyEvent e) {
        if (e.getKeyCode() == 116) {
            this.initFileTree(Main.get().getCurrentProject());
        }
    }

    private boolean confirmContinueAction(Object message, String titleKey, ImageIcon icon) {
        return this.confirmAction(message, titleKey, icon, new String[]{this.textDisplayer.getString("option.continue"), this.textDisplayer.getString("option.cancel")});
    }

    private boolean confirmAction(Object message, String titleKey, ImageIcon icon, Object[] options) {
        return this.actionOption(message, titleKey, icon, options) == 0;
    }

    private int actionOption(Object message, String titleKey, ImageIcon icon, Object[] options) {
        return XissWebUI.showConfirmAction(message, this.textDisplayer.getString(titleKey), icon, options);
    }

    private File getCurrentFileToEdit() {
        File f = this.getFileUnderMenu();
        return SlideShowProject.isSkinFile(f) ? SlideShowProject.getSkinEditableFile(f) : f;
    }

    private void onDoubleClick(MouseEvent e) {
        File f;
        if (this.setNodeUnderMenu(e) && ((f = this.getFileUnderMenu()).isFile() || SlideShowProject.isSkinFile(f))) {
            File toEdit = this.getCurrentFileToEdit();
            if (Main.get().getEditorManager().isEditable(toEdit.getName())) {
                Main.get().getEditorManager().openEditor(toEdit.getName(), (Object)toEdit);
            }
        }
    }

    private void onSimpleClick(MouseEvent e) {
        DefaultMutableTreeNode node = TreeHelper.getNode(this.fileTree, e);
        if (node != null && this.fileSelection.isCheckableNode(node)) {
            this.fileSelection.managedCheckedElement(node);
        }
        this.fileSelection.selectionChanged = false;
    }

    public void fileSelectionChanged(FileSelection selection) {
        this.storeFileSelectionPreference();
        this.updateSelectionInfo(selection);
    }

    private void updateSelectionInfo(FileSelection selection) {
        if (Main.get().hasCurrentProject()) {
            StringBuffer buffTxt = new StringBuffer();
            int nbSelection = selection.countDirectorySelection(!Main.get().getCurrentProject().isRepositoryProject());
            if (nbSelection > 0) {
                buffTxt.append(nbSelection).append(' ');
                if (nbSelection > 1) {
                    buffTxt.append(TextDisplayer.getString("file.selection.directories", this.getClass()));
                } else {
                    buffTxt.append(TextDisplayer.getString("file.selection.directory", this.getClass()));
                }
            }
            if (selection.hasSlideShowSelection()) {
                buffTxt.append(", ").append(selection.getSlideShowSelectionCount()).append(' ');
                if (selection.getSlideShowSelectionCount() > 1) {
                    buffTxt.append(TextDisplayer.getString("file.selection.slide.shows", this.getClass()));
                } else {
                    buffTxt.append(TextDisplayer.getString("file.selection.slide.show", this.getClass()));
                }
            }
            this.selectLabel.setText(buffTxt.toString());
            this.fileSelectionPanel.setVisible(nbSelection > 0);
        }
    }

    private void onRightClick(MouseEvent e) {
        if (this.setNodeUnderMenu(e)) {
            File file = this.getFileUnderMenu();
            SlideShowProject project = Main.get().getCurrentProject();
            if (file.isFile() && !".project".equals(file.getName())) {
                this.showFilePopupMenu(e);
            } else if (file.isDirectory()) {
                if (file.getName().equals("skins")) {
                    this.showDirPopupMenu(e);
                } else if (SlideShowProject.isSkinFile(file)) {
                    this.showFilePopupMenu(e);
                } else if (!project.isInOrigin(file) && !project.isInRepository(file) && !FileManager.isDirectImageDirSlideShow(file) || project.getLocation().equals(file)) {
                    this.showDirPopupMenu(e);
                }
            } else if (file.equals(project.getRepositoryDirectory())) {
                Main.get().getXissWeb().getNoRepositoryPopupMenu().show(this.fileTree, e.getX(), e.getY());
            } else if (file.equals(project.getOriginDiretory())) {
                Main.get().getXissWeb().getNoOriginDirPopupMenu().show(this.fileTree, e.getX(), e.getY());
            } else if (file.equals(project.getSrcDirectory()) && !project.isRepositoryProject() && !project.isReverseProject()) {
                Main.get().getXissWeb().getNoSrcDirPopupMenu().show(this.fileTree, e.getX(), e.getY());
            }
        }
    }

    private void showDirPopupMenu(MouseEvent e) {
        SlideShowProject project = Main.get().getCurrentProject();
        File file = this.getFileUnderMenu();
        boolean isInSrc = project.isInSrc(file);
        boolean isSkinsDir = file.getName().equals("skins");
        boolean isSrc = project.isSrcDirectory(file);
        boolean isSlideshow = SlideShowDirectory.isSlideshowDirectory(file, project.getProperties());
        boolean isRoot = file.equals(project.getLocation());
        File layout = SlideShowProject.getLayoutFileInDir(file);
        File content = new File(file, "slideshow.xml");
        this.textDisplayer.register(this.getAddLayoutMenu(), layout.exists() && !layout.equals(this.layoutToPast) ? "menu.dir.replace.layout" : "menu.dir.add.layout");
        this.getNewFolderMenuItem().setVisible(!isSkinsDir);
        this.getNewFileMenuItem().setVisible(!isSkinsDir);
        this.getRenameFolderMenuItem().setEnabled(!isSkinsDir && !isRoot && !isSrc);
        this.getDeleteFolderMenuItem().setEnabled(!isRoot && !isSrc);
        this.getAddSkinMenuItem().setVisible(isSkinsDir || isRoot);
        this.getDirMenuFolderSeparator().setVisible(isRoot || isInSrc);
        this.getNewLayoutMenuItem().setVisible(isRoot || isInSrc);
        this.getAddLayoutMenu().setVisible(isRoot || isInSrc);
        this.getDirMenuSeparator().setVisible(isSlideshow && isInSrc || isRoot);
        this.getRefreshMenuItem().setVisible(isRoot);
        this.getHideShowAllFiles().setVisible(isRoot);
        this.getHideShowImageFile().setVisible(isRoot);
        this.getSowDirMenuItem().setVisible(isSlideshow && isInSrc);
        this.getBuildDirMenuItem().setVisible(isSlideshow && isInSrc);
        this.getBuildDirMenuItem().setEnabled(content.exists() && isInSrc);
        this.getShowDirMenuItem().setVisible(isSlideshow && isInSrc);
        this.getShowDirMenuItem().setEnabled(ShowHelper.hasHtmlToShow(file));
        this.getDirPopupMenu().show(this.fileTree, e.getX(), e.getY());
    }

    private void showFilePopupMenu(MouseEvent e) {
        File file = this.getFileUnderMenu();
        Editor ed = Main.get().getEditorsContainer().getEditor(this.getCurrentFileToEdit());
        boolean isInSrc = !Main.get().getCurrentProject().isInOrigin(file) && !Main.get().getCurrentProject().isInRepository(file);
        boolean isLayout = SlideShowProject.isLayoutFile(file);
        boolean isContent = SlideShowProject.isContentFile(file);
        boolean isEditable = Main.get().getEditorManager().isEditable(file.getName());
        boolean isReadOnly = ed == null || ed.isReadOnly();
        boolean isProperties = SlideShowProject.isProjectPropertiesFile(file);
        this.getOpenMenuFileItem().setEnabled(ed == null);
        this.getSaveMenuFileItem().setVisible(!isReadOnly);
        this.getSaveMenuFileItem().setEnabled(ed != null && ed.hasDocumentModified());
        this.getCancelMenuFileItem().setVisible(!isReadOnly);
        this.getCancelMenuFileItem().setEnabled(isEditable && ed != null && ed.hasDocumentModified());
        this.getCloseMenuFileItem().setEnabled(ed != null);
        this.getOpenWithMenu().setVisible(this.multipleEditorFile(file));
        this.getSlideshowSeparator().setVisible(isContent);
        this.getSlideshowBuildMenu().setVisible(isContent);
        this.getSlideshowShowMenu().setVisible(isContent);
        this.getSlideshowShowMenu().setEnabled(ShowHelper.hasHtmlToShow(file.getParentFile()));
        this.getFileSeparator().setVisible(isInSrc);
        this.getRenameFileMenuItem().setVisible(isInSrc);
        this.getRenameFileMenuItem().setEnabled(!isLayout && !isContent && !isProperties);
        this.getDeleteFileMenuItem().setVisible(isInSrc);
        this.getDeleteFileMenuItem().setEnabled(!isContent && !isProperties);
        this.getFilePopupMenu().show(this.fileTree, e.getX(), e.getY());
    }

    private boolean multipleEditorFile(File file) {
        return TextEditor.isTextEditable(SlideShowProject.isSkinFile(file) ? file.list()[0] : file.getName());
    }

    public FileSelection getFileSelection() {
        return this.fileSelection;
    }

    private boolean setNodeUnderMenu(MouseEvent e) {
        this.nodeUnderMenu = null;
        TreePath selPath = this.fileTree.getPathForLocation(e.getX(), e.getY());
        if (selPath != null) {
            this.nodeUnderMenu = (DefaultMutableTreeNode)selPath.getLastPathComponent();
        }
        return this.nodeUnderMenu != null;
    }

    File getFileUnderMenu() {
        return (File)this.nodeUnderMenu.getUserObject();
    }

    public void initFileTree(SlideShowProject project) {
        DefaultMutableTreeNode node;
        this.fileSelection.removeObserver(this);
        HashSet<DefaultMutableTreeNode> nodes = new HashSet<DefaultMutableTreeNode>(this.fileSelection.getChechedNodes());
        HashSet<Object> files = new HashSet<Object>();
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            node = (DefaultMutableTreeNode)i.next();
            files.add(node.getUserObject());
        }
        this.fileSelection.uncheckAll();
        this.fileTree.setCellRenderer(new FileTreeCellRenderer(project));
        this.treeModel = new FileTreeModel(this, project);
        this.fileTree.setModel(this.treeModel);
        TreeHelper.expandRoot(this.fileTree);
        TreeHelper.expandNode(this.fileTree, this.treeModel.getNodeFromUserObject(project.getLocation()));
        this.textDisplayer.resetAllText();
        nodes.clear();
        i = files.iterator();
        while (i.hasNext()) {
            node = this.treeModel.getNodeFromUserObject(i.next());
            if (node == null) continue;
            nodes.add(node);
        }
        this.fileSelection.setCheckedNodes(nodes);
        this.fileSelection.addObserver(this);
    }

    private JPopupMenu getFilePopupMenu() {
        if (this.filePopupMenu == null) {
            this.filePopupMenu = new JPopupMenu();
            this.filePopupMenu.add(this.getOpenMenuFileItem());
            this.filePopupMenu.add(this.getOpenWithMenu());
            this.filePopupMenu.add(this.getSaveMenuFileItem());
            this.filePopupMenu.add(this.getCancelMenuFileItem());
            this.filePopupMenu.add(this.getCloseMenuFileItem());
            this.filePopupMenu.add(this.getSlideshowSeparator());
            this.filePopupMenu.add(this.getSlideshowBuildMenu());
            this.filePopupMenu.add(this.getSlideshowShowMenu());
            this.filePopupMenu.add(this.getFileSeparator());
            this.filePopupMenu.add(this.getRenameFileMenuItem());
            this.filePopupMenu.add(this.getDeleteFileMenuItem());
        }
        return this.filePopupMenu;
    }

    private JSeparator getFileSeparator() {
        if (this.fileSeparator == null) {
            this.fileSeparator = new JSeparator();
        }
        return this.fileSeparator;
    }

    private JMenuItem getRenameFileMenuItem() {
        if (this.renameFileMenuItem == null) {
            this.renameFileMenuItem = new JMenuItem();
            this.textDisplayer.register(this.renameFileMenuItem, "menu.file.remane");
            this.renameFileMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileManager.this.performRenameFile();
                }
            });
        }
        return this.renameFileMenuItem;
    }

    private JMenuItem getSaveMenuFileItem() {
        if (this.saveMenuFileItem == null) {
            this.saveMenuFileItem = new JMenuItem();
            this.saveMenuFileItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileManager.this.saveCurrentFile();
                }
            });
            this.textDisplayer.register(this.saveMenuFileItem, "menu.file.save");
        }
        return this.saveMenuFileItem;
    }

    private JMenuItem getCancelMenuFileItem() {
        if (this.cancelMenuFileItem == null) {
            this.cancelMenuFileItem = new JMenuItem();
            this.cancelMenuFileItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileManager.this.cancelCurrentFile();
                }
            });
            this.textDisplayer.register(this.cancelMenuFileItem, "menu.file.cancel");
        }
        return this.cancelMenuFileItem;
    }

    private JMenuItem getCloseMenuFileItem() {
        if (this.closeMenuFileItem == null) {
            this.closeMenuFileItem = new JMenuItem();
            this.closeMenuFileItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileManager.this.closeCurrentFile();
                }
            });
            this.textDisplayer.register(this.closeMenuFileItem, "menu.file.close");
        }
        return this.closeMenuFileItem;
    }

    private JMenuItem getOpenMenuFileItem() {
        if (this.openMenuFileItem == null) {
            this.openMenuFileItem = new JMenuItem();
            this.openMenuFileItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileManager.this.openCurrentFile();
                }
            });
            this.textDisplayer.register(this.openMenuFileItem, "menu.file.open");
        }
        return this.openMenuFileItem;
    }

    void openCurrentFile() {
        File toEdit = this.getCurrentFileToEdit();
        Main.get().getEditorManager().openEditor(toEdit.getName(), (Object)toEdit);
    }

    void doOpenCurrentFileInTextEditor() {
        File toEdit = this.getCurrentFileToEdit();
        Editor e = Main.get().getEditorsContainer().getEditor(toEdit);
        boolean open = true;
        if (e != null && !(e instanceof TextEditor)) {
            open = Main.get().getEditorManager().closeEditor(e);
        }
        if (open) {
            Main.get().getEditorManager().openEditor("editor.text", (Object)toEdit);
        }
    }

    void doOopenCurrentFileInGraphicEditor() {
        File toEdit = this.getCurrentFileToEdit();
        Editor e = Main.get().getEditorsContainer().getEditor(toEdit);
        boolean open = true;
        if (e != null && e instanceof TextEditor) {
            open = Main.get().getEditorManager().closeEditor(e);
        }
        if (open) {
            this.openCurrentFile();
        }
    }

    void saveCurrentFile() {
        File toEdit = this.getCurrentFileToEdit();
        Editor e = Main.get().getEditorsContainer().getEditor(toEdit);
        e.save();
    }

    void cancelCurrentFile() {
        File toEdit = this.getCurrentFileToEdit();
        Editor e = Main.get().getEditorsContainer().getEditor(toEdit);
        e.cancel();
    }

    void closeCurrentFile() {
        File toEdit = this.getCurrentFileToEdit();
        Main.get().getEditorManager().closeDocumentEditor(toEdit);
    }

    void performNewSkin() {
        File skinsDir = Main.get().getCurrentProject().getProjectSkinsDirectory();
        this.skinNameChecker.setDirectory(skinsDir);
        InputDialog dialog = this.getFolderNameInputDialog();
        dialog.setTitle(this.textDisplayer.getString("skin.enter.name.title"));
        dialog.setMessage(this.textDisplayer.getString("skin.enter.name.message"));
        dialog.setErrorMessage(this.textDisplayer.getString("skin.enter.name.error"));
        dialog.setIcon(XissWebUI.getIcon(SKIN_DOC_ICON));
        dialog.setInitialtValue(this.textDisplayer.getString("skin.enter.name.default.name"));
        FileDirectoryNameChecker checker = (FileDirectoryNameChecker)dialog.getValueChecker();
        checker.setDirectory(skinsDir);
        dialog.setVisible(true);
        if (dialog.getActonPerformed() == 0) {
            String skName = dialog.getValue();
            File template = new File(Main.get().getCurrentProject().getProperties().getSimpleSkinTemplatePath());
            if (!skinsDir.exists()) {
                skinsDir.mkdir();
            }
            File skinDir = FileHelper.checkDirectory(Main.get().getCurrentProject().getProjectSkinsDirectory(), skName);
            FileHelper.recurseCopyFiles(template, skinDir);
            DefaultMutableTreeNode node = this.treeModel.createNeededNodes(skinDir);
            this.treeModel.nodeStructureChanged(node.getParent());
            this.fileTree.setSelectionPath(new TreePath(node.getPath()));
            this.notifyObserverFileAdded(skinDir);
        }
    }

    protected void performNewFile() {
        File dir = this.getFileUnderMenu();
        DefaultMutableTreeNode node = this.nodeUnderMenu;
        InputDialog dialog = this.getFolderNameInputDialog();
        dialog.setTitle(this.textDisplayer.getString("new.file.enter.name.title"));
        dialog.setMessage(this.textDisplayer.getString("file.enter.name.message"));
        dialog.setErrorMessage(this.textDisplayer.getString("file.enter.name.error"));
        dialog.setIcon(XissWebUI.getIcon(FILE_ICON));
        dialog.setInitialtValue(this.textDisplayer.getString("file.enter.name.default.name"));
        FileDirectoryNameChecker checker = (FileDirectoryNameChecker)dialog.getValueChecker();
        checker.setDirectory(dir);
        dialog.setVisible(true);
        if (dialog.getActonPerformed() == 0) {
            File newFile = new File(dir, dialog.getValue());
            try {
                if (newFile.createNewFile()) {
                    this.treeModel.addNodeForUserObject(node, (Object)newFile);
                    this.treeModel.nodeStructureChanged(node);
                    this.notifyObserverFileAdded(newFile);
                } else {
                    XissWebUI.showErrorMessage(this.textDisplayer.getString("new.file.error.message"), this.textDisplayer.getString("new.file.error.title"));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                XissWebUI.showErrorMessage(e, this.textDisplayer.getString("new.file.error.title"));
                return;
            }
        }
    }

    private String transfretAction(boolean isCopy) {
        return isCopy ? "copy" : "move";
    }

    private boolean beforeTransfertFile(File file, boolean isCopy) {
        Object[] objectArray;
        String action = this.transfretAction(isCopy);
        Editor e = Main.get().getEditorsContainer().getEditor(file);
        if (e == null || isCopy && !e.hasDocumentModified()) {
            return true;
        }
        StringBuffer message = new StringBuffer();
        message.append(this.textDisplayer.getString("copy.move.file.before.transfer.message.1"));
        message.append(" \"").append(file.getName()).append("\" ");
        if (e.hasDocumentModified()) {
            message.append(RED_TEXT_START);
        }
        message.append(this.textDisplayer.getString("copy.move.file.before.transfer.message.2"));
        if (e.hasDocumentModified()) {
            message.append(RED_TEXT_END);
        }
        message.append(this.textDisplayer.getString(action + ".file.before.transfer.message.3"));
        if (e.hasDocumentModified()) {
            this.htmlize(message);
        }
        if (isCopy) {
            String[] stringArray = new String[3];
            stringArray[0] = this.textDisplayer.getString("copy.file.before.transfer.option.save");
            stringArray[1] = this.textDisplayer.getString("copy.file.before.transfer.option.no.save");
            objectArray = stringArray;
            stringArray[2] = this.textDisplayer.getString("copy.move.file.before.transfer.option.cancel");
        } else {
            Object[] objectArray2 = new String[2];
            objectArray2[0] = this.textDisplayer.getString("move.file.before.transfer.option.continue");
            objectArray = objectArray2;
            objectArray2[1] = this.textDisplayer.getString("copy.move.file.before.transfer.option.cancel");
        }
        Object[] options = objectArray;
        int option = this.actionOption(message, action + ".file.confirm.title", FileManager.getIcon(file), options);
        if (option == 0) {
            if (isCopy) {
                Main.get().getEditorManager().saveEditor(e);
            } else {
                return Main.get().getEditorManager().closeEditor(e);
            }
        }
        return option != options.length - 1;
    }

    private boolean beforeTransfertFolder(File dircetory, boolean isCopy) {
        Object[] objectArray;
        String action = this.transfretAction(isCopy);
        List le = this.getOpenedFiles(dircetory, isCopy);
        if (le.isEmpty()) {
            return true;
        }
        if (isCopy) {
            String[] stringArray = new String[3];
            stringArray[0] = this.textDisplayer.getString("copy.folder.before.transfer.option.save");
            stringArray[1] = this.textDisplayer.getString("copy.folder.before.transfer.option.no.save");
            objectArray = stringArray;
            stringArray[2] = this.textDisplayer.getString("copy.move.folder.before.transfer.option.cancel");
        } else {
            Object[] objectArray2 = new String[2];
            objectArray2[0] = this.textDisplayer.getString("move.folder.before.transfer.option.continue");
            objectArray = objectArray2;
            objectArray2[1] = this.textDisplayer.getString("copy.move.folder.before.transfer.option.cancel");
        }
        Object[] options = objectArray;
        StringBuffer message = new StringBuffer();
        message.append(this.textDisplayer.getString(action + ".folder.before.transfer.message.1"));
        if (!isCopy) {
            message.append(" \"").append(dircetory.getName()).append("\".");
        }
        this.appendEditors(message, le, !isCopy);
        message.append(this.textDisplayer.getString(action + ".folder.before.transfer.message.2"));
        if (isCopy) {
            message.append(" \"").append(dircetory.getName()).append("\"");
            message.append(this.textDisplayer.getString("copy.folder.before.transfer.message.3"));
        }
        this.htmlize(message);
        int option = this.actionOption(message, action + ".folder.confirm.title", FileManager.getIcon(dircetory), options);
        if (option == 0) {
            if (isCopy) {
                Main.get().getEditorManager().saveEditors(le);
            } else {
                return Main.get().getEditorManager().closeEditors(le);
            }
        }
        return option != options.length - 1;
    }

    boolean performTransferFile(File file, File target, boolean isCopy) throws Exception {
        File targetFile;
        File targetDir;
        System.out.println("performTransferFile target " + file + " " + target + " " + isCopy);
        if (!(!file.isDirectory() ? this.beforeTransfertFile(file, isCopy) : this.beforeTransfertFolder(file, isCopy))) {
            return false;
        }
        if (SlideShowProject.isLayoutFile(file)) {
            return this.performTransferLayout(file, target, isCopy);
        }
        String action = this.transfretAction(isCopy);
        int option = 0;
        if (target.isDirectory()) {
            targetDir = target;
            targetFile = new File(targetDir, file.getName());
        } else {
            targetDir = target.getParentFile();
            targetFile = new File(targetDir, file.getName());
        }
        if (isCopy && targetFile.equals(file)) {
            targetFile = this.newCopyFile(targetDir, file.getName());
        }
        option = 0;
        Editor editor = null;
        StringBuffer buff = new StringBuffer();
        if (targetFile.exists()) {
            String type = targetFile.isDirectory() ? "folder" : "file";
            editor = Main.get().getEditorsContainer().getEditor(targetFile);
            buff.append(this.textDisplayer.getString("copy.move." + type + ".confirm.message.1"));
            buff.append(" \"").append(file.getName()).append("\" ");
            buff.append(this.textDisplayer.getString("copy.move.file.confirm.message.2"));
            if (editor != null) {
                buff.append(" ").append(this.textDisplayer.getString("copy.move.file.confirm.message.3")).append(" ");
                if (editor.hasDocumentModified()) {
                    buff.append(RED_TEXT_START);
                }
                buff.append(this.textDisplayer.getString("copy.move.file.confirm.message.4"));
                if (editor.hasDocumentModified()) {
                    buff.append(RED_TEXT_END);
                }
            }
            buff.append(this.textDisplayer.getString("copy.move.file.confirm.message.5"));
            if (editor != null && editor.hasDocumentModified()) {
                this.htmlize(buff);
            }
            Object[] options = new String[]{this.textDisplayer.getString("copy.move." + type + ".option.overwite"), this.textDisplayer.getString("copy.move.file.option.create"), this.textDisplayer.getString("copy.move.file.option.cancel")};
            option = this.actionOption(buff, action + "." + type + ".confirm.title", FileManager.getIcon(targetFile), options);
        }
        switch (option) {
            case 0: {
                break;
            }
            case 1: {
                targetFile = this.newCopyFile(targetDir, file.getName());
                break;
            }
            default: {
                return false;
            }
        }
        return this.transferFile(file, targetFile, editor, isCopy);
    }

    private boolean performTransferLayout(File file, File targetFile, boolean isCopy) {
        String action = this.transfretAction(isCopy);
        boolean ok = true;
        Editor eTarget = null;
        StringBuffer buff = new StringBuffer();
        if (targetFile.exists()) {
            eTarget = Main.get().getEditorsContainer().getEditor(targetFile);
            Object[] options = new String[]{this.textDisplayer.getString("copy.move.layout.option.overwrite"), this.textDisplayer.getString("copy.move.layout.option.cancel")};
            if (eTarget != null) {
                buff.setLength(0);
                buff.append(this.textDisplayer.getString("copy.move.layout.edited.confirm.message.1"));
                if (eTarget.hasDocumentModified()) {
                    buff.append(RED_TEXT_START);
                }
                buff.append(' ').append(this.textDisplayer.getString("copy.move.layout.edited.confirm.message.2"));
                if (eTarget.hasDocumentModified()) {
                    buff.append(RED_TEXT_END);
                }
                buff.append(this.textDisplayer.getString("copy.move.layout.edited.confirm.message.3"));
                if (eTarget.hasDocumentModified()) {
                    this.htmlize(buff);
                }
                ok = this.confirmAction(buff, action + ".layout.confirm.title", FileManager.getIcon(targetFile), options);
            } else {
                ok = this.confirmAction(this.textDisplayer.getString("copy.move.layout.confirm.message"), action + ".layout.confirm.title", FileManager.getIcon(targetFile), options);
            }
        }
        if (ok) {
            return this.transferFile(file, targetFile, eTarget, isCopy);
        }
        return false;
    }

    private boolean transferFile(File file, File targetFile, Editor eTarget, boolean isCopy) {
        if (!isCopy && file.isDirectory()) {
            this.fileSelection.setCheckedNode(this.treeModel.getNodeFromUserObject(file), false);
        }
        boolean done = isCopy ? (file.isDirectory() ? FileHelper.recurseCopyFiles(file, targetFile) : FileHelper.copyFile(file, targetFile, false)) : this.moveFile(file, targetFile);
        String action = this.transfretAction(isCopy);
        if (done) {
            if (eTarget != null) {
                Main.get().getEditorManager().cancelEditor(eTarget);
            }
            if (!isCopy) {
                this.notifyObserverFileRemoved(file);
                this.notifyObserverFileAdded(targetFile);
            }
            DefaultMutableTreeNode node = this.treeModel.getNodeFromUserObject(file);
            DefaultMutableTreeNode parentSource = null;
            if (node != null && !isCopy) {
                this.fileSelection.setCheckedNode(node, false);
                parentSource = this.removeNode(node, false);
            }
            node = this.treeModel.createNeededNodes(targetFile);
            this.treeModel.nodeStructureChanged(node.getParent());
            if (!isCopy && parentSource != null) {
                TreeHelper.expandNode(this.fileTree, parentSource);
            }
            this.fileTree.setSelectionPath(new TreePath(node.getPath()));
            System.out.println(action + " DONE!");
        } else {
            StringBuffer buff = new StringBuffer();
            buff.append(this.textDisplayer.getString(action + ".file.faild.message.1"));
            buff.append(" \"").append(file).append("\" ");
            buff.append(this.textDisplayer.getString("copy.move.file.faild.message.2"));
            XissWebUI.showErrorMessage(buff, this.textDisplayer.getString(action + ".file.faild.title"));
        }
        return done;
    }

    private File newCopyFile(File directory, String fileName) {
        String newName = this.textDisplayer.getString("copy.file.copy.prefix") + fileName;
        File newFile = new File(directory, newName);
        if (newFile.exists()) {
            return this.newCopyFile(directory, newName);
        }
        return newFile;
    }

    private boolean moveFile(File sourceFile, File destinationFile) {
        boolean ok = true;
        File destSaved = null;
        if (destinationFile.exists()) {
            destSaved = new File(destinationFile.getParentFile(), destinationFile.getName() + ".saved");
            ok = destinationFile.renameTo(destSaved);
        }
        if (ok) {
            ok = sourceFile.renameTo(destinationFile);
        }
        if (ok && destSaved != null) {
            ok = destSaved.delete();
        }
        return ok;
    }

    private void htmlize(StringBuffer buff) {
        buff.insert(0, HTML_START).append(HTML_END);
    }

    void performRenameFile() {
        boolean ok;
        File file = this.getFileUnderMenu();
        boolean isSkin = SlideShowProject.isSkinFile(file);
        ImageIcon icon = FileManager.getIcon(file);
        Editor e = Main.get().getEditorManager().getEditorsContainer().getEditor(SlideShowProject.isSkinFile(file) ? SlideShowProject.getSkinEditableFile(file) : file);
        boolean bl = ok = e == null;
        if (!ok) {
            StringBuffer buff = new StringBuffer();
            buff.append(this.textDisplayer.getString("rename.file.confirm.message.1"));
            buff.append(" \"").append(file.getName()).append("\" ");
            buff.append(this.textDisplayer.getString("rename.file.confirm.message.2"));
            ok = this.confirmContinueAction(buff, "rename.file.confirm.title", icon);
        }
        if (!ok || !Main.get().getEditorManager().closeDocumentEditor(isSkin ? SlideShowProject.getSkinEditableFile(file) : file)) {
            return;
        }
        InputDialog dialog = this.getFolderNameInputDialog();
        XissWebUI.configureDialog(dialog);
        dialog.setTitle(this.textDisplayer.getString("rename.file.enter.name.title"));
        dialog.setMessage(this.textDisplayer.getString(isSkin ? "skin.enter.name.message" : "file.enter.name.message"));
        dialog.setErrorMessage(this.textDisplayer.getString(isSkin ? "skin.enter.name.error" : "file.enter.name.error"));
        FileDirectoryNameChecker checker = (FileDirectoryNameChecker)dialog.getValueChecker();
        checker.setDirectory(file.getParentFile());
        dialog.setInitialtValue(file.getName());
        dialog.setVisible(true);
        if (dialog.getActonPerformed() == 0) {
            File newFile = new File(file.getParentFile(), dialog.getValue());
            if (file.renameTo(newFile)) {
                DefaultMutableTreeNode node = this.nodeUnderMenu;
                DefaultMutableTreeNode newNode = this.treeModel.createNeededNodes(newFile);
                this.removeNode(node, true);
                this.fileTree.setSelectionPath(new TreePath(newNode.getPath()));
                this.notifyObserverFileRemoved(file);
                this.notifyObserverFileAdded(newFile);
            } else {
                XissWebUI.showErrorMessage(this.textDisplayer.getString("rename.file.error.message"), this.textDisplayer.getString("rename.file.error.title"));
            }
        }
    }

    void performDeleteFile() {
        File file = this.getFileUnderMenu();
        ImageIcon icon = FileManager.getIcon(file);
        Editor e = Main.get().getEditorManager().getEditorsContainer().getEditor(SlideShowProject.isSkinFile(file) ? SlideShowProject.getSkinEditableFile(file) : file);
        StringBuffer buff = new StringBuffer();
        buff.append(this.textDisplayer.getString("delete.file.confirm.message.1"));
        buff.append(" \"").append(file.getName()).append("\" ");
        if (e != null) {
            if (e.hasDocumentModified()) {
                buff.append(RED_TEXT_START);
            }
            buff.append(this.textDisplayer.getString("delete.file.confirm.message.2"));
            if (e.hasDocumentModified()) {
                buff.append(RED_TEXT_END);
            }
        }
        buff.append(" ").append(this.textDisplayer.getString("delete.file.confirm.message.3"));
        this.htmlize(buff);
        Object[] options = new String[]{this.textDisplayer.getString("delete.file.confirm.option.delete"), this.textDisplayer.getString("delete.file.confirm.option.cancel")};
        if (this.confirmAction(buff, "delete.file.confirm.title", icon, options)) {
            boolean deleted;
            if (e != null) {
                Main.get().getEditorManager().closeEditor(e, true);
            }
            DefaultMutableTreeNode node = this.nodeUnderMenu;
            boolean bl = deleted = file.isDirectory() ? FileHelper.recursDelete(file) : file.delete();
            if (deleted) {
                this.removeNode(node, true);
                this.notifyObserverFileRemoved(file);
            } else {
                XissWebUI.showErrorMessage(this.textDisplayer.getString("delete.file.error.message"), this.textDisplayer.getString("delete.file.error.title"));
            }
        }
    }

    private DefaultMutableTreeNode removeNode(DefaultMutableTreeNode node, boolean expand) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        parent.remove(node);
        this.treeModel.nodeStructureChanged(parent);
        if (expand) {
            TreeHelper.expandNode(this.fileTree, parent);
        }
        return parent;
    }

    private void notifyObserverFileRemoved(File file) {
        if (this.observer != null) {
            this.observer.fileRemoved(file);
        }
    }

    private void notifyObserverFileAdded(File file) {
        if (this.observer != null) {
            this.observer.fileAdded(file);
        }
    }

    public void readingImage(DirectoryActionEvent event) {
    }

    public void imageReaded(DirectoryActionEvent event) {
    }

    public void slideshowContentCreated(DirectoryActionEvent event) {
        this.treeModel.createNeededNodes(event.getFileOrDir());
        if (this.observer != null) {
            this.observer.fileAdded(event.getFileOrDir());
        }
    }

    public void slideshowContentReaded(DirectoryActionEvent event) {
    }

    public void copyingContentDir(DirectoryActionEvent event) {
    }

    public void writingSlideshowContent(DirectoryActionEvent event) {
    }

    public void slideshowContentWroten(DirectoryActionEvent event) {
        Editor editor = Main.get().getEditorsContainer().getEditor(event.getFileOrDir());
        if (editor != null) {
            editor.reload();
        }
    }

    public void visitingInDirectory(DirectoryActionEvent event) {
    }

    public void inDirectoryVisited(DirectoryActionEvent event) {
    }

    public void visitingOutDirectory(DirectoryActionEvent event) {
    }

    public void outDirectoryVisited(DirectoryActionEvent event) {
    }

    public void copyingImage(DirectoryActionEvent event) {
    }

    public void resizingImage(DirectoryActionEvent event) {
    }

    public void imageResized(DirectoryActionEvent event) {
    }

    public void creatingThumbnail(DirectoryActionEvent event) {
    }

    public void generateIndexPage(DirectoryActionEvent event) {
    }

    public void generateImagePage(DirectoryActionEvent event) {
    }

    public void copySkin(DirectoryActionEvent event) {
    }

    private JPopupMenu getDirPopupMenu() {
        if (this.dirPopupMenu == null) {
            this.dirPopupMenu = new JPopupMenu();
            this.dirPopupMenu.add(this.getAddSkinMenuItem());
            this.dirPopupMenu.add(this.getNewLayoutMenuItem());
            this.dirPopupMenu.add(this.getAddLayoutMenu());
            this.dirPopupMenu.add(this.getDirMenuSeparator());
            this.dirPopupMenu.add(this.getRefreshMenuItem());
            this.dirPopupMenu.add(this.getHideShowImageFile());
            this.dirPopupMenu.add(this.getHideShowAllFiles());
            this.dirPopupMenu.add(this.getSowDirMenuItem());
            this.dirPopupMenu.add(this.getBuildDirMenuItem());
            this.dirPopupMenu.add(this.getShowDirMenuItem());
            this.dirPopupMenu.add(this.getDirMenuFolderSeparator());
            this.dirPopupMenu.add(this.getNewFolderMenuItem());
            this.dirPopupMenu.add(this.getNewFileMenuItem());
            this.dirPopupMenu.add(new JSeparator());
            this.dirPopupMenu.add(this.getRenameFolderMenuItem());
            this.dirPopupMenu.add(this.getDeleteFolderMenuItem());
        }
        return this.dirPopupMenu;
    }

    private JMenuItem getDeleteFolderMenuItem() {
        if (this.deleteFolderMenuItem == null) {
            this.deleteFolderMenuItem = new JMenuItem();
            this.textDisplayer.register(this.deleteFolderMenuItem, "menu.dir.delete.folder.item");
            this.deleteFolderMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileManager.this.performDeleteFolder();
                }
            });
        }
        return this.deleteFolderMenuItem;
    }

    private JMenuItem getRenameFolderMenuItem() {
        if (this.renameFolderMenuItem == null) {
            this.renameFolderMenuItem = new JMenuItem();
            this.textDisplayer.register(this.renameFolderMenuItem, "menu.dir.rename.folder.item");
            this.renameFolderMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileManager.this.performRenameFolder();
                }
            });
        }
        return this.renameFolderMenuItem;
    }

    private JMenuItem getNewFolderMenuItem() {
        if (this.newFolderMenuItem == null) {
            this.newFolderMenuItem = new JMenuItem();
            this.textDisplayer.register(this.newFolderMenuItem, "menu.dir.new.folder.item");
            this.newFolderMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileManager.this.performNewFolder();
                }
            });
        }
        return this.newFolderMenuItem;
    }

    private JMenuItem getNewFileMenuItem() {
        if (this.newFileMenuItem == null) {
            this.newFileMenuItem = new JMenuItem();
            this.textDisplayer.register(this.newFileMenuItem, "menu.dir.new.file.item");
            this.newFileMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileManager.this.performNewFile();
                }
            });
        }
        return this.newFileMenuItem;
    }

    void performNewFolder() {
        DefaultMutableTreeNode parentNode = this.nodeUnderMenu;
        InputDialog dialog = this.getFolderNameInputDialog();
        dialog.setTitle(this.textDisplayer.getString("new.folder.enter.name.title"));
        XissWebUI.configureDialog(dialog);
        File file = this.getFileUnderMenu();
        FileDirectoryNameChecker checker = (FileDirectoryNameChecker)dialog.getValueChecker();
        checker.setDirectory(file);
        dialog.setInitialtValue(this.textDisplayer.getString("folder.enter.name.default.name"));
        dialog.setMessage(this.textDisplayer.getString("folder.enter.name.message"));
        dialog.setErrorMessage(this.textDisplayer.getString("folder.enter.name.error"));
        dialog.setVisible(true);
        if (dialog.getActonPerformed() == 0) {
            String value = dialog.getValue();
            File newDir = new File(file, value);
            if (newDir.mkdir()) {
                DefaultMutableTreeNode node = this.treeModel.addNodeForUserObject(parentNode, (Object)newDir);
                this.treeModel.nodeStructureChanged(parentNode);
                this.fileTree.setSelectionPath(new TreePath(node.getPath()));
            } else {
                StringBuffer buff = new StringBuffer();
                buff.append(this.textDisplayer.getString("new.folder.error.message")).append(' ');
                buff.append(newDir);
                XissWebUI.showErrorMessage(buff, this.textDisplayer.getString("new.folder.error.title"));
            }
        }
    }

    private List getOpenedFiles(File file, boolean modifiedOnly) {
        DefaultMutableTreeNode node = this.treeModel.getNodeFromUserObject(file);
        return node == null ? new ArrayList() : this.getOpenedFiles(node, modifiedOnly);
    }

    private List getOpenedFiles(DefaultMutableTreeNode node, boolean modifiedOnly) {
        ArrayList<Editor> editors = new ArrayList<Editor>();
        EditorManager eManager = Main.get().getEditorManager();
        Enumeration<TreeNode> e = node.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
            File f = (File)n.getUserObject();
            Editor editor = eManager.getEditorsContainer().getEditor(f);
            if (editor == null || modifiedOnly && !editor.hasDocumentModified()) continue;
            editors.add(editor);
        }
        return editors;
    }

    private List getFilesInHierarchy(DefaultMutableTreeNode node) {
        ArrayList<File> files = new ArrayList<File>();
        Enumeration<TreeNode> e = node.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
            File f = (File)n.getUserObject();
            if (!f.isFile()) continue;
            files.add(f);
        }
        return files;
    }

    private void appendEditors(StringBuffer buff, List editors, boolean modified) {
        buff.append(UL_START);
        Iterator i = editors.iterator();
        while (i.hasNext()) {
            Editor e = (Editor)i.next();
            buff.append(LI_START);
            buff.append(e.getDocumentName());
            if (modified && e.hasDocumentModified()) {
                buff.append(" ").append(RED_TEXT_START).append(this.textDisplayer.getString("file.modified")).append(RED_TEXT_END);
            }
            buff.append(LI_END);
        }
        buff.append(UL_END);
    }

    void performRenameFolder() {
        File dir = this.getFileUnderMenu();
        List editors = this.getOpenedFiles(this.nodeUnderMenu, false);
        List files = this.getFilesInHierarchy(this.nodeUnderMenu);
        boolean ok = editors.isEmpty();
        if (!ok) {
            StringBuffer buff = new StringBuffer();
            buff.append(this.textDisplayer.getString("folder.rename.close.editors.message.1"));
            buff.append(" \"").append(dir.getName()).append("\" ");
            buff.append(this.textDisplayer.getString("folder.rename.close.editors.message.2"));
            this.appendEditors(buff, editors, false);
            this.htmlize(buff);
            ok = this.confirmContinueAction(buff, "folder.rename.close.editors.title", FileManager.getIcon(dir));
            if (ok) {
                ok = Main.get().getEditorManager().closeEditors(editors);
            }
        }
        if (ok) {
            InputDialog dialog = this.getFolderNameInputDialog();
            XissWebUI.configureDialog(dialog);
            dialog.setTitle(this.textDisplayer.getString("rename.folder.enter.name.title"));
            dialog.setMessage(this.textDisplayer.getString("folder.enter.name.message"));
            dialog.setErrorMessage(this.textDisplayer.getString("folder.enter.name.error"));
            FileDirectoryNameChecker checker = (FileDirectoryNameChecker)dialog.getValueChecker();
            checker.setDirectory(dir.getParentFile());
            dialog.setInitialtValue(dir.getName());
            dialog.setVisible(true);
            if (dialog.getActonPerformed() == 0) {
                DefaultMutableTreeNode node = this.nodeUnderMenu;
                String newName = dialog.getValue();
                File newDir = new File(dir.getParentFile(), newName);
                if (dir.renameTo(newDir)) {
                    this.treeModel.addDirHierarchy(newDir);
                    DefaultMutableTreeNode newNode = this.treeModel.getNodeFromUserObject(newDir);
                    boolean isCheched = this.fileSelection.isCheckableNode(node);
                    if (isCheched) {
                        this.fileSelection.setCheckedNode(node, false);
                    }
                    this.removeNode(node, true);
                    this.fileTree.setSelectionPath(new TreePath(newNode.getPath()));
                    if (isCheched) {
                        this.fileSelection.setCheckedNode(newNode, true);
                    }
                    if (this.observer != null) {
                        File file;
                        Iterator i = files.iterator();
                        while (i.hasNext()) {
                            file = (File)i.next();
                            this.observer.fileRemoved(file);
                        }
                        files = this.getFilesInHierarchy(newNode);
                        i = files.iterator();
                        while (i.hasNext()) {
                            file = (File)i.next();
                            this.observer.fileAdded(file);
                        }
                    }
                } else {
                    StringBuffer buff = new StringBuffer();
                    buff.append(this.textDisplayer.getString("folder.rename.error.message.1")).append(" \"");
                    buff.append(dir.getName()).append("\" ");
                    buff.append(this.textDisplayer.getString("folder.rename.error.message.2")).append(" \"");
                    buff.append(newDir.getName()).append("\".");
                    XissWebUI.showErrorMessage(buff, this.textDisplayer.getString("folder.rename.error.title"));
                }
            }
        }
    }

    void performDeleteFolder() {
        File dir = this.getFileUnderMenu();
        List editors = this.getOpenedFiles(this.nodeUnderMenu, false);
        List files = this.getFilesInHierarchy(this.nodeUnderMenu);
        StringBuffer buff = new StringBuffer();
        buff.append(this.textDisplayer.getString("delete.folder.confirm.message.1")).append(" \"");
        buff.append(dir.getName()).append("\" ");
        buff.append(this.textDisplayer.getString(FileHelper.isEmpty(dir) ? "delete.folder.empty.confirm.message.2" : "delete.folder.confirm.message.2"));
        if (!editors.isEmpty()) {
            buff.append(BR_TAG);
            buff.append(this.textDisplayer.getString("delete.folder.confirm.message.3"));
            this.appendEditors(buff, editors, true);
        }
        this.htmlize(buff);
        Object[] options = new String[]{this.textDisplayer.getString("delete.folder.confirm.option.delete"), this.textDisplayer.getString("delete.folder.confirm.option.cancel")};
        boolean ok = this.confirmAction(buff, "delete.folder.confirm.title", FileManager.getIcon(dir), options);
        if (ok && !editors.isEmpty()) {
            ok = Main.get().getEditorManager().closeEditors(editors);
        }
        if (ok) {
            DefaultMutableTreeNode node = this.nodeUnderMenu;
            boolean deleted = FileHelper.recursDelete(dir);
            if (this.observer != null) {
                Iterator i = files.iterator();
                while (i.hasNext()) {
                    File file = (File)i.next();
                    if (file.exists()) continue;
                    this.observer.fileRemoved(file);
                }
            }
            if (!deleted) {
                XissWebUI.showErrorMessage(this.textDisplayer.getString("delete.folder.error.message"), this.textDisplayer.getString("delete.folder.error.title"));
                this.initFileTree(Main.get().getCurrentProject());
            } else {
                this.fileSelection.setCheckedNode(node, false);
                this.removeNode(node, true);
            }
        }
    }

    private InputDialog getFolderNameInputDialog() {
        if (this.folderNameInputDialog == null) {
            this.folderNameInputDialog = new InputDialog(Main.get().getXissWeb(), "title", this.textDisplayer.getString("folder.enter.name.message"), XissWebUI.getIcon("/images/file/directory.png"), new FileDirectoryNameChecker(), this.textDisplayer.getString("folder.enter.name.error"), "");
            ComponentConfigurator.configure((Component)this.folderNameInputDialog, (String)PERFS_FOLDER_NAME_INPUT_DIALOG);
        }
        return this.folderNameInputDialog;
    }

    private JCheckBoxMenuItem getHideShowAllFiles() {
        if (this.hideShowAllFiles == null) {
            this.hideShowAllFiles = new JCheckBoxMenuItem();
            this.hideShowAllFiles.setSelected(this.showFilesTreeFilter);
            this.textDisplayer.register(this.hideShowAllFiles, "menu.dir.hide.show.files.item");
            this.hideShowAllFiles.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    FileManager.this.performHideShowAllFiles();
                }
            });
        }
        return this.hideShowAllFiles;
    }

    void performHideShowAllFiles() {
        this.showFilesTreeFilter = this.hideShowAllFiles.isSelected();
        Main.preferences.putBoolean(PREFS_SHOW_FILES, this.getClass(), this.showFilesTreeFilter);
        Main.get().getXissWeb().getProjectPrefs().storeFilterShowAllFiles(this.showFilesTreeFilter);
        this.initFileTree(Main.get().getCurrentProject());
    }

    void performHideShowImageFiles() {
        this.showImageInSlideShowsTreeFilter = this.hideShowImageFiles.isSelected();
        Main.preferences.putBoolean(PREFS_SHOW_IMAGES_IN_SLIDE_SHOWS, this.getClass(), this.showImageInSlideShowsTreeFilter);
        Main.get().getXissWeb().getProjectPrefs().storeFilterShowImageInSlideShow(this.showFilesTreeFilter);
        this.initFileTree(Main.get().getCurrentProject());
    }

    private JCheckBoxMenuItem getHideShowImageFile() {
        if (this.hideShowImageFiles == null) {
            this.hideShowImageFiles = new JCheckBoxMenuItem();
            this.hideShowImageFiles.setSelected(this.showImageInSlideShowsTreeFilter);
            this.textDisplayer.register(this.hideShowImageFiles, "menu.dir.hide.show.image.files.item");
            this.hideShowImageFiles.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    FileManager.this.performHideShowImageFiles();
                }
            });
        }
        return this.hideShowImageFiles;
    }

    private JMenuItem getRefreshMenuItem() {
        if (this.refreshMenuItem == null) {
            this.refreshMenuItem = new JMenuItem();
            this.refreshMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
            this.textDisplayer.register(this.refreshMenuItem, "menu.dir.refresh.item");
            this.refreshMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileManager.this.initFileTree(Main.get().getCurrentProject());
                }
            });
        }
        return this.refreshMenuItem;
    }

    void performAddLayout(String layoutName) {
        File f = new File(Main.get().getCurrentProject().getProperties().getLayoutsBaseDir(), layoutName + File.separator + "layout.xml");
        try {
            this.performTransferFile(f, this.getFileUnderMenu(), true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void performNewLayout() {
        SlideShowLayoutInfo layout = SlideShowLayoutInfo.emptyLayout();
        try {
            File file = this.getFileUnderMenu();
            File origin = new File(System.getProperty("java.io.tmpdir"), "layout.xml");
            new LayoutSerializer(Main.get().getCurrentProject().getProperties().getSlideshowEncoding()).serialize(layout, origin);
            this.performTransferFile(origin, file, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JSeparator getSlideshowSeparator() {
        if (this.slideshowSeparator == null) {
            this.slideshowSeparator = new JSeparator();
        }
        return this.slideshowSeparator;
    }

    private JMenuItem getSlideshowShowMenu() {
        if (this.slideshowShowMenu == null) {
            this.slideshowShowMenu = new JMenuItem();
            this.textDisplayer.register(this.slideshowShowMenu, "menu.slideshow.show");
            this.slideshowShowMenu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileManager.this.performSlideshowShow(FileManager.this.getFileUnderMenu().getParentFile());
                }
            });
        }
        return this.slideshowShowMenu;
    }

    void performSlideshowShow(File slideShowDir) {
        ShowHelper.performShowSlideshowDir(slideShowDir);
    }

    private JMenuItem getSlideshowBuildMenu() {
        if (this.slideshowBiuldMenu == null) {
            this.slideshowBiuldMenu = new JMenuItem();
            this.textDisplayer.register(this.slideshowBiuldMenu, "menu.slideshow.build");
            this.slideshowBiuldMenu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileManager.this.performSlideshowBuild(FileManager.this.getFileUnderMenu());
                }
            });
        }
        return this.slideshowBiuldMenu;
    }

    void performSlideshowBuild(File contentFile) {
        boolean ok = true;
        Editor e = Main.get().getEditorsContainer().getEditor(contentFile);
        if (e != null && e.hasDocumentModified()) {
            ok = Main.get().getEditorManager().querySaveEditor(e, true, this.textDisplayer.getString("save.before.build"));
        }
        if (ok) {
            Main.get().getXissWeb().performOneSlideShowBuild(contentFile.getParentFile());
        }
    }

    private JMenu getAddLayoutMenu() {
        if (this.addLayoutMenu == null) {
            this.addLayoutMenu = new JMenu();
            this.textDisplayer.register(this.addLayoutMenu, "menu.dir.add.layout");
            this.makeAddLayoutMenu();
        }
        return this.addLayoutMenu;
    }

    private void makeAddLayoutMenu() {
        File layoutDir = Main.get().getCurrentProject().getProperties().getLayoutsBaseDir();
        File[] layouts = layoutDir.listFiles();
        for (int i = 0; i < layouts.length; ++i) {
            JMenuItem item = new JMenuItem(layouts[i].getName());
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileManager.this.performAddLayout(((JMenuItem)e.getSource()).getText());
                }
            });
            this.addLayoutMenu.add(item);
        }
    }

    private JMenuItem getNewLayoutMenuItem() {
        if (this.newLayoutMenuItem == null) {
            this.newLayoutMenuItem = new JMenuItem();
            this.textDisplayer.register(this.newLayoutMenuItem, "menu.dir.new.layout");
            this.newLayoutMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileManager.this.performNewLayout();
                }
            });
        }
        return this.newLayoutMenuItem;
    }

    private JMenu getOpenWithMenu() {
        if (this.openWithMenu == null) {
            this.openWithMenu = new JMenu();
            this.textDisplayer.register(this.openWithMenu, "menu.file.open.with");
            this.openWithMenu.add(this.getGraphicEditorMenuItem());
            this.openWithMenu.add(this.getTextEditorMenuItem());
        }
        return this.openWithMenu;
    }

    private JMenuItem getGraphicEditorMenuItem() {
        if (this.graphicEditorMenuItem == null) {
            this.graphicEditorMenuItem = new JMenuItem();
            this.graphicEditorMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileManager.this.doOopenCurrentFileInGraphicEditor();
                }
            });
            this.textDisplayer.register(this.graphicEditorMenuItem, "menu.open.with.graphic.editor");
        }
        return this.graphicEditorMenuItem;
    }

    private JMenuItem getTextEditorMenuItem() {
        if (this.textEditorMenuItem == null) {
            this.textEditorMenuItem = new JMenuItem();
            this.textEditorMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileManager.this.doOpenCurrentFileInTextEditor();
                }
            });
            this.textDisplayer.register(this.textEditorMenuItem, "menu.open.with.text.editor");
        }
        return this.textEditorMenuItem;
    }

    private JMenuItem getAddSkinMenuItem() {
        if (this.addSkinMenuItem == null) {
            this.addSkinMenuItem = new JMenuItem();
            this.addSkinMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileManager.this.performNewSkin();
                }
            });
            this.textDisplayer.register(this.addSkinMenuItem, "default.menu.add.skin");
        }
        return this.addSkinMenuItem;
    }

    private JMenuItem getDeleteFileMenuItem() {
        if (this.deleteFileMenuItem == null) {
            this.deleteFileMenuItem = new JMenuItem();
            this.deleteFileMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileManager.this.performDeleteFile();
                }
            });
            this.textDisplayer.register(this.deleteFileMenuItem, "menu.file.delete");
        }
        return this.deleteFileMenuItem;
    }

    private JSeparator getDirMenuFolderSeparator() {
        if (this.dirMenuFolderSeparator == null) {
            this.dirMenuFolderSeparator = new JSeparator();
        }
        return this.dirMenuFolderSeparator;
    }

    private JSeparator getDirMenuSeparator() {
        if (this.dirMenuSeparator == null) {
            this.dirMenuSeparator = new JSeparator();
        }
        return this.dirMenuSeparator;
    }

    private JMenuItem getSowDirMenuItem() {
        if (this.sowDirMenuItem == null) {
            this.sowDirMenuItem = new JMenuItem();
            this.sowDirMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileManager.this.performSowSlideshowDir(FileManager.this.getFileUnderMenu());
                }
            });
            this.textDisplayer.register(this.sowDirMenuItem, "menu.dir.sow.menu.item");
        }
        return this.sowDirMenuItem;
    }

    void performSowSlideshowDir(File slideshowDir) {
        Main.get().getXissWeb().performSow(slideshowDir);
    }

    private JMenuItem getBuildDirMenuItem() {
        if (this.buildDirMenuItem == null) {
            this.buildDirMenuItem = new JMenuItem();
            this.buildDirMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileManager.this.performSlideshowBuild(new File(FileManager.this.getFileUnderMenu(), "slideshow.xml"));
                }
            });
            this.textDisplayer.register(this.buildDirMenuItem, "menu.dir.build.menu.item");
        }
        return this.buildDirMenuItem;
    }

    private JMenuItem getShowDirMenuItem() {
        if (this.showDirMenuItem == null) {
            this.showDirMenuItem = new JMenuItem();
            this.showDirMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileManager.this.performSlideshowShow(FileManager.this.getFileUnderMenu());
                }
            });
            this.textDisplayer.register(this.showDirMenuItem, "menu.dir.show.menu.item");
        }
        return this.showDirMenuItem;
    }

    public static ImageIcon geFileIcon(File f) {
        boolean onError;
        Editor e = Main.get().getEditorManager().getEditorsContainer().getEditor(f);
        boolean bl = onError = e != null && !e.isDocumentValid();
        if (SlideShowProject.isProjectPropertiesFile(f)) {
            return XissWebUI.getIcon(PROPERTIES_SLIDE_SOW_ICON);
        }
        if (SlideShowProject.isLayoutFile(f)) {
            return XissWebUI.getIcon(onError ? LAYOUT_SLIDE_SOW_ERROR_ICON : LAYOUT_SLIDE_SOW_ICON);
        }
        if (SlideShowProject.isContentFile(f)) {
            return XissWebUI.getIcon(onError ? CONTENT_SLIDE_SOW_ERROR_ICON : CONTENT_SLIDE_SOW_ICON);
        }
        if (ImageFileHelper.isImageFile(f)) {
            return XissWebUI.getIcon(IMAGE_FILE_ICON);
        }
        String extension = FileHelper.fileNameExtention(f);
        if ("html".equalsIgnoreCase(extension)) {
            return XissWebUI.getIcon(onError ? FILE_HTML_ERROR_ICON : FILE_HTML_ICON);
        }
        if ("css".equalsIgnoreCase(extension)) {
            return XissWebUI.getIcon(FILE_CSS_ICON);
        }
        if ("xml".equalsIgnoreCase(extension)) {
            return XissWebUI.getIcon(onError ? FILE_XML_ERROR_ICON : FILE_XML_ICON);
        }
        if ("js".equalsIgnoreCase(extension)) {
            return XissWebUI.getIcon(FILE_JS_ICON);
        }
        if ("php".equalsIgnoreCase(extension)) {
            return XissWebUI.getIcon(FILE_PHP_ICON);
        }
        if ("text".equalsIgnoreCase(extension) || "txt".equalsIgnoreCase(extension)) {
            return XissWebUI.getIcon(FILE_TEXT_ICON);
        }
        return XissWebUI.getIcon(FILE_ICON);
    }

    static ImageIcon getIcon(File file) {
        SlideShowProject project = Main.get().getCurrentProject();
        ImageIcon icon = null;
        if (project != null && file.isDirectory()) {
            if (SlideShowProject.isSkinFile(file)) {
                Editor e = Main.get().getEditorManager().getEditorsContainer().getEditor(SlideShowProject.getSkinEditableFile(file));
                boolean onError = e != null && !e.isDocumentValid();
                icon = XissWebUI.getIcon(onError ? SKIN_DOC_ERROR_ICON : SKIN_DOC_ICON);
            } else {
                icon = XissWebUI.getIcon("/images/file/directory.png");
                if (project.isInOrigin(file) && project.getProperties().getExcludeDirs().contains(file.getName())) {
                    icon = XissWebUI.getIcon(EXCLUDED_DIRECTORY_ICON);
                } else if (file.equals(project.getLocation())) {
                    icon = XissWebUI.getIcon(PPROJECT_ROOT_ICON);
                } else if (file.equals(project.getSrcDirectory())) {
                    icon = project.isRepositoryProject() && Main.get().getXissWeb().isRepositoryMode() || project.isReverseProject() && Main.get().getXissWeb().isRervseMode() ? XissWebUI.getIcon(SRC_DIRECTORY_ICON) : XissWebUI.getIcon(SRC_SOW_ICON);
                } else if (SlideShowDirectory.isSlideshowDirectory(file, project.getProperties())) {
                    icon = XissWebUI.getIcon(IMAGE_DIRECTORY_ICON);
                } else if (file.equals(project.getRepositoryDirectory())) {
                    icon = Main.get().getXissWeb().isRepositoryMode() ? XissWebUI.getIcon(IMAGE_REPOSITORY_SOW_ICON) : XissWebUI.getIcon(IMAGE_REPOSITORY_ICON);
                } else if (file.equals(project.getOriginDiretory())) {
                    icon = Main.get().getXissWeb().isRervseMode() ? XissWebUI.getIcon(ORIGIN_SOW_ICON) : XissWebUI.getIcon(ORIGIN_DIRECTORY_ICON);
                } else if (file.getName().equals("skins")) {
                    icon = XissWebUI.getIcon(SKINS_DIR_ICON);
                }
            }
        } else {
            icon = FileManager.geFileIcon(file);
        }
        if (!file.exists()) {
            if (file.equals(project.getSrcDirectory())) {
                icon = project.isRepositoryProject() || project.isReverseProject() ? XissWebUI.getIcon(SRC_DIRECTORY_ICON) : XissWebUI.getIcon(SRC_ERROR_ICON);
            } else if (file.equals(project.getRepositoryDirectory())) {
                icon = XissWebUI.getIcon(IMAGE_REPOSITORY_ERROR_ICON);
            } else if (file.equals(project.getOriginDiretory())) {
                icon = XissWebUI.getIcon(ORIGIN_ERROR_ICON);
            }
        }
        return icon;
    }

    public void fileInEditionChanged(Editor editor, int status) {
        this.treeModel.nodeChanged(this.treeModel.getNodeFromUserObject(editor.getEditedDocument()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

