/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import org.xissweb.file.FileHelper;
import org.xissweb.gui.Main;
import org.xissweb.gui.file.FileManager;
import org.xissweb.gui.file.FileSelectionObserver;
import org.xissweb.project.SlideShowProject;

public class FileSelection
extends DefaultTreeSelectionModel {
    private static final long serialVersionUID = 2324260823948129074L;
    private JTree tree;
    private Set slideShowSelection = new HashSet();
    private Set checkedNodes = new HashSet();
    private Set observers = new HashSet();
    boolean selectionChanged = false;

    public FileSelection(JTree tree) {
        this.tree = tree;
        this.setSelectionMode(1);
        this.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                FileSelection.this.selectionChanged(e);
            }
        });
    }

    public void addObserver(FileSelectionObserver observer) {
        this.observers.add(observer);
    }

    public void removeObserver(FileSelectionObserver observer) {
        this.observers.remove(observer);
    }

    public Set getAllDircetorySelection() {
        HashSet<File> set = new HashSet<File>();
        Iterator i = this.checkedNodes.iterator();
        while (i.hasNext()) {
            File f = (File)((DefaultMutableTreeNode)i.next()).getUserObject();
            set.add(f);
        }
        return set;
    }

    public int countDirectorySelection(boolean excludeRepository) {
        int nb = this.checkedNodes.size();
        if (excludeRepository) {
            File baseDir = Main.get().getCurrentProject().getRepositoryDirectory();
            Iterator i = this.checkedNodes.iterator();
            while (i.hasNext()) {
                File f = (File)((DefaultMutableTreeNode)i.next()).getUserObject();
                if (!FileHelper.hasDirInPath(f, baseDir)) continue;
                --nb;
            }
        }
        return nb;
    }

    public Set getDircetorySelection() {
        return this.getDircetorySelection(false);
    }

    public Set getRepositoryDircetorySelection() {
        return this.getDircetorySelection(true);
    }

    private Set getDircetorySelection(boolean inRepository) {
        HashSet<File> set = new HashSet<File>();
        SlideShowProject project = Main.get().getCurrentProject();
        File baseDir = inRepository ? project.getRepositoryDirectory() : project.getSrcDirectory();
        Iterator i = this.checkedNodes.iterator();
        while (i.hasNext()) {
            File f = (File)((DefaultMutableTreeNode)i.next()).getUserObject();
            if (!FileHelper.hasDirInPath(f, baseDir)) continue;
            set.add(f);
        }
        return set;
    }

    public Set getSlideShowSelection() {
        return this.slideShowSelection;
    }

    public boolean hasSlideShowSelection() {
        return !this.slideShowSelection.isEmpty();
    }

    public int getSlideShowSelectionCount() {
        return this.slideShowSelection.size();
    }

    public Set getChechedNodes() {
        return this.checkedNodes;
    }

    public boolean hasCheckedNode() {
        return !this.checkedNodes.isEmpty();
    }

    public boolean isCheckedNode(DefaultMutableTreeNode node) {
        return this.checkedNodes.contains(node);
    }

    public void uncheckAll() {
        HashSet nodes = new HashSet(this.checkedNodes);
        this.checkedNodes.clear();
        this.slideShowSelection.clear();
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            ((DefaultTreeModel)this.tree.getModel()).nodeChanged((DefaultMutableTreeNode)i.next());
        }
        this.notifyObservers();
    }

    void setCheckedNodes(Set nodes) {
        this.checkedNodes.clear();
        this.slideShowSelection.clear();
        this.checkedNodes.addAll(nodes);
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)i.next();
            File f = this.slideShowFile(node);
            if (f != null) {
                this.slideShowSelection.add(f);
            }
            ((DefaultTreeModel)this.tree.getModel()).nodeChanged(node);
        }
        this.notifyObservers();
    }

    public boolean hasChildUnchecked(DefaultMutableTreeNode node) {
        boolean checkedChild = true;
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements() && checkedChild) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
            if (!this.isCheckableNode(n)) continue;
            checkedChild = this.isCheckedNode(n);
        }
        return checkedChild;
    }

    public boolean noChildrenChecked(DefaultMutableTreeNode node) {
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
            if (!this.isCheckableNode(n) || !this.isCheckedNode(n)) continue;
            return false;
        }
        return true;
    }

    void selectionChanged(TreeSelectionEvent e) {
        this.selectionChanged = true;
    }

    private void notifyObservers() {
        Iterator i = this.observers.iterator();
        while (i.hasNext()) {
            FileSelectionObserver o = (FileSelectionObserver)i.next();
            o.fileSelectionChanged(this);
        }
    }

    void managedCheckedElement(DefaultMutableTreeNode node) {
        boolean check = this.selectionChanged;
        if (!this.selectionChanged && this.tree.getSelectionPath() != null) {
            this.removeSelectionPath(this.tree.getSelectionPath());
        }
        this.setCheckedNode(node, check);
    }

    public void setCheckedNode(DefaultMutableTreeNode node, boolean check) {
        ArrayList changes = new ArrayList();
        if (check) {
            this.recursiveCheckDown(node, changes);
            this.recursiveCheckUp((DefaultMutableTreeNode)node.getParent(), changes);
        } else {
            this.recursiveUncheckDown(node, changes);
            this.recursiveUncheckUp((DefaultMutableTreeNode)node.getParent(), changes);
        }
        Iterator i = changes.iterator();
        while (i.hasNext()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)i.next();
            ((DefaultTreeModel)this.tree.getModel()).nodeChanged(n);
        }
        if (!changes.isEmpty()) {
            this.notifyObservers();
        }
    }

    private void recursiveCheckUp(DefaultMutableTreeNode node, List changes) {
        if (this.isCheckableNode(node) && this.checkedNodes.add(node)) {
            changes.add(node);
            this.recursiveCheckUp((DefaultMutableTreeNode)node.getParent(), changes);
        }
    }

    private void recursiveCheckDown(DefaultMutableTreeNode node, List changes) {
        if (this.isCheckableNode(node)) {
            if (this.checkedNodes.add(node)) {
                changes.add(node);
                File f = this.slideShowFile(node);
                if (f != null) {
                    this.slideShowSelection.add(f);
                }
            }
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                this.recursiveCheckDown(n, changes);
            }
        }
    }

    private void recursiveUncheckUp(DefaultMutableTreeNode node, List changes) {
        boolean check;
        if (this.isCheckableNode(node) && (check = this.noChildrenChecked(node)) && this.checkedNodes.remove(node)) {
            changes.add(node);
            this.recursiveUncheckUp((DefaultMutableTreeNode)node.getParent(), changes);
        }
    }

    private void recursiveUncheckDown(DefaultMutableTreeNode node, List changes) {
        if (this.isCheckableNode(node)) {
            if (this.checkedNodes.remove(node)) {
                changes.add(node);
                File f = this.slideShowFile(node);
                if (f != null) {
                    this.slideShowSelection.remove(f);
                }
            }
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                this.recursiveUncheckDown(n, changes);
            }
        }
    }

    private File slideShowFile(DefaultMutableTreeNode node) {
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
            File f = (File)n.getUserObject();
            if (!SlideShowProject.isContentFile(f)) continue;
            return f;
        }
        return null;
    }

    public boolean isRepositoryDiretory(DefaultMutableTreeNode node) {
        File f = (File)node.getUserObject();
        return FileHelper.hasDirInPath(f, Main.get().getCurrentProject().getRepositoryDirectory());
    }

    public boolean isCheckableNode(DefaultMutableTreeNode node) {
        if (!(node.getUserObject() instanceof File)) {
            return false;
        }
        File f = (File)node.getUserObject();
        return Main.get().hasCurrentProject() && f.isDirectory() && !FileHelper.isEmpty(f) && !FileManager.isDirectImageDirSlideShow(f) && (FileHelper.hasDirInPath(f, Main.get().getCurrentProject().getSrcDirectory()) || Main.get().getXissWeb().isRepositoryMode() && FileHelper.hasDirInPath(f, Main.get().getCurrentProject().getRepositoryDirectory()));
    }
}

