/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.file;

import java.awt.Component;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.xissweb.gui.file.FileManager;
import org.xissweb.gui.file.FileSelection;
import org.xissweb.gui.util.tree.AbstractCheckableTreeCellRenderer;
import org.xissweb.project.SlideShowProject;

public class FileTreeCellRenderer
extends AbstractCheckableTreeCellRenderer {
    private static final long serialVersionUID = 8854860731021099573L;
    private SlideShowProject project;

    public FileTreeCellRenderer(SlideShowProject project) {
        this.project = project;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        FileSelection fileSelection = (FileSelection)tree.getSelectionModel();
        this.checkBox.setEnabled(true);
        this.setCheckBoxVisible(fileSelection.isCheckableNode(node));
        this.setChecked(fileSelection.isCheckedNode(node) && this.isCheckBoxVisible());
        if (this.checkBox.isVisible() && fileSelection.isCheckedNode(node) && !fileSelection.hasChildUnchecked(node)) {
            this.checkBox.setEnabled(false);
        }
        return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    protected ImageIcon getIconFromNode(DefaultMutableTreeNode node) {
        if (!(node.getUserObject() instanceof File)) {
            return null;
        }
        return FileManager.getIcon((File)node.getUserObject());
    }

    protected String getStringForNode(DefaultMutableTreeNode node) {
        if (!(node.getUserObject() instanceof File)) {
            return node.toString();
        }
        File file = (File)node.getUserObject();
        String nodeText = file.getName();
        if (file.equals(this.project.getRepositoryDirectory())) {
            nodeText = this.project.getProperties().getOriginalImageRepository();
        } else if (file.equals(this.project.getOriginDiretory())) {
            nodeText = this.project.getProperties().getOriginRootDir();
        }
        return nodeText;
    }
}

