/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.layout.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.xissweb.gui.Help;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.editor.Editor;
import org.xissweb.gui.editor.EditorsContainer;
import org.xissweb.gui.editor.ValidProcessHandler;
import org.xissweb.gui.layout.LayoutEditor;
import org.xissweb.i18n.TextDisplayer;

public abstract class AbstractLayoutElementEditor
extends JPanel
implements Editor {
    private static final long serialVersionUID = -2778711659356499984L;
    protected static final String ERROR_ICON = "/images/common/error.png";
    protected static final String HELP_ICON = "/images/common/help.png";
    private static final String titleKey = "editor.title";
    protected LayoutEditor mainEditor;
    protected boolean isModified;
    protected boolean onError;
    protected boolean initializing;
    protected TextDisplayer textDisplayer;
    protected JLabel titleLabel;

    public AbstractLayoutElementEditor(LayoutEditor mainEditor) {
        this.mainEditor = mainEditor;
        this.setLayout(new GridBagLayout());
        this.initializing = true;
    }

    protected void addTitle(int gridWidth) {
        this.addTitle(gridWidth, null);
    }

    protected void addTitle(int gridWidth, String helpTag) {
        this.titleLabel = new JLabel();
        this.titleLabel.setForeground(XissWebUI.darkColor);
        this.titleLabel.setFont(XissWebUI.titleFont);
        this.textDisplayer.register(this.titleLabel, titleKey);
        GridBagConstraints titleConstraints = new GridBagConstraints();
        titleConstraints.gridx = 0;
        titleConstraints.gridy = 0;
        titleConstraints.gridwidth = gridWidth;
        titleConstraints.insets = new Insets(10, 0, 30, 0);
        titleConstraints.anchor = 10;
        this.add((Component)this.titleLabel, titleConstraints);
        if (helpTag != null) {
            this.addHelpIcon(gridWidth, helpTag);
        }
    }

    protected void addHelpIcon(int titleGridWidth, final String helpTag) {
        GridBagConstraints helpLabelConstraints = new GridBagConstraints();
        helpLabelConstraints.gridx = titleGridWidth - 1;
        helpLabelConstraints.gridy = 0;
        helpLabelConstraints.insets = new Insets(7, 0, 0, 0);
        helpLabelConstraints.anchor = 13;
        JLabel helpLabel = new JLabel();
        helpLabel.setText("");
        helpLabel.setIcon(XissWebUI.getIcon(HELP_ICON));
        helpLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Help.open(helpTag);
            }
        });
        this.add((Component)helpLabel, helpLabelConstraints);
    }

    protected abstract void initEdition();

    protected abstract void doSave();

    public void setEditorsContainer(EditorsContainer editorsContainer) {
    }

    public boolean isReadOnly() {
        return this.mainEditor.isReadOnly();
    }

    public void edit() {
        this.initializing = true;
        this.initEdition();
        this.modified(false);
        this.initializing = false;
    }

    public void edit(Object arg) {
        this.edit();
    }

    public int save() {
        this.doSave();
        this.mainEditor.modified(false);
        return 0;
    }

    public void cancel() {
        this.initEdition();
        this.modified(false);
    }

    public boolean isDocumentValid() {
        return !this.onError;
    }

    public void reload() {
        this.initEdition();
    }

    public void setValidProcessHandler(ValidProcessHandler handler) {
    }

    public ValidProcessHandler getValidProcessHandler() {
        return null;
    }

    public boolean hasDocumentModified() {
        return this.isModified;
    }

    public String getDocumentName() {
        return this.textDisplayer.getString(titleKey);
    }

    public Component getEditorGuiComponent() {
        return this;
    }

    public Icon getIcon() {
        return null;
    }

    public JMenuItem[] getMenuItems() {
        return null;
    }
}

