/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.layout.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.xissweb.data.layout.AnimationInfo;
import org.xissweb.gui.editor.DocumentException;
import org.xissweb.gui.layout.LayoutEditor;
import org.xissweb.gui.layout.editor.AbstractLayoutElementEditor;
import org.xissweb.gui.layout.editor.TransitionInfoEditor;
import org.xissweb.i18n.TextDisplayManager;

public class AnimationEditor
extends AbstractLayoutElementEditor {
    private static final long serialVersionUID = 6029092249819138993L;
    private static final String helpTag = "animation";
    private static final String[] animationKindKeys = new String[]{"animation.kind.fade", "animation.kind.superimposed.fade", "animation.kind.scroll.horizontal", "animation.kind.scroll.vertical"};
    private static final String[] animationWaitScreenSizeKeys = new String[]{"animation.wait.screen.none", "animation.wait.screen.image.area", "animation.wait.screen.full.screen"};
    private AnimationInfo animation;
    private TransitionInfoEditor transitionInfoEditor = null;
    private JComboBox animationKindComboBox = null;
    private JComboBox animationWaitScreenSizeComboBox = null;
    private JCheckBox controlPanelCheckBox = null;

    public AnimationEditor(LayoutEditor mainEditor) {
        super(mainEditor);
        this.textDisplayer = TextDisplayManager.createTextDisplayFor(this.getClass());
        this.initialize();
    }

    private void initialize() {
        JLabel animationWaitScreenSizeLabel = new JLabel();
        this.textDisplayer.register(animationWaitScreenSizeLabel, "animation.wait.screen.size");
        GridBagConstraints waitScreenSizeLabelConstraints = new GridBagConstraints();
        waitScreenSizeLabelConstraints.gridx = 0;
        waitScreenSizeLabelConstraints.gridy = 2;
        waitScreenSizeLabelConstraints.insets = new Insets(7, 15, 7, 5);
        waitScreenSizeLabelConstraints.anchor = 12;
        GridBagConstraints waitScreenSizeComboBoxConstraints = new GridBagConstraints();
        waitScreenSizeComboBoxConstraints.gridx = 1;
        waitScreenSizeComboBoxConstraints.gridy = 2;
        waitScreenSizeComboBoxConstraints.insets = new Insets(5, 5, 5, 5);
        waitScreenSizeComboBoxConstraints.anchor = 18;
        JLabel controlPanelLabel = new JLabel();
        this.textDisplayer.register(controlPanelLabel, "animation.control.panel.check.box");
        GridBagConstraints controlPanelLabelConstraints = new GridBagConstraints();
        controlPanelLabelConstraints.gridx = 0;
        controlPanelLabelConstraints.gridy = 3;
        controlPanelLabelConstraints.insets = new Insets(7, 15, 7, 5);
        controlPanelLabelConstraints.anchor = 12;
        GridBagConstraints controlPanelConstraints = new GridBagConstraints();
        controlPanelConstraints.gridx = 1;
        controlPanelConstraints.gridy = 3;
        controlPanelConstraints.insets = new Insets(5, 5, 5, 5);
        controlPanelConstraints.anchor = 18;
        controlPanelConstraints.weightx = 2000.0;
        controlPanelConstraints.weighty = 1000.0;
        GridBagConstraints kindLabelConstraints = new GridBagConstraints();
        kindLabelConstraints.gridx = 0;
        kindLabelConstraints.insets = new Insets(7, 15, 7, 5);
        kindLabelConstraints.gridy = 1;
        kindLabelConstraints.anchor = 13;
        GridBagConstraints kindComboConstraints = new GridBagConstraints();
        kindComboConstraints.fill = 0;
        kindComboConstraints.gridx = 1;
        kindComboConstraints.gridy = 1;
        kindComboConstraints.anchor = 17;
        kindComboConstraints.insets = new Insets(5, 5, 5, 5);
        JLabel animationKindLabel = new JLabel();
        this.textDisplayer.register(animationKindLabel, "animation.kind");
        GridBagConstraints trannsitionConstraints = new GridBagConstraints();
        trannsitionConstraints.anchor = 18;
        trannsitionConstraints.gridx = 2;
        trannsitionConstraints.gridy = 1;
        trannsitionConstraints.insets = new Insets(5, 5, 5, 5);
        trannsitionConstraints.weightx = 20000.0;
        this.addTitle(3, helpTag);
        this.add((Component)animationWaitScreenSizeLabel, waitScreenSizeLabelConstraints);
        this.add((Component)this.getAnimationWaitScreenSizeComboBox(), waitScreenSizeComboBoxConstraints);
        this.add((Component)animationKindLabel, kindLabelConstraints);
        this.add((Component)this.getAnimationKindComboBox(), kindComboConstraints);
        this.add((Component)this.getTransitionInfoEditor(), trannsitionConstraints);
        this.add((Component)controlPanelLabel, controlPanelLabelConstraints);
        this.add((Component)this.getControlPanelCheckBox(), controlPanelConstraints);
    }

    protected void doSave() {
        this.animation.setKind(this.getAnimationKindSelectedValue());
        this.animation.setWaitScreenSize(this.getAnimationWaitScreenSizeSelectedValue());
        this.animation.setControlPanel(this.getControlPanelCheckBox().isSelected());
    }

    protected void initEdition() {
        try {
            this.transitionInfoEditor.setEditedDocument(this.animation.getTransition());
            this.transitionInfoEditor.edit();
            this.getAnimationKindComboBox().setSelectedIndex(this.getAnimationKindIndex());
            this.getAnimationWaitScreenSizeComboBox().setSelectedIndex(this.getAnimationWaitScreenSizeIndex());
            this.getControlPanelCheckBox().setSelected(this.animation.isControlPanel());
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    private int getAnimationWaitScreenSizeIndex() {
        return this.animation.getWaitScreenSize();
    }

    private boolean getControlPanelValue() {
        return this.animation.isControlPanel();
    }

    private int getAnimationKindIndex() {
        return this.animation.getKind();
    }

    private int getAnimationKindSelectedValue() {
        return this.getAnimationKindComboBox().getSelectedIndex();
    }

    private int getAnimationWaitScreenSizeSelectedValue() {
        return this.getAnimationWaitScreenSizeComboBox().getSelectedIndex();
    }

    public void modified(boolean error) {
        if (!this.initializing) {
            boolean bl = this.isModified = this.getAnimationKindIndex() != this.getAnimationKindSelectedValue() || this.getAnimationWaitScreenSizeIndex() != this.getAnimationWaitScreenSizeSelectedValue() || this.getControlPanelValue() != this.getControlPanelCheckBox().isSelected();
            if (this.isModified) {
                this.save();
            }
        }
    }

    public Object getEditedDocument() {
        return this.animation;
    }

    public void setEditedDocument(Object document) throws DocumentException {
        this.animation = (AnimationInfo)document;
    }

    private TransitionInfoEditor getTransitionInfoEditor() {
        if (this.transitionInfoEditor == null) {
            this.transitionInfoEditor = new TransitionInfoEditor(this.mainEditor);
        }
        return this.transitionInfoEditor;
    }

    private JComboBox getAnimationKindComboBox() {
        if (this.animationKindComboBox == null) {
            this.animationKindComboBox = new JComboBox();
            this.textDisplayer.registerCombo(this.animationKindComboBox, animationKindKeys);
            this.animationKindComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    AnimationEditor.this.modified(false);
                }
            });
        }
        return this.animationKindComboBox;
    }

    private JComboBox getAnimationWaitScreenSizeComboBox() {
        if (this.animationWaitScreenSizeComboBox == null) {
            this.animationWaitScreenSizeComboBox = new JComboBox();
            this.textDisplayer.registerCombo(this.animationWaitScreenSizeComboBox, animationWaitScreenSizeKeys);
            this.animationWaitScreenSizeComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AnimationEditor.this.modified(false);
                }
            });
        }
        return this.animationWaitScreenSizeComboBox;
    }

    private JCheckBox getControlPanelCheckBox() {
        if (this.controlPanelCheckBox == null) {
            this.controlPanelCheckBox = new JCheckBox();
            this.controlPanelCheckBox.setHorizontalTextPosition(2);
            this.controlPanelCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AnimationEditor.this.modified(false);
                }
            });
        }
        return this.controlPanelCheckBox;
    }
}

