/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.layout.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.xissweb.data.layout.LocalIndexGoogleMapsInfo;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.editor.DocumentException;
import org.xissweb.gui.editor.number.IntegerValueChecker;
import org.xissweb.gui.layout.LayoutEditor;
import org.xissweb.gui.layout.editor.AbstractLayoutElementEditor;
import org.xissweb.gui.layout.editor.GoogleMapsInfoEditor;
import org.xissweb.i18n.TextDisplayManager;

public class LocalIndexGoogleMapsEditor
extends AbstractLayoutElementEditor {
    private static final long serialVersionUID = 4489494345135300017L;
    private static final String helpTag = "googleindex";
    private LocalIndexGoogleMapsInfo localIndexInfo;
    private boolean onWidthError;
    private boolean onHeightError;
    private JLabel widthLabel = null;
    private JTextField widthTextField = null;
    private JLabel heightLabel = null;
    private JTextField heightTextField = null;
    private JLabel errorLabel = null;
    private JPanel gMapsInfoPanel = null;

    public LocalIndexGoogleMapsEditor(LayoutEditor mainEditor) {
        super(mainEditor);
        this.textDisplayer = TextDisplayManager.createTextDisplayFor(this.getClass());
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gMapsInfoPanelConstraints = new GridBagConstraints();
        gMapsInfoPanelConstraints.gridx = 0;
        gMapsInfoPanelConstraints.gridwidth = 4;
        gMapsInfoPanelConstraints.weighty = 1000.0;
        gMapsInfoPanelConstraints.fill = 0;
        gMapsInfoPanelConstraints.insets = new Insets(15, 5, 5, 5);
        gMapsInfoPanelConstraints.anchor = 11;
        gMapsInfoPanelConstraints.gridy = 2;
        GridBagConstraints errorLabelConstraints = new GridBagConstraints();
        errorLabelConstraints.gridx = 1;
        errorLabelConstraints.gridy = 0;
        errorLabelConstraints.gridwidth = 3;
        errorLabelConstraints.anchor = 17;
        errorLabelConstraints.insets = new Insets(35, 0, 0, 0);
        this.errorLabel = new JLabel();
        this.errorLabel.setText("");
        this.errorLabel.setIcon(XissWebUI.getIcon("/images/common/error.png"));
        this.errorLabel.setVisible(false);
        GridBagConstraints heightTextFieldConstraints = new GridBagConstraints();
        heightTextFieldConstraints.fill = 0;
        heightTextFieldConstraints.gridx = 3;
        heightTextFieldConstraints.gridy = 1;
        heightTextFieldConstraints.weightx = 300.0;
        heightTextFieldConstraints.anchor = 17;
        heightTextFieldConstraints.gridwidth = 1;
        heightTextFieldConstraints.insets = new Insets(5, 5, 5, 5);
        GridBagConstraints heightLabelConstraints = new GridBagConstraints();
        heightLabelConstraints.gridx = 2;
        heightLabelConstraints.gridy = 1;
        heightLabelConstraints.insets = new Insets(7, 20, 7, 5);
        heightLabelConstraints.anchor = 17;
        heightLabelConstraints.weightx = 0.0;
        this.heightLabel = new JLabel();
        this.heightLabel.setText("height.label");
        this.textDisplayer.register(this.heightLabel, "height.label");
        GridBagConstraints widthTextFieldConstraints = new GridBagConstraints();
        widthTextFieldConstraints.fill = 0;
        widthTextFieldConstraints.gridx = 1;
        widthTextFieldConstraints.gridy = 1;
        widthTextFieldConstraints.weightx = 1.0;
        widthTextFieldConstraints.anchor = 17;
        widthTextFieldConstraints.insets = new Insets(5, 5, 5, 5);
        GridBagConstraints widthLabelConstraints = new GridBagConstraints();
        widthLabelConstraints.gridx = 0;
        widthLabelConstraints.gridy = 1;
        widthLabelConstraints.insets = new Insets(7, 30, 7, 5);
        widthLabelConstraints.anchor = 17;
        this.widthLabel = new JLabel();
        this.widthLabel.setText("width.label");
        this.textDisplayer.register(this.widthLabel, "width.label");
        this.addTitle(5, helpTag);
        this.add((Component)this.widthLabel, widthLabelConstraints);
        this.add((Component)this.getWidthTextField(), widthTextFieldConstraints);
        this.add((Component)this.heightLabel, heightLabelConstraints);
        this.add((Component)this.getHeightTextField(), heightTextFieldConstraints);
        this.add((Component)this.errorLabel, errorLabelConstraints);
        this.add((Component)this.getGMapsInfoPanel(), gMapsInfoPanelConstraints);
    }

    protected void doSave() {
        this.localIndexInfo.setWidth(this.getWidthValue());
        this.localIndexInfo.setHeight(this.getHeightValue());
    }

    protected void initEdition() {
        this.getWidthTextField().setText(Integer.toString(this.localIndexInfo.getWidth()));
        this.getHeightTextField().setText(Integer.toString(this.localIndexInfo.getHeight()));
        try {
            ((GoogleMapsInfoEditor)this.gMapsInfoPanel).setEditedDocument(this.localIndexInfo.getGMapsInfo());
            ((GoogleMapsInfoEditor)this.gMapsInfoPanel).edit();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    public void modified(boolean error) {
        if (!this.initializing && this.localIndexInfo != null) {
            if (!error) {
                boolean bl = this.isModified = this.localIndexInfo.getWidth() != this.getWidthValue() || this.localIndexInfo.getHeight() != this.getHeightValue();
                if (this.isModified) {
                    this.save();
                }
            }
            this.onError = error;
        }
    }

    void widthChanged() {
        String text = this.widthTextField.getText();
        int status = IntegerValueChecker.checkValue(text);
        if (status == -1 || status == 0 || status == 1) {
            this.errorLabel.setText(IntegerValueChecker.getMessage(status));
            this.errorLabel.setVisible(true);
            this.onWidthError = true;
            this.modified(true);
        } else {
            this.onWidthError = false;
            this.errorLabel.setVisible(this.onHeightError);
            this.modified(this.onHeightError);
        }
    }

    void heightChanged() {
        String text = this.heightTextField.getText();
        int status = IntegerValueChecker.checkValue(text);
        if (status == -1 || status == 0 || status == 1) {
            this.errorLabel.setText(IntegerValueChecker.getMessage(status));
            this.errorLabel.setVisible(true);
            this.onHeightError = true;
            this.modified(true);
        } else {
            this.onHeightError = false;
            this.errorLabel.setVisible(this.onWidthError);
            this.modified(this.onWidthError);
        }
    }

    private int getWidthValue() {
        return this.onWidthError ? this.localIndexInfo.getWidth() : Integer.parseInt(this.widthTextField.getText());
    }

    private int getHeightValue() {
        return this.onHeightError ? this.localIndexInfo.getHeight() : Integer.parseInt(this.heightTextField.getText());
    }

    public Object getEditedDocument() {
        return this.localIndexInfo;
    }

    public void setEditedDocument(Object document) throws DocumentException {
        this.localIndexInfo = (LocalIndexGoogleMapsInfo)document;
    }

    private JTextField getWidthTextField() {
        if (this.widthTextField == null) {
            this.widthTextField = new JTextField();
            this.widthTextField.setColumns(5);
            this.widthTextField.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    LocalIndexGoogleMapsEditor.this.widthChanged();
                }
            });
            this.widthTextField.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    LocalIndexGoogleMapsEditor.this.widthChanged();
                }
            });
        }
        return this.widthTextField;
    }

    private JTextField getHeightTextField() {
        if (this.heightTextField == null) {
            this.heightTextField = new JTextField();
            this.heightTextField.setColumns(5);
            this.heightTextField.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    LocalIndexGoogleMapsEditor.this.heightChanged();
                }
            });
            this.heightTextField.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    LocalIndexGoogleMapsEditor.this.heightChanged();
                }
            });
        }
        return this.heightTextField;
    }

    private JPanel getGMapsInfoPanel() {
        if (this.gMapsInfoPanel == null) {
            this.gMapsInfoPanel = new GoogleMapsInfoEditor(this.mainEditor);
        }
        return this.gMapsInfoPanel;
    }
}

