/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.properties;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.SoftBevelBorder;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import org.xissweb.gui.Main;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.editor.DocumentException;
import org.xissweb.gui.editor.Editor;
import org.xissweb.gui.editor.EditorsContainer;
import org.xissweb.gui.editor.ValidProcessHandler;
import org.xissweb.gui.properties.PropertiesTreeCellRenderer;
import org.xissweb.gui.properties.PropertiesTreeModel;
import org.xissweb.gui.properties.PropertiesTreeSelectionModel;
import org.xissweb.gui.properties.PropertyChangeEvent;
import org.xissweb.gui.properties.PropertyChangeListener;
import org.xissweb.gui.properties.PropertyEditorObserver;
import org.xissweb.gui.properties.PropertyValueEditor;
import org.xissweb.gui.properties.editor.PropertyAbsolutePathtEditor;
import org.xissweb.gui.properties.editor.PropertyEnumEditor;
import org.xissweb.gui.properties.editor.PropertyLayoutEditor;
import org.xissweb.gui.properties.editor.PropertyNumberEditor;
import org.xissweb.gui.properties.editor.PropertyProjectPathEditor;
import org.xissweb.gui.properties.editor.PropertySkinEditor;
import org.xissweb.gui.properties.editor.PropertyStringEditor;
import org.xissweb.gui.util.tree.TreeHelper;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.prefs.ui.SplitPaneConfigurator;
import org.xissweb.project.CategoryInfo;
import org.xissweb.project.PropertyInfo;
import org.xissweb.project.SlideShowPropInfo;
import org.xissweb.project.SlideShowProperties;

public class PropertiesEditor
extends JPanel
implements Editor,
PropertyEditorObserver,
ActionListener {
    private static final long serialVersionUID = -6660557110230487828L;
    private static final int editorPanelWidth = 300;
    public static final int editorPanelHeight = 125;
    private static final String PROPERTIES_SLIDE_SOW_ICON = "/images/file/properties.png";
    private List listeners;
    private EditorsContainer editorsContainer;
    private File propertiesFile;
    private SlideShowProperties properties;
    private HashMap newValues = new HashMap();
    private PropertiesTreeModel treeModel;
    private TextDisplayer textDisplayer;
    private PropertyValueEditor valueEditor;
    private GridBagConstraints propertyEditorConstraints;
    private JPanel onePropertyEditorPanel = null;
    private JPanel footerPanel = null;
    private JScrollPane treeScrollPane = null;
    private JTree propertiesTree = null;
    private JSplitPane mainSplitPane = null;
    private Hashtable valueEditors = new Hashtable();
    private JPanel propertyInfoPanel = null;
    private JLabel propKeyLabel = null;
    private JEditorPane infoTextArea = null;
    private JButton setDefaultButton = null;
    private JScrollPane scrollPane;
    static /* synthetic */ Class class$org$xissweb$gui$properties$PropertiesEditor;

    public PropertiesEditor() {
        this((Frame)null);
    }

    public PropertiesEditor(Frame parent) {
        this.listeners = new ArrayList();
        this.textDisplayer = TextDisplayManager.createTextDisplayFor(class$org$xissweb$gui$properties$PropertiesEditor == null ? (class$org$xissweb$gui$properties$PropertiesEditor = PropertiesEditor.class$("org.xissweb.gui.properties.PropertiesEditor")) : class$org$xissweb$gui$properties$PropertiesEditor);
        this.initialize();
        this.initEditors();
        SplitPaneConfigurator.configure((JSplitPane)this.getMainSplitPane(), (String)this.getClass().getName());
    }

    public SlideShowProperties getProperties() {
        return this.properties;
    }

    public JLabel getPropKeyLabel() {
        return this.propKeyLabel;
    }

    private void initEditors() {
        this.valueEditors.put("string value", new PropertyStringEditor());
        this.valueEditors.put("number value", new PropertyNumberEditor());
        this.valueEditors.put("enum value", new PropertyEnumEditor());
        this.valueEditors.put("project path value", new PropertyProjectPathEditor());
        this.valueEditors.put("layout value", new PropertyLayoutEditor());
        this.valueEditors.put("skin path value", new PropertyAbsolutePathtEditor());
        this.valueEditors.put("skin value", new PropertySkinEditor());
        this.valueEditors.put("path value", new PropertyAbsolutePathtEditor());
        Enumeration e = this.valueEditors.elements();
        while (e.hasMoreElements()) {
            PropertyValueEditor vEditor = (PropertyValueEditor)e.nextElement();
            vEditor.registerEditorObserver(this);
        }
    }

    public PropertyValueEditor getValueEditor(String valueType) {
        return (PropertyValueEditor)this.valueEditors.get(valueType);
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getFooterPanel(), "South");
        this.add((Component)this.getMainSplitPane(), "Center");
    }

    public void modified(boolean error) {
    }

    private JPanel getOnePropertyEditorPanel() {
        if (this.onePropertyEditorPanel == null) {
            this.propertyEditorConstraints = new GridBagConstraints();
            this.propertyEditorConstraints.anchor = 11;
            this.propertyEditorConstraints.gridx = 0;
            this.propertyEditorConstraints.gridy = 1;
            this.propertyEditorConstraints.insets = new Insets(5, 5, 5, 5);
            this.propertyEditorConstraints.fill = 2;
            this.propertyEditorConstraints.weightx = 300.0;
            this.propertyEditorConstraints.weighty = 300.0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 100.0;
            gridBagConstraints.gridx = 0;
            this.onePropertyEditorPanel = new JPanel();
            this.onePropertyEditorPanel.setLayout(new GridBagLayout());
            this.onePropertyEditorPanel.setPreferredSize(new Dimension(300, 250));
            this.onePropertyEditorPanel.setMaximumSize(new Dimension(300, 250));
            this.onePropertyEditorPanel.setBackground(Color.white);
            this.onePropertyEditorPanel.add((Component)this.getPropertyInfoPanel(), gridBagConstraints);
        }
        return this.onePropertyEditorPanel;
    }

    public JPanel getEditorContainer() {
        return this.getOnePropertyEditorPanel();
    }

    private JPanel getFooterPanel() {
        if (this.footerPanel == null) {
            FlowLayout flowLayout2 = new FlowLayout();
            flowLayout2.setAlignment(1);
            flowLayout2.setHgap(15);
            this.footerPanel = new JPanel();
            this.footerPanel.setLayout(flowLayout2);
            this.footerPanel.setBackground(Color.white);
            this.footerPanel.setBorder(new SoftBevelBorder(1));
            this.footerPanel.add((Component)this.getSetDefaultButton(), null);
        }
        return this.footerPanel;
    }

    private JScrollPane getTreeScrollPane() {
        if (this.treeScrollPane == null) {
            this.treeScrollPane = new JScrollPane();
            this.treeScrollPane.setViewportView(this.getPropertiesTree());
        }
        return this.treeScrollPane;
    }

    private JTree getPropertiesTree() {
        if (this.propertiesTree == null) {
            this.propertiesTree = new JTree();
            this.propertiesTree.setBackground(XissWebUI.paleColor);
            this.propertiesTree.setToggleClickCount(1);
            this.treeModel = new PropertiesTreeModel();
            this.propertiesTree.setModel(this.treeModel);
            this.propertiesTree.setCellRenderer(new PropertiesTreeCellRenderer(this));
            this.propertiesTree.setRootVisible(false);
            this.propertiesTree.setSelectionModel(new PropertiesTreeSelectionModel(this));
            this.propertiesTree.putClientProperty("JTree.lineStyle", "Horizontal");
        }
        return this.propertiesTree;
    }

    public boolean isDocumentValid() {
        return true;
    }

    public int save() {
        String propKey;
        int result = 0;
        ArrayList<DefaultMutableTreeNode> nodeList = new ArrayList<DefaultMutableTreeNode>();
        Iterator<Object> i = this.newValues.keySet().iterator();
        while (i.hasNext()) {
            propKey = (String)i.next();
            nodeList.add(this.treeModel.getNodeFromUserObject(propKey));
            this.properties.setValue(propKey, (String)this.newValues.get(propKey));
        }
        try {
            this.properties.saveProperties();
            i = this.newValues.keySet().iterator();
            while (i.hasNext()) {
                propKey = (String)i.next();
                this.notifyListeners(propKey, (String)this.newValues.get(propKey));
            }
            this.newValues.clear();
            i = nodeList.iterator();
            while (i.hasNext()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)i.next();
                this.treeModel.nodeChanged(node);
            }
            this.editorsContainer.editorStatusChange(this, 3);
        }
        catch (FileNotFoundException e) {
            result = 1;
        }
        catch (IOException e) {
            result = 1;
        }
        return result;
    }

    public synchronized void addPropertyChangedListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removePropertyChangedListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(String key, String value) {
        PropertyChangeEvent event = new PropertyChangeEvent(this.properties, key, value);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            PropertyChangeListener l = (PropertyChangeListener)i.next();
            l.propertyValueChange(event);
        }
    }

    private JSplitPane getMainSplitPane() {
        if (this.mainSplitPane == null) {
            this.mainSplitPane = new JSplitPane();
            this.mainSplitPane.setLeftComponent(this.getTreeScrollPane());
            this.mainSplitPane.setRightComponent(this.getOnePropertyEditorPanel());
        }
        return this.mainSplitPane;
    }

    private JPanel getPropertyInfoPanel() {
        if (this.propertyInfoPanel == null) {
            GridBagConstraints infoTextConstraints = new GridBagConstraints();
            infoTextConstraints.fill = 1;
            infoTextConstraints.gridx = 0;
            infoTextConstraints.gridy = 1;
            infoTextConstraints.weightx = 10.0;
            infoTextConstraints.weighty = 10.0;
            infoTextConstraints.anchor = 11;
            infoTextConstraints.insets = new Insets(3, 3, 3, 3);
            GridBagConstraints propKeyConstraints = new GridBagConstraints();
            propKeyConstraints.insets = new Insets(3, 3, 3, 3);
            propKeyConstraints.gridy = 0;
            propKeyConstraints.gridx = 0;
            propKeyConstraints.fill = 0;
            this.propKeyLabel = new JLabel();
            this.propKeyLabel.setText(" ");
            this.propKeyLabel.setFont(new Font("Courier New", 1, 12));
            this.propKeyLabel.setForeground(XissWebUI.darkColor);
            this.propertyInfoPanel = new JPanel();
            this.propertyInfoPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 56, 127), 1));
            this.propertyInfoPanel.setLayout(new GridBagLayout());
            this.propertyInfoPanel.setBackground(Color.white);
            this.propertyInfoPanel.setName("jPanel");
            this.propertyInfoPanel.add((Component)this.getInfoTextArea(), infoTextConstraints);
            this.propertyInfoPanel.setMinimumSize(new Dimension(300, 125));
            this.propertyInfoPanel.setPreferredSize(new Dimension(300, 125));
            this.propertyInfoPanel.add((Component)this.propKeyLabel, propKeyConstraints);
        }
        return this.propertyInfoPanel;
    }

    private JEditorPane getInfoTextArea() {
        if (this.infoTextArea == null) {
            this.infoTextArea = new JEditorPane();
            this.infoTextArea.setEnabled(true);
            this.infoTextArea.setMinimumSize(new Dimension(280, 40));
            this.infoTextArea.setPreferredSize(new Dimension(280, 40));
            this.infoTextArea.setFont(new Font("Arial", 0, 11));
            this.infoTextArea.setBackground(Color.white);
            this.infoTextArea.setForeground(XissWebUI.darkColor);
            this.infoTextArea.setEditable(false);
            this.infoTextArea.setEditorKit(new HTMLEditorKit());
        }
        return this.infoTextArea;
    }

    private void setDefaultAction() {
        this.propertiesTree.setSelectionPath(null);
        Properties defaultProp = new Properties();
        try {
            FileInputStream in = new FileInputStream(SlideShowProperties.getDefaultPropertieFile());
            defaultProp.load(in);
            Iterator<Object> i = defaultProp.keySet().iterator();
            while (i.hasNext()) {
                String keyProp = (String)i.next();
                this.propertyValueEdited(keyProp, defaultProp.getProperty(keyProp));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setValidProcessHandler(ValidProcessHandler handler) {
    }

    public ValidProcessHandler getValidProcessHandler() {
        return null;
    }

    public void setEditorsContainer(EditorsContainer editorsContainer) {
        this.editorsContainer = editorsContainer;
    }

    public void setEditedDocument(Object document) throws DocumentException {
        File f = (File)document;
        if (!f.exists()) {
            throw new DocumentException(f.getAbsolutePath());
        }
        this.propertiesFile = f;
        this.properties = Main.get().getCurrentProject().getProperties();
    }

    public Object getEditedDocument() {
        return this.propertiesFile;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void edit(Object property) {
        this.doEdit();
        TreeHelper.selectNode(this.propertiesTree, this.treeModel.getNodeFromUserObject(property), true);
    }

    public void edit() {
        this.doEdit();
    }

    private void doEdit() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setBackground(Color.white);
            this.scrollPane.getViewport().setView(this);
            this.scrollPane.setBackground(Color.white);
        }
        this.treeModel = new PropertiesTreeModel(this.properties);
        this.propertiesTree.setModel(this.treeModel);
        TreeHelper.expandRoot(this.propertiesTree);
        this.textDisplayer.resetAllText();
        DefaultMutableTreeNode node = this.treeModel.getNodeFromUserObject(SlideShowProperties.getCategoryInfo("main.properties"));
        TreeHelper.expandNode(this.propertiesTree, node);
        this.editorsContainer.editorStatusChange(this, 0);
    }

    public void cancel() {
        ArrayList keys = new ArrayList(this.newValues.keySet());
        this.newValues.clear();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            this.treeModel.nodeChanged(this.treeModel.getNodeFromUserObject((String)i.next()));
        }
        if (this.valueEditor != null) {
            this.valueEditor.reset();
        }
        this.editorsContainer.editorStatusChange(this, 2);
    }

    public void reload() {
        this.doEdit();
    }

    public boolean hasDocumentModified() {
        return !this.newValues.isEmpty();
    }

    public Component getEditorGuiComponent() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.getViewport().setView(this);
            this.scrollPane.setBackground(Color.white);
        }
        return this.scrollPane;
    }

    public String getDocumentName() {
        return "xissweb.properties";
    }

    public Icon getIcon() {
        return XissWebUI.getIcon(PROPERTIES_SLIDE_SOW_ICON);
    }

    public JMenuItem[] getMenuItems() {
        return null;
    }

    public boolean isNewValue(String propKey, String value) {
        String propValue = this.properties.getValue(propKey);
        return propValue == null && value != null || propValue != null && !propValue.equals(value);
    }

    public void setEditorForProperty(SlideShowPropInfo propInfo) {
        this.getPropKeyLabel().setText(propInfo.getKey());
        String txt = SlideShowProperties.getPropertyLabelTextInfo(propInfo);
        try {
            this.getInfoTextArea().read((InputStream)new ByteArrayInputStream(txt.getBytes()), (Object)null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.valueEditor != null) {
            this.getEditorContainer().remove((Component)((Object)this.valueEditor));
            this.valueEditor = null;
        }
        if (propInfo.isPropertyInfo()) {
            PropertyInfo pInfo = (PropertyInfo)propInfo;
            this.valueEditor = this.getValueEditor(pInfo.getValueType());
            if (this.valueEditor != null) {
                this.getEditorContainer().add((Component)((Object)this.valueEditor), this.propertyEditorConstraints);
                this.valueEditor.initEdition(pInfo.getKey(), this.getCurrentValue(pInfo), pInfo.getDefaultValue(), pInfo.getPossibleValues());
            }
        }
        this.getEditorContainer().validate();
        this.getEditorContainer().repaint();
    }

    public void unsetEditorForProperty() {
        if (this.valueEditor != null) {
            this.getEditorContainer().remove((Component)((Object)this.valueEditor));
        }
        this.valueEditor = null;
        this.getPropKeyLabel().setText(" ");
        this.getInfoTextArea().setText(" ");
        this.getEditorContainer().validate();
        this.getEditorContainer().repaint();
    }

    public void propertyValueEdited(String propKey, String value) {
        if (this.isNewValue(propKey, value)) {
            this.newValues.put(propKey, value);
            this.treeModel.nodeChanged(this.treeModel.getNodeFromUserObject(propKey));
            if (this.newValues.values().size() == 1) {
                this.editorsContainer.editorStatusChange(this, 1);
            }
        } else {
            this.newValues.remove(propKey);
            this.treeModel.nodeChanged(this.treeModel.getNodeFromUserObject(propKey));
            if (this.newValues.isEmpty()) {
                this.editorsContainer.editorStatusChange(this, 2);
            }
        }
    }

    public String getCurrentValue(PropertyInfo pInfo) {
        String cValue = (String)this.newValues.get(pInfo.getKey());
        if (!this.newValues.containsKey(pInfo.getKey())) {
            cValue = this.properties.getValue(pInfo.getKey());
        }
        return cValue;
    }

    public boolean isEdited(SlideShowPropInfo propInfo) {
        if (propInfo.isCategoryInfo()) {
            CategoryInfo category = (CategoryInfo)propInfo;
            Iterator i = category.getContent().iterator();
            while (i.hasNext()) {
                SlideShowPropInfo pI = (SlideShowPropInfo)i.next();
                boolean result = this.isEdited(pI);
                if (!result) continue;
                return true;
            }
        } else {
            return this.newValues.containsKey(propInfo.getKey());
        }
        return false;
    }

    public String getPropertyValue(PropertyInfo propInfo) {
        String value = (String)this.newValues.get(propInfo);
        if (!this.newValues.containsKey(propInfo)) {
            value = this.properties.getValue(propInfo.getKey());
        }
        if (value == null || value.length() == 0) {
            value = "?";
        }
        return value;
    }

    private JButton getSetDefaultButton() {
        if (this.setDefaultButton == null) {
            this.setDefaultButton = new JButton();
            this.setDefaultButton.addActionListener(this);
            this.textDisplayer.register(this.setDefaultButton, "set.default.button");
        }
        return this.setDefaultButton;
    }

    public void actionPerformed(ActionEvent e) {
        this.setDefaultAction();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

