/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.properties;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.properties.PropertiesEditor;
import org.xissweb.gui.util.LabelCellRenderer;
import org.xissweb.project.PropertyInfo;
import org.xissweb.project.SlideShowPropInfo;
import org.xissweb.project.SlideShowProperties;

public class PropertiesTreeCellRenderer
extends LabelCellRenderer
implements TreeCellRenderer {
    private static final long serialVersionUID = -4363109543884191806L;
    private static final String OPENED_ICON = "/images/properties/opened.gif";
    private static final String CLOSED_ICON = "/images/properties/closed.gif";
    private static final String PROPERTY_ICON = "/images/properties/property.gif";
    private PropertiesEditor editor;

    public PropertiesTreeCellRenderer(PropertiesEditor editor) {
        this.editor = editor;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        SlideShowPropInfo element = (SlideShowPropInfo)node.getUserObject();
        if (element.isCategoryInfo()) {
            if (expanded) {
                this.setIcon(XissWebUI.getIcon(OPENED_ICON));
            } else {
                this.setIcon(XissWebUI.getIcon(CLOSED_ICON));
            }
        } else {
            this.setIcon(XissWebUI.getIcon(PROPERTY_ICON));
        }
        if (sel) {
            this.setBackground(selectedBackgroundColor);
        }
        if (this.editor.isEdited(element)) {
            this.setFont(this.boldTextFont);
        } else {
            this.setFont(this.plainTextFont);
        }
        String stringValue = tree.convertValueToText(element.getKey(), sel, expanded, leaf, row, hasFocus);
        try {
            String theValue = SlideShowProperties.getPropertyLabel(element);
            if (element.isPropertyInfo()) {
                String currentValue = this.editor.getPropertyValue((PropertyInfo)element);
                theValue = theValue + " = " + currentValue;
            }
            stringValue = tree.convertValueToText(theValue, sel, expanded, leaf, row, hasFocus);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.setText(stringValue);
        this.cellSelected = sel;
        return this;
    }
}

