/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.skin.simple;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.xissweb.data.skin.ColorInfo;
import org.xissweb.gui.skin.simple.SkinEditor;
import org.xissweb.gui.skin.simple.SkinEditorHelper;

public class SkinColorPanel
extends JPanel {
    private static final long serialVersionUID = -3141607752234202195L;
    private static final Color borderColor = Color.gray;
    private static final Color borderHighlight = Color.lightGray;
    private static Color colorCopied = null;
    private static final int size = 30;
    private SkinEditor editor;
    private LineBorder border = new LineBorder(borderColor, 1);
    private LineBorder borderHighlighted = new LineBorder(borderHighlight, 3);
    private ColorInfo colorInfo;
    private String toolTipKey;
    private ColoredButton button = null;

    public SkinColorPanel() {
        this.initialize();
    }

    public void setEditor(SkinEditor editor) {
        this.editor = editor;
    }

    public Color getColor() {
        return this.button.getBackground();
    }

    public void highlight() {
        this.button.setBorder(this.borderHighlighted);
        if (this.toolTipKey != null) {
            this.editor.currentColor(this.toolTipKey);
        }
    }

    public void unhighlight() {
        this.button.setBorder(this.border);
        this.editor.currentColor(null);
    }

    void chooseColor() {
        Color c = this.editor.chooseColor(this);
        if (c != null) {
            this.colorChanged(c);
            this.editor.elementEdited(this.colorInfo);
        }
    }

    void keyEventOnColor(KeyEvent e) {
        switch (e.getKeyChar()) {
            case 'b': {
                Color c = this.button.getBackground().brighter();
                if (!c.equals(this.button.getBackground())) {
                    this.colorChanged(c);
                    this.editor.elementEdited(this.colorInfo);
                }
                return;
            }
            case 'd': {
                Color c = this.button.getBackground().darker();
                if (!c.equals(this.button.getBackground())) {
                    this.colorChanged(c);
                    this.editor.elementEdited(this.colorInfo);
                }
                return;
            }
        }
        if (KeyEvent.getKeyText(e.getKeyCode()).equals("C") && e.getModifiers() == 2) {
            colorCopied = this.getColor();
            return;
        }
        if (KeyEvent.getKeyText(e.getKeyCode()).equals("V") && e.getModifiers() == 2) {
            if (colorCopied != null && !this.getColor().equals(colorCopied)) {
                this.colorChanged(colorCopied);
                this.editor.elementEdited(this.colorInfo);
            }
            return;
        }
    }

    public void colorChanged(Color color) {
        this.colorInfo.setR(color.getRed());
        this.colorInfo.setG(color.getGreen());
        this.colorInfo.setB(color.getBlue());
        this.button.setBackground(color);
    }

    public String getToolTipKey() {
        return this.toolTipKey;
    }

    public void setToolTipKey(String toolTipKey) {
        this.toolTipKey = toolTipKey;
    }

    public ColorInfo getColorInfo() {
        return this.colorInfo;
    }

    public void setColorInfo(ColorInfo colorInfo) {
        this.colorInfo = colorInfo;
        this.button.setBackground(SkinEditorHelper.getColor(colorInfo));
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(30, 30));
        this.add((Component)this.getButton(), "Center");
    }

    private ColoredButton getButton() {
        if (this.button == null) {
            this.button = new ColoredButton();
            this.button.setBorderPainted(true);
            this.button.setBorder(this.border);
            this.button.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    SkinColorPanel.this.keyEventOnColor(e);
                }
            });
            this.button.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    SkinColorPanel.this.highlight();
                }

                public void focusLost(FocusEvent e) {
                    SkinColorPanel.this.unhighlight();
                }
            });
            this.button.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        SkinColorPanel.this.chooseColor();
                    }
                }
            });
        }
        return this.button;
    }

    private class ColoredButton
    extends JButton {
        private static final long serialVersionUID = 1L;

        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.getBorder().paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        }
    }
}

