/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.skin.simple;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import org.xissweb.data.skin.AnimationLoadInfo;
import org.xissweb.data.skin.ColorInfo;
import org.xissweb.data.skin.ColorsInfo;
import org.xissweb.data.skin.ComponentInfo;
import org.xissweb.data.skin.ComponentStyleInfo;
import org.xissweb.data.skin.FontInfo;
import org.xissweb.data.skin.ImageAreaInfo;
import org.xissweb.data.skin.LineInfo;
import org.xissweb.data.skin.LinkInfo;
import org.xissweb.data.skin.PageInfo;
import org.xissweb.data.skin.SlideShowSkinInfo;
import org.xissweb.data.skin.ThumbnailInfo;
import org.xissweb.gui.editor.font.CssFontHelper;

public class SkinEditorHelper {
    private static final float size100percent = 14.0f;
    private static final float[] dashedLine = new float[]{3.0f, 3.0f};
    private static final float[] dottedLine = new float[]{2.0f, 2.0f};

    public static Color getColor(ColorInfo colorInfo) {
        return new Color(colorInfo.getR(), colorInfo.getG(), colorInfo.getB());
    }

    public static boolean equal(SlideShowSkinInfo skinI, SlideShowSkinInfo skinR) {
        if (!skinI.getName().equals(skinR.getName())) {
            return false;
        }
        if (!SkinEditorHelper.equal(skinI.getColors(), skinR.getColors())) {
            return false;
        }
        if (!SkinEditorHelper.equal(skinI.getPage(), skinR.getPage())) {
            return false;
        }
        return SkinEditorHelper.equal(skinI.getComponent(), skinR.getComponent());
    }

    public static void setColorInfo(Color color, ColorInfo cInfo) {
        cInfo.setR(color.getRed());
        cInfo.setG(color.getGreen());
        cInfo.setB(color.getBlue());
    }

    public static Font getFont(FontInfo fontInfo) {
        int style = 0;
        if (fontInfo.getStyle().equals("italic")) {
            if (fontInfo.getWeight().equals("normal")) {
                style = 2;
            } else if (fontInfo.getWeight().equals("bold")) {
                style = 3;
            }
        } else if (fontInfo.getStyle().equals("normal") && fontInfo.getWeight().equals("bold")) {
            style = 1;
        }
        int size = fontInfo.getSize();
        if (fontInfo.getUnit().equals("%")) {
            size = Math.round(14.0f * (float)size / 100.0f);
        }
        Font f = CssFontHelper.getFont(fontInfo.getNames());
        return f.deriveFont(style, size);
    }

    public static Stroke getStroke(LineInfo lineInfo) {
        if (lineInfo.getType().equals("dashed")) {
            float[] dash = new float[]{dashedLine[0] * (float)lineInfo.getThin(), dashedLine[1] * (float)lineInfo.getThin()};
            return new BasicStroke(lineInfo.getThin(), 0, 0, 1.0f, dash, 0.0f);
        }
        if (lineInfo.getType().equals("dotted")) {
            float[] dot = new float[]{dottedLine[0] * (float)lineInfo.getThin() / 2.0f, dottedLine[0] * (float)lineInfo.getThin() / 2.0f};
            return new BasicStroke(lineInfo.getThin(), 0, 0, 1.0f, dot, 0.0f);
        }
        if (lineInfo.getType().equals("solid")) {
            return new BasicStroke(lineInfo.getThin());
        }
        return null;
    }

    private static boolean equal(ColorsInfo colorsI, ColorsInfo colorsR) {
        if (!SkinEditorHelper.equal(colorsI.getBodyBackground(), colorsR.getBodyBackground())) {
            return false;
        }
        if (!SkinEditorHelper.equal(colorsI.getPageBackground(), colorsR.getPageBackground())) {
            return false;
        }
        if (!SkinEditorHelper.equal(colorsI.getForeground(), colorsR.getForeground())) {
            return false;
        }
        if (!SkinEditorHelper.equal(colorsI.getLinkForeground(), colorsR.getLinkForeground())) {
            return false;
        }
        if (!SkinEditorHelper.equal(colorsI.getLinkHover(), colorsR.getLinkHover())) {
            return false;
        }
        return SkinEditorHelper.equal(colorsI.getDisabledForeground(), colorsR.getDisabledForeground());
    }

    private static boolean equal(PageInfo pageI, PageInfo pageR) {
        return pageI.isCentered() == pageR.isCentered() && SkinEditorHelper.equal(pageI.getFont(), pageR.getFont()) && SkinEditorHelper.equal(pageI.getLink(), pageR.getLink());
    }

    private static boolean equal(ComponentInfo cmpI, ComponentInfo cmpR) {
        return SkinEditorHelper.equal(cmpI.getImageArea(), cmpR.getImageArea()) && SkinEditorHelper.equal(cmpI.getThumbnail(), cmpR.getThumbnail()) && SkinEditorHelper.equal(cmpI.getCopyright(), cmpR.getCopyright());
    }

    private static boolean equal(ComponentStyleInfo cmpStyleI, ComponentStyleInfo cmpStyleR) {
        return SkinEditorHelper.equal(cmpStyleI.getFont(), cmpStyleR.getFont());
    }

    private static boolean equal(ThumbnailInfo thumbI, ThumbnailInfo thumbR) {
        return SkinEditorHelper.equal(thumbI.getLink(), thumbR.getLink()) && SkinEditorHelper.equal(thumbI.getCurrent(), thumbR.getCurrent());
    }

    private static boolean equal(ImageAreaInfo imgI, ImageAreaInfo imgR) {
        return imgI.getMargin() == imgR.getMargin() && SkinEditorHelper.equal(imgI.getColor(), imgR.getColor()) && SkinEditorHelper.equal(imgI.getBackground(), imgR.getBackground()) && SkinEditorHelper.equal(imgI.getFont(), imgR.getFont()) && SkinEditorHelper.equal(imgI.getMetadataFont(), imgR.getMetadataFont()) && SkinEditorHelper.equal(imgI.getBorder(), imgR.getBorder()) && SkinEditorHelper.equal(imgI.getLocalIndex().getBorderColor(), imgR.getLocalIndex().getBorderColor()) && SkinEditorHelper.equal(imgI.getLocalIndex().getBackground(), imgR.getLocalIndex().getBackground()) && SkinEditorHelper.equal(imgI.getAnimationLoad(), imgR.getAnimationLoad());
    }

    private static boolean equal(AnimationLoadInfo anim1, AnimationLoadInfo anim2) {
        return anim1.getBackground() == anim2.getBackground() && anim1.getIconStyle() == anim2.getIconStyle() && anim1.getOpacity() == anim2.getOpacity();
    }

    private static boolean equal(LinkInfo linkI, LinkInfo linkR) {
        return SkinEditorHelper.equal(linkI.getNormal(), linkR.getNormal()) && SkinEditorHelper.equal(linkI.getHover(), linkR.getHover());
    }

    private static boolean equal(LineInfo lineI, LineInfo lineR) {
        return lineI.getThin() == lineR.getThin() && lineI.getType().equals(lineR.getType());
    }

    private static boolean equal(FontInfo fI, FontInfo fR) {
        if (fI.getNames().length != fR.getNames().length) {
            return false;
        }
        for (int i = 0; i < fI.getNames().length; ++i) {
            if (fI.getNames()[i].equals(fR.getNames()[i])) continue;
            return false;
        }
        return fI.getSize() == fR.getSize() && fI.getUnit().equals(fR.getUnit()) && fI.getStyle().equals(fR.getStyle()) && fI.getWeight().equals(fR.getWeight());
    }

    private static boolean equal(ColorInfo colorI, ColorInfo colorR) {
        if (colorI != null && colorR != null) {
            return colorI.getR() == colorR.getR() && colorI.getG() == colorR.getG() && colorI.getB() == colorR.getB();
        }
        return colorI == colorR;
    }
}

