/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.util;

import java.io.File;
import java.util.Set;
import org.xissweb.file.DirectoryVisitor;
import org.xissweb.file.FileHelper;
import org.xissweb.image.ImageFileHelper;
import org.xissweb.produce.AbstractProducer;
import org.xissweb.produce.SlideShowDirectory;
import org.xissweb.produce.SlideShowFileFilter;
import org.xissweb.produce.sow.SowReverseVisitorFilter;
import org.xissweb.project.SlideShowProject;
import org.xissweb.project.SlideShowProperties;

public class ImageFileCounter
extends AbstractProducer {
    private SlideShowProject project;
    private int countImages;
    private int countDirectories;

    public static int countImages(File dir, SlideShowProperties properties) {
        int nbImages = 0;
        File imgDir = SlideShowDirectory.imageDirectory(dir, properties);
        if (imgDir != null) {
            nbImages = ImageFileHelper.countImageFiles(imgDir);
        }
        return nbImages;
    }

    public static int countImages(File originDir, File destDir, SlideShowProperties properties) {
        int nbImages = 0;
        File originalImgDir = SlideShowDirectory.imageDirectory(originDir, properties);
        if (originalImgDir != null) {
            File[] files = ImageFileHelper.listImageFiles(originalImgDir);
            File destImgDir = SlideShowDirectory.imageDirectory(destDir, properties);
            for (int i = 0; i < files.length; ++i) {
                if (destImgDir == null) {
                    ++nbImages;
                    continue;
                }
                File destImage = ImageFileHelper.imageFile(destImgDir, FileHelper.fileShortName(files[i]));
                if (destImage == null || !FileHelper.isOutOfSync(files[i], destImage)) continue;
                ++nbImages;
            }
        }
        return nbImages;
    }

    public void count(SlideShowProject project, File directory) {
        this.count(project, directory, null);
    }

    public void count(SlideShowProject project, File directory, Set selectedDirs) {
        this.project = project;
        this.countImages = 0;
        this.countDirectories = 0;
        DirectoryVisitor visitor = new DirectoryVisitor(this, new SlideShowFileFilter(project.getProperties(), selectedDirs));
        visitor.visit(directory);
    }

    public void countReverse(SlideShowProject project, File directory, Set selectedDirs) {
        this.project = project;
        this.countImages = 0;
        this.countDirectories = 0;
        Set exclusion = project.getProperties().getExcludeDirs();
        DirectoryVisitor visitor = new DirectoryVisitor(this, new SowReverseVisitorFilter(exclusion), new SlideShowFileFilter(project.getProperties(), selectedDirs));
        visitor.visit(directory);
    }

    public int getImageCount() {
        return this.countImages;
    }

    public int getDirectoryCount() {
        return this.countDirectories;
    }

    protected boolean doInDirectory(File directory, boolean selected) {
        if (selected) {
            ++this.countDirectories;
            this.countImages += ImageFileCounter.countImages(directory, this.project.getProperties());
        }
        return false;
    }

    protected boolean doOutDirectory(File directory, boolean selected) {
        return false;
    }
}

