/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.util.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.xissweb.gui.XissWebUI;

public abstract class AbstractPanelTreeCellRenderer
implements TreeCellRenderer {
    protected static final Color selectedBackgroundColor = XissWebUI.mediumColor;
    protected static final Color panelBackground = XissWebUI.backgroundColor;
    protected Font plainTextFont = XissWebUI.plainFont;
    protected Font boldTextFont = XissWebUI.boldFont;
    protected JPanel panel;
    protected JLabel label = new JLabel();

    protected AbstractPanelTreeCellRenderer() {
        this.label.setFont(this.plainTextFont);
        FlowLayout layout = new FlowLayout();
        layout.setHgap(1);
        layout.setVgap(1);
        layout.setAlignment(0);
        this.panel = new JPanel(layout);
        this.panel.add(this.label);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        String stringValue = tree.convertValueToText(this.getStringForNode(node), sel, expanded, leaf, row, hasFocus);
        this.label.setText(stringValue);
        this.label.setIcon(this.getIconFromNode(node));
        this.panel.setBackground(sel ? selectedBackgroundColor : panelBackground);
        return this.panel;
    }

    protected abstract String getStringForNode(DefaultMutableTreeNode var1);

    protected abstract ImageIcon getIconFromNode(DefaultMutableTreeNode var1);
}

