/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.image;

import com.drew.metadata.MetadataException;
import java.awt.Dimension;
import java.awt.Image;
import java.io.File;
import javax.swing.ImageIcon;
import org.xissweb.file.FileHelper;
import org.xissweb.image.JPEGMetaDataExtractor;

public class ImageData {
    public static final String IMAGE_PNG_EXTENTION = "png";
    public static final String IMAGE_GIF_EXTENTION = "gif";
    public static final String IMAGE_JPEG_EXTENTION = "jpeg";
    public static final String IMAGE_JPG_EXTENTION = "jpg";
    public static final int[] TIME_SPACE_EXIF_TAGS = new int[]{306, 2, 4, 6};
    public static final int[] DIGITAL_EXIF_TAGS = new int[]{271, 272, 36867, 34855, 37377, 33434, 37378, 37386, 37385, 37384, 2, 4, 6};
    public static final int[] FILM_EXIF_TAGS = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, 2, 4, 6};
    public static final int[] PROCESSING_EXIF_TAGS = new int[]{305, 306, 2, 4, 6};
    private static final Object[] IMAGE_TYPE_TAGS = new Object[]{DIGITAL_EXIF_TAGS, FILM_EXIF_TAGS, PROCESSING_EXIF_TAGS, TIME_SPACE_EXIF_TAGS};
    private File file;
    private String extension = null;
    private JPEGMetaDataExtractor jpegMetadata = null;
    private Dimension dimension = null;
    private Image image = null;
    private String[] metadatas = null;

    public ImageData(File file) {
        this.file = file;
        this.extension = FileHelper.fileNameExtention(file);
        if (this.isJPEG()) {
            this.jpegMetadata = new JPEGMetaDataExtractor(file);
            this.readDimension();
        }
    }

    public boolean isJPEG() {
        return this.extension.equalsIgnoreCase(IMAGE_JPEG_EXTENTION) || this.extension.equalsIgnoreCase(IMAGE_JPG_EXTENTION);
    }

    public boolean isGIF() {
        return this.extension.equalsIgnoreCase(IMAGE_GIF_EXTENTION);
    }

    public boolean isPNG() {
        return this.extension.equalsIgnoreCase(IMAGE_PNG_EXTENTION);
    }

    public String getExtension() {
        return this.extension;
    }

    public File getFile() {
        return this.file;
    }

    private void readDimension() {
        this.dimension = this.jpegMetadata.getImageDimension();
    }

    public void readMetaData() {
        this.readMetaData(DIGITAL_EXIF_TAGS);
        if (!this.isDigitalImage()) {
            this.readMetaData(TIME_SPACE_EXIF_TAGS);
        }
    }

    public void readMetaData(int imageType) {
        this.readMetaData((int[])IMAGE_TYPE_TAGS[imageType]);
    }

    private void readMetaData(int[] tags) {
        if (this.jpegMetadata != null) {
            this.metadatas = new String[tags.length];
            for (int i = 0; i < tags.length; ++i) {
                this.metadatas[i] = this.jpegMetadata.getExifValue(tags[i]);
            }
        }
    }

    public Dimension getDimension() {
        if (this.dimension == null) {
            this.dimension = new Dimension();
            this.dimension.width = this.getImage().getWidth(null);
            this.dimension.height = this.getImage().getHeight(null);
        }
        return this.dimension;
    }

    public int getWidth() {
        return this.getDimension().width;
    }

    public int getHeight() {
        return this.getDimension().height;
    }

    public boolean isDigitalImage() {
        return this.metadatas != null && this.metadatas.length == DIGITAL_EXIF_TAGS.length && this.metadatas[0] != null && this.metadatas[1] != null;
    }

    public String getUserComment() {
        if (!this.isJPEG()) {
            return null;
        }
        try {
            return this.jpegMetadata.getUserCommentValue();
        }
        catch (MetadataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String[] getMetaDatas() {
        return this.metadatas;
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = new ImageIcon(this.file.getAbsolutePath()).getImage();
        }
        return this.image;
    }
}

