/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.produce.depend;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xissweb.file.FileHelper;

public class Dependencies {
    private File targetFile;
    private List dependencies;
    private int count = -1;

    Dependencies(File targetFile) {
        this.targetFile = targetFile;
        this.dependencies = new ArrayList();
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    public void dependsOn(File file) {
        this.dependencies.add(file);
    }

    public boolean isEmpty() {
        return this.dependencies.isEmpty();
    }

    public boolean isOutOfSync() {
        return this.isOutOfSync(false);
    }

    public boolean isOutOfSync(boolean trace) {
        boolean outOfSync = false;
        if (trace) {
            System.out.println("isOutOfSync for target " + this.getTargetFile());
            System.out.println("    " + this.getTargetFile().exists() + " " + this.getTargetFile().lastModified());
        }
        int currentCount = this.dependencies.size();
        if (this.count != -1 && currentCount != this.count) {
            outOfSync = true;
            if (trace) {
                System.out.println("    dependecies count");
            }
        }
        Iterator i = this.dependencies.iterator();
        while (i.hasNext() && !outOfSync) {
            File depend = (File)i.next();
            if (trace) {
                System.out.println("    " + depend + " " + depend.lastModified() + " > " + this.targetFile.lastModified());
            }
            if (!FileHelper.isOutOfSync(depend, this.targetFile)) continue;
            outOfSync = true;
        }
        this.count = currentCount;
        if (trace) {
            System.out.println("    " + outOfSync);
        }
        return outOfSync;
    }

    public void clear() {
        this.dependencies.clear();
    }
}

