/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.produce.sow;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.xissweb.data.content.ImageInfo;
import org.xissweb.data.content.SlideShowContentInfo;
import org.xissweb.data.content.xml.ContentDeserializer;
import org.xissweb.data.content.xml.ContentSerializer;
import org.xissweb.file.FileHelper;
import org.xissweb.file.SteppedDirectoryVisitor;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.image.ImageData;
import org.xissweb.image.ImageFileHelper;
import org.xissweb.produce.AbstractProducer;
import org.xissweb.produce.DirectoryActionEvent;
import org.xissweb.produce.FileOnlyFilter;
import org.xissweb.produce.SlideShowDirectory;
import org.xissweb.produce.SlideShowFileFilter;
import org.xissweb.produce.sow.Context;
import org.xissweb.produce.sow.SowEventListener;
import org.xissweb.produce.sow.SowException;
import org.xissweb.produce.sow.SowReverseVisitorFilter;
import org.xissweb.produce.util.HTMLQuery;

public class Sower
extends AbstractProducer {
    private File srcRootDir;
    private File targetRootDir;
    private boolean sourceIsOriginal;
    private int maxImageWidth;
    private int maxImageHeight;
    private ContentDeserializer deserializer = new ContentDeserializer();
    private ContentSerializer serializer = new ContentSerializer();
    private HTMLQuery query = new HTMLQuery();
    private Set fileExclusion;
    SteppedDirectoryVisitor visitor;
    Context context = new Context();

    public boolean hasPathToHtml() {
        return this.project.getProperties().getHtmlPath() != null;
    }

    private boolean hasTarget() {
        return this.targetRootDir != null;
    }

    private boolean isReversing() {
        return this.hasTarget() && !this.sourceIsOriginal;
    }

    public boolean reverseSows() throws SowException {
        if (this.visitor == null) {
            this.sourceIsOriginal = false;
            String origin = this.project.getProperties().getOriginRootDir();
            this.targetRootDir = this.project.getSrcDirectory();
            this.srcRootDir = this.project.getOriginDiretory();
            if (this.srcRootDir == null) {
                throw new SowException(TextDisplayer.getString("no.origin", this.getClass()));
            }
            this.fileExclusion = this.properties.getExcludeFiles();
            if (!this.srcRootDir.exists()) {
                throw new SowException("\"" + origin + "\" " + TextDisplayer.getString("origin.no.exists", this.getClass()));
            }
        }
        return this.sows(this.srcRootDir, this.properties.getExcludeDirs());
    }

    public boolean sows() throws SowException {
        if (this.visitor == null) {
            this.sourceIsOriginal = false;
            this.targetRootDir = null;
            this.srcRootDir = this.project.getSrcDirectory();
            if (!this.srcRootDir.exists()) {
                throw new SowException(TextDisplayer.getString("source.no.exists", this.getClass()));
            }
        }
        return this.sows(this.srcRootDir);
    }

    public boolean sowsFromRepository() throws SowException {
        if (this.visitor == null) {
            this.sourceIsOriginal = true;
            String origin = this.project.getProperties().getOriginalImageRepository();
            if (origin == null) {
                throw new SowException(TextDisplayer.getString("no.repository", this.getClass()));
            }
            this.maxImageWidth = this.project.getProperties().getMaxImageWidth();
            this.maxImageHeight = this.project.getProperties().getMaxImageHeight();
            this.targetRootDir = this.project.getSrcDirectory();
            this.srcRootDir = this.project.getRepositoryDirectory();
            if (!this.srcRootDir.exists()) {
                throw new SowException("\"" + origin + "\" " + TextDisplayer.getString("repository.no.exists", this.getClass()));
            }
        }
        return this.sows(this.srcRootDir);
    }

    private boolean sows(File currentDir, Set exclusion) {
        if (this.visitor == null) {
            this.visitor = new SteppedDirectoryVisitor(this, new SowReverseVisitorFilter(exclusion), new SlideShowFileFilter(this.properties, this.selection));
            this.visitor.visitInitialization(currentDir);
        }
        return this.visitor.step();
    }

    private boolean sows(File currentDir) {
        if (this.visitor == null) {
            this.visitor = new SteppedDirectoryVisitor(this, new SlideShowFileFilter(this.properties, this.selection));
            this.visitor.visitInitialization(currentDir);
        }
        return this.visitor.step();
    }

    public boolean doInDirectory(File currentDir, boolean selected) {
        if (selected) {
            return this.sowOneDirectory(currentDir);
        }
        return false;
    }

    public boolean doOutDirectory(File currentDir, boolean selected) {
        return false;
    }

    public boolean sowOneDirectory(File directory) {
        boolean doInContinue = true;
        if (!this.context.isInDirectory(directory)) {
            this.context.directory = directory;
            this.context.imageDir = SlideShowDirectory.imageDirectory(directory, this.project.getProperties());
            if (this.hasTarget()) {
                this.context.targetDir = FileHelper.checkDirectory(this.targetRootDir, FileHelper.relativePath(this.srcRootDir, directory));
            }
            if (this.context.imageDir != null) {
                this.context.slideShowFile = this.hasTarget() ? new File(this.context.targetDir, this.project.getProperties().getSlideshowContentFileName()) : new File(directory, this.project.getProperties().getSlideshowContentFileName());
                if (this.context.slideShowFile.exists()) {
                    this.context.contentInfo = this.deserializer.deserialize(this.context.slideShowFile);
                    this.notifySlideShowContentReaded(this.context.slideShowFile);
                } else {
                    String imagesPath = FileHelper.relativePath(directory, this.context.imageDir);
                    this.context.contentInfo = new SlideShowContentInfo(directory.getName(), imagesPath, this.properties.getThumbnailDirName());
                    this.notifySlideshowContentCreated(directory, this.context.slideShowFile);
                    if (this.isReversing() && this.properties.getInfoFilePath() != null) {
                        File htmlFile = new File(directory, this.properties.getInfoFilePath());
                        String xpath = this.properties.getSlideshowThemeQuery();
                        if (xpath != null && htmlFile.exists()) {
                            this.context.contentInfo.setName(this.query.execute(htmlFile, xpath));
                        }
                        if ((xpath = this.properties.getSlideshowTitleQuery()) != null && htmlFile.exists()) {
                            this.context.contentInfo.getTitle().setValue(this.query.execute(htmlFile, xpath));
                        }
                    } else {
                        this.context.contentInfo.setName(FileHelper.relativePath(this.srcRootDir, directory).replace(File.separatorChar, ' '));
                    }
                }
            } else {
                if (this.isReversing()) {
                    this.copyDirectoryContent(directory, this.context.targetDir);
                }
                this.context.clear();
                doInContinue = false;
            }
        } else {
            doInContinue = this.readImages();
            if (!doInContinue) {
                boolean removed = this.context.contentInfo.removeUnexistingImages();
                boolean renumber = this.context.contentInfo.resetImageNumber();
                if (this.context.imageInfoUpdated || removed || renumber) {
                    this.notifyWritingSlideshowContent(directory, this.context.slideShowFile);
                    if (this.context.contentInfo.getEncoding() == null) {
                        this.serializer.setEncoding(this.properties.getSlideshowEncoding());
                    }
                    this.serializer.serialize(this.context.slideShowFile, this.context.contentInfo);
                    this.notifySlideshowContentWroten(directory, this.context.slideShowFile);
                }
                this.context.clear();
            }
        }
        return doInContinue;
    }

    protected void copyDirectoryContent(File sourceDir, File targetDir) {
        this.notifyCopyingContentDir(sourceDir, targetDir);
        FileHelper.copyFiles(sourceDir, targetDir, new FileOnlyFilter(this.fileExclusion));
    }

    private boolean readImages() {
        boolean doInContinue = true;
        if (this.context.files == null) {
            this.context.files = ImageFileHelper.listImageFiles(this.context.imageDir);
            this.context.fileIndex = 0;
            Arrays.sort(this.context.files);
            if (this.hasTarget()) {
                this.context.targetImagesDir = SlideShowDirectory.createImageDirectory(this.properties, this.context.targetDir);
            }
        }
        if (this.context.hasNextFile()) {
            this.notifyReadingImage(this.context.directory, this.context.getFile());
            ImageInfo imageInfo = this.context.contentInfo.retrievesOrCreatesImageInfo(FileHelper.fileShortName(this.context.getFile().getName()));
            this.notifyImageReaded(this.context.directory, this.context.getFile());
            ImageData currentImage = new ImageData(this.context.getFile());
            if (!imageInfo.hasComment()) {
                String comment = currentImage.getUserComment();
                imageInfo.setStringValue(comment == null || comment.length() == 0 ? this.properties.getDefaultImageComment() : comment);
            }
            this.context.imageInfoUpdated = this.readImageInfo(imageInfo, currentImage, this.maxImageWidth, this.maxImageHeight) || this.context.imageInfoUpdated;
            imageInfo.setImageExist(true);
            if (this.hasTarget() && this.hasImageInRepository() && this.properties.isImportImage()) {
                File targetFile = this.targetFile(imageInfo, this.context.targetImagesDir);
                if (FileHelper.isOutOfSync(currentImage.getFile(), targetFile)) {
                    this.resizeOrCopy(imageInfo, currentImage, this.context.targetImagesDir, targetFile);
                }
            }
            if (this.isReversing()) {
                if (this.hasPathToHtml()) {
                    imageInfo.setStringValue(this.retrieveComment(this.context.directory, imageInfo.getFileName()));
                }
                if (FileHelper.copyFile(this.context.getFile(), new File(this.context.targetImagesDir, this.context.getFile().getName()))) {
                    this.notifyCopyingImage(this.context.targetImagesDir, this.context.getFile());
                }
            }
            ++this.context.fileIndex;
            doInContinue = this.context.hasNextFile();
        }
        return doInContinue;
    }

    private String retrieveComment(File currentDir, String name) {
        String comment = "";
        File htmlFile = new File(new File(currentDir, this.properties.getHtmlPath()), name + ".html");
        if (htmlFile.exists()) {
            comment = this.query.execute(htmlFile, this.properties.getImageCommentQuery());
        }
        return comment;
    }

    private void notifySlideshowContentCreated(File dir, File file) {
        DirectoryActionEvent event = new DirectoryActionEvent((Object)this, dir, file);
        Iterator l = this.listeners.iterator();
        while (l.hasNext()) {
            ((SowEventListener)l.next()).slideshowContentCreated(event);
        }
    }

    private void notifySlideShowContentReaded(File dir) {
        DirectoryActionEvent event = new DirectoryActionEvent(this, dir);
        Iterator l = this.listeners.iterator();
        while (l.hasNext()) {
            ((SowEventListener)l.next()).slideshowContentReaded(event);
        }
    }

    private void notifyReadingImage(File dir, File file) {
        DirectoryActionEvent event = new DirectoryActionEvent((Object)this, dir, file);
        Iterator l = this.listeners.iterator();
        while (l.hasNext()) {
            ((SowEventListener)l.next()).readingImage(event);
        }
    }

    private void notifyImageReaded(File dir, File file) {
        DirectoryActionEvent event = new DirectoryActionEvent((Object)this, dir, file);
        Iterator l = this.listeners.iterator();
        while (l.hasNext()) {
            ((SowEventListener)l.next()).imageReaded(event);
        }
    }

    public void stop() {
        super.stop();
        this.context.clear();
        this.visitor = null;
    }
}

